/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.hdfs.protocol.CacheDirective;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.RetryCacheDistributed;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;

class FSNDNCacheOp {
    FSNDNCacheOp() {
    }

    static CacheDirectiveInfo addCacheDirective(final FSNamesystem fsn, final FSDirectory fsd, final CacheManager cacheManager, final CacheDirectiveInfo directive, final EnumSet<CacheFlag> flags) throws IOException {
        CacheManager.validatePoolName(directive);
        final String path = CacheManager.validatePath(directive);
        final long id = cacheManager.getNextDirectiveId();
        HopsTransactionalRequestHandler addDirectiveHandler = new HopsTransactionalRequestHandler(HDFSOperationType.ADD_CACHE_DIRECTIVE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCachePoolLock(directive.getPool()));
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, path).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getCacheDirectiveLock(id)).add(lf.getBlockLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                CacheDirectiveInfo cacheDirectiveInfo;
                RetryCacheDistributed.CacheEntryWithPayload cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache(), null);
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return PBHelper.bytesToLong(cacheEntry.getPayload());
                }
                boolean success = false;
                Long result = null;
                try {
                    FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                    if (directive.getId() != null) {
                        throw new IOException("addDirective: you cannot specify an ID for this operation.");
                    }
                    CacheDirectiveInfo effectiveDirective = cacheManager.addDirective(directive, pc, flags, id);
                    result = effectiveDirective.getId();
                    success = true;
                    cacheDirectiveInfo = effectiveDirective;
                }
                catch (Throwable throwable) {
                    RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (boolean)success, (byte[])PBHelper.longToBytes(result));
                    throw throwable;
                }
                RetryCacheDistributed.setState((RetryCacheDistributed.CacheEntryWithPayload)cacheEntry, (boolean)success, (byte[])PBHelper.longToBytes(result));
                return cacheDirectiveInfo;
            }
        };
        return (CacheDirectiveInfo)addDirectiveHandler.handle();
    }

    static void modifyCacheDirective(final FSNamesystem fsn, final FSDirectory fsd, final CacheManager cacheManager, final CacheDirectiveInfo directive, final EnumSet<CacheFlag> flags) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_CACHE_DIRECTIVE){
            String path;
            List<String> pools;
            {
                super(opType);
                this.pools = new ArrayList<String>(2);
            }

            @Override
            public void setUp() throws IOException {
                CacheDirectiveDataAccess da = (CacheDirectiveDataAccess)HdfsStorageFactory.getDataAccess(CacheDirectiveDataAccess.class);
                CacheDirective originalDirective = (CacheDirective)da.find(directive.getId().longValue());
                if (directive.getPath() != null) {
                    this.path = directive.getPath().toString();
                } else if (originalDirective != null) {
                    this.path = originalDirective.getPath();
                }
                if (directive.getPool() != null) {
                    this.pools.add(directive.getPool());
                }
                if (originalDirective != null) {
                    this.pools.add(originalDirective.getPoolName());
                }
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCacheDirectiveLock(directive.getId())).add(lf.getCachePoolsLock(this.pools));
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, this.path).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                boolean success = false;
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache());
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                try {
                    cacheManager.modifyDirective(directive, pc, flags);
                    success = true;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    static void removeCacheDirective(final FSNamesystem fsn, final CacheManager cacheManager, final long id) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_CACHE_DIRECTIVE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCacheDirectiveLock(id)).add(lf.getCachePoolLock(TransactionLockTypes.LockType.WRITE));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache());
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                    cacheManager.removeDirective(id, pc);
                    success = true;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    static BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(FSNamesystem fsn, CacheManager cacheManager, long startId, CacheDirectiveInfo filter) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        return cacheManager.listCacheDirectives(startId, filter, pc);
    }

    static CachePoolInfo addCachePool(final FSNamesystem fsn, final CacheManager cacheManager, final CachePoolInfo req) throws IOException {
        CachePoolInfo.validate(req);
        final String poolName = req.getPoolName();
        return (CachePoolInfo)new HopsTransactionalRequestHandler(HDFSOperationType.ADD_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCachePoolLock(poolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache());
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    CachePoolInfo info;
                    FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    CachePoolInfo cachePoolInfo = info = cacheManager.addCachePool(req);
                    return cachePoolInfo;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
            }
        }.handle();
    }

    static void modifyCachePool(final FSNamesystem fsn, final CacheManager cacheManager, final CachePoolInfo req) throws IOException {
        CachePoolInfo.validate(req);
        final String poolName = req.getPoolName();
        new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCachePoolLock(poolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache());
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    cacheManager.modifyCachePool(req);
                    success = true;
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    static void removeCachePool(final FSNamesystem fsn, final CacheManager cacheManager, final String cachePoolName) throws IOException {
        CachePoolInfo.validateName(cachePoolName);
        new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_CACHE_POOL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId()));
                }
                locks.add(lf.getCachePoolLock(cachePoolName)).add(lf.getCacheDirectiveLock(cachePoolName));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCache.CacheEntry cacheEntry = RetryCacheDistributed.waitForCompletion((RetryCacheDistributed)fsn.getRetryCache());
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
                    if (pc != null) {
                        pc.checkSuperuserPrivilege();
                    }
                    cacheManager.removeCachePool(cachePoolName);
                }
                finally {
                    RetryCacheDistributed.setState((RetryCache.CacheEntry)cacheEntry, (boolean)success);
                }
                return null;
            }
        }.handle();
    }

    static BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(FSNamesystem fsn, CacheManager cacheManager, String prevKey) throws IOException {
        FSPermissionChecker pc = FSNDNCacheOp.getFsPermissionChecker(fsn);
        return cacheManager.listCachePools(pc, prevKey);
    }

    private static FSPermissionChecker getFsPermissionChecker(FSNamesystem fsn) throws AccessControlException {
        return fsn.isPermissionEnabled() ? fsn.getPermissionChecker() : null;
    }
}

