/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.metadata.hdfs.entity.EncodingPolicy;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;

public class TestUtil {
    public static void createRandomFile(DistributedFileSystem dfs, Path path, long seed, int blockCount, int blockSize) throws IOException {
        HdfsDataOutputStream out = dfs.create(path, new EncodingPolicy("src", 1));
        byte[] buffer = TestUtil.randomBytes(seed, blockCount, blockSize);
        out.write(buffer, 0, buffer.length);
        out.close();
    }

    public static byte[] randomBytes(long seed, int blockCount, int blockSize) {
        return TestUtil.randomBytes(seed, blockCount * blockSize);
    }

    public static byte[] randomBytes(long seed, int size) {
        byte[] b = new byte[size];
        Random rand = new Random(seed);
        rand.nextBytes(b);
        return b;
    }
}

