/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.htrace.core.SpanId;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDFSOutputStream {
    static MiniDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @Test
    public void testCloseTwice() throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        DataStreamer streamer = (DataStreamer)Whitebox.getInternalState((Object)dos, (String)"streamer");
        DataStreamer.LastExceptionInStreamer ex = (DataStreamer.LastExceptionInStreamer)Whitebox.getInternalState((Object)streamer, (String)"lastException");
        Throwable thrown = (Throwable)Whitebox.getInternalState((Object)ex, (String)"thrown");
        Assert.assertNull((Object)thrown);
        dos.close();
        IOException dummy = new IOException("dummy");
        ex.set((Throwable)dummy);
        try {
            dos.close();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e, (Object)dummy);
        }
        thrown = (Throwable)Whitebox.getInternalState((Object)ex, (String)"thrown");
        Assert.assertNull((Object)thrown);
        dos.close();
    }

    @Test
    public void testComputePacketChunkSize() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        int packetSize = 65536;
        int bytesPerChecksum = 512;
        Method method = dos.getClass().getDeclaredMethod("computePacketChunkSize", Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        method.invoke((Object)dos, 65536, 512);
        Field field = dos.getClass().getDeclaredField("packetSize");
        field.setAccessible(true);
        Assert.assertTrue(((Integer)field.get(dos) + 33 < 65536 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)field.get(dos) + 257 < 65536 ? 1 : 0) != 0);
    }

    @Test
    public void testCongestionBackoff() throws IOException {
        DfsClientConf dfsClientConf = (DfsClientConf)Mockito.mock(DfsClientConf.class);
        DFSClient client = (DFSClient)Mockito.mock(DFSClient.class);
        Mockito.when((Object)client.getConf()).thenReturn((Object)dfsClientConf);
        client.clientRunning = true;
        DataStreamer stream = new DataStreamer((HdfsFileStatus)Mockito.mock(HdfsFileStatus.class), (ExtendedBlock)Mockito.mock(ExtendedBlock.class), client, "foo", null, null, null, null, -1, false, null);
        DataOutputStream blockStream = (DataOutputStream)Mockito.mock(DataOutputStream.class);
        ((DataOutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)blockStream)).flush();
        Whitebox.setInternalState((Object)stream, (String)"blockStream", (Object)blockStream);
        Whitebox.setInternalState((Object)stream, (String)"stage", (Object)BlockConstructionStage.PIPELINE_CLOSE);
        LinkedList dataQueue = (LinkedList)Whitebox.getInternalState((Object)stream, (String)"dataQueue");
        ArrayList congestedNodes = (ArrayList)Whitebox.getInternalState((Object)stream, (String)"congestedNodes");
        congestedNodes.add(Mockito.mock(DatanodeInfo.class));
        DFSPacket packet = (DFSPacket)Mockito.mock(DFSPacket.class);
        Mockito.when((Object)packet.getTraceParents()).thenReturn((Object)new SpanId[0]);
        dataQueue.add(packet);
        stream.run();
        Assert.assertTrue((boolean)congestedNodes.isEmpty());
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }
}

