/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultNameNodePort {
    @Test
    public void testGetAddressFromString() throws Exception {
        Assert.assertEquals((long)NameNode.getAddress((String)"foo").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress((String)"hopsfs://foo/").getPort(), (long)8020L);
        Assert.assertEquals((long)NameNode.getAddress((String)"hopsfs://foo:555").getPort(), (long)555L);
        Assert.assertEquals((long)NameNode.getAddress((String)"foo:555").getPort(), (long)555L);
    }

    @Test
    public void testGetAddressFromConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hopsfs://foo/");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)8020L);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hopsfs://foo:555/");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)555L);
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo");
        Assert.assertEquals((long)NameNode.getAddress((Configuration)conf).getPort(), (long)8020L);
    }

    @Test
    public void testGetUri() {
        Assert.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 555)), (Object)URI.create("hopsfs://foo:555"));
        Assert.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 8020)), (Object)URI.create("hopsfs://foo"));
    }
}

