/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.BaseTestLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LeaseRenewer;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.TestSubtreeLock;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestLease {
    static final String dirString = "/test/lease";
    final Path dir = new Path("/test/lease");
    static final Log LOG = LogFactory.getLog(TestLease.class);
    Configuration conf = new HdfsConfiguration();
    static final ClientProtocol mcp = (ClientProtocol)Mockito.mock(ClientProtocol.class);

    static boolean hasLease(final MiniDFSCluster cluster, final Path src) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                locks.add((Lock)new TestLeaseLock(TransactionLockTypes.LockType.READ, TransactionLockTypes.LockType.WRITE, src.toString()));
            }

            public Object performTask() throws IOException {
                return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).getLeaseByPath(src.toString()) != null;
            }
        }.handle();
    }

    static int leaseCount(MiniDFSCluster cluster) throws IOException {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseAbort() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            NamenodeProtocols preSpyNN = cluster.getNameNodeRpc();
            NamenodeProtocols spyNN = (NamenodeProtocols)Mockito.spy((Object)preSpyNN);
            DFSClient dfs = new DFSClient(null, (ClientProtocol)spyNN, this.conf, null);
            byte[] buf = new byte[1024];
            FSDataOutputStream c_out = this.createFsOut(dfs, "/test/leasec");
            c_out.write(buf, 0, 1024);
            c_out.close();
            DFSInputStream c_in = dfs.open("/test/leasec");
            FSDataOutputStream d_out = this.createFsOut(dfs, "/test/leased");
            ((NamenodeProtocols)Mockito.doThrow((Throwable)new RemoteException(SecretManager.InvalidToken.class.getName(), "Your token is worthless")).when((Object)spyNN)).renewLease(Matchers.anyString());
            LeaseRenewer originalRenewer = dfs.getLeaseRenewer();
            dfs.lastLeaseRenewal = Time.monotonicNow() - 60000L - 1000L;
            try {
                dfs.renewLease();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                d_out.write(buf, 0, 1024);
                LOG.info((Object)"Write worked beyond the soft limit as expected.");
            }
            catch (IOException e) {
                Assert.fail((String)"Write failed.");
            }
            dfs.lastLeaseRenewal = Time.monotonicNow() - 3600000L - 1000L;
            dfs.renewLease();
            try {
                d_out.write(buf, 0, 1024);
                d_out.close();
                Assert.fail((String)"Write did not fail even after the fatal lease renewal failure");
            }
            catch (IOException e) {
                LOG.info((Object)"Write failed as expected. ", (Throwable)e);
            }
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)originalRenewer.isEmpty());
            ((NamenodeProtocols)Mockito.doNothing().when((Object)spyNN)).renewLease(Matchers.anyString());
            try {
                int num = c_in.read(buf, 0, 1);
                if (num != 1) {
                    Assert.fail((String)"Failed to read 1 byte");
                }
                c_in.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Read failed with ", (Throwable)e);
                Assert.fail((String)"Read after lease renewal failure failed");
            }
            try {
                c_out = this.createFsOut(dfs, "/test/leasec");
                c_out.write(buf, 0, 1024);
                c_out.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Write failed with ", (Throwable)e);
                Assert.fail((String)"Write failed");
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseAfterRename() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        try {
            Path p = new Path("/test-file");
            Path d = new Path("/test-d");
            Path d2 = new Path("/test-d-other");
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(p);
            out.writeBytes("something");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, p));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            DistributedFileSystem fs2 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            LOG.info((Object)"DMS: rename file into dir");
            Path pRenamed = new Path(d, p.getName());
            fs2.mkdirs(d);
            fs2.rename(p, pRenamed);
            Assert.assertFalse((String)"Subtree locks were not cleared properly", (boolean)TestSubtreeLock.subTreeLocksExists());
            Assert.assertFalse((String)(p + " exists"), (boolean)fs2.exists(p));
            Assert.assertTrue((String)(pRenamed + " not found"), (boolean)fs2.exists(pRenamed));
            Assert.assertFalse((String)("has lease for " + p), (boolean)TestLease.hasLease(cluster, p));
            Assert.assertTrue((String)("no lease for " + pRenamed), (boolean)TestLease.hasLease(cluster, pRenamed));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            LOG.info((Object)"DMS: rename parent dir");
            Path pRenamedAgain = new Path(d2, pRenamed.getName());
            fs2.rename(d, d2);
            Assert.assertFalse((String)"Subtree locks were not cleared properly", (boolean)TestSubtreeLock.subTreeLocksExists());
            Assert.assertFalse((String)(d + " exists"), (boolean)fs2.exists(d));
            Assert.assertFalse((String)("has lease for " + pRenamed), (boolean)TestLease.hasLease(cluster, pRenamed));
            Assert.assertTrue((String)(d2 + " not found"), (boolean)fs2.exists(d2));
            Assert.assertTrue((String)(pRenamedAgain + " not found"), (boolean)fs2.exists(pRenamedAgain));
            Assert.assertTrue((String)("no lease for " + pRenamedAgain), (boolean)TestLease.hasLease(cluster, pRenamedAgain));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            LOG.info((Object)"DMS: rename parent again");
            pRenamed = pRenamedAgain;
            pRenamedAgain = new Path(new Path(d, d2.getName()), p.getName());
            fs2.mkdirs(d);
            Assert.assertFalse((String)"Subtree locks were not cleared properly", (boolean)TestSubtreeLock.subTreeLocksExists());
            fs2.rename(d2, d);
            Assert.assertFalse((String)(d2 + " exists"), (boolean)fs2.exists(d2));
            Assert.assertFalse((String)("no lease for " + pRenamed), (boolean)TestLease.hasLease(cluster, pRenamed));
            Assert.assertTrue((String)(d + " not found"), (boolean)fs2.exists(d));
            Assert.assertTrue((String)(pRenamedAgain + " not found"), (boolean)fs2.exists(pRenamedAgain));
            Assert.assertTrue((String)("no lease for " + pRenamedAgain), (boolean)TestLease.hasLease(cluster, pRenamedAgain));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            pRenamed = pRenamedAgain;
            pRenamedAgain = new Path(d2, p.getName());
            fs2.rename(pRenamed.getParent(), d2, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertFalse((String)(pRenamed.getParent() + " not found"), (boolean)fs2.exists(pRenamed.getParent()));
            Assert.assertFalse((String)("has lease for " + pRenamed), (boolean)TestLease.hasLease(cluster, pRenamed));
            Assert.assertTrue((String)(d2 + " not found"), (boolean)fs2.exists(d2));
            Assert.assertTrue((String)(pRenamedAgain + " not found"), (boolean)fs2.exists(pRenamedAgain));
            Assert.assertTrue((String)("no lease for " + pRenamedAgain), (boolean)TestLease.hasLease(cluster, pRenamedAgain));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            pRenamed = pRenamedAgain;
            pRenamedAgain = new Path(d, p.getName());
            fs2.rename(pRenamed.getParent(), d, new Options.Rename[]{Options.Rename.OVERWRITE});
            Assert.assertFalse((String)(pRenamed.getParent() + " not found"), (boolean)fs2.exists(pRenamed.getParent()));
            Assert.assertFalse((String)("has lease for " + pRenamed), (boolean)TestLease.hasLease(cluster, pRenamed));
            Assert.assertTrue((String)(d + " not found"), (boolean)fs2.exists(d));
            Assert.assertTrue((String)(pRenamedAgain + " not found"), (boolean)fs2.exists(pRenamedAgain));
            Assert.assertTrue((String)("no lease for " + pRenamedAgain), (boolean)TestLease.hasLease(cluster, pRenamedAgain));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseAfterRenameAndRecreate() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        try {
            Path path1 = new Path("/test-file");
            String contents1 = "contents1";
            Path path2 = new Path("/test-file-new-location");
            String contents2 = "contents2";
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out1 = fs.create(path1);
            out1.writeBytes("contents1");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, path1));
            Assert.assertEquals((long)1L, (long)TestLease.leaseCount(cluster));
            DistributedFileSystem fs2 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            fs2.rename(path1, path2);
            FSDataOutputStream out2 = fs2.create(path1);
            out2.writeBytes("contents2");
            out2.close();
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, path2));
            out1.close();
            DistributedFileSystem fs3 = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
            Assert.assertEquals((Object)"contents1", (Object)DFSTestUtil.readFile((FileSystem)fs3, path2));
            Assert.assertEquals((Object)"contents2", (Object)DFSTestUtil.readFile((FileSystem)fs3, path1));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLease() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path b = new Path(this.dir, "b");
            FSDataOutputStream a_out = fs.create(a);
            a_out.writeBytes("something");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, a));
            Assert.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            FSDataOutputStream b_out = fs.create(b);
            b_out.writeBytes("something");
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, a));
            Assert.assertTrue((boolean)TestLease.hasLease(cluster, b));
            a_out.close();
            b_out.close();
            Assert.assertTrue((!TestLease.hasLease(cluster, a) ? 1 : 0) != 0);
            Assert.assertTrue((!TestLease.hasLease(cluster, b) ? 1 : 0) != 0);
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testFactory() throws Exception {
        String[] groups = new String[]{"supergroup"};
        UserGroupInformation[] ugi = new UserGroupInformation[3];
        for (int i = 0; i < ugi.length; ++i) {
            ugi[i] = UserGroupInformation.createUserForTesting((String)("user" + i), (String[])groups);
        }
        ((ClientProtocol)Mockito.doReturn((Object)new HdfsFileStatus(0L, false, 1, 1024L, 0L, 0L, new FsPermission(777), "owner", "group", new byte[0], new byte[0], 1010L, 0, null, 0)).when((Object)mcp)).getFileInfo(Matchers.anyString());
        ((ClientProtocol)Mockito.doReturn((Object)new HdfsFileStatus(0L, false, 1, 1024L, 0L, 0L, new FsPermission(777), "owner", "group", new byte[0], new byte[0], 1010L, 0, null, 0)).when((Object)mcp)).create(Matchers.anyString(), (FsPermission)Matchers.anyObject(), Matchers.anyString(), (EnumSetWritable)Matchers.anyObject(), Matchers.anyBoolean(), Matchers.anyShort(), Matchers.anyLong(), (CryptoProtocolVersion[])Matchers.anyObject(), (EncodingPolicy)Matchers.any(EncodingPolicy.class));
        Configuration conf = new Configuration();
        DFSClient c1 = TestLease.createDFSClientAs(ugi[0], conf);
        FSDataOutputStream out1 = this.createFsOut(c1, "/out1");
        DFSClient c2 = TestLease.createDFSClientAs(ugi[0], conf);
        FSDataOutputStream out2 = this.createFsOut(c2, "/out2");
        Assert.assertEquals((Object)c1.getLeaseRenewer(), (Object)c2.getLeaseRenewer());
        DFSClient c3 = TestLease.createDFSClientAs(ugi[1], conf);
        FSDataOutputStream out3 = this.createFsOut(c3, "/out3");
        Assert.assertTrue((c1.getLeaseRenewer() != c3.getLeaseRenewer() ? 1 : 0) != 0);
        DFSClient c4 = TestLease.createDFSClientAs(ugi[1], conf);
        FSDataOutputStream out4 = this.createFsOut(c4, "/out4");
        Assert.assertEquals((Object)c3.getLeaseRenewer(), (Object)c4.getLeaseRenewer());
        DFSClient c5 = TestLease.createDFSClientAs(ugi[2], conf);
        FSDataOutputStream out5 = this.createFsOut(c5, "/out5");
        Assert.assertTrue((c1.getLeaseRenewer() != c5.getLeaseRenewer() ? 1 : 0) != 0);
        Assert.assertTrue((c3.getLeaseRenewer() != c5.getLeaseRenewer() ? 1 : 0) != 0);
    }

    private FSDataOutputStream createFsOut(DFSClient dfs, String path) throws IOException {
        return new FSDataOutputStream(dfs.create(path, true), null);
    }

    public static DFSClient createDFSClientAs(UserGroupInformation ugi, final Configuration conf) throws Exception {
        return (DFSClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

            @Override
            public DFSClient run() throws Exception {
                return new DFSClient(null, mcp, conf, null);
            }
        });
    }

    public static class TestLeaseLock
    extends BaseTestLock {
        private final TransactionLockTypes.LockType leasePathLock;
        private final TransactionLockTypes.LockType leaseLock;
        private final String leasePath;

        public TestLeaseLock(TransactionLockTypes.LockType leasePathLock, TransactionLockTypes.LockType leaseLock, String leasePath) {
            this.leasePathLock = leasePathLock;
            this.leaseLock = leaseLock;
            this.leasePath = leasePath;
        }

        protected void acquire(TransactionLocks locks) throws IOException {
            LeasePath lp = (LeasePath)this.acquireLock(this.leasePathLock, (FinderType)LeasePath.Finder.ByPath, new Object[]{this.leasePath});
            if (lp != null) {
                this.acquireLock(this.leaseLock, (FinderType)Lease.Finder.ByHolderId, new Object[]{lp.getHolderId()});
            }
        }
    }
}

