/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestDelegationToken {
    private MiniDFSCluster cluster;
    private DelegationTokenSecretManager dtSecretManager;
    private Configuration config;
    private static final Log LOG = LogFactory.getLog(TestDelegationToken.class);

    @Before
    public void setUp() throws Exception {
        this.config = new HdfsConfiguration();
        this.config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        this.config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        this.config.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.config.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hopsfs://localhost:0");
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(0).build();
        this.cluster.waitActive();
        this.dtSecretManager = NameNodeAdapter.getDtSecretManager(this.cluster.getNamesystem());
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private Token<DelegationTokenIdentifier> generateDelegationToken(String owner, String renewer) {
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), null);
        return new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
    }

    @Test
    public void testDelegationTokenSecretManager() throws Exception {
        Token<DelegationTokenIdentifier> token = this.generateDelegationToken("SomeUser", "JobTracker");
        try {
            this.dtSecretManager.renewToken(token, "FakeRenewer");
            Assert.fail((String)"should have failed");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.dtSecretManager.renewToken(token, "JobTracker");
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        Assert.assertTrue((null != this.dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier) ? 1 : 0) != 0);
        LOG.info((Object)"Sleep to expire the token");
        Thread.sleep(6000L);
        try {
            this.dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
            Assert.fail((String)"Token should have expired");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
        this.dtSecretManager.renewToken(token, "JobTracker");
        LOG.info((Object)"Sleep beyond the max lifetime");
        Thread.sleep(5000L);
        try {
            this.dtSecretManager.renewToken(token, "JobTracker");
            Assert.fail((String)"should have been expired");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        Token<DelegationTokenIdentifier> token = this.generateDelegationToken("SomeUser", "JobTracker");
        try {
            this.dtSecretManager.cancelToken(token, "FakeCanceller");
            Assert.fail((String)"should have failed");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.dtSecretManager.cancelToken(token, "JobTracker");
        try {
            this.dtSecretManager.renewToken(token, "JobTracker");
            Assert.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void testAddDelegationTokensDFSApi() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"JobTracker");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Credentials creds = new Credentials();
        Token[] tokens = dfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)1L, (long)tokens.length);
        Assert.assertEquals((long)1L, (long)creds.numberOfTokens());
        this.checkTokenIdentifier(ugi, tokens[0]);
        Token[] tokens2 = dfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)0L, (long)tokens2.length);
        Assert.assertEquals((long)1L, (long)creds.numberOfTokens());
    }

    @Test
    public void testDelegationTokenWebHdfsApi() throws Exception {
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        final String uri = "webhdfs://" + this.config.get("dfs.namenode.http-address");
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"JobTracker", (String[])new String[]{"user"});
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws Exception {
                return (WebHdfsFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)TestDelegationToken.this.config);
            }
        });
        Credentials creds = new Credentials();
        Token[] tokens = webhdfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)1L, (long)tokens.length);
        Assert.assertEquals((long)1L, (long)creds.numberOfTokens());
        Assert.assertSame((Object)tokens[0], creds.getAllTokens().iterator().next());
        this.checkTokenIdentifier(ugi, tokens[0]);
        Token[] tokens2 = webhdfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)0L, (long)tokens2.length);
    }

    @Ignore
    @Test
    public void testDelegationTokenWithDoAs() throws Exception {
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Credentials creds = new Credentials();
        Token[] tokens = dfs.addDelegationTokens("JobTracker", creds);
        Assert.assertEquals((long)1L, (long)tokens.length);
        final Token token = tokens[0];
        final UserGroupInformation longUgi = UserGroupInformation.createRemoteUser((String)"JobTracker/foo.com@FOO.COM");
        UserGroupInformation shortUgi = UserGroupInformation.createRemoteUser((String)"JobTracker");
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                try {
                    token.renew(TestDelegationToken.this.config);
                }
                catch (Exception e) {
                    Assert.fail((String)("Could not renew delegation token for user " + longUgi));
                }
                return null;
            }
        });
        shortUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                token.renew(TestDelegationToken.this.config);
                return null;
            }
        });
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                try {
                    token.cancel(TestDelegationToken.this.config);
                }
                catch (Exception e) {
                    Assert.fail((String)("Could not cancel delegation token for user " + longUgi));
                }
                return null;
            }
        });
    }

    @Test
    public void testDTManagerInSafeMode() throws Exception {
        this.cluster.startDataNodes(this.config, 1, true, HdfsServerConstants.StartupOption.REGULAR, null);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        for (int i = 0; i < 5; ++i) {
            DFSTestUtil.createFile((FileSystem)fs, new Path("/test-" + i), 100L, (short)1, 1L);
        }
        this.cluster.getConfiguration(0).setInt("dfs.namenode.delegation.key.update-interval", 500);
        this.cluster.getConfiguration(0).setInt("dfs.namenode.safemode.extension", 30000);
        this.cluster.setWaitSafeMode(false);
        this.cluster.restartNameNode(new String[0]);
        NameNode nn = this.cluster.getNameNode();
        Assert.assertTrue((boolean)nn.isInSafeMode());
        DelegationTokenSecretManager sm = NameNodeAdapter.getDtSecretManager(nn.getNamesystem());
        Assert.assertFalse((String)"Secret manager should not run in safe mode", (boolean)sm.isRunning());
        NameNodeAdapter.leaveSafeMode(nn);
        Assert.assertTrue((String)"Secret manager should start when safe mode is exited", (boolean)sm.isRunning());
        LOG.info((Object)"========= entering safemode again");
        NameNodeAdapter.enterSafeMode(nn, false);
        Assert.assertFalse((String)"Secret manager should stop again when safe mode is manually entered", (boolean)sm.isRunning());
        this.cluster.getConfiguration(0).setInt("dfs.namenode.safemode.extension", 0);
        this.cluster.setWaitSafeMode(true);
        this.cluster.restartNameNode(new String[0]);
        nn = this.cluster.getNameNode();
        sm = NameNodeAdapter.getDtSecretManager(nn.getNamesystem());
        Assert.assertFalse((boolean)nn.isInSafeMode());
        Assert.assertTrue((boolean)sm.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTokenIdentifier(UserGroupInformation ugi, final Token<?> token) throws Exception {
        Assert.assertNotNull(token);
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(tokenId));){
            identifier.readFields((DataInput)in);
        }
        Assert.assertNotNull((Object)identifier);
        LOG.info((Object)"A valid token should have non-null password, and should be renewed successfully");
        Assert.assertTrue((null != this.dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier) ? 1 : 0) != 0);
        this.dtSecretManager.renewToken(token, "JobTracker");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                token.renew(TestDelegationToken.this.config);
                token.cancel(TestDelegationToken.this.config);
                return null;
            }
        });
    }
}

