/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Preconditions;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.util.Daemon;
import org.junit.Assert;

public class BlockManagerTestUtil {
    public static void setNodeReplicationLimit(BlockManager blockManager, int limit) {
        blockManager.maxReplicationStreams = limit;
    }

    public static DatanodeDescriptor getDatanode(FSNamesystem ns, String dnUuid) {
        return ns.getBlockManager().getDatanodeManager().getDatanodeByUuid(dnUuid);
    }

    public static void updateState(BlockManager blockManager) throws IOException {
        blockManager.updateState();
    }

    public static int[] getReplicaInfo(FSNamesystem namesystem, final Block b) throws IOException {
        final BlockManager bm = namesystem.getBlockManager();
        return (int[])new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)b);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(b.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                return new int[]{BlockManagerTestUtil.getNumberOfRacks(bm, b), bm.countNodes(b).liveReplicas(), bm.neededReplications.contains(bm.getStoredBlock(b)) ? 1 : 0};
            }
        }.handle((Object)namesystem);
    }

    private static int getNumberOfRacks(BlockManager blockManager, Block b) throws StorageException, TransactionContextException {
        HashSet<String> rackSet = new HashSet<String>(0);
        Collection corruptNodes = BlockManagerTestUtil.getCorruptReplicas(blockManager).getNodes(blockManager.blocksMap.getStoredBlock(b));
        for (DatanodeStorageInfo storage : blockManager.blocksMap.storageList(b)) {
            String rackName;
            DatanodeDescriptor cur = storage.getDatanodeDescriptor();
            if (cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur) || rackSet.contains(rackName = cur.getNetworkLocation())) continue;
            rackSet.add(rackName);
        }
        return rackSet.size();
    }

    public static Daemon getReplicationThread(BlockManager blockManager) {
        return blockManager.replicationThread;
    }

    public static void stopReplicationThread(BlockManager blockManager) throws IOException {
        blockManager.enableRMTerminationForTesting();
        blockManager.replicationThread.interrupt();
        try {
            blockManager.replicationThread.join();
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted while trying to stop ReplicationMonitor");
        }
    }

    public static CorruptReplicasMap getCorruptReplicas(BlockManager blockManager) {
        return blockManager.corruptReplicas;
    }

    public static int getComputedDatanodeWork(BlockManager blockManager) throws IOException {
        return blockManager.computeDatanodeWork();
    }

    public static int computeInvalidationWork(BlockManager bm) throws IOException {
        return bm.computeInvalidateWork(Integer.MAX_VALUE);
    }

    public static int computeAllPendingWork(BlockManager bm) throws IOException {
        int work = BlockManagerTestUtil.computeInvalidationWork(bm);
        return work += bm.computeReplicationWork(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noticeDeadDatanode(NameNode nn, String dnName) throws IOException {
        FSNamesystem namesystem = nn.getNamesystem();
        DatanodeManager dnm = namesystem.getBlockManager().getDatanodeManager();
        HeartbeatManager hbm = dnm.getHeartbeatManager();
        HeartbeatManager dnds = hbm.getDatanodes();
        DatanodeDescriptor theDND = null;
        for (DatanodeDescriptor dnd : dnds) {
            if (!dnd.getXferAddr().equals(dnName)) continue;
            theDND = dnd;
        }
        Assert.assertNotNull((String)("Could not find DN with name: " + dnName), theDND);
        HeartbeatManager heartbeatManager = hbm;
        synchronized (heartbeatManager) {
            DFSTestUtil.setDatanodeDead((DatanodeInfo)theDND);
            hbm.heartbeatCheck();
        }
        for (Integer sid : theDND.getSidsOnNode()) {
            int retry = 0;
            while (!BlockManagerTestUtil.getReplicas(sid).isEmpty() && retry < 10) {
                try {
                    Thread.sleep(1000L);
                    ++retry;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlockManagerTestUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            Assert.assertNotEquals((long)retry, (long)10L);
        }
    }

    private static Map<Long, Long> getReplicas(final int sid) throws IOException {
        return (Map)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                return da.findBlockAndInodeIdsByStorageId(sid);
            }
        }.handle();
    }

    public static void setWritingPrefersLocalNode(BlockManager bm, boolean prefer) {
        BlockPlacementPolicy bpp = bm.getBlockPlacementPolicy();
        Preconditions.checkState((boolean)(bpp instanceof BlockPlacementPolicyDefault), (String)"Must use default policy, got %s", (Object[])new Object[]{bpp.getClass()});
        ((BlockPlacementPolicyDefault)bpp).setPreferLocalNode(prefer);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, boolean initializeStorage) throws IOException {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, initializeStorage ? new DatanodeStorage(DatanodeStorage.generateUuid()) : null);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage) throws IOException {
        return BlockManagerTestUtil.getDatanodeDescriptor(ipAddr, rackLocation, storage, "host");
    }

    public static void checkHeartbeat(BlockManager bm) throws IOException {
        bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    public static int checkHeartbeatAndGetUnderReplicatedBlocksCount(BlockManager bm) throws IOException {
        bm.getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        return bm.getUnderReplicatedNotMissingBlocks();
    }

    public static DatanodeStorageInfo updateStorage(DatanodeDescriptor dn, DatanodeStorage s) throws IOException {
        return dn.updateStorage(s);
    }

    public static DatanodeDescriptor getDatanodeDescriptor(String ipAddr, String rackLocation, DatanodeStorage storage, String hostname) throws IOException {
        DatanodeDescriptor dn = DFSTestUtil.getDatanodeDescriptor(ipAddr, 50010, rackLocation, hostname);
        if (storage != null) {
            dn.updateStorage(storage);
        }
        return dn;
    }

    public static void rescanPostponedMisreplicatedBlocks(BlockManager bm) throws IOException {
        bm.rescanPostponedMisreplicatedBlocks();
    }

    public static StorageReport[] getStorageReportsForDatanode(DatanodeDescriptor dnd) {
        ArrayList<StorageReport> reports = new ArrayList<StorageReport>();
        for (DatanodeStorageInfo storage : dnd.getStorageInfos()) {
            DatanodeStorage dns = new DatanodeStorage(storage.getStorageID(), storage.getState(), storage.getStorageType());
            StorageReport report = new StorageReport(dns, false, storage.getCapacity(), storage.getDfsUsed(), storage.getRemaining(), storage.getBlockPoolUsed());
            reports.add(report);
        }
        return reports.toArray(StorageReport.EMPTY_ARRAY);
    }

    public static void recheckDecommissionState(DatanodeManager dm) throws ExecutionException, InterruptedException {
        dm.getDecomManager().runMonitor();
    }
}

