/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestDataNodeVolumeFailure {
    private final int block_size = 512;
    MiniDFSCluster cluster = null;
    private Configuration conf;
    int dn_num = 2;
    int blocks_num = 30;
    short repl = (short)2;
    File dataDir = null;
    File data_fail = null;
    File failedDir = null;
    Map<String, BlockLocs> block_map = new HashMap<String, BlockLocs>();

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.conf.setInt("dfs.block.fetcher.buckets.per.thread", 1000);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.dn_num).build();
        this.cluster.waitActive();
        this.dataDir = new File(this.cluster.getDataDirectory());
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            for (File dir : this.cluster.getAllInstanceStorageDirs()) {
                dir.setExecutable(true);
            }
        }
        if (this.data_fail != null) {
            this.data_fail.setWritable(true);
        }
        if (this.failedDir != null) {
            this.failedDir.setWritable(true);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testVolumeFailure() throws Exception {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        this.dataDir = new File(this.cluster.getDataDirectory());
        System.out.println("Data dir: is " + this.dataDir.getPath());
        String filename = "/test.txt";
        Path filePath = new Path(filename);
        int filesize = 512 * this.blocks_num;
        DFSTestUtil.createFile((FileSystem)fs, filePath, filesize, this.repl, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, this.repl);
        System.out.println("file " + filename + "(size " + filesize + ") is created and replicated");
        this.data_fail = new File(this.dataDir, "data3");
        this.failedDir = MiniDFSCluster.getFinalizedDir(this.dataDir, this.cluster.getNamesystem().getBlockPoolId());
        if (this.failedDir.exists() && !this.deteteBlocks(this.failedDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.failedDir + "'");
        }
        this.data_fail.setReadOnly();
        this.failedDir.setReadOnly();
        System.out.println("Deleting " + this.failedDir.getPath() + "; exist=" + this.failedDir.exists());
        this.triggerFailure(filename, filesize);
        DataNode dn = this.cluster.getDataNodes().get(1);
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        DatanodeRegistration dnR = dn.getDNRegistrationForBP(bpid);
        Map perVolumeBlockLists = dn.getFSDataset().getBlockReports(bpid);
        StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
        int reportIndex = 0;
        for (Map.Entry kvPair : perVolumeBlockLists.entrySet()) {
            DatanodeStorage dnStorage = (DatanodeStorage)kvPair.getKey();
            BlockReport blockList = (BlockReport)kvPair.getValue();
            reports[reportIndex++] = new StorageBlockReport(dnStorage, blockList);
        }
        this.cluster.getNameNodeRpc().blockReport(dnR, bpid, reports, null);
        this.verify(filename, filesize);
        System.out.println("creating file test1.txt");
        Path fileName1 = new Path("/test1.txt");
        DFSTestUtil.createFile((FileSystem)fs, fileName1, filesize, this.repl, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, fileName1, this.repl);
        System.out.println("file " + fileName1.getName() + " is created and replicated");
    }

    @Test(timeout=150000L)
    public void testFailedVolumeBeingRemovedFromDataNode() throws InterruptedException, IOException, TimeoutException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        this.dataDir = new File(this.cluster.getDataDirectory());
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)2, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)2);
        File dn0Vol1 = new File(this.dataDir, "data_0_0");
        DataNodeTestUtils.injectDataDirFailure(dn0Vol1);
        DataNode dn0 = this.cluster.getDataNodes().get(0);
        long lastDiskErrorCheck = dn0.getLastDiskErrorCheck();
        dn0.checkDiskErrorAsync();
        while (dn0.getLastDiskErrorCheck() == lastDiskErrorCheck) {
            Thread.sleep(100L);
        }
        DataStorage storage = dn0.getStorage();
        Assert.assertEquals((long)1L, (long)storage.getNumStorageDirs());
        for (int i = 0; i < storage.getNumStorageDirs(); ++i) {
            Storage.StorageDirectory sd = storage.getStorageDir(i);
            Assert.assertFalse((boolean)sd.getRoot().getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
        }
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        BlockPoolSliceStorage bpsStorage = storage.getBPStorage(bpid);
        Assert.assertEquals((long)1L, (long)bpsStorage.getNumStorageDirs());
        for (int i = 0; i < bpsStorage.getNumStorageDirs(); ++i) {
            Storage.StorageDirectory sd = bpsStorage.getStorageDir(i);
            Assert.assertFalse((boolean)sd.getRoot().getAbsolutePath().startsWith(dn0Vol1.getAbsolutePath()));
        }
        FsDatasetSpi data = dn0.getFSDataset();
        for (FsVolumeSpi volume : data.getVolumes()) {
            Assert.assertNotEquals((Object)new File(volume.getBasePath()).getAbsoluteFile(), (Object)dn0Vol1.getAbsoluteFile());
        }
        for (ReplicaInfo replica : FsDatasetTestUtil.getReplicas(data, bpid)) {
            Assert.assertNotNull((Object)replica.getVolume());
            Assert.assertNotEquals((Object)new File(replica.getVolume().getBasePath()).getAbsoluteFile(), (Object)dn0Vol1.getAbsoluteFile());
        }
        String[] dataDirStrs = dn0.getConf().get("dfs.datanode.data.dir").split(",");
        Assert.assertEquals((long)1L, (long)dataDirStrs.length);
        Assert.assertFalse((boolean)dataDirStrs[0].contains(dn0Vol1.getAbsolutePath()));
    }

    @Test
    @Ignore
    public void testUnderReplicationAfterVolFailure() throws Exception {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        this.cluster.startDataNodes(this.conf, 1, true, null, null);
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)3);
        File dn1Vol1 = this.cluster.getInstanceStorageDir(0, 0);
        File dn2Vol1 = this.cluster.getInstanceStorageDir(1, 0);
        DataNodeTestUtils.injectDataDirFailure(dn1Vol1, dn2Vol1);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile((FileSystem)fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, file2, (short)3);
        int underReplicatedBlocks = BlockManagerTestUtil.checkHeartbeatAndGetUnderReplicatedBlocksCount(bm);
        Assert.assertTrue((String)"There is no under replicated block after volume failure", (underReplicatedBlocks > 0 ? 1 : 0) != 0);
    }

    private void verify(String fn, int fs) throws IOException {
        int totalReal = this.countRealBlocks(this.block_map);
        System.out.println("countRealBlocks counted " + totalReal + " blocks");
        int totalNN = this.countNNBlocks(this.block_map, fn, fs);
        System.out.println("countNNBlocks counted " + totalNN + " blocks");
        for (String bid : this.block_map.keySet()) {
            BlockLocs bl = this.block_map.get(bid);
            Assert.assertEquals((String)"Num files should match num locations", (long)bl.num_files, (long)bl.num_locs);
        }
        Assert.assertEquals((String)"Num physical blocks should match num stored in the NN", (long)totalReal, (long)totalNN);
        FSNamesystem fsn = this.cluster.getNamesystem();
        BlockManagerTestUtil.getComputedDatanodeWork(fsn.getBlockManager());
        long underRepl = fsn.getUnderReplicatedBlocks();
        long pendRepl = fsn.getPendingReplicationBlocks();
        long totalRepl = underRepl + pendRepl;
        System.out.println("underreplicated after = " + underRepl + " and pending repl =" + pendRepl + "; total underRepl = " + totalRepl);
        System.out.println("total blocks (real and replicating):" + ((long)totalReal + totalRepl) + " vs. all files blocks " + this.blocks_num * 2);
        Assert.assertEquals((String)"Incorrect total block count", (long)((long)totalReal + totalRepl), (long)(this.blocks_num * this.repl));
    }

    private void triggerFailure(String path, long size) throws IOException {
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            DatanodeInfo dinfo = lb.getLocations()[1];
            ExtendedBlock b = lb.getBlock();
            try {
                this.accessBlock(dinfo, lb);
            }
            catch (IOException e) {
                System.out.println("Failure triggered, on block: " + b.getBlockId() + "; corresponding volume should be removed by now");
                break;
            }
        }
    }

    private boolean deteteBlocks(File dir) {
        File[] fileList;
        for (File f : fileList = dir.listFiles()) {
            if (!f.getName().startsWith("blk_") || f.delete()) continue;
            return false;
        }
        return true;
    }

    private void accessBlock(DatanodeInfo datanode, LocatedBlock lblock) throws IOException {
        InetSocketAddress targetAddr = null;
        ExtendedBlock block = lblock.getBlock();
        targetAddr = NetUtils.createSocketAddr((String)datanode.getXferAddr());
        BlockReader blockReader = new BlockReaderFactory(new DfsClientConf(this.conf)).setInetSocketAddress(targetAddr).setExtendedBlock(block).setFileName(BlockReaderFactory.getFileName((InetSocketAddress)targetAddr, (String)"test-blockpoolid", (long)block.getBlockId())).setBlockToken(lblock.getBlockToken()).setStartOffset(0L).setLength(-1L).setVerifyChecksum(true).setClientName("TestDataNodeVolumeFailure").setDatanodeInfo(datanode).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setClientCacheContext(ClientContext.getFromConf((Configuration)this.conf)).setConfiguration(this.conf).setTracer(FsTracer.get((Configuration)this.conf)).setRemotePeerFactory(new RemotePeerFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                Peer peer = null;
                Socket sock = NetUtils.getSocketFactoryFromProperty((Configuration)TestDataNodeVolumeFailure.this.conf, (String)TestDataNodeVolumeFailure.this.conf.get("dfs.client.xceiver.socket.factory.class", "org.apache.hadoop.net.StandardSocketFactory")).createSocket();
                try {
                    sock.connect(addr, HdfsServerConstants.READ_TIMEOUT);
                    sock.setSoTimeout(HdfsServerConstants.READ_TIMEOUT);
                    peer = TcpPeerServer.peerFromSocket((Socket)sock);
                }
                finally {
                    if (peer == null) {
                        IOUtils.closeSocket((Socket)sock);
                    }
                }
                return peer;
            }
        }).build();
        blockReader.close();
    }

    private int countNNBlocks(Map<String, BlockLocs> map, String path, long size) throws IOException {
        int total = 0;
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        List locatedBlocks = nn.getBlockLocations(path, 0L, size).getLocatedBlocks();
        for (LocatedBlock lb : locatedBlocks) {
            String blockId = "" + lb.getBlock().getBlockId();
            DatanodeInfo[] dn_locs = lb.getLocations();
            BlockLocs bl = map.get(blockId);
            if (bl == null) {
                bl = new BlockLocs();
            }
            total += dn_locs.length;
            bl.num_locs += dn_locs.length;
            map.put(blockId, bl);
        }
        return total;
    }

    private int countRealBlocks(Map<String, BlockLocs> map) {
        int total = 0;
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < this.dn_num; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                if (dir == null) {
                    System.out.println("dir is null for dn=" + i + " and data_dir=" + j);
                    continue;
                }
                List<File> res = MiniDFSCluster.getAllBlockMetadataFiles(dir);
                if (res == null) {
                    System.out.println("res is null for dir = " + dir + " i=" + i + " and j=" + j);
                    continue;
                }
                for (File f : res) {
                    String s = f.getName();
                    Assert.assertNotNull((String)"Block file name should not be null", (Object)s);
                    String bid = s.substring(s.indexOf("_") + 1, s.lastIndexOf("_"));
                    BlockLocs val = map.get(bid);
                    if (val == null) {
                        val = new BlockLocs();
                    }
                    ++val.num_files;
                    map.put(bid, val);
                }
                total += res.size();
            }
        }
        return total;
    }

    private class BlockLocs {
        public int num_files = 0;
        public int num_locs = 0;

        private BlockLocs() {
        }
    }
}

