/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.ConnectException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.log4j.Level;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="The design of this test needs to be reconsidered. It fails most of the times because of race conditions.")
public class TestHARead
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestHARead.class);
    final Path dir;

    public TestHARead() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        this.dir = new Path("/test/HA/");
    }

    int list(FileSystem fs) throws IOException {
        int totalFiles = 0;
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info((Object)("" + s.getPath()));
            ++totalFiles;
        }
        return totalFiles;
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHighAvailability() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(4)).numDataNodes(2).format(true).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem(0);
            TestHARead.assertTrue((boolean)fs.mkdirs(this.dir));
            Path file1 = new Path(this.dir, "file1");
            TestHARead.createFile((FileSystem)fs, file1);
            TestHARead.assertTrue((boolean)fs.exists(file1));
            TestHARead.assertEquals((int)1, (int)this.list((FileSystem)fs));
            FileStatus fileStatus = fs.listStatus(this.dir)[0];
            TestHARead.assertNotSame((Object)0, (Object)fs.getFileBlockLocations(file1, 0L, 1L).length);
            cluster.getNameNode(0).stop();
            cluster.getNameNode(1).stop();
            TestHARead.assertTrue((boolean)fs.exists(file1));
            Path file2 = new Path(this.dir, "file2");
            TestHARead.createFile((FileSystem)fs, file2);
            TestHARead.assertTrue((boolean)fs.exists(file2));
            Path file3 = new Path(this.dir, "file3");
            TestHARead.createFile((FileSystem)fs, file3);
            TestHARead.assertTrue((boolean)fs.exists(file3));
            Path file4 = new Path(this.dir, "file4");
            TestHARead.assertEquals((int)3, (int)this.list((FileSystem)fs));
            cluster.getNameNode(2).stop();
            fs.getFileStatus(file2);
            TestHARead.assertTrue((boolean)fs.delete(this.dir, true));
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            ex.printStackTrace();
            TestHARead.assertFalse((String)"Cannot be any connectivity issues", (boolean)(ex instanceof ConnectException));
            TestHARead.fail();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

