/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;

public abstract class HATestUtil {
    private static Log LOG = LogFactory.getLog(HATestUtil.class);
    private static final String LOGICAL_HOSTNAME = "ha-nn-uri-%d";

    public static void waitForDNDeletions(final MiniDFSCluster cluster) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                for (DataNode dn : cluster.getDataNodes()) {
                    if (DataNodeTestUtils.getPendingAsyncDeletions(dn) <= 0L) continue;
                    return false;
                }
                return true;
            }
        }, (int)1000, (int)10000);
    }

    public static void waitForNNToIssueDeletions(final NameNode nn) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                LOG.info((Object)"Waiting for NN to issue block deletions to DNs");
                try {
                    return nn.getNamesystem().getBlockManager().getPendingDeletionBlocksCount() == 0L;
                }
                catch (IOException ex) {
                    Logger.getLogger(HATestUtil.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        }, (int)250, (int)10000);
    }

    public static String getLogicalHostname(MiniDFSCluster cluster) {
        return String.format(LOGICAL_HOSTNAME, cluster.getInstanceId());
    }

    public static URI getLogicalUri(MiniDFSCluster cluster) throws URISyntaxException {
        return new URI("hopsfs://" + HATestUtil.getLogicalHostname(cluster));
    }
}

