/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStartupProgress {
    private StartupProgress startupProgress;

    @Before
    public void setUp() {
        this.startupProgress = new StartupProgress();
    }

    @Test(timeout=10000L)
    public void testInitialState() {
        StartupProgressView view = this.startupProgress.createView();
        Assert.assertNotNull((Object)view);
        Assert.assertEquals((long)0L, (long)view.getElapsedTime());
        Assert.assertEquals((float)0.0f, (float)view.getPercentComplete(), (float)0.001f);
        ArrayList<Phase> phases = new ArrayList<Phase>();
        for (Phase phase : view.getPhases()) {
            phases.add(phase);
            Assert.assertEquals((long)0L, (long)view.getElapsedTime(phase));
            Assert.assertNull((Object)view.getFile(phase));
            Assert.assertEquals((float)0.0f, (float)view.getPercentComplete(phase), (float)0.001f);
            Assert.assertEquals((long)Long.MIN_VALUE, (long)view.getSize(phase));
            Assert.assertEquals((Object)Status.PENDING, (Object)view.getStatus(phase));
            Assert.assertEquals((long)0L, (long)view.getTotal(phase));
            for (Step step : view.getSteps(phase)) {
                Assert.fail((String)String.format("unexpected step %s in phase %s at initial state", step, phase));
            }
        }
        Assert.assertArrayEquals((Object[])EnumSet.allOf(Phase.class).toArray(), (Object[])phases.toArray());
    }
}

