/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.GetConf;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestGetConf {
    FileSystem localFileSys;

    private String[] toStringArray(List<InetSocketAddress> list) {
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = NetUtils.getHostPortString((InetSocketAddress)list.get(i));
        }
        return ret;
    }

    private List<InetSocketAddress> getAddressListFromConf(TestType type, HdfsConfiguration conf) throws IOException {
        switch (type) {
            case NAMENODE: {
                return DFSUtil.getNameNodesServiceRpcAddresses((Configuration)conf);
            }
            case NNRPCADDRESSES: {
                return DFSUtil.getNameNodesServiceRpcAddresses((Configuration)conf);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runTool(HdfsConfiguration conf, String[] args, boolean success) throws Exception {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(o, true);
        try {
            int ret = ToolRunner.run((Tool)new GetConf((Configuration)conf, out, out), (String[])args);
            out.flush();
            System.err.println("Output: " + o.toString());
            Assert.assertEquals((String)("Expected " + (success ? "success" : "failure") + " for args: " + Joiner.on((String)" ").join((Object[])args) + "\nOutput: " + o.toString()), (Object)success, (Object)(ret == 0 ? 1 : 0));
            String string = o.toString();
            return string;
        }
        finally {
            o.close();
            out.close();
        }
    }

    private String getAddressListFromTool(TestType type, HdfsConfiguration conf, boolean success) throws Exception {
        String[] args = new String[1];
        switch (type) {
            case NAMENODE: {
                args[0] = GetConf.Command.NAMENODE.getName();
                break;
            }
            case NNRPCADDRESSES: {
                args[0] = GetConf.Command.NNRPCADDRESSES.getName();
            }
        }
        return this.runTool(conf, args, success);
    }

    private void getAddressListFromTool(TestType type, HdfsConfiguration conf, boolean checkPort, List<InetSocketAddress> expected) throws Exception {
        String out = this.getAddressListFromTool(type, conf, expected.size() != 0);
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(out);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken().trim();
            values.add(s);
        }
        Object[] actual = values.toArray(new String[values.size()]);
        int i = 0;
        Object[] expectedHosts = new String[expected.size()];
        for (InetSocketAddress addr : expected) {
            if (!checkPort) {
                expectedHosts[i++] = addr.getHostName();
                continue;
            }
            expectedHosts[i++] = addr.getHostName() + ":" + addr.getPort();
        }
        Assert.assertTrue((boolean)Arrays.equals(expectedHosts, actual));
    }

    private void verifyAddresses(HdfsConfiguration conf, TestType type, boolean checkPort, String ... expected) throws Exception {
        List<InetSocketAddress> list = this.getAddressListFromConf(type, conf);
        Object[] actual = this.toStringArray(list);
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assert.assertTrue((boolean)Arrays.equals(expected, actual));
        this.getAddressListFromTool(type, conf, checkPort, list);
    }

    private static String getNameServiceId(int index) {
        return "ns" + index;
    }

    @Test
    public void testEmptyConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        this.getAddressListFromTool(TestType.NAMENODE, conf, false);
        this.getAddressListFromTool(TestType.NNRPCADDRESSES, conf, false);
        for (GetConf.Command cmd : GetConf.Command.values()) {
            String arg = cmd.getName();
            GetConf.CommandHandler handler = GetConf.Command.getHandler((String)arg);
            Assert.assertNotNull((String)("missing handler: " + cmd), (Object)handler);
            if (handler.key == null) continue;
            String[] args = new String[]{handler.key};
            this.runTool(conf, args, false);
        }
    }

    @Test
    public void testInvalidArgument() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] args = new String[]{"-invalidArgument"};
        String ret = this.runTool(conf, args, false);
        Assert.assertTrue((boolean)ret.contains(GetConf.USAGE));
    }

    @Test
    public void testNonFederation() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        conf.set("fs.defaultFS", "hopsfs://localhost:1000");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1000");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1000");
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.servicerpc-address", "localhost:1000");
        conf.set("dfs.namenode.rpc-address", "localhost:1001");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1000");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1000");
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-address", "localhost:1001");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1001");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1001");
    }

    @Test
    public void testGetSpecificKey() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("mykey", " myval ");
        String[] args = new String[]{"-confKey", "mykey"};
        Assert.assertTrue((boolean)this.runTool(conf, args, true).equals("myval\n"));
    }

    @Test
    public void testExtraArgsThrowsError() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("mykey", "myval");
        String[] args = new String[]{"-namenodes", "unexpected-arg"};
        Assert.assertTrue((boolean)this.runTool(conf, args, false).contains("Did not expect argument: unexpected-arg"));
    }

    @Test
    public void testTool() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        for (GetConf.Command cmd : GetConf.Command.values()) {
            GetConf.CommandHandler handler = GetConf.Command.getHandler((String)cmd.getName());
            if (handler.key == null || "-confKey".equals(cmd.getName())) continue;
            String[] args = new String[]{cmd.getName()};
            conf.set(handler.key, "value");
            Assert.assertTrue((boolean)this.runTool(conf, args, true).contains("value"));
        }
    }

    @Test
    public void TestGetConfExcludeCommand() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = this.localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, System.getProperty("test.build.data", "target/test/data") + "/Getconf/");
        Path hostsFile = new Path(dir, "hosts");
        Path excludeFile = new Path(dir, "exclude");
        conf.set("dfs.hosts", hostsFile.toUri().getPath());
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        this.writeConfigFile(hostsFile, null);
        this.writeConfigFile(excludeFile, null);
        String[] args = new String[]{"-excludeFile"};
        String ret = this.runTool(conf, args, true);
        Assert.assertEquals((Object)excludeFile.toUri().getPath(), (Object)ret.trim());
        this.cleanupFile(this.localFileSys, excludeFile.getParent());
    }

    @Test
    public void TestGetConfIncludeCommand() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = this.localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, System.getProperty("test.build.data", "target/test/data") + "/Getconf/");
        Path hostsFile = new Path(dir, "hosts");
        Path excludeFile = new Path(dir, "exclude");
        conf.set("dfs.hosts", hostsFile.toUri().getPath());
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        this.writeConfigFile(hostsFile, null);
        this.writeConfigFile(excludeFile, null);
        String[] args = new String[]{"-includeFile"};
        String ret = this.runTool(conf, args, true);
        Assert.assertEquals((Object)hostsFile.toUri().getPath(), (Object)ret.trim());
        this.cleanupFile(this.localFileSys, excludeFile.getParent());
    }

    private void writeConfigFile(Path name, ArrayList<String> nodes) throws IOException {
        if (this.localFileSys.exists(name)) {
            this.localFileSys.delete(name, true);
        }
        FSDataOutputStream stm = this.localFileSys.create(name);
        if (nodes != null) {
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
        }
        stm.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    static enum TestType {
        NAMENODE,
        NNRPCADDRESSES;

    }
}

