/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.hops.erasure_coding.Codec;
import io.hops.exception.OutOfDBExtentsException;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSOutputSummer;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSPacket;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Time;
import org.apache.htrace.core.TraceScope;

@InterfaceAudience.Private
public class DFSOutputStream
extends FSOutputSummer
implements Syncable,
CanSetDropBehind {
    public static final Log LOG = LogFactory.getLog(DFSOutputStream.class);
    @VisibleForTesting
    static final int CREATE_RETRY_COUNT = 10;
    @VisibleForTesting
    static CryptoProtocolVersion[] SUPPORTED_CRYPTO_VERSIONS = CryptoProtocolVersion.supported();
    protected final DFSClient dfsClient;
    protected final ByteArrayManager byteArrayManager;
    protected volatile boolean closed = false;
    protected final String src;
    protected final long fileId;
    protected final long blockSize;
    protected final DataChecksum checksum;
    protected DFSPacket currentPacket = null;
    protected DataStreamer streamer;
    protected int packetSize = 0;
    protected int chunksPerPacket = 0;
    protected long lastFlushOffset = 0L;
    private long initialFileSize = 0L;
    private final short blockReplication;
    protected boolean shouldSyncBlock = false;
    protected final AtomicReference<CachingStrategy> cachingStrategy;
    private FileEncryptionInfo fileEncryptionInfo;
    private boolean singleBlock = false;
    private static BlockStoragePolicySuite policySuite = BlockStoragePolicySuite.createDefaultSuite();

    protected DFSPacket createPacket(int packetSize, int chunksPerPkt, long offsetInBlock, long seqno, boolean lastPacketInBlock) throws InterruptedIOException {
        byte[] buf;
        int bufferSize = PacketHeader.PKT_MAX_HEADER_LEN + packetSize;
        try {
            buf = this.byteArrayManager.newByteArray(bufferSize);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iioe = new InterruptedIOException("seqno=" + seqno);
            iioe.initCause(ie);
            throw iioe;
        }
        return new DFSPacket(buf, chunksPerPkt, offsetInBlock, seqno, this.checksum.getChecksumSize(), lastPacketInBlock);
    }

    protected void checkClosed() throws IOException {
        if (this.isClosed()) {
            this.streamer.getLastException().throwException4Close();
        }
    }

    @VisibleForTesting
    public synchronized DatanodeInfo[] getPipeline() {
        if (this.streamer.streamerClosed()) {
            return null;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return null;
        }
        DatanodeInfo[] value = new DatanodeInfo[currentNodes.length];
        for (int i = 0; i < currentNodes.length; ++i) {
            value[i] = currentNodes[i];
        }
        return value;
    }

    private DFSOutputStream(DFSClient dfsClient, String src, Progressable progress, HdfsFileStatus stat, DataChecksum checksum) throws IOException {
        super(checksum);
        int bytesPerChecksum;
        this.dfsClient = dfsClient;
        this.src = src;
        this.fileId = stat.getFileId();
        this.blockSize = stat.getBlockSize();
        this.blockReplication = stat.getReplication();
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
        this.cachingStrategy = new AtomicReference<CachingStrategy>(dfsClient.getDefaultWriteCachingStrategy());
        if (progress != null && DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("Set non-null progress callback on DFSOutputStream " + src));
        }
        if ((bytesPerChecksum = checksum.getBytesPerChecksum()) < 1 || this.blockSize % (long)bytesPerChecksum != 0L) {
            throw new IOException("io.bytes.per.checksum(" + bytesPerChecksum + ") and blockSize(" + this.blockSize + ") do not match. blockSize should be a multiple of io.bytes.per.checksum");
        }
        this.checksum = checksum;
        this.byteArrayManager = dfsClient.getClientContext().getByteArrayManager();
    }

    protected DFSOutputStream(DFSClient dfsClient, String src, HdfsFileStatus stat, EnumSet<CreateFlag> flag, Progressable progress, DataChecksum checksum, String[] favoredNodes, EncodingPolicy policy, int dbFileMaxSize, boolean forceClientToWriteSFToDisk) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.shouldSyncBlock = flag.contains(CreateFlag.SYNC_BLOCK);
        this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), checksum.getBytesPerChecksum());
        this.streamer = new DataStreamer(stat, null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, dbFileMaxSize, forceClientToWriteSFToDisk, favoredNodes);
        if (policy != null) {
            Codec codec = Codec.getCodec(policy.getCodec());
            if (codec == null) {
                throw new IOException("Unkown codec: " + policy.getCodec());
            }
            this.streamer.enableSourceStream(codec.getStripeLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForCreate(DFSClient dfsClient, String src, FsPermission masked, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, Progressable progress, int buffersize, DataChecksum checksum, String[] favoredNodes, EncodingPolicy policy, int dbFileMaxSize, boolean forceClientToWriteSFToDisk) throws IOException {
        try (TraceScope scope = dfsClient.newPathTraceScope("newStreamForCreate", src);){
            HdfsFileStatus stat = null;
            boolean shouldRetry = true;
            int retryCount = 10;
            while (shouldRetry) {
                shouldRetry = false;
                try {
                    stat = dfsClient.namenode.create(src, masked, dfsClient.clientName, (EnumSetWritable<CreateFlag>)new EnumSetWritable(flag), createParent, replication, blockSize, SUPPORTED_CRYPTO_VERSIONS, policy);
                    break;
                }
                catch (RemoteException re) {
                    IOException e = re.unwrapRemoteException(new Class[]{AccessControlException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, FileAlreadyExistsException.class, FileNotFoundException.class, ParentNotDirectoryException.class, NSQuotaExceededException.class, RetryStartFileException.class, SafeModeException.class, UnresolvedPathException.class, UnknownCryptoProtocolVersionException.class});
                    if (e instanceof RetryStartFileException) {
                        if (retryCount > 0) {
                            shouldRetry = true;
                            --retryCount;
                            continue;
                        }
                        throw new IOException("Too many retries because of encryption zone operations", e);
                    }
                    throw e;
                }
            }
            Preconditions.checkNotNull(stat, (Object)"HdfsFileStatus should not be null!");
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, stat, flag, progress, checksum, favoredNodes, policy, dbFileMaxSize, forceClientToWriteSFToDisk);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private DFSOutputStream(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, int dbFileMaxSize, boolean forceClientToWriteSFToDisk, String[] favoredNodes) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.initialFileSize = stat.getLen();
        this.shouldSyncBlock = flags.contains(CreateFlag.SYNC_BLOCK);
        boolean toNewBlock = flags.contains(CreateFlag.NEW_BLOCK);
        if (!toNewBlock && lastBlock != null && policySuite.getPolicy(stat.getStoragePolicy()).getStorageTypes()[0] != StorageType.DB) {
            this.streamer = new DataStreamer(lastBlock, stat, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, dbFileMaxSize, forceClientToWriteSFToDisk);
            this.streamer.setBytesCurBlock(lastBlock.getBlockSize());
            this.adjustPacketChunkSize(stat);
            this.streamer.setPipelineInConstruction(lastBlock);
        } else {
            this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), checksum.getBytesPerChecksum());
            if (policySuite.getPolicy(stat.getStoragePolicy()).getStorageTypes()[0] == StorageType.DB && lastBlock != null) {
                this.streamer = new DataStreamer(stat, null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, dbFileMaxSize, forceClientToWriteSFToDisk, favoredNodes);
                this.streamer.setBytesCurBlock(0L);
                this.write(lastBlock.getData(), 0, lastBlock.getData().length);
                LOG.debug((Object)"Stuffed Inode:  Putting Existing data in packets");
            } else {
                this.streamer = new DataStreamer(stat, lastBlock != null ? lastBlock.getBlock() : null, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, dbFileMaxSize, forceClientToWriteSFToDisk, favoredNodes);
            }
        }
        this.streamer.setFileStoredInDB(policySuite.getPolicy(stat.getStoragePolicy()).getStorageTypes()[0] == StorageType.DB);
        this.fileEncryptionInfo = stat.getFileEncryptionInfo();
    }

    private void adjustPacketChunkSize(HdfsFileStatus stat) throws IOException {
        long usedInLastBlock = stat.getLen() % this.blockSize;
        int freeInLastBlock = (int)(this.blockSize - usedInLastBlock);
        int usedInCksum = (int)(stat.getLen() % (long)this.checksum.getBytesPerChecksum());
        int freeInCksum = this.checksum.getBytesPerChecksum() - usedInCksum;
        if ((long)freeInLastBlock == this.blockSize) {
            throw new IOException("The last block for file " + this.src + " is full.");
        }
        if (usedInCksum > 0 && freeInCksum > 0) {
            this.computePacketChunkSize(0, freeInCksum);
            this.setChecksumBufSize(freeInCksum);
            this.streamer.setAppendChunk(true);
        } else {
            this.computePacketChunkSize(Math.min(this.dfsClient.getConf().getWritePacketSize(), freeInLastBlock), this.checksum.getBytesPerChecksum());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DFSOutputStream newStreamForAppend(DFSClient dfsClient, String src, EnumSet<CreateFlag> flags, int bufferSize, Progressable progress, LocatedBlock lastBlock, HdfsFileStatus stat, DataChecksum checksum, String[] favoredNodes, int dbFileMaxSize, boolean forceClientToWriteSFToDisk) throws IOException {
        try (TraceScope scope = dfsClient.newPathTraceScope("newStreamForAppend", src);){
            if (policySuite.getPolicy(stat.getStoragePolicy()).getStorageTypes()[0] == StorageType.DB) {
                String errorMessage = null;
                if (stat.getLen() > stat.getBlockSize()) {
                    errorMessage = "Invalid paraters for appending a file stored in the database. Block size can not be smaller than the max size of a file stored in the database";
                } else if ((long)dbFileMaxSize > stat.getBlockSize()) {
                    errorMessage = "Invalid paraters for appending a file stored in the database. Files stored in the database can not be larger than a HDFS block";
                }
                if (errorMessage != null) {
                    throw new IOException(errorMessage);
                }
            }
            DFSOutputStream out = new DFSOutputStream(dfsClient, src, flags, progress, lastBlock, stat, checksum, dbFileMaxSize, forceClientToWriteSFToDisk, favoredNodes);
            out.start();
            DFSOutputStream dFSOutputStream = out;
            return dFSOutputStream;
        }
    }

    private DFSOutputStream(DFSClient dfsClient, String src, Progressable progress, HdfsFileStatus stat, LocatedBlock lb, DataChecksum checksum) throws IOException {
        this(dfsClient, src, progress, stat, checksum);
        this.singleBlock = true;
        this.computePacketChunkSize(dfsClient.getConf().getWritePacketSize(), checksum.getBytesPerChecksum());
        this.streamer = new DataStreamer(stat, lb, this.singleBlock, dfsClient, src, progress, checksum, this.cachingStrategy, this.byteArrayManager, -1, false);
    }

    static DFSOutputStream newStreamForSingleBlock(DFSClient dfsClient, String src, Progressable progress, LocatedBlock block, DataChecksum checksum, HdfsFileStatus stat) throws IOException {
        DFSOutputStream out = new DFSOutputStream(dfsClient, src, progress, stat, block, checksum);
        out.start();
        return out;
    }

    protected void computePacketChunkSize(int psize, int csize) {
        int bodySize = psize - PacketHeader.PKT_MAX_HEADER_LEN;
        int chunkSize = csize + this.checksum.getChecksumSize();
        this.chunksPerPacket = Math.max(bodySize / chunkSize, 1);
        this.packetSize = chunkSize * this.chunksPerPacket;
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("computePacketChunkSize: src=" + this.src + ", chunkSize=" + chunkSize + ", chunksPerPacket=" + this.chunksPerPacket + ", packetSize=" + this.packetSize));
        }
    }

    protected TraceScope createWriteTraceScope() {
        return this.dfsClient.newPathTraceScope("DFSOutputStream#write", this.src);
    }

    protected synchronized void writeChunk(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        int bytesPerChecksum = this.checksum.getBytesPerChecksum();
        if (len > bytesPerChecksum) {
            throw new IOException("writeChunk() buffer size is " + len + " is larger than supported  bytesPerChecksum " + bytesPerChecksum);
        }
        if (cklen != 0 && cklen != this.checksum.getChecksumSize()) {
            throw new IOException("writeChunk() checksum size is supposed to be " + this.checksum.getChecksumSize() + " but found to be " + cklen);
        }
        if (this.currentPacket == null) {
            this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("DFSClient writeChunk allocating new packet seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", packetSize=" + this.packetSize + ", chunksPerPacket=" + this.chunksPerPacket + ", bytesCurBlock=" + this.streamer.getBytesCurBlock()));
            }
        }
        this.currentPacket.writeChecksum(checksum, ckoff, cklen);
        this.currentPacket.writeData(b, offset, len);
        this.currentPacket.incNumChunks();
        this.streamer.incBytesCurBlock(len);
        if (this.currentPacket.getNumChunks() == this.currentPacket.getMaxChunks() || this.streamer.getBytesCurBlock() == this.blockSize) {
            if (DFSClient.LOG.isDebugEnabled()) {
                DFSClient.LOG.debug((Object)("DFSClient writeChunk packet full seqno=" + this.currentPacket.getSeqno() + ", src=" + this.src + ", bytesCurBlock=" + this.streamer.getBytesCurBlock() + ", blockSize=" + this.blockSize + ", appendChunk=" + this.streamer.getAppendChunk()));
            }
            this.streamer.waitAndQueuePacket(this.currentPacket);
            this.currentPacket = null;
            this.adjustChunkBoundary();
            this.endBlock();
        }
    }

    protected void adjustChunkBoundary() {
        if (this.streamer.getAppendChunk() && this.streamer.getBytesCurBlock() % (long)this.checksum.getBytesPerChecksum() == 0L) {
            this.streamer.setAppendChunk(false);
            this.resetChecksumBufSize();
        }
        if (!this.streamer.getAppendChunk()) {
            int psize = Math.min((int)(this.blockSize - this.streamer.getBytesCurBlock()), this.dfsClient.getConf().getWritePacketSize());
            this.computePacketChunkSize(psize, this.checksum.getBytesPerChecksum());
        }
    }

    protected void endBlock() throws IOException {
        if (this.streamer.getBytesCurBlock() == this.blockSize) {
            this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
            this.currentPacket.setSyncBlock(this.shouldSyncBlock);
            this.streamer.waitAndQueuePacket(this.currentPacket);
            this.currentPacket = null;
            this.streamer.setBytesCurBlock(0L);
            this.lastFlushOffset = 0L;
        }
    }

    @Deprecated
    public void sync() throws IOException {
        this.hflush();
    }

    public void hflush() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hflush", this.src);){
            this.flushOrSync(false, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, EnumSet.noneOf(HdfsDataOutputStream.SyncFlag.class));
        }
    }

    public void hsync(EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("hsync", this.src);){
            this.flushOrSync(true, syncFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushOrSync(boolean isSync, EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags) throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        this.streamer.syncOrFlushCalled();
        try {
            long toWaitFor;
            long lastBlockLength = -1L;
            boolean updateLength = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH);
            boolean endBlock = syncFlags.contains((Object)HdfsDataOutputStream.SyncFlag.END_BLOCK);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                int numKept = this.flushBuffer(!endBlock, true);
                if (DFSClient.LOG.isDebugEnabled()) {
                    DFSClient.LOG.debug((Object)("DFSClient flush(): bytesCurBlock=" + this.streamer.getBytesCurBlock() + " lastFlushOffset=" + this.lastFlushOffset + " createNewBlock=" + endBlock));
                }
                if (this.lastFlushOffset != this.streamer.getBytesCurBlock()) {
                    assert (this.streamer.getBytesCurBlock() > this.lastFlushOffset);
                    this.lastFlushOffset = this.streamer.getBytesCurBlock();
                    if (isSync && this.currentPacket == null && !endBlock) {
                        this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
                    }
                } else if (isSync && this.streamer.getBytesCurBlock() > 0L && !endBlock) {
                    this.currentPacket = this.createPacket(this.packetSize, this.chunksPerPacket, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), false);
                } else if (this.currentPacket != null) {
                    this.currentPacket.releaseBuffer(this.byteArrayManager);
                    this.currentPacket = null;
                }
                if (this.currentPacket != null) {
                    this.currentPacket.setSyncBlock(isSync);
                    this.streamer.waitAndQueuePacket(this.currentPacket);
                    this.currentPacket = null;
                }
                if (endBlock && this.streamer.getBytesCurBlock() > 0L) {
                    this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
                    this.currentPacket.setSyncBlock(this.shouldSyncBlock || isSync);
                    this.streamer.waitAndQueuePacket(this.currentPacket);
                    this.currentPacket = null;
                    this.streamer.setBytesCurBlock(0L);
                    this.lastFlushOffset = 0L;
                } else {
                    this.streamer.setBytesCurBlock(this.streamer.getBytesCurBlock() - (long)numKept);
                }
                toWaitFor = this.streamer.getLastQueuedSeqno();
            }
            this.streamer.waitForAckedSeqno(toWaitFor);
            if (updateLength || this.streamer.getPersistBlocks().get()) {
                dFSOutputStream = this;
                synchronized (dFSOutputStream) {
                    if (!this.streamer.streamerClosed() && this.streamer.getBlock() != null) {
                        lastBlockLength = this.streamer.getBlock().getNumBytes();
                    }
                }
            }
            if (this.streamer.getPersistBlocks().getAndSet(false) || updateLength) {
                try {
                    this.dfsClient.namenode.fsync(this.src, this.fileId, this.dfsClient.clientName, lastBlockLength);
                }
                catch (IOException ioe) {
                    DFSClient.LOG.warn((Object)("Unable to persist blocks in hflush for " + this.src), (Throwable)ioe);
                    this.checkClosed();
                    throw ioe;
                }
            }
            dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.streamer.streamerClosed()) {
                    this.streamer.setHflush();
                }
            }
        }
        catch (InterruptedIOException interrupt) {
            throw interrupt;
        }
        catch (IOException e) {
            DFSClient.LOG.warn((Object)"Error while syncing", (Throwable)e);
            DFSOutputStream dFSOutputStream = this;
            synchronized (dFSOutputStream) {
                if (!this.isClosed()) {
                    this.streamer.getLastException().set(e);
                    this.closeThreads(true);
                }
            }
            throw e;
        }
    }

    @Deprecated
    public synchronized int getNumCurrentReplicas() throws IOException {
        return this.getCurrentBlockReplication();
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        this.dfsClient.checkOpen();
        this.checkClosed();
        if (this.streamer.streamerClosed()) {
            return this.blockReplication;
        }
        DatanodeInfo[] currentNodes = this.streamer.getNodes();
        if (currentNodes == null) {
            return this.blockReplication;
        }
        return currentNodes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInternal() throws IOException {
        long toWaitFor;
        DFSOutputStream dFSOutputStream = this;
        synchronized (dFSOutputStream) {
            this.dfsClient.checkOpen();
            this.checkClosed();
            this.streamer.queuePacket(this.currentPacket);
            this.currentPacket = null;
            toWaitFor = this.streamer.getLastQueuedSeqno();
        }
        this.streamer.waitForAckedSeqno(toWaitFor);
    }

    protected synchronized void start() {
        this.streamer.start();
    }

    synchronized void abort() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.streamer.getLastException().set(new IOException("Lease timeout of " + this.dfsClient.getConf().getHdfsTimeout() / 1000 + " seconds expired."));
        this.closeThreads(true);
        this.dfsClient.endFileLease(this.fileId);
    }

    boolean isClosed() {
        return this.closed || this.streamer.streamerClosed();
    }

    void setClosed() {
        this.closed = true;
        this.streamer.release();
    }

    protected void closeThreads(boolean force) throws IOException {
        try {
            this.streamer.close(force);
            this.streamer.join();
            this.streamer.closeSocket();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to shutdown streamer");
        }
        finally {
            this.streamer.setSocketToNull();
            this.setClosed();
        }
    }

    public synchronized void close() throws IOException {
        try (TraceScope scope = this.dfsClient.newPathTraceScope("DFSOutputStream#close", this.src);){
            this.closeImpl();
        }
    }

    protected synchronized void closeImpl() throws IOException {
        if (this.isClosed()) {
            this.streamer.getLastException().check(true);
            return;
        }
        try {
            this.closeInternal();
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (OutOfDBExtentsException e) {
            this.currentPacket = null;
            this.streamer.forwardSmallFilesPacketsToDataNodes();
            this.streamer.setBytesCurBlock(0L);
            this.closeInternal();
        }
        finally {
            this.setClosed();
        }
    }

    private void closeInternal() throws IOException {
        this.flushBuffer();
        if (this.currentPacket != null) {
            this.streamer.waitAndQueuePacket(this.currentPacket);
            this.currentPacket = null;
        }
        if (this.streamer.getBytesCurBlock() != 0L) {
            this.currentPacket = this.createPacket(0, 0, this.streamer.getBytesCurBlock(), this.streamer.getAndIncCurrentSeqno(), true);
            this.currentPacket.setSyncBlock(this.shouldSyncBlock);
        }
        this.flushInternal();
        ExtendedBlock lastBlock = this.streamer.getBlock();
        try (TraceScope scope = this.dfsClient.getTracer().newScope("completeFile");){
            this.completeFile(lastBlock);
        }
        this.closeThreads(false);
        this.dfsClient.endFileLease(this.fileId);
    }

    protected void completeFile(ExtendedBlock last) throws IOException {
        if (this.singleBlock) {
            return;
        }
        long localstart = Time.monotonicNow();
        DfsClientConf conf = this.dfsClient.getConf();
        long sleeptime = conf.getBlockWriteLocateFollowingInitialDelayMs();
        boolean fileComplete = false;
        int retries = conf.getNumBlockWriteLocateFollowingRetry();
        while (!fileComplete) {
            fileComplete = this.completeFileInternal(last);
            if (fileComplete) continue;
            int hdfsTimeout = conf.getHdfsTimeout();
            if (!this.dfsClient.clientRunning || hdfsTimeout > 0 && localstart + (long)hdfsTimeout < Time.monotonicNow()) {
                String msg = "Unable to close file because dfsclient  was unable to contact the HDFS servers. clientRunning " + this.dfsClient.clientRunning + " hdfsTimeout " + hdfsTimeout;
                DFSClient.LOG.info((Object)msg);
                throw new IOException(msg);
            }
            try {
                if (retries == 0) {
                    throw new IOException("Unable to close file because the last block does not have enough number of replicas.");
                }
                --retries;
                Thread.sleep(sleeptime);
                sleeptime *= 2L;
                if (Time.monotonicNow() - localstart <= 5000L) continue;
                DFSClient.LOG.info((Object)("Could not complete " + this.src + " retrying..."));
            }
            catch (InterruptedException ie) {
                DFSClient.LOG.warn((Object)"Caught exception ", (Throwable)ie);
            }
        }
    }

    private boolean completeFileInternal(ExtendedBlock last) throws IOException {
        boolean fileComplete = false;
        byte[] data = null;
        if (this.streamer.canStoreFileInDB()) {
            data = this.getSmallFileData();
        }
        try {
            fileComplete = this.dfsClient.namenode.complete(this.src, this.dfsClient.clientName, last, this.fileId, data);
        }
        catch (RemoteException e) {
            IOException nonRetirableExceptions = e.unwrapRemoteException(new Class[]{NSQuotaExceededException.class, DSQuotaExceededException.class, OutOfDBExtentsException.class});
            if (nonRetirableExceptions != e) {
                throw nonRetirableExceptions;
            }
            throw e;
        }
        return fileComplete;
    }

    private byte[] getSmallFileData() {
        byte[] data = null;
        if (this.streamer.canStoreFileInDB() && !this.streamer.getSmallFileDataQueue().isEmpty()) {
            LOG.debug((Object)"Stuffed Inode:  Sending data to the NameNode in comple file operation ");
            int length = 0;
            for (DFSPacket packet : this.streamer.getSmallFileDataQueue()) {
                if (packet.isHeartbeatPacket()) continue;
                length += packet.getDataLength();
            }
            LOG.debug((Object)("Stuffed Inode:  total data is " + length));
            data = new byte[length];
            int index = 0;
            for (DFSPacket packet : this.streamer.getSmallFileDataQueue()) {
                index += packet.writeToArray(data, index);
            }
        }
        return data;
    }

    @VisibleForTesting
    public void setArtificialSlowdown(long period) {
        this.streamer.setArtificialSlowdown(period);
    }

    @VisibleForTesting
    public synchronized void setChunksPerPacket(int value) {
        this.chunksPerPacket = Math.min(this.chunksPerPacket, value);
        this.packetSize = (this.checksum.getBytesPerChecksum() + this.checksum.getChecksumSize()) * this.chunksPerPacket;
    }

    public long getInitialLen() {
        return this.initialFileSize;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.fileEncryptionInfo;
    }

    synchronized Token<BlockTokenIdentifier> getBlockToken() {
        return this.streamer.getBlockToken();
    }

    private static <T> void arraycopy(T[] srcs, T[] dsts, int skipIndex) {
        System.arraycopy(srcs, 0, dsts, 0, skipIndex);
        System.arraycopy(srcs, skipIndex + 1, dsts, skipIndex, dsts.length - skipIndex);
    }

    public void setDropBehind(Boolean dropBehind) throws IOException {
        CachingStrategy nextStrategy;
        CachingStrategy prevStrategy;
        while (!this.cachingStrategy.compareAndSet(prevStrategy = this.cachingStrategy.get(), nextStrategy = new CachingStrategy.Builder(prevStrategy).setDropBehind(dropBehind).build())) {
        }
    }

    @VisibleForTesting
    ExtendedBlock getBlock() {
        return this.streamer.getBlock();
    }

    @VisibleForTesting
    public long getFileId() {
        return this.fileId;
    }

    public void enableParityStream(int stripeLength, int parityLength, String sourceFile) throws IOException {
        this.streamer.enableParityStream(stripeLength, parityLength, sourceFile);
    }

    public Collection<DatanodeInfo> getUsedNodes() {
        return this.streamer.getUsedNodes();
    }

    public void setParityStripeNodesForNextStripe(Collection<DatanodeInfo> locations) {
        this.streamer.setParityStripeNodesForNextStripe(locations);
    }

    public void enableSourceStream(int stripeLength) {
        this.streamer.enableSourceStream(stripeLength);
    }
}

