/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer3;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class DFSUtil {
    public static final Log LOG = LogFactory.getLog((String)DFSUtil.class.getName());
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    public static final Comparator<DatanodeInfo> DECOM_COMPARATOR = new Comparator<DatanodeInfo>(){

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            return a.isDecommissioned() == b.isDecommissioned() ? 0 : (a.isDecommissioned() ? 1 : -1);
        }
    };
    static final AddressMatcher LOCAL_ADDRESS_MATCHER = new AddressMatcher(){

        @Override
        public boolean match(InetSocketAddress s) {
            return NetUtils.isLocalAddress((InetAddress)s.getAddress());
        }
    };
    public static Options helpOptions = new Options();
    public static Option helpOpt = new Option("h", "help", false, "get help information");

    private DFSUtil() {
    }

    public static Random getRandom() {
        return RANDOM.get();
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM.get();
    }

    public static <T> T[] shuffle(T[] array) {
        if (array != null && array.length > 0) {
            Random random = DFSUtil.getRandom();
            int n = array.length;
            while (n > 1) {
                int randomIndex;
                if (--n == (randomIndex = random.nextInt(n))) continue;
                T tmp = array[randomIndex];
                array[randomIndex] = array[n];
                array[n] = tmp;
            }
        }
        return array;
    }

    public static boolean isValidName(String src) {
        return DFSUtilClient.isValidName((String)src);
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        return DFSUtilClient.string2Bytes((String)str);
    }

    public static String byteArray2PathString(byte[][] pathComponents, int offset, int length) {
        if (pathComponents.length == 0) {
            return "";
        }
        Preconditions.checkArgument((offset >= 0 && offset < pathComponents.length ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 && offset + length <= pathComponents.length ? 1 : 0) != 0);
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            result.append(new String(pathComponents[i], Charsets.UTF_8));
            if (i >= pathComponents.length - 1) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static String byteArray2PathString(byte[][] pathComponents) {
        return DFSUtil.byteArray2PathString(pathComponents, 0, pathComponents.length);
    }

    public static String strings2PathString(String[] components) {
        if (components.length == 0) {
            return "";
        }
        if (components.length == 1 && (components[0] == null || components[0].isEmpty())) {
            return "/";
        }
        return Joiner.on((String)"/").join((Object[])components);
    }

    public static String path2String(Object path) {
        return path == null ? null : (path instanceof String ? (String)path : (path instanceof byte[][] ? DFSUtil.byteArray2PathString((byte[][])path) : path.toString()));
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = DFSUtilClient.concatSuffixes((String[])suffixes);
        return DFSUtilClient.addSuffix((String)key, (String)keySuffix);
    }

    public static int roundBytesToGB(long bytes) {
        return Math.round((float)bytes / 1024.0f / 1024.0f / 1024.0f);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    static String[] getSuffixIDs(Configuration conf, String addressKey, String knownNsId, String knownNNId, AddressMatcher matcher) {
        String nameserviceId = null;
        String namenodeId = null;
        int found = 0;
        Collection nsIds = DFSUtilClient.getNameServiceIds((Configuration)conf);
        for (String nsId : DFSUtilClient.emptyAsSingletonNull((Collection)nsIds)) {
            if (knownNsId != null && !knownNsId.equals(nsId)) continue;
            Collection nnIds = DFSUtilClient.getNameNodeIds((Configuration)conf, (String)nsId);
            for (String nnId : DFSUtilClient.emptyAsSingletonNull((Collection)nnIds)) {
                String key;
                String addr;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)String.format("addressKey: %s nsId: %s nnId: %s", addressKey, nsId, nnId));
                }
                if (knownNNId != null && !knownNNId.equals(nnId) || (addr = conf.get(key = DFSUtil.addKeySuffixes(addressKey, nsId, nnId))) == null) continue;
                InetSocketAddress s = null;
                try {
                    s = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in creating socket address " + addr), (Throwable)e);
                    continue;
                }
                if (s.isUnresolved() || !matcher.match(s)) continue;
                nameserviceId = nsId;
                namenodeId = nnId;
                ++found;
            }
        }
        if (found > 1) {
            String msg = "Configuration has multiple addresses that match local node's address. Please configure the system with dfs.nameservice.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        return new String[]{nameserviceId, namenodeId};
    }

    static String[] getSuffixIDs(Configuration conf, final InetSocketAddress address, String ... keys) {
        AddressMatcher matcher = new AddressMatcher(){

            @Override
            public boolean match(InetSocketAddress s) {
                return address.equals(s);
            }
        };
        for (String key : keys) {
            String[] ids = DFSUtil.getSuffixIDs(conf, key, null, null, matcher);
            if (ids == null || ids[0] == null && ids[1] == null) continue;
            return ids;
        }
        return null;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static boolean parseHelpArgument(String[] args, String helpDescription, PrintStream out, boolean printGenericCommandUsage) {
        if (args.length == 1) {
            try {
                PosixParser parser = new PosixParser();
                CommandLine cmdLine = parser.parse(helpOptions, args);
                if (cmdLine.hasOption(helpOpt.getOpt()) || cmdLine.hasOption(helpOpt.getLongOpt())) {
                    out.println(helpDescription + "\n");
                    if (printGenericCommandUsage) {
                        ToolRunner.printGenericCommandUsage((PrintStream)out);
                    }
                    return true;
                }
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return false;
    }

    public static float getInvalidateWorkPctPerIteration(Configuration conf) {
        float blocksInvalidateWorkPct = conf.getFloat("dfs.namenode.invalidate.work.pct.per.iteration", 0.32f);
        Preconditions.checkArgument((blocksInvalidateWorkPct > 0.0f && blocksInvalidateWorkPct <= 1.0f ? 1 : 0) != 0, (Object)("dfs.namenode.invalidate.work.pct.per.iteration = '" + blocksInvalidateWorkPct + "' is invalid. It should be a positive, non-zero float value, not greater than 1.0f, to indicate a percentage."));
        return blocksInvalidateWorkPct;
    }

    public static int getReplWorkMultiplier(Configuration conf) {
        int blocksReplWorkMultiplier = conf.getInt("dfs.namenode.replication.work.multiplier.per.iteration", 2);
        Preconditions.checkArgument((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0, (Object)("dfs.namenode.replication.work.multiplier.per.iteration = '" + blocksReplWorkMultiplier + "' is invalid. It should be a positive, non-zero integer value."));
        return blocksReplWorkMultiplier;
    }

    public static String getSpnegoKeytabKey(Configuration conf, String defaultKey) {
        String value = conf.get("dfs.web.authentication.kerberos.keytab");
        return value == null || value.isEmpty() ? defaultKey : "dfs.web.authentication.kerberos.keytab";
    }

    public static HttpConfig.Policy getHttpPolicy(Configuration conf) {
        String policyStr = conf.get("dfs.http.policy");
        if (policyStr == null) {
            boolean https = conf.getBoolean("dfs.https.enable", false);
            boolean hadoopSsl = conf.getBoolean("hadoop.ssl.enabled", false);
            if (hadoopSsl) {
                LOG.warn((Object)"hadoop.ssl.enabled is deprecated. Please use dfs.http.policy.");
            }
            if (https) {
                LOG.warn((Object)"dfs.https.enable is deprecated. Please use dfs.http.policy.");
            }
            return hadoopSsl || https ? HttpConfig.Policy.HTTP_AND_HTTPS : HttpConfig.Policy.HTTP_ONLY;
        }
        HttpConfig.Policy policy = HttpConfig.Policy.fromString((String)policyStr);
        if (policy == null) {
            throw new HadoopIllegalArgumentException("Unregonized value '" + policyStr + "' for " + "dfs.http.policy");
        }
        conf.set("dfs.http.policy", policy.name());
        return policy;
    }

    public static HttpServer3.Builder loadSslConfToHttpServerBuilder(HttpServer3.Builder builder, Configuration sslConf) {
        return builder.needsClientAuth(sslConf.getBoolean("dfs.client.https.need-auth", false)).keyPassword(DFSUtil.getPassword(sslConf, "ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), DFSUtil.getPassword(sslConf, "ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), DFSUtil.getPassword(sslConf, "ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks"));
    }

    public static List<InetSocketAddress> getNameNodesServiceRpcAddresses(Configuration conf) throws IOException {
        String defaultAddress;
        List<InetSocketAddress> addresses = DFSUtil.getNameNodesRPCAddresses(conf, "dfs.namenodes.servicerpc.addresses", "dfs.namenodes.rpc.addresses", "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        if (addresses.isEmpty()) {
            addresses = DFSUtil.getNameNodesRPCAddresses(conf);
        }
        if (addresses.isEmpty() && (defaultAddress = DFSUtil.getFSDefaultNameAsHostPortString(conf)) != null) {
            URI uri = DFSUtil.createHDFSUri(defaultAddress);
            addresses.add(new InetSocketAddress(uri.getHost(), uri.getPort()));
        }
        if (addresses.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addresses;
    }

    public static List<InetSocketAddress> getNameNodesRPCAddresses(Configuration conf) {
        return DFSUtil.getNameNodesRPCAddresses(conf, "dfs.namenodes.rpc.addresses", "dfs.namenode.rpc-address");
    }

    private static List<InetSocketAddress> getNameNodesRPCAddresses(Configuration conf, String listKey, String singleKey) {
        return DFSUtil.getNameNodesRPCAddresses(conf, listKey, listKey, singleKey, singleKey);
    }

    private static List<InetSocketAddress> getNameNodesRPCAddresses(Configuration conf, String listKey, String defaultListKey, String singleKey, String defaultSingleKey) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (URI uri : DFSUtil.getNameNodesRPCAddressesAsURIs(conf, listKey, defaultListKey, singleKey, defaultSingleKey)) {
            addresses.add(new InetSocketAddress(uri.getHost(), uri.getPort()));
        }
        return addresses;
    }

    public static List<URI> getNameNodesRPCAddressesAsURIs(Configuration conf) {
        return DFSUtil.getNameNodesRPCAddressesAsURIs(conf, "dfs.namenodes.rpc.addresses", "dfs.namenode.rpc-address");
    }

    private static List<URI> getNameNodesRPCAddressesAsURIs(Configuration conf, String listKey, String singleKey) {
        return DFSUtil.getNameNodesRPCAddressesAsURIs(conf, listKey, listKey, singleKey, singleKey);
    }

    private static List<URI> getNameNodesRPCAddressesAsURIs(Configuration conf, String listKey, String defaultListKey, String singleKey, String defaultSingleKey) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String nn : DFSUtil.getNameNodesRPCAddressesInternal(conf, listKey, singleKey)) {
            uris.add(DFSUtil.createHDFSUri(nn));
        }
        if (uris.isEmpty()) {
            for (String nn : DFSUtil.getNameNodesRPCAddressesInternal(conf, defaultListKey, defaultSingleKey)) {
                uris.add(DFSUtil.createHDFSUri(nn));
            }
        }
        return uris;
    }

    public static String joinNameNodesRpcAddresses(List<InetSocketAddress> namenodes) {
        ArrayList nnstr = Lists.newArrayList();
        for (InetSocketAddress nn : namenodes) {
            nnstr.add(NetUtils.getHostPortString((InetSocketAddress)nn));
        }
        return DFSUtil.joinNameNodesHostPortString(nnstr);
    }

    public static String joinNameNodesHostPortString(List<String> namenodes) {
        return Joiner.on((String)",").join(namenodes);
    }

    private static Set<String> getNameNodesRPCAddressesInternal(Configuration conf, String listKey, String singleKey) {
        String singleNameNode;
        String namenodes = conf.get(listKey);
        HashSet namenodesSet = Sets.newHashSet();
        if (namenodes != null && !namenodes.isEmpty()) {
            String[] nnsStr;
            for (String nn : nnsStr = namenodes.split(",")) {
                if (nn.isEmpty()) continue;
                namenodesSet.add(nn);
            }
        }
        if ((singleNameNode = conf.get(singleKey)) != null && !singleNameNode.isEmpty()) {
            namenodesSet.add(singleNameNode);
        }
        return namenodesSet;
    }

    private static String getFSDefaultNameAsHostPortString(Configuration conf) {
        String defaultAddress = conf.get("fs.defaultFS");
        if (defaultAddress != null && !defaultAddress.isEmpty() && defaultAddress.startsWith("hdfs")) {
            URI defaultUri = DFSUtil.createHDFSUri(defaultAddress);
            return defaultUri.getHost() + ":" + defaultUri.getPort();
        }
        return null;
    }

    public static URI getInfoServer(InetSocketAddress namenodeAddr, Configuration conf, String scheme) throws IOException {
        String authority;
        String[] suffixes = null;
        if (namenodeAddr != null) {
            suffixes = DFSUtil.getSuffixIDs(conf, namenodeAddr, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        }
        if ("http".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.http-address", "0.0.0.0:50070", suffixes);
        } else if ("https".equals(scheme)) {
            authority = DFSUtil.getSuffixedConf(conf, "dfs.namenode.https-address", "0.0.0.0:50470", suffixes);
        } else {
            throw new IllegalArgumentException("Invalid scheme:" + scheme);
        }
        if (namenodeAddr != null) {
            authority = DFSUtil.substituteForWildcardAddress(authority, namenodeAddr.getHostName());
        }
        return URI.create(scheme + "://" + authority);
    }

    public static URI getInfoServerWithDefaultHost(String defaultHost, Configuration conf, String scheme) throws IOException {
        URI configuredAddr = DFSUtil.getInfoServer(null, conf, scheme);
        String authority = DFSUtil.substituteForWildcardAddress(configuredAddr.getAuthority(), defaultHost);
        return URI.create(scheme + "://" + authority);
    }

    public static String getHttpClientScheme(Configuration conf) {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        return policy == HttpConfig.Policy.HTTPS_ONLY ? "https" : "http";
    }

    @VisibleForTesting
    static String substituteForWildcardAddress(String configuredAddress, String defaultHost) {
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        InetAddress addr = sockAddr.getAddress();
        if (addr != null && addr.isAnyLocalAddress()) {
            return defaultHost + ":" + sockAddr.getPort();
        }
        return configuredAddress;
    }

    private static String getSuffixedConf(Configuration conf, String key, String defaultVal, String[] suffixes) {
        String ret = conf.get(DFSUtil.addKeySuffixes(key, suffixes));
        if (ret != null) {
            return ret;
        }
        return conf.get(key, defaultVal);
    }

    public static List<URI> getNsServiceRpcUris(Configuration conf) throws URISyntaxException {
        return DFSUtil.getNameNodesRPCAddressesAsURIs(conf, "dfs.namenodes.servicerpc.addresses", "dfs.namenodes.rpc.addresses", "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
    }

    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static URI createHDFSUri(String server) {
        if (server.startsWith("hdfs")) {
            return URI.create(server);
        }
        return URI.create("hdfs://" + server);
    }

    public static Configuration loadSslConfiguration(Configuration conf) {
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("dfs.https.server.keystore.resource", "ssl-server.xml"));
        boolean requireClientAuth = conf.getBoolean("dfs.client.https.need-auth", false);
        sslConf.setBoolean("dfs.client.https.need-auth", requireClientAuth);
        return sslConf;
    }

    public static HttpServer3.Builder httpServerTemplateForNNAndJN(Configuration conf, InetSocketAddress httpAddr, InetSocketAddress httpsAddr, String name, String spnegoUserNameKey, String spnegoKeytabFileKey) throws IOException {
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        HttpServer3.Builder builder = new HttpServer3.Builder().setName(name).setConf(conf).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).setSecurityEnabled(UserGroupInformation.isSecurityEnabled()).setUsernameConfKey(spnegoUserNameKey).setKeytabConfKey(DFSUtil.getSpnegoKeytabKey(conf, spnegoKeytabFileKey));
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)("Starting web server as: " + SecurityUtil.getServerPrincipal((String)conf.get(spnegoUserNameKey), (String)httpAddr.getHostName())));
        }
        if (policy.isHttpEnabled()) {
            if (httpAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("http://" + NetUtils.getHostPortString((InetSocketAddress)httpAddr));
            builder.addEndpoint(uri);
            LOG.info((Object)("Starting Web-server for " + name + " at: " + uri));
        }
        if (policy.isHttpsEnabled() && httpsAddr != null) {
            Configuration sslConf = DFSUtil.loadSslConfiguration(conf);
            DFSUtil.loadSslConfToHttpServerBuilder(builder, sslConf);
            if (httpsAddr.getPort() == 0) {
                builder.setFindPort(true);
            }
            URI uri = URI.create("https://" + NetUtils.getHostPortString((InetSocketAddress)httpsAddr));
            builder.addEndpoint(uri);
            LOG.info((Object)("Starting Web-server for " + name + " at: " + uri));
        }
        return builder;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration conf) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    static String getPassword(Configuration conf, String alias) {
        String password = null;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            password = null;
        }
        return password;
    }

    public static String dateToIso8601String(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
        return df.format(date);
    }

    public static String durationToString(long durationMs) {
        boolean negative = false;
        if (durationMs < 0L) {
            negative = true;
            durationMs = -durationMs;
        }
        long durationSec = durationMs / 1000L;
        int secondsPerMinute = 60;
        int secondsPerHour = 3600;
        int secondsPerDay = 86400;
        long days = durationSec / 86400L;
        long hours = (durationSec -= days * 86400L) / 3600L;
        long minutes = (durationSec -= hours * 3600L) / 60L;
        long seconds = durationSec -= minutes * 60L;
        long milliseconds = durationMs % 1000L;
        String format = "%03d:%02d:%02d:%02d.%03d";
        if (negative) {
            format = "-" + format;
        }
        return String.format(format, days, hours, minutes, seconds, milliseconds);
    }

    public static long parseRelativeTime(String relTime) throws IOException {
        long ttl;
        if (relTime.length() < 2) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": too short");
        }
        String ttlString = relTime.substring(0, relTime.length() - 1);
        try {
            ttl = Long.parseLong(ttlString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Unable to parse relative time value of " + relTime + ": " + ttlString + " is not a number");
        }
        if (!relTime.endsWith("s")) {
            if (relTime.endsWith("m")) {
                ttl *= 60L;
            } else if (relTime.endsWith("h")) {
                ttl *= 3600L;
            } else if (relTime.endsWith("d")) {
                ttl *= 86400L;
            } else {
                throw new IOException("Unable to parse relative time value of " + relTime + ": unknown time unit " + relTime.charAt(relTime.length() - 1));
            }
        }
        return ttl * 1000L;
    }

    public static KeyProvider createKeyProvider(Configuration conf) throws IOException {
        URI providerUri;
        String providerUriStr = conf.get("dfs.encryption.key.provider.uri", null);
        if (providerUriStr == null) {
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        KeyProvider keyProvider = KeyProviderFactory.get((URI)providerUri, (Configuration)conf);
        if (keyProvider == null) {
            throw new IOException("Could not instantiate KeyProvider from dfs.encryption.key.provider.uri setting of '" + providerUriStr + "'");
        }
        if (keyProvider.isTransient()) {
            throw new IOException("KeyProvider " + keyProvider.toString() + " was found but it is a transient provider.");
        }
        return keyProvider;
    }

    public static KeyProviderCryptoExtension createKeyProviderCryptoExtension(Configuration conf) throws IOException {
        KeyProvider keyProvider = DFSUtil.createKeyProvider(conf);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    static {
        helpOptions.addOption(helpOpt);
    }

    private static interface AddressMatcher {
        public boolean match(InetSocketAddress var1);
    }

    @InterfaceAudience.Private
    public static class DecomStaleComparator
    implements Comparator<DatanodeInfo> {
        private long staleInterval;

        public DecomStaleComparator(long interval) {
            this.staleInterval = interval;
        }

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            boolean bStale;
            if (a.isDecommissioned()) {
                return b.isDecommissioned() ? 0 : 1;
            }
            if (b.isDecommissioned()) {
                return -1;
            }
            boolean aStale = a.isStale(this.staleInterval);
            return aStale == (bStale = b.isStale(this.staleInterval)) ? 0 : (aStale ? 1 : -1);
        }
    }
}

