/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockInfoUnderConstruction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitializeBlockRecovery() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        int leaseCreationLockRows = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            HeartbeatManager hm = namesystem.getBlockManager().getDatanodeManager().getHeartbeatManager();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg1 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd1 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg1);
            DatanodeRegistration nodeReg2 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(1), poolId);
            DatanodeDescriptor dd2 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg2);
            DatanodeRegistration nodeReg3 = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(2), poolId);
            DatanodeDescriptor dd3 = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg3);
            DatanodeManager dn = namesystem.getBlockManager().getDatanodeManager();
            HeartbeatManager heartbeatManager = hm;
            synchronized (heartbeatManager) {
                DatanodeStorageInfo s1 = dd1.getStorageInfos()[0];
                DatanodeStorageInfo s2 = dd2.getStorageInfos()[0];
                DatanodeStorageInfo s3 = dd3.getStorageInfos()[0];
                dd3.isAlive = true;
                dd2.isAlive = true;
                dd1.isAlive = true;
                BlockInfoContiguousUnderConstruction blockInfo = this.createBlockInfoUnderConstruction(new DatanodeStorageInfo[]{s1, s2, s3}, leaseCreationLockRows);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -3000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -2000L);
                this.initializeBlockRecovery(blockInfo, 1L, dn, leaseCreationLockRows);
                BlockInfoContiguousUnderConstruction[] blockInfoRecovery = dd2.getLeaseRecoveryCommand(1);
                Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -3000L);
                this.initializeBlockRecovery(blockInfo, 2L, dn, leaseCreationLockRows);
                blockInfoRecovery = dd1.getLeaseRecoveryCommand(1);
                Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -3000L);
                this.initializeBlockRecovery(blockInfo, 3L, dn, leaseCreationLockRows);
                blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
                Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, 0L);
                this.initializeBlockRecovery(blockInfo, 3L, dn, leaseCreationLockRows);
                blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
                Assert.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private BlockInfoContiguousUnderConstruction createBlockInfoUnderConstruction(final DatanodeStorageInfo[] storages, final int leaseCreationLockRows) throws IOException {
        return (BlockInfoContiguousUnderConstruction)new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(3L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                Block block = new Block(10L, 0L, 1000L);
                EntityManager.add((Object)new BlockInfoContiguous(block, this.inodeIdentifier != null ? this.inodeIdentifier.getInodeId() : (long)BlockInfoContiguous.NON_EXISTING_ID));
                BlockInfoContiguousUnderConstruction blockInfo = new BlockInfoContiguousUnderConstruction(block, 3L, HdfsServerConstants.BlockUCState.UNDER_RECOVERY, storages);
                return blockInfo;
            }
        }.handle();
    }

    private void initializeBlockRecovery(final BlockInfoContiguousUnderConstruction blockInfo, final long recoveryId, final DatanodeManager dn, final int leaseCreationLockRows) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(3L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                blockInfo.initializeBlockRecovery(recoveryId, dn);
                return null;
            }
        }.handle();
    }
}

