/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaseRestart {
    Configuration getConf() {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.failover.max.attempts", 1);
        conf.setInt("dfs.client.retry.max.attempts", 1);
        conf.setInt("dfs.client.failover.sleep.base.millis", 500);
        conf.setInt("dfs.client.failover.sleep.max.millis", 1000);
        conf.setInt("dfs.client.failover.connection.retries", 0);
        conf.setInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        conf.setInt("ipc.client.connect.max.retries.on.timeouts", 2);
        conf.setInt("ipc.client.connect.max.retries", 1);
        conf.set("dfs.client.retry.policy.spec", "1000,2");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingInodeLease() throws Exception {
        boolean NN_COUNT = true;
        String fileName = "testFile";
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.getConf()).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(1)).numDataNodes(1).format(true).build();
        cluster.setLeasePeriod(3000L, 5000L);
        Random rand = new Random(System.currentTimeMillis());
        DistributedFileSystem fs = cluster.getFileSystem(rand.nextInt(1));
        FSDataOutputStream out = fs.create(new Path("/testFile"));
        try {
            out.write(1);
            out.hflush();
            cluster.shutdownNameNodes();
            fs.getClient().getLeaseRenewer().interruptAndJoin();
            IOUtils.closeStream((Closeable)out);
            fs.getClient().close();
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws IOException {
                    INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    da.deleteInode("testFile");
                    return null;
                }
            }.handle();
            cluster.restartNameNodes();
            cluster.setLeasePeriod(3000L, 5000L);
            Thread.sleep(10000L);
            Assert.assertTrue((String)"The lease should eventually be removed by the lease manager", (cluster.getNamesystem().getLeaseManager().getNumSortedLeases() == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }
}

