/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.protocol.Bucket;

public class BlockReport
implements Iterable<BlockListAsLongs.BlockReportReplica> {
    private Bucket[] buckets;
    private int numBlocks;

    public Bucket[] getBuckets() {
        return this.buckets;
    }

    public int getNumberOfBlocks() {
        return this.numBlocks;
    }

    public BlockReport(Bucket[] buckets, int numBlocks) {
        this.buckets = buckets;
        this.numBlocks = numBlocks;
    }

    @VisibleForTesting
    public Iterable<Block> blockIterable() {
        return new Iterable<Block>(){

            @Override
            public Iterator<Block> iterator() {
                return new Iterator<Block>(){
                    Iterator<BlockListAsLongs.BlockReportReplica> it;
                    {
                        this.it = BlockReport.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Block next() {
                        BlockListAsLongs.BlockReportReplica next = this.it.next();
                        return new Block(next.getBlockId(), next.getBytesOnDisk(), next.getGenerationStamp());
                    }
                };
            }
        };
    }

    @Override
    public Iterator<BlockListAsLongs.BlockReportReplica> iterator() {
        return new BlockReportIterator();
    }

    public static Builder builder(int numBuckets) {
        return new Builder(numBuckets);
    }

    public static int bucket(Replica replica, int numBuckets) {
        return BlockReport.bucket(replica.getBlockId(), numBuckets);
    }

    private static int bucket(Block block, int numBuckets) {
        return BlockReport.bucket(block.getBlockId(), numBuckets);
    }

    private static int bucket(long blockId, int numBuckets) {
        int reminder = (int)(blockId % (long)numBuckets);
        return reminder >= 0 ? reminder : numBuckets + reminder;
    }

    private static byte[] hashAsFinalized(Block theBlock) {
        return HashBuckets.hash(theBlock.getBlockId(), theBlock.getGenerationStamp(), theBlock.getNumBytes(), HdfsServerConstants.ReplicaState.FINALIZED.getValue());
    }

    public static byte[] hashAsFinalized(BlockListAsLongs.BlockReportReplica block) {
        Block toHash = new Block(block.getBlockId(), block.getBytesOnDisk(), block.getGenerationStamp());
        return BlockReport.hashAsFinalized(toHash);
    }

    public static byte[] hashAsFinalized(BlockInfoContiguous block) {
        Block toHash = new Block(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
        return BlockReport.hashAsFinalized(toHash);
    }

    private static byte[] hash(Replica replica) {
        return HashBuckets.hash(replica.getBlockId(), replica.getGenerationStamp(), replica.getNumBytes(), replica.getState().getValue());
    }

    public static byte[] hash(Block block, HdfsServerConstants.ReplicaState state) {
        return HashBuckets.hash(block.getBlockId(), block.getGenerationStamp(), block.getNumBytes(), state.getValue());
    }

    public void writeTo(OutputStream os) throws IOException {
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)os);
        cos.writeInt32(1, this.buckets.length);
        int fieldId = 2;
        for (Bucket b : this.buckets) {
            cos.writeInt32(fieldId++, b.getBlocks().getNumberOfBlocks());
            cos.writeBytes(fieldId++, b.getBlocks().getBlocksBuffer());
        }
        cos.flush();
    }

    public static BlockReport readFrom(InputStream is) throws IOException {
        int tag;
        int field;
        CodedInputStream cis = CodedInputStream.newInstance((InputStream)is);
        int numBuckets = -1;
        HashMap<Integer, Integer> numBlocksInBucket = new HashMap<Integer, Integer>();
        HashMap<Integer, ByteString> bucketBlocksBuf = new HashMap<Integer, ByteString>();
        while (!cis.isAtEnd() && (field = WireFormat.getTagFieldNumber((int)(tag = cis.readTag()))) != 0) {
            if (field == 1) {
                numBuckets = cis.readInt32();
                continue;
            }
            if (field > 1 && field % 2 == 0) {
                numBlocksInBucket.put(field / 2 - 1, cis.readInt32());
                continue;
            }
            if (field <= 1 || field % 2 != 1) continue;
            bucketBlocksBuf.put(field / 2 - 1, cis.readBytes());
        }
        if (numBuckets != -1) {
            Bucket[] buckets = new Bucket[numBuckets];
            int numBlocks = 0;
            for (int i = 0; i < numBuckets; ++i) {
                if (numBlocksInBucket.get(i) == null || bucketBlocksBuf.get(i) == null) continue;
                numBlocks += ((Integer)numBlocksInBucket.get(i)).intValue();
                BlockListAsLongs blocks = BlockListAsLongs.decodeBuffer((Integer)numBlocksInBucket.get(i), (ByteString)bucketBlocksBuf.get(i));
                buckets[i] = new Bucket(blocks);
            }
            return new BlockReport(buckets, numBlocks);
        }
        return null;
    }

    private class BlockReportIterator
    implements Iterator<BlockListAsLongs.BlockReportReplica> {
        int currentBucket = 0;
        Iterator<BlockListAsLongs.BlockReportReplica> currentBucketIterator = null;

        BlockReportIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.currentBucket < BlockReport.this.buckets.length) {
                if (this.currentBucketIterator == null) {
                    this.currentBucketIterator = BlockReport.this.buckets[this.currentBucket].getBlocks().iterator();
                }
                if (this.currentBucketIterator.hasNext()) {
                    return true;
                }
                ++this.currentBucket;
                this.currentBucketIterator = null;
            }
            return false;
        }

        @Override
        public BlockListAsLongs.BlockReportReplica next() {
            if (this.hasNext()) {
                return this.currentBucketIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not allowed to remove blocks from blockReport.");
        }
    }

    public static class Builder {
        private final int NUM_BUCKETS;
        private ArrayList<Replica>[] buckets;
        private byte[][] hashes;
        private int blockCounter = 0;

        private Builder(int numBuckets) {
            this.NUM_BUCKETS = numBuckets;
            this.buckets = new ArrayList[this.NUM_BUCKETS];
            this.hashes = new byte[this.NUM_BUCKETS][20];
            for (int i = 0; i < this.NUM_BUCKETS; ++i) {
                this.buckets[i] = new ArrayList();
            }
        }

        public Builder add(Replica replica) {
            int bucket = BlockReport.bucket(replica, this.NUM_BUCKETS);
            this.buckets[bucket].add(replica);
            HashBuckets.XORHashes(this.hashes[bucket], BlockReport.hash(replica));
            ++this.blockCounter;
            return this;
        }

        public BlockReport build() {
            Bucket[] bucketArray = new Bucket[this.NUM_BUCKETS];
            for (int i = 0; i < this.NUM_BUCKETS; ++i) {
                bucketArray[i] = new Bucket(BlockListAsLongs.encode(this.buckets[i]));
                bucketArray[i].setHash(this.hashes[i]);
            }
            return new BlockReport(bucketArray, this.blockCounter);
        }
    }
}

