/*
 * Decompiled with CFR 0.152.
 */
package io.hops;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class TestUtil {
    public static long getINodeId(NameNode nameNode, Path path) throws IOException {
        return TestUtil.getINode(nameNode, path).getId();
    }

    public static INode getINode(final NameNode nameNode, Path path) throws IOException {
        final String filePath = path.toUri().getPath();
        return (INode)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, new String[]{filePath}).setNameNodeID(nameNode.getId()).setActiveNameNodes((Collection)nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INode targetNode = nameNode.getNamesystem().getINode(filePath);
                return targetNode;
            }
        }.handle();
    }
}

