/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.lock;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.Before;

public class TestNDBSizer {
    HdfsConfiguration conf = null;
    INodeDirectory root;
    INodeDirectory dir1;
    INodeDirectory dir2;
    INodeDirectory dir3;
    INodeDirectory dir4;
    INodeDirectory dir5;
    INodeDirectory dir6;
    INodeFile file1;
    INodeFile file2;
    INodeFile file3;

    @Before
    public void init() throws IOException {
        this.conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)this.conf);
        HdfsStorageFactory.formatStorage();
    }

    public void testInsertData() throws Exception {
        this.insertData();
    }

    private void insertData() throws StorageException, StorageException, IOException {
        int j;
        System.out.println("Building the data...");
        int NUM_INODES = 500000;
        int NUM_BLOCKS = 1200000;
        int NUM_REPLICAS = 3600000;
        int BATCH_SIZE = 5000;
        String filename = "";
        for (int i = 0; i < 100; ++i) {
            filename = filename + "-";
        }
        final LinkedList<INodeDirectory> newFiles = new LinkedList<INodeDirectory>();
        for (int i = 0; i < 500000; ++i) {
            INodeDirectory dir = new INodeDirectory((long)i, "", new PermissionStatus("salman", "usr", new FsPermission(511)), true);
            dir.setLocalNameNoPersistance(filename + Integer.toString(i));
            dir.setParentIdNoPersistance((long)i);
            newFiles.add(dir);
            if (newFiles.size() < 5000) continue;
            final int j2 = i;
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws StorageException, IOException {
                    INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    da.prepare(new LinkedList(), (Collection)newFiles, new LinkedList());
                    newFiles.clear();
                    TestNDBSizer.showProgressBar("INodes", j2, 500000.0);
                    return null;
                }
            }.handle();
        }
        System.out.println();
        final LinkedList<BlockInfoContiguous> newBlocks = new LinkedList<BlockInfoContiguous>();
        for (int i = 0; i < 1200000; ++i) {
            BlockInfoContiguous block = new BlockInfoContiguous();
            block.setINodeIdNoPersistance((long)i);
            block.setBlockIdNoPersistance((long)i);
            newBlocks.add(block);
            if (newBlocks.size() < 5000) continue;
            j = i;
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws StorageException, IOException {
                    BlockInfoDataAccess bda = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                    bda.prepare(new LinkedList(), (Collection)newBlocks, new LinkedList());
                    newBlocks.clear();
                    TestNDBSizer.showProgressBar("Blocks", j, 1200000.0);
                    return null;
                }
            }.handle();
        }
        System.out.println();
        final LinkedList<Replica> replicas = new LinkedList<Replica>();
        for (int i = 0; i < 3600000; ++i) {
            replicas.add(new Replica(i, (long)i, (long)i, i));
            if (replicas.size() < 5000) continue;
            j = i;
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws StorageException, IOException {
                    ReplicaDataAccess rda = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                    rda.prepare(new LinkedList(), (Collection)replicas, new LinkedList());
                    replicas.clear();
                    TestNDBSizer.showProgressBar("Replicas", j, 3600000.0);
                    return null;
                }
            }.handle();
        }
    }

    public static void showProgressBar(String msg, double achieved, double total) throws IOException {
        int i;
        int percent = (int)(achieved / total * 100.0);
        System.out.print("\r");
        StringBuffer bar = new StringBuffer(msg + " |");
        for (i = 0; i < percent; ++i) {
            bar.append(".");
        }
        for (i = 0; i < 100 - percent; ++i) {
            bar.append(" ");
        }
        bar.append("| " + percent + "%");
        System.out.println(bar);
    }
}

