/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestInodeLock {
    public static final Log LOG = LogFactory.getLog(TestInodeLock.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeLockWithWrongPath() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            final MiniDFSCluster clusterFinal = cluster;
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.mkdirs(new Path("/tmp"));
            DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/f1"), 0L, (short)1, 0L);
            new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, new String[]{"/tmp/f1", "/tmp/f2"}).setNameNodeID(clusterFinal.getNameNode().getId()).setActiveNameNodes((Collection)clusterFinal.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                    locks.add((Lock)il);
                }

                public Object performTask() throws IOException {
                    return null;
                }
            }.handle();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeAndBlockLock() throws IOException {
        Logger.getRootLogger().setLevel(Level.INFO);
        Configuration conf = new Configuration();
        int BLOCK_SIZE = 0x100000;
        conf.setInt("dfs.blocksize", 0x100000);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).build();
            cluster.waitActive();
            MiniDFSCluster clusterFinal = cluster;
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.mkdirs(new Path("/tmp"));
            int BLOCKS_PER_FILE = 10;
            int NO_OF_FILES = 10;
            for (int i = 0; i < 10; ++i) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/file" + i), 0xA00000L, (short)3, 0L);
            }
            int count = (Integer)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws IOException {
                    HdfsStorageFactory.getConnector().writeLock();
                    ReplicaUnderConstructionDataAccess da = (ReplicaUnderConstructionDataAccess)HdfsStorageFactory.getDataAccess(ReplicaUnderConstructionDataAccess.class);
                    return da.countAll();
                }
            }.performTask();
            assert (count == 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInodeAndBlockLock1() throws IOException {
        Configuration conf = new Configuration();
        int BLOCK_SIZE = 0x100000;
        conf.setInt("dfs.blocksize", 0x100000);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            MiniDFSCluster clusterFinal = cluster;
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.mkdirs(new Path("/tmp"));
            boolean BLOCKS_PER_FILE = true;
            boolean NO_OF_FILES = true;
            for (int i = 0; i < 1; ++i) {
                DFSTestUtil.createFile((FileSystem)hdfs, new Path("/tmp/file" + i), 0x100000L, (short)3, 0L);
            }
            InodeLockThread worker1 = new InodeLockThread("file0", new Long(2L), new Long(2L), 1000L);
            InodeLockThread worker2 = new InodeLockThread(new Long(3L), 1000L);
            long startTime = System.currentTimeMillis();
            Thread thread1 = new Thread(worker1);
            thread1.start();
            Thread.sleep(250L);
            Thread thread2 = new Thread(worker2);
            thread2.start();
            thread1.join();
            thread2.join();
            long endTime = System.currentTimeMillis();
            assert (endTime - startTime > 2000L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    class InodeLockThread
    implements Runnable {
        private Long id;
        private Long pid;
        private String name;
        private Long partID;
        private long sleep;

        public InodeLockThread(Long id, long sleep) {
            this.id = id;
            this.sleep = sleep;
        }

        public InodeLockThread(String name, Long pid, Long partID, long sleep) {
            this.name = name;
            this.pid = pid;
            this.partID = partID;
            this.sleep = sleep;
        }

        @Override
        public void run() {
            try {
                new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

                    public void acquireLock(TransactionLocks locks) throws IOException {
                        try {
                            INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                            EntityManager.writeLock();
                            LOG.info((Object)("TID: " + Thread.currentThread().getId() + " Connector " + HdfsStorageFactory.getConnector()));
                            if (InodeLockThread.this.id != null) {
                                assert (da.findInodeByIdFTIS(InodeLockThread.this.id.longValue()) != null);
                                LOG.info((Object)"Locked using FTIS");
                                Thread.sleep(InodeLockThread.this.sleep);
                                LOG.info((Object)"Locked using FTIS Returning");
                            } else {
                                assert (da.findInodeByNameParentIdAndPartitionIdPK(InodeLockThread.this.name, InodeLockThread.this.pid.longValue(), InodeLockThread.this.partID.longValue()) != null);
                                LOG.info((Object)"Locked using PK");
                                Thread.sleep(InodeLockThread.this.sleep);
                                LOG.info((Object)"Locked using PK Returning");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }

                    public Object performTask() throws IOException {
                        return null;
                    }
                }.handle();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

