/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.hadoop.cli.CLITestHelper;
import org.apache.hadoop.cli.CLITestHelperDFS;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CLICommandCryptoAdmin;
import org.apache.hadoop.cli.util.CLICommandTypes;
import org.apache.hadoop.cli.util.CLITestCmd;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.cli.util.CryptoAdminCmdExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.CryptoAdmin;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestCryptoAdminCLI
extends CLITestHelperDFS {
    protected MiniDFSCluster dfsCluster = null;
    protected FileSystem fs = null;
    protected String namenode = null;
    private static File tmpDir;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf.setClass("hadoop.security.authorization.policyprovider", HDFSPolicyProvider.class, PolicyProvider.class);
        this.conf.setInt("dfs.replication", 1);
        tmpDir = new File(System.getProperty("test.build.data", "target"), UUID.randomUUID().toString()).getAbsoluteFile();
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        this.conf.set("dfs.encryption.key.provider.uri", "jceks://file" + jksPath.toUri());
        this.dfsCluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.dfsCluster.waitClusterUp();
        this.createAKey("mykey", this.conf);
        this.namenode = this.conf.get("fs.defaultFS", "file:///");
        this.username = System.getProperty("user.name");
        this.fs = this.dfsCluster.getFileSystem();
        Assert.assertTrue((String)("Not an HDFS: " + this.fs.getUri()), (boolean)(this.fs instanceof DistributedFileSystem));
    }

    @After
    public void tearDown() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
        Thread.sleep(2000L);
        super.tearDown();
    }

    private void createAKey(String keyName, Configuration conf) throws NoSuchAlgorithmException, IOException {
        KeyProviderCryptoExtension provider = this.dfsCluster.getNameNode().getNamesystem().getProvider();
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        provider.createKey(keyName, options);
        provider.flush();
    }

    protected String getTestFile() {
        return "testCryptoConf.xml";
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("NAMENODE", this.namenode);
        expCmd = expCmd.replaceAll("#LF#", System.getProperty("line.separator"));
        expCmd = super.expandCommand(expCmd);
        return expCmd;
    }

    @Override
    protected CLITestHelper.TestConfigFileParser getConfigParser() {
        return new TestConfigFileParserCryptoAdmin();
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        return cmd.getExecutor(this.namenode, this.conf).executeCommand(cmd.getCmd());
    }

    @Test
    public void testAll() {
        super.testAll();
    }

    private class CLITestCmdCryptoAdmin
    extends CLITestCmd {
        public CLITestCmdCryptoAdmin(String str, CLICommandTypes type) {
            super(str, type);
        }

        public CommandExecutor getExecutor(String tag, Configuration conf) throws IllegalArgumentException {
            if (this.getType() instanceof CLICommandCryptoAdmin) {
                return new CryptoAdminCmdExecutor(tag, new CryptoAdmin(conf));
            }
            return super.getExecutor(tag, conf);
        }
    }

    private class TestConfigFileParserCryptoAdmin
    extends CLITestHelper.TestConfigFileParser {
        private TestConfigFileParserCryptoAdmin() {
            super((CLITestHelper)TestCryptoAdminCLI.this);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("crypto-admin-command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestCmdCryptoAdmin(this.charString, new CLICommandCryptoAdmin()));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestCmdCryptoAdmin(this.charString, new CLICommandCryptoAdmin()));
                }
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

