/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.hops.erasure_coding.MockEncodingManager;
import io.hops.erasure_coding.MockRepairManager;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.security.UsersGroups;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig"})
@InterfaceStability.Unstable
public class MiniDFSCluster {
    private static final String NAMESERVICE_ID_PREFIX = "nameserviceId";
    private static final Log LOG = LogFactory.getLog(MiniDFSCluster.class);
    public static final String PROP_TEST_BUILD_DATA = "test.build.data";
    public static final String HDFS_MINIDFS_BASEDIR = "hdfs.minidfs.basedir";
    public static final String DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY = "dfs.namenode.safemode.extension.testing";
    private static final int DEFAULT_STORAGES_PER_DATANODE = 2;
    private Configuration conf;
    private NameNodeInfo[] nameNodes;
    protected int numDataNodes;
    protected ArrayList<DataNodeProperties> dataNodes = new ArrayList();
    private File base_dir;
    private File data_dir;
    private boolean waitSafeMode = true;
    private boolean checkExitOnShutdown = true;
    protected final int storagesPerDatanode;
    private Set<FileSystem> fileSystems = Sets.newHashSet();
    private int instanceId;
    private static int instanceCount;

    public int getStoragesPerDatanode() {
        return this.storagesPerDatanode;
    }

    protected MiniDFSCluster(Builder builder) throws IOException {
        int i;
        if (builder.nnTopology == null) {
            builder.nnTopology = MiniDFSNNTopology.simpleSingleNN(builder.nameNodePort, builder.nameNodeHttpPort);
        }
        assert (builder.storageTypes == null || builder.storageTypes.length == builder.numDataNodes);
        int numNameNodes = builder.nnTopology.countNameNodes();
        LOG.info((Object)("starting cluster: numNameNodes=" + numNameNodes + ", numDataNodes=" + builder.numDataNodes));
        this.nameNodes = new NameNodeInfo[numNameNodes];
        this.storagesPerDatanode = builder.storagesPerDatanode;
        if (builder.storageTypes == null && builder.storageTypes1D != null) {
            assert (builder.storageTypes1D.length == this.storagesPerDatanode);
            Builder.access$302(builder, new StorageType[builder.numDataNodes][this.storagesPerDatanode]);
            for (i = 0; i < builder.numDataNodes; ++i) {
                ((Builder)builder).storageTypes[i] = builder.storageTypes1D;
            }
        }
        if (builder.storageCapacities == null && builder.storageCapacities1D != null) {
            assert (builder.storageCapacities1D.length == this.storagesPerDatanode);
            Builder.access$702(builder, new long[builder.numDataNodes][this.storagesPerDatanode]);
            for (i = 0; i < builder.numDataNodes; ++i) {
                ((Builder)builder).storageCapacities[i] = builder.storageCapacities1D;
            }
        }
        this.initMiniDFSCluster(builder.conf, builder.numDataNodes, builder.storageTypes, builder.format, builder.manageNameDfsDirs, builder.manageNameDfsSharedDirs, builder.enableManagedDfsDirsRedundancy, builder.manageDataDfsDirs, builder.option, builder.dnOption, builder.racks, builder.hosts, builder.storageCapacities, builder.simulatedCapacities, builder.clusterId, builder.waitSafeMode, builder.setupHostsFile, builder.nnTopology, builder.checkExitOnShutdown, builder.checkDataNodeAddrConfig, builder.checkDataNodeHostConfig, builder.dnConfOverlays, builder.skipFsyncForTesting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniDFSCluster() {
        this.nameNodes = new NameNodeInfo[0];
        this.storagesPerDatanode = 2;
        Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
        synchronized (MiniDFSCluster.class) {
            this.instanceId = instanceCount++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, HdfsServerConstants.StartupOption nameNodeOperation) throws IOException {
        this(0, conf, numDataNodes, false, false, false, nameNodeOperation, null, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks, String[] hosts) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, hosts, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.storagesPerDatanode = 2;
        this.initMiniDFSCluster(conf, numDataNodes, null, format, manageNameDfsDirs, true, manageDataDfsDirs, manageDataDfsDirs, operation, null, racks, hosts, null, simulatedCapacities, null, true, false, MiniDFSNNTopology.simpleSingleNN(nameNodePort, 0), true, false, false, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMiniDFSCluster(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean format, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption startOpt, HdfsServerConstants.StartupOption dnStartOpt, String[] racks, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, String clusterId, boolean waitSafeMode, boolean setupHostsFile, MiniDFSNNTopology nnTopology, boolean checkExitOnShutdown, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays, boolean skipFsyncForTesting) throws IOException {
        boolean success = false;
        try {
            ExitUtil.disableSystemExit();
            FileSystem.enableSymlinks();
            Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
            synchronized (MiniDFSCluster.class) {
                this.instanceId = instanceCount++;
                // ** MonitorExit[var25_25] (shouldn't be in output)
                this.conf = conf;
                this.base_dir = new File(this.determineDfsBaseDir());
                this.data_dir = new File(this.base_dir, "data");
                this.waitSafeMode = waitSafeMode;
                this.checkExitOnShutdown = checkExitOnShutdown;
                int replication = conf.getInt("dfs.replication", 3);
                conf.setInt("dfs.replication", Math.min(replication, numDataNodes));
                int safemodeExtension = conf.getInt(DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY, 0);
                conf.setInt("dfs.namenode.safemode.extension", safemodeExtension);
                int decommissionInterval = conf.getInt("dfs.namenode.decommission.interval", 30);
                if (decommissionInterval == 30) {
                    decommissionInterval = 3;
                }
                conf.setInt("dfs.namenode.decommission.interval", decommissionInterval);
                conf.setClass("net.topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
                if (conf.get("dfs.erasure_coding.encoding_manager") == null) {
                    conf.set("dfs.erasure_coding.encoding_manager", MockEncodingManager.class.getName());
                }
                if (conf.get("dfs.erasure_coding.block_rapair_manager") == null) {
                    conf.set("dfs.erasure_coding.block_rapair_manager", MockRepairManager.class.getName());
                }
                conf.set("dfs.ndc.enable", "true");
                HdfsStorageFactory.reset();
                HdfsStorageFactory.setConfiguration((Configuration)conf);
                if (format) {
                    LOG.debug((Object)"MiniDFSClustring Formatting the Cluster");
                    assert (HdfsStorageFactory.formatStorage());
                    if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
                        throw new IOException("Cannot remove data directory: " + this.data_dir);
                    }
                }
                try {
                    this.createNameNodesAndSetConf(nnTopology, manageNameDfsDirs, manageNameDfsSharedDirs, enableManagedDfsDirsRedundancy, format, startOpt, clusterId, conf);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOE creating namenodes. Permissions dump:\n" + this.createPermissionsDiagnosisString(this.data_dir)), (Throwable)ioe);
                    throw ioe;
                }
                if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
                    return;
                }
                this.startDataNodes(conf, numDataNodes, storageTypes, manageDataDfsDirs, dnStartOpt != null ? dnStartOpt : startOpt, racks, hosts, storageCapacities, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, checkDataNodeHostConfig, dnConfOverlays);
                this.waitClusterUp();
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
        {
            return;
        }
    }

    private String createPermissionsDiagnosisString(File path) {
        StringBuilder sb = new StringBuilder();
        while (path != null) {
            sb.append("path '" + path + "': ").append("\n");
            sb.append("\tabsolute:").append(path.getAbsolutePath()).append("\n");
            sb.append("\tpermissions: ");
            sb.append(path.isDirectory() ? "d" : "-");
            sb.append(path.canRead() ? "r" : "-");
            sb.append(path.canWrite() ? "w" : "-");
            sb.append(path.canExecute() ? "x" : "-");
            sb.append("\n");
            path = path.getParentFile();
        }
        return sb.toString();
    }

    private void createNameNodesAndSetConf(MiniDFSNNTopology nnTopology, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, Configuration conf) throws IOException {
        Preconditions.checkArgument((nnTopology.countNameNodes() > 0 ? 1 : 0) != 0, (Object)"empty NN topology: no namenodes specified!");
        if (this.nameNodes == null) {
            this.nameNodes = new NameNodeInfo[nnTopology.countNameNodes()];
        }
        if (nnTopology.countNameNodes() == 1) {
            MiniDFSNNTopology.NNConf onlyNN = nnTopology.getOnlyNameNode();
            conf.set("fs.defaultFS", DFSUtil.createHDFSUri((String)("127.0.0.1:" + onlyNN.getIpcPort())).toString());
        }
        conf.unset("dfs.namenodes.rpc.addresses");
        conf.unset("dfs.namenodes.servicerpc.addresses");
        conf.unset("dfs.namenode.http-address");
        conf.unset("dfs.namenode.rpc-address");
        conf.unset("dfs.namenode.servicerpc-address");
        int i = 0;
        for (MiniDFSNNTopology.NNConf nNConf : nnTopology.getNamenodes()) {
            boolean formatThisOne = format;
            if (format && i++ > 0) {
                formatThisOne = false;
            }
            if (!formatThisOne) continue;
            if (nNConf.getClusterId() == null) {
                HdfsServerConstants.StartupOption.FORMAT.setClusterId(clusterId);
            } else {
                HdfsServerConstants.StartupOption.FORMAT.setClusterId(nNConf.getClusterId());
            }
            DFSTestUtil.formatNameNode(conf);
        }
        int nnCounter = 0;
        for (MiniDFSNNTopology.NNConf nn : nnTopology.getNamenodes()) {
            this.createNameNode(nnCounter++, conf, this.numDataNodes, false, operation, clusterId, nn);
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList nnServiceRpcs = Lists.newArrayList();
        ArrayList nnhttpAddresses = Lists.newArrayList();
        ArrayList nnhttpsAddresses = Lists.newArrayList();
        for (NameNodeInfo nameNodeInfo : this.nameNodes) {
            arrayList.add(nameNodeInfo.nameNode.getNameNodeAddressHostPortString());
            if (nameNodeInfo.nameNode.getHttpAddress() != null) {
                nnhttpAddresses.add(NetUtils.getHostPortString((InetSocketAddress)nameNodeInfo.nameNode.getHttpAddress()));
            }
            if (nameNodeInfo.nameNode.getHttpsAddress() != null) {
                nnhttpsAddresses.add(NetUtils.getHostPortString((InetSocketAddress)nameNodeInfo.nameNode.getHttpsAddress()));
            }
            nnServiceRpcs.add(NetUtils.getHostPortString((InetSocketAddress)nameNodeInfo.nameNode.getServiceRpcAddress()));
        }
        String rpcAddresses = DFSUtil.joinNameNodesHostPortString((List)arrayList);
        String serviceRpcAddresses = DFSUtil.joinNameNodesHostPortString((List)nnServiceRpcs);
        conf.set("dfs.namenodes.rpc.addresses", rpcAddresses);
        conf.set("dfs.namenodes.servicerpc.addresses", serviceRpcAddresses);
        for (NameNodeInfo nameNodeInfo : this.nameNodes) {
            nameNodeInfo.conf.set("dfs.namenodes.rpc.addresses", rpcAddresses);
            nameNodeInfo.conf.set("dfs.namenodes.servicerpc.addresses", serviceRpcAddresses);
        }
        if (!nnhttpAddresses.isEmpty()) {
            conf.set("dfs.namenode.http-address", (String)nnhttpAddresses.get(0));
        }
        if (!nnhttpsAddresses.isEmpty()) {
            conf.set("dfs.namenode.https-address", (String)nnhttpsAddresses.get(0));
        }
        conf.set("dfs.namenode.rpc-address", (String)arrayList.get(0));
        conf.set("dfs.namenode.servicerpc-address", (String)nnServiceRpcs.get(0));
        conf.set("fs.defaultFS", DFSUtil.createHDFSUri((String)((String)arrayList.get(0))).toString());
    }

    public NameNodeInfo[] getNameNodeInfos() {
        return this.nameNodes;
    }

    private void createNameNode(int nnIndex, Configuration conf, int numDataNodes, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, MiniDFSNNTopology.NNConf nnConf) throws IOException {
        String[] stringArray;
        Configuration nameNodeConf = new Configuration(conf);
        nameNodeConf.set("dfs.namenode.http-address", "127.0.0.1:" + nnConf.getHttpPort());
        nameNodeConf.set("dfs.namenode.rpc-address", "127.0.0.1:" + nnConf.getIpcPort());
        nameNodeConf.set("dfs.namenode.servicerpc-address", "127.0.0.1:0");
        if (format) {
            DFSTestUtil.formatNameNode(nameNodeConf);
        }
        if (operation == HdfsServerConstants.StartupOption.UPGRADE) {
            operation.setClusterId(clusterId);
        }
        if (operation == null || operation == HdfsServerConstants.StartupOption.FORMAT || operation == HdfsServerConstants.StartupOption.REGULAR) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] args = stringArray;
        NameNode nn = NameNode.createNameNode((String[])args, (Configuration)nameNodeConf);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        nameNodeConf.set("dfs.namenode.rpc-address", nn.getNameNodeAddressHostPortString());
        if (nn.getHttpAddress() != null) {
            nameNodeConf.set("dfs.namenode.http-address", NetUtils.getHostPortString((InetSocketAddress)nn.getHttpAddress()));
        }
        if (nn.getHttpsAddress() != null) {
            nameNodeConf.set("dfs.namenode.https-address", NetUtils.getHostPortString((InetSocketAddress)nn.getHttpsAddress()));
        }
        this.nameNodes[nnIndex] = new NameNodeInfo(nn, nnConf.getNnId(), nameNodeConf);
    }

    public URI getURI() {
        this.checkSingleNameNode();
        return this.getURI(0);
    }

    public URI getURI(int nnIndex) {
        String hostPort = this.nameNodes[nnIndex].nameNode.getNameNodeAddressHostPortString();
        URI uri = null;
        try {
            uri = new URI("hdfs://" + hostPort);
        }
        catch (URISyntaxException e) {
            NameNode.LOG.warn("unexpected URISyntaxException: " + e);
        }
        return uri;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public Configuration getConfiguration(int nnIndex) {
        return this.nameNodes[nnIndex].conf;
    }

    public void waitNameNodeUp(int nnIndex) throws IOException {
        while (!this.isNameNodeUp(nnIndex)) {
            try {
                LOG.warn((Object)("Waiting for namenode at " + nnIndex + " to start..."));
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitClusterUp() throws IOException {
        int i = 0;
        if (this.numDataNodes > 0) {
            while (!this.isClusterUp()) {
                try {
                    LOG.warn((Object)"Waiting for the Mini HDFS Cluster to start...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++i <= 15) continue;
                throw new IOException("Timed out waiting for Mini HDFS Cluster to start");
            }
        }
    }

    String makeDataNodeDirs(int dnIndex, StorageType[] storageTypes) throws IOException {
        StringBuilder sb = new StringBuilder();
        assert (storageTypes == null || storageTypes.length == this.storagesPerDatanode);
        for (int j = 0; j < this.storagesPerDatanode; ++j) {
            File dir = this.getInstanceStorageDir(dnIndex, j);
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Mkdirs failed to create directory for DataNode " + dir);
            }
            sb.append((j > 0 ? "," : "") + "[" + (storageTypes == null ? StorageType.DEFAULT : storageTypes[j]) + "]" + Util.fileAsURI((File)dir));
        }
        return sb.toString();
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, hosts, simulatedCapacities, false);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, null, manageDfsDirs, operation, racks, hosts, null, simulatedCapacities, setupHostsFile, false, false, null);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        this.startDataNodes(conf, numDataNodes, null, manageDfsDirs, operation, racks, hosts, null, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, false, null);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays) throws IOException {
        int i;
        String[] stringArray;
        int curDatanodesNum;
        assert (storageCapacities == null || simulatedCapacities == null);
        assert (storageTypes == null || storageTypes.length == numDataNodes);
        assert (storageCapacities == null || storageCapacities.length == numDataNodes);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        if (checkDataNodeHostConfig) {
            conf.setIfUnset("dfs.datanode.hostname", "127.0.0.1");
        } else {
            conf.set("dfs.datanode.hostname", "127.0.0.1");
        }
        conf.set("dfs.security-actions.actor-class", "io.hops.security.TestingFsSecurityActions");
        int curDatanodesNumSaved = curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i2 = curDatanodesNum; i2 < curDatanodesNum + numDataNodes; ++i2) {
                hosts[i2 - curDatanodesNum] = "host" + i2 + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (dnConfOverlays != null && numDataNodes > dnConfOverlays.length) {
            throw new IllegalArgumentException("The length of dnConfOverlays [" + dnConfOverlays.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (operation == null || operation != HdfsServerConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        DataNode[] dns = new DataNode[numDataNodes];
        for (i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            HdfsConfiguration dnConf = new HdfsConfiguration(conf);
            if (dnConfOverlays != null) {
                dnConf.addResource(dnConfOverlays[i]);
            }
            this.setupDatanodeAddress((Configuration)dnConf, setupHostsFile, checkDataNodeAddrConfig);
            if (manageDfsDirs) {
                String dirs = this.makeDataNodeDirs(i, storageTypes == null ? null : storageTypes[i - curDatanodesNum]);
                dnConf.set("dfs.datanode.data.dir", dirs);
                conf.set("dfs.datanode.data.dir", dirs);
            }
            if (simulatedCapacities != null) {
                SimulatedFSDataset.setFactory((Configuration)dnConf);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("dfs.datanode.hostname", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("dfs.datanode.hostname")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack((String)name, (String)racks[i - curDatanodesNum]);
            }
            HdfsConfiguration newconf = new HdfsConfiguration((Configuration)dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            SecureDataNodeStarter.SecureResources secureResources = null;
            if (UserGroupInformation.isSecurityEnabled() && conf.get("dfs.data.transfer.protection") == null) {
                try {
                    secureResources = SecureDataNodeStarter.getSecureResources((Configuration)dnConf);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            int maxRetriesOnSasl = conf.getInt("ipc.client.connect.max.retries.on.sasl", 5);
            int numRetries = 0;
            DataNode dn = null;
            while (true) {
                try {
                    dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf, (SecureDataNodeStarter.SecureResources)secureResources);
                }
                catch (IOException e) {
                    if (UserGroupInformation.isSecurityEnabled() && numRetries < maxRetriesOnSasl) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        ++numRetries;
                        continue;
                    }
                    throw e;
                }
                break;
            }
            if (dn == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String service = SecurityUtil.buildTokenService((InetSocketAddress)dn.getXferAddress()).toString();
            if (racks != null) {
                LOG.info((Object)("Adding node with service : " + service + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack((String)service, (String)racks[i - curDatanodesNum]);
            }
            dn.runDatanodeDaemon();
            this.dataNodes.add(new DataNodeProperties(dn, (Configuration)newconf, dnArgs, secureResources, dn.getIpcPort()));
            dns[i - curDatanodesNum] = dn;
        }
        this.numDataNodes += numDataNodes;
        this.waitActive();
        if (storageCapacities != null) {
            for (i = curDatanodesNumSaved; i < curDatanodesNumSaved + numDataNodes; ++i) {
                int index = i - curDatanodesNum;
                List volumes = dns[index].getFSDataset().getVolumes();
                assert (storageCapacities[index].length == this.storagesPerDatanode);
                assert (volumes.size() == this.storagesPerDatanode);
                for (int j = 0; j < volumes.size(); ++j) {
                    FsVolumeImpl volume = (FsVolumeImpl)volumes.get(j);
                    LOG.info((Object)("setCapacityForTesting " + storageCapacities[index][j] + " for [" + volume.getStorageType() + "]" + volume.getStorageID()));
                    volume.setCapacityForTesting(storageCapacities[index][j]);
                }
            }
        }
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null, false);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities, false);
    }

    private void finalizeNamenode(NameNode nn, Configuration conf) throws Exception {
        if (nn == null) {
            throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
        }
        ToolRunner.run((Tool)new DFSAdmin(conf), (String[])new String[]{"-finalizeUpgrade"});
    }

    public void finalizeCluster(int nnIndex, Configuration conf) throws Exception {
        this.finalizeNamenode(this.nameNodes[nnIndex].nameNode, this.nameNodes[nnIndex].conf);
    }

    public void finalizeCluster(Configuration conf) throws Exception {
        for (NameNodeInfo nnInfo : this.nameNodes) {
            if (nnInfo == null) {
                throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
            }
            this.finalizeNamenode(nnInfo.nameNode, nnInfo.conf);
        }
    }

    public int getNumNameNodes() {
        return this.nameNodes.length;
    }

    public NameNode getNameNode() {
        this.checkSingleNameNode();
        return this.getNameNode(0);
    }

    public NamenodeProtocols getNameNodeRpc() {
        this.checkSingleNameNode();
        return this.getNameNodeRpc(0);
    }

    public NamenodeProtocols getNameNodeRpc(int nnIndex) {
        return this.getNameNode(nnIndex).getRpcServer();
    }

    public NameNode getNameNode(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode;
    }

    public FSNamesystem getNamesystem() {
        this.checkSingleNameNode();
        return NameNodeAdapter.getNamesystem(this.nameNodes[0].nameNode);
    }

    public FSNamesystem getNamesystem(int nnIndex) {
        return NameNodeAdapter.getNamesystem(this.nameNodes[nnIndex].nameNode);
    }

    public ArrayList<DataNode> getDataNodes() {
        ArrayList<DataNode> list = new ArrayList<DataNode>();
        for (DataNodeProperties dataNode : this.dataNodes) {
            DataNode node = dataNode.datanode;
            list.add(node);
        }
        return list;
    }

    public DataNode getDataNode(int ipcPort) {
        for (DataNode dn : this.getDataNodes()) {
            if (dn.ipcServer.getListenerAddress().getPort() != ipcPort) continue;
            return dn;
        }
        return null;
    }

    public int getNameNodePort() {
        this.checkSingleNameNode();
        return this.getNameNodePort(0);
    }

    public int getNameNodePort(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode.getNameNodeAddress().getPort();
    }

    public int getNameNodeServicePort(int nnIndex) {
        return this.nameNodes[nnIndex].nameNode.getServiceRpcAddress().getPort();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean deleteDfsDir) {
        this.shutdown(deleteDfsDir, true);
    }

    public void shutdown(boolean deleteDfsDir, boolean closeFileSystem) {
        LOG.info((Object)"Shutting down the Mini HDFS Cluster");
        if (this.checkExitOnShutdown && ExitUtil.terminateCalled()) {
            LOG.fatal((Object)"Test resulted in an unexpected exit", (Throwable)ExitUtil.getFirstExitException());
            ExitUtil.resetFirstExitException();
            throw new AssertionError((Object)"Test resulted in an unexpected exit");
        }
        if (closeFileSystem) {
            for (FileSystem fs : this.fileSystems) {
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Exception while closing file system", (Throwable)ioe);
                }
            }
            this.fileSystems.clear();
        }
        this.shutdownDataNodes();
        for (int i = 0; i < this.nameNodes.length; ++i) {
            NameNode nameNode;
            NameNodeInfo nnInfo = this.nameNodes[i];
            if (nnInfo == null || (nameNode = nnInfo.nameNode) == null) continue;
            this.shutdownNameNode(i);
        }
        UsersGroups.stop();
        if (this.base_dir != null) {
            if (deleteDfsDir) {
                this.base_dir.delete();
            } else {
                this.base_dir.deleteOnExit();
            }
        }
    }

    public void shutdownDataNodes() {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            LOG.info((Object)("Shutting down DataNode " + i));
            DataNode dn = this.dataNodes.remove((int)i).datanode;
            dn.shutdown();
            --this.numDataNodes;
        }
    }

    public synchronized void shutdownNameNodes() {
        for (int i = 0; i < this.nameNodes.length; ++i) {
            this.shutdownNameNode(i);
        }
    }

    public synchronized void shutdownNameNode(int nnIndex) {
        NameNode nn = this.nameNodes[nnIndex].nameNode;
        if (nn != null) {
            LOG.info((Object)"Shutting down the namenode");
            nn.stop();
            nn.join();
            Configuration conf = this.nameNodes[nnIndex].conf;
            this.nameNodes[nnIndex] = new NameNodeInfo(null, null, conf);
        }
    }

    public synchronized void restartNameNodes() throws IOException {
        for (int i = 0; i < this.nameNodes.length; ++i) {
            this.restartNameNode(i, false);
        }
        this.waitClusterUp();
        LOG.info((Object)"Restarted the namenode");
        this.waitActive();
    }

    public synchronized void restartNameNode(String ... args) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, true, true, args);
    }

    public synchronized void restartNameNode(boolean waitActive) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, waitActive, true, new String[0]);
    }

    public synchronized void restartNameNode(boolean waitActive, boolean deleteReplicaTable) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, waitActive, false, new String[0]);
    }

    public synchronized void restartNameNode(int nnIndex) throws IOException {
        this.restartNameNode(nnIndex, true, true, new String[0]);
    }

    public synchronized void restartNameNode(int nnIndex, boolean waitActive) throws IOException {
        this.restartNameNode(nnIndex, waitActive, true, new String[0]);
    }

    public synchronized void restartNameNode(int nnIndex, boolean waitActive, boolean deleteReplicaTable, String ... args) throws IOException {
        String nnId = this.nameNodes[nnIndex].nnId;
        Configuration conf = this.nameNodes[nnIndex].conf;
        this.shutdownNameNode(nnIndex);
        NameNode nn = NameNode.createNameNode((String[])args, (Configuration)conf);
        this.nameNodes[nnIndex] = new NameNodeInfo(nn, nnId, conf);
        if (waitActive) {
            this.waitClusterUp();
            LOG.info((Object)"Restarted the namenode");
            this.waitActive();
        }
    }

    private int corruptBlockOnDataNodesHelper(ExtendedBlock block, boolean deleteBlockFile) throws IOException {
        File[] blockFiles;
        int blocksCorrupted = 0;
        for (File f : blockFiles = this.getAllBlockFiles(block)) {
            if ((!deleteBlockFile || !MiniDFSCluster.corruptBlockByDeletingBlockFile(f)) && (deleteBlockFile || !MiniDFSCluster.corruptBlock(f))) continue;
            ++blocksCorrupted;
        }
        return blocksCorrupted;
    }

    public int corruptBlockOnDataNodes(ExtendedBlock block) throws IOException {
        return this.corruptBlockOnDataNodesHelper(block, false);
    }

    public int corruptBlockOnDataNodesByDeletingBlockFile(ExtendedBlock block) throws IOException {
        return this.corruptBlockOnDataNodesHelper(block, true);
    }

    public String readBlockOnDataNode(int i, ExtendedBlock block) throws IOException {
        assert (i >= 0 && i < this.dataNodes.size()) : "Invalid datanode " + i;
        File blockFile = this.getBlockFile(i, block);
        if (blockFile != null && blockFile.exists()) {
            return DFSTestUtil.readFile(blockFile);
        }
        return null;
    }

    public boolean corruptReplica(int i, ExtendedBlock blk) throws IOException {
        File blockFile = this.getBlockFile(i, blk);
        return MiniDFSCluster.corruptBlock(blockFile);
    }

    public static boolean corruptBlock(File blockFile) throws IOException {
        if (blockFile == null || !blockFile.exists()) {
            return false;
        }
        Random random = new Random();
        RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
        FileChannel channel = raFile.getChannel();
        String badString = "BADBAD";
        int rand = random.nextInt((int)channel.size() / 2);
        raFile.seek(rand);
        raFile.write(badString.getBytes());
        raFile.close();
        LOG.warn((Object)("Corrupting the block " + blockFile));
        return true;
    }

    public static boolean corruptBlockByDeletingBlockFile(File blockFile) throws IOException {
        if (blockFile == null || !blockFile.exists()) {
            return false;
        }
        return blockFile.delete();
    }

    public boolean changeGenStampOfBlock(int dnIndex, ExtendedBlock blk, long newGenStamp) throws IOException {
        File blockFile = this.getBlockFile(dnIndex, blk);
        File metaFile = FsDatasetUtil.findMetaFile((File)blockFile);
        return metaFile.renameTo(new File(DatanodeUtil.getMetaName((String)blockFile.getAbsolutePath(), (long)newGenStamp)));
    }

    public synchronized DataNodeProperties stopDataNode(int i) {
        if (i < 0 || i >= this.dataNodes.size()) {
            return null;
        }
        DataNodeProperties dnprop = this.dataNodes.remove(i);
        DataNode dn = dnprop.datanode;
        LOG.info((Object)("MiniDFSCluster Stopping DataNode " + dn.getDisplayName() + " from a total of " + (this.dataNodes.size() + 1) + " datanodes."));
        dn.shutdown();
        --this.numDataNodes;
        return dnprop;
    }

    public synchronized DataNodeProperties stopDataNode(String dnName) {
        int node = -1;
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode dn = this.dataNodes.get((int)i).datanode;
            LOG.info((Object)("DN name=" + dnName + " found DN=" + dn + " with name=" + dn.getDisplayName()));
            if (!dnName.equals(dn.getDatanodeId().getXferAddr())) continue;
            node = i;
            break;
        }
        return this.stopDataNode(node);
    }

    public boolean restartDataNode(DataNodeProperties dnprop) throws IOException {
        return this.restartDataNode(dnprop, false);
    }

    public synchronized boolean restartDataNode(DataNodeProperties dnprop, boolean keepPort) throws IOException {
        Configuration conf = dnprop.conf;
        String[] args = dnprop.dnArgs;
        SecureDataNodeStarter.SecureResources secureResources = dnprop.secureResources;
        HdfsConfiguration newconf = new HdfsConfiguration(conf);
        if (keepPort) {
            InetSocketAddress addr = dnprop.datanode.getXferAddress();
            conf.set("dfs.datanode.address", addr.getAddress().getHostAddress() + ":" + addr.getPort());
            conf.set("dfs.datanode.ipc.address", addr.getAddress().getHostAddress() + ":" + dnprop.ipcPort);
        }
        DataNode newDn = DataNode.createDataNode((String[])args, (Configuration)conf, (SecureDataNodeStarter.SecureResources)secureResources);
        this.dataNodes.add(new DataNodeProperties(newDn, (Configuration)newconf, args, secureResources, newDn.getIpcPort()));
        ++this.numDataNodes;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MiniDFSCluster.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public boolean restartDataNode(int i) throws IOException {
        return this.restartDataNode(i, false);
    }

    public synchronized boolean restartDataNode(int i, boolean keepPort) throws IOException {
        return this.restartDataNode(i, keepPort, false);
    }

    public synchronized boolean restartDataNode(int idn, boolean keepPort, boolean expireOnNN) throws IOException {
        DataNodeProperties dnprop = this.stopDataNode(idn);
        if (expireOnNN) {
            this.setDataNodeDead(dnprop.datanode.getDatanodeId());
        }
        if (dnprop == null) {
            return false;
        }
        return this.restartDataNode(dnprop, keepPort);
    }

    public void setDataNodeDead(DatanodeID dnId) throws IOException {
        DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(this.getNamesystem(), dnId);
        DFSTestUtil.setDatanodeDead((DatanodeInfo)dnd);
        BlockManagerTestUtil.checkHeartbeat(this.getNamesystem().getBlockManager());
    }

    public void setDataNodesDead() throws IOException {
        for (DataNodeProperties dnp : this.dataNodes) {
            this.setDataNodeDead(dnp.datanode.getDatanodeId());
        }
    }

    public synchronized boolean restartDataNodes(boolean keepPort) throws IOException {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            if (!this.restartDataNode(i, keepPort)) {
                return false;
            }
            LOG.info((Object)("Restarted DataNode " + i));
        }
        return true;
    }

    public boolean restartDataNodes() throws IOException {
        return this.restartDataNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameNodeUp(int nnIndex) throws IOException {
        NameNode nameNode = this.nameNodes[nnIndex].nameNode;
        if (nameNode == null) {
            return false;
        }
        long[] sizes = NameNodeAdapter.getStats(nameNode.getNamesystem());
        boolean isUp = false;
        MiniDFSCluster miniDFSCluster = this;
        synchronized (miniDFSCluster) {
            isUp = (!nameNode.isInSafeMode() || !this.waitSafeMode) && sizes[0] != 0L;
        }
        return isUp;
    }

    public boolean isClusterUp() throws IOException {
        for (int index = 0; index < this.nameNodes.length; ++index) {
            if (this.isNameNodeUp(index)) continue;
            return false;
        }
        return true;
    }

    public boolean isDataNodeUp() {
        if (this.dataNodes == null || this.dataNodes.size() == 0) {
            return false;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (!dn.datanode.isDatanodeUp()) continue;
            return true;
        }
        return false;
    }

    public DistributedFileSystem getFileSystem() throws IOException {
        this.checkSingleNameNode();
        return this.getFileSystem(0);
    }

    public DistributedFileSystem getFileSystem(int nnIndex) throws IOException {
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((URI)this.getURI(nnIndex), (Configuration)this.nameNodes[nnIndex].conf);
        this.fileSystems.add((FileSystem)dfs);
        return dfs;
    }

    public FileSystem getNewFileSystemInstance(int nnIndex) throws IOException {
        FileSystem dfs = FileSystem.newInstance((URI)this.getURI(nnIndex), (Configuration)this.nameNodes[nnIndex].conf);
        this.fileSystems.add(dfs);
        return dfs;
    }

    public String getHttpUri(int nnIndex) {
        return "http://" + this.nameNodes[nnIndex].conf.get("dfs.namenode.http-address");
    }

    public void triggerBlockReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(dn);
        }
    }

    public void triggerDeletionReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerDeletionReport(dn);
        }
    }

    public void triggerHeartbeats() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerHeartbeat(dn);
        }
    }

    public void waitActive(int nnIndex) throws IOException {
        if (this.nameNodes.length == 0 || this.nameNodes[nnIndex] == null || this.nameNodes[nnIndex].nameNode == null) {
            return;
        }
        InetSocketAddress addr = this.nameNodes[nnIndex].nameNode.getServiceRpcAddress();
        assert (addr.getPort() != 0);
        DFSClient client = new DFSClient(addr, this.conf);
        while (this.shouldWait(client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE), addr)) {
            try {
                LOG.info((Object)"Waiting for cluster to become active");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        client.close();
    }

    public void waitActive() throws IOException {
        block2: for (int index = 0; index < this.nameNodes.length; ++index) {
            int failedCount = 0;
            while (true) {
                try {
                    this.waitActive(index);
                    continue block2;
                }
                catch (IOException e) {
                    if (++failedCount <= 1) continue;
                    LOG.warn((Object)("Tried waitActive() " + failedCount + " time(s) and failed, giving up.  " + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                break;
            }
        }
        LOG.info((Object)"Cluster is active");
    }

    private synchronized boolean shouldWait(DatanodeInfo[] dnInfo, InetSocketAddress addr) {
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isConnectedToNN(addr)) continue;
            LOG.warn((Object)("BPOfferService in datanode " + dn.datanode + " failed to connect to namenode at " + addr));
            return false;
        }
        if (dnInfo.length != this.numDataNodes) {
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isDatanodeFullyStarted()) continue;
            return true;
        }
        for (DatanodeInfo dn : dnInfo) {
            if (dn.getCapacity() != 0L && dn.getLastUpdate() > 0L) continue;
            LOG.info((Object)("No heartbeat from DataNode: " + dn.toString()));
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (DataNodeTestUtils.getFSDataset(dn.datanode) != null) continue;
            return true;
        }
        return false;
    }

    public void formatDataNodeDirs() throws IOException {
        this.base_dir = new File(this.determineDfsBaseDir());
        this.data_dir = new File(this.base_dir, "data");
        if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
            throw new IOException("Cannot remove data directory: " + this.data_dir);
        }
    }

    public Map<DatanodeStorage, BlockReport> getBlockReport(String bpid, int dataNodeIndex) {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        return DataNodeTestUtils.getFSDataset(dn).getBlockReports(bpid);
    }

    public List<Map<DatanodeStorage, BlockReport>> getAllBlockReports(String bpid) {
        int numDataNodes = this.dataNodes.size();
        ArrayList<Map<DatanodeStorage, BlockReport>> result = new ArrayList<Map<DatanodeStorage, BlockReport>>(numDataNodes);
        for (int i = 0; i < numDataNodes; ++i) {
            result.add(this.getBlockReport(bpid, i));
        }
        return result;
    }

    public void injectBlocks(int dataNodeIndex, Iterable<Block> blocksToInject, String bpid) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimilatedFSDataset");
        }
        if (bpid == null) {
            bpid = this.getNamesystem().getBlockPoolId();
        }
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void injectBlocks(int nameNodeIndex, int dataNodeIndex, Iterable<Block> blocksToInject) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimilatedFSDataset");
        }
        String bpid = this.getNamesystem(nameNodeIndex).getBlockPoolId();
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void setLeasePeriod(long soft, long hard) {
        NameNodeAdapter.setLeasePeriod(this.getNamesystem(), soft, hard);
    }

    public void setLeasePeriod(long soft, long hard, int nnIndex) {
        NameNodeAdapter.setLeasePeriod(this.getNamesystem(nnIndex), soft, hard);
    }

    public void setWaitSafeMode(boolean wait) {
        this.waitSafeMode = wait;
    }

    DataNode[] listDataNodes() {
        DataNode[] list = new DataNode[this.dataNodes.size()];
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            list[i] = this.dataNodes.get((int)i).datanode;
        }
        return list;
    }

    public String getDataDirectory() {
        return this.data_dir.getAbsolutePath();
    }

    protected String determineDfsBaseDir() {
        String dfsdir;
        if (this.conf != null && (dfsdir = this.conf.get(HDFS_MINIDFS_BASEDIR, null)) != null) {
            return dfsdir;
        }
        return MiniDFSCluster.getBaseDirectory();
    }

    public static String getBaseDirectory() {
        return System.getProperty(PROP_TEST_BUILD_DATA, "build/test/data") + "/dfs/";
    }

    public File getInstanceStorageDir(int dnIndex, int dirIndex) {
        return new File(this.base_dir, this.getStorageDirPath(dnIndex, dirIndex));
    }

    public ArrayList<File> getAllInstanceStorageDirs() {
        ArrayList<File> dirs = new ArrayList<File>();
        for (int dirId = 0; dirId < this.numDataNodes; ++dirId) {
            for (int storageId = 0; storageId < this.storagesPerDatanode; ++storageId) {
                dirs.add(this.getInstanceStorageDir(dirId, storageId));
            }
        }
        return dirs;
    }

    public File getStorageDir(int dnIndex, int dirIndex) {
        return new File(MiniDFSCluster.getBaseDirectory(), this.getStorageDirPath(dnIndex, dirIndex));
    }

    private String getStorageDirPath(int dnIndex, int dirIndex) {
        return "data/data_" + dnIndex + "_" + dirIndex;
    }

    public static String getDNCurrentDir(File storageDir) {
        return storageDir + "/" + "current" + "/";
    }

    public static String getBPDir(File storageDir, String bpid) {
        return MiniDFSCluster.getDNCurrentDir(storageDir) + bpid + "/";
    }

    public static String getBPDir(File storageDir, String bpid, String dirName) {
        return MiniDFSCluster.getBPDir(storageDir, bpid) + dirName + "/";
    }

    public static File getRbwDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "rbw");
    }

    public static File getFinalizedDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "finalized");
    }

    public static File getBlockFile(File storageDir, ExtendedBlock blk) {
        return new File(DatanodeUtil.idToBlockDir((File)MiniDFSCluster.getFinalizedDir(storageDir, blk.getBlockPoolId()), (long)blk.getBlockId()), blk.getBlockName());
    }

    public static File getBlockMetadataFile(File storageDir, ExtendedBlock blk) {
        return new File(DatanodeUtil.idToBlockDir((File)MiniDFSCluster.getFinalizedDir(storageDir, blk.getBlockPoolId()), (long)blk.getBlockId()), blk.getBlockName() + "_" + blk.getGenerationStamp() + ".meta");
    }

    public static List<File> getAllBlockMetadataFiles(File storageDir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = storageDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            List<File> subdirResults;
            if (f.getName().startsWith("blk_") && f.getName().endsWith(".meta")) {
                results.add(f);
                continue;
            }
            if (!f.isDirectory() || (subdirResults = MiniDFSCluster.getAllBlockMetadataFiles(f)) == null) continue;
            results.addAll(subdirResults);
        }
        return results;
    }

    public static void shutdownCluster(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public File[] getAllBlockFiles(ExtendedBlock block) {
        if (this.dataNodes.size() == 0) {
            return new File[0];
        }
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            File blockFile = this.getBlockFile(i, block);
            if (blockFile == null) continue;
            list.add(blockFile);
        }
        return list.toArray(new File[list.size()]);
    }

    public File getBlockFile(int dnIndex, ExtendedBlock block) {
        for (int i = 0; i <= 1; ++i) {
            File storageDir = this.getStorageDir(dnIndex, i);
            File blockFile = MiniDFSCluster.getBlockFile(storageDir, block);
            if (!blockFile.exists()) continue;
            return blockFile;
        }
        return null;
    }

    public File getBlockMetadataFile(int dnIndex, ExtendedBlock block) {
        for (int i = 0; i <= 1; ++i) {
            File storageDir = this.getStorageDir(dnIndex, i);
            File blockMetaFile = MiniDFSCluster.getBlockMetadataFile(storageDir, block);
            if (!blockMetaFile.exists()) continue;
            return blockMetaFile;
        }
        return null;
    }

    private void checkSingleNameNode() {
        if (this.nameNodes.length != 1) {
            throw new IllegalArgumentException("Namenode index is needed");
        }
    }

    protected void setupDatanodeAddress(Configuration conf, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        if (setupHostsFile) {
            String hostsFile = conf.get("dfs.hosts", "").trim();
            if (hostsFile.length() == 0) {
                throw new IOException("Parameter dfs.hosts is not setup in conf");
            }
            String address = "127.0.0.1:" + NetUtils.getFreeSocketPort();
            if (checkDataNodeAddrConfig) {
                conf.setIfUnset("dfs.datanode.address", address);
            } else {
                conf.set("dfs.datanode.address", address);
            }
            this.addToFile(hostsFile, address);
            LOG.info((Object)("Adding datanode " + address + " to hosts file " + hostsFile));
        } else if (checkDataNodeAddrConfig) {
            conf.setIfUnset("dfs.datanode.address", "127.0.0.1:0");
        } else {
            conf.set("dfs.datanode.address", "127.0.0.1:0");
        }
        if (checkDataNodeAddrConfig) {
            conf.setIfUnset("dfs.datanode.http.address", "127.0.0.1:0");
            conf.setIfUnset("dfs.datanode.ipc.address", "127.0.0.1:0");
        } else {
            conf.set("dfs.datanode.http.address", "127.0.0.1:0");
            conf.set("dfs.datanode.ipc.address", "127.0.0.1:0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFile(String p, String address) throws IOException {
        File f = new File(p);
        f.createNewFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(f, true));){
            writer.println(address);
        }
    }

    public List<DataNodeProperties> getDataNodeProperties() {
        return this.dataNodes;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        instanceCount = 0;
    }

    static class NameNodeInfo {
        final NameNode nameNode;
        final Configuration conf;
        final String nnId;

        NameNodeInfo(NameNode nn, String nnId, Configuration conf) {
            this.nameNode = nn;
            this.nnId = nnId;
            this.conf = conf;
        }
    }

    public class DataNodeProperties {
        final DataNode datanode;
        final Configuration conf;
        String[] dnArgs;
        final SecureDataNodeStarter.SecureResources secureResources;
        final int ipcPort;

        DataNodeProperties(DataNode node, Configuration conf, String[] args, SecureDataNodeStarter.SecureResources secureResources, int ipcPort) {
            this.datanode = node;
            this.conf = conf;
            this.dnArgs = args;
            this.secureResources = secureResources;
            this.ipcPort = ipcPort;
        }

        public void setDnArgs(String ... args) {
            this.dnArgs = args;
        }
    }

    public static class Builder {
        private int nameNodePort = 0;
        private int nameNodeHttpPort = 0;
        private final Configuration conf;
        private int numDataNodes = 1;
        private StorageType[][] storageTypes = null;
        private StorageType[] storageTypes1D = null;
        private int storagesPerDatanode = 2;
        private boolean format = true;
        private boolean manageNameDfsDirs = true;
        private boolean manageNameDfsSharedDirs = true;
        private boolean enableManagedDfsDirsRedundancy = true;
        private boolean manageDataDfsDirs = true;
        private HdfsServerConstants.StartupOption option = null;
        private HdfsServerConstants.StartupOption dnOption = null;
        private String[] racks = null;
        private String[] hosts = null;
        private long[] simulatedCapacities = null;
        private long[][] storageCapacities = null;
        private long[] storageCapacities1D = null;
        private String clusterId = null;
        private boolean waitSafeMode = true;
        private boolean setupHostsFile = false;
        private MiniDFSNNTopology nnTopology = null;
        private boolean checkExitOnShutdown = true;
        private boolean checkDataNodeAddrConfig = false;
        private boolean checkDataNodeHostConfig = false;
        private Configuration[] dnConfOverlays;
        private boolean skipFsyncForTesting = true;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder nameNodePort(int val) {
            this.nameNodePort = val;
            return this;
        }

        public Builder nameNodeHttpPort(int val) {
            this.nameNodeHttpPort = val;
            return this;
        }

        public Builder numDataNodes(int val) {
            this.numDataNodes = val;
            return this;
        }

        public Builder storagesPerDatanode(int numStorages) {
            this.storagesPerDatanode = numStorages;
            return this;
        }

        public Builder storageTypes(StorageType[] types) {
            this.storageTypes1D = types;
            return this;
        }

        public Builder storageTypes(StorageType[][] types) {
            this.storageTypes = types;
            return this;
        }

        public Builder storageCapacities(long[] capacities) {
            this.storageCapacities1D = capacities;
            return this;
        }

        public Builder storageCapacities(long[][] capacities) {
            this.storageCapacities = capacities;
            return this;
        }

        public Builder format(boolean val) {
            this.format = val;
            return this;
        }

        public Builder manageNameDfsDirs(boolean val) {
            this.manageNameDfsDirs = val;
            return this;
        }

        public Builder manageNameDfsSharedDirs(boolean val) {
            this.manageNameDfsSharedDirs = val;
            return this;
        }

        public Builder enableManagedDfsDirsRedundancy(boolean val) {
            this.enableManagedDfsDirsRedundancy = val;
            return this;
        }

        public Builder manageDataDfsDirs(boolean val) {
            this.manageDataDfsDirs = val;
            return this;
        }

        public Builder startupOption(HdfsServerConstants.StartupOption val) {
            this.option = val;
            return this;
        }

        public Builder dnStartupOption(HdfsServerConstants.StartupOption val) {
            this.dnOption = val;
            return this;
        }

        public Builder racks(String[] val) {
            this.racks = val;
            return this;
        }

        public Builder hosts(String[] val) {
            this.hosts = val;
            return this;
        }

        public Builder simulatedCapacities(long[] val) {
            this.simulatedCapacities = val;
            return this;
        }

        public Builder waitSafeMode(boolean val) {
            this.waitSafeMode = val;
            return this;
        }

        public Builder checkExitOnShutdown(boolean val) {
            this.checkExitOnShutdown = val;
            return this;
        }

        public Builder checkDataNodeAddrConfig(boolean val) {
            this.checkDataNodeAddrConfig = val;
            return this;
        }

        public Builder checkDataNodeHostConfig(boolean val) {
            this.checkDataNodeHostConfig = val;
            return this;
        }

        public Builder clusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setupHostsFile(boolean val) {
            this.setupHostsFile = val;
            return this;
        }

        public Builder nnTopology(MiniDFSNNTopology topology) {
            this.nnTopology = topology;
            return this;
        }

        public Builder dataNodeConfOverlays(Configuration[] dnConfOverlays) {
            this.dnConfOverlays = dnConfOverlays;
            return this;
        }

        public Builder skipFsyncForTesting(boolean val) {
            this.skipFsyncForTesting = val;
            return this;
        }

        public MiniDFSCluster build() throws IOException {
            return new MiniDFSCluster(this);
        }

        static /* synthetic */ StorageType[][] access$302(Builder x0, StorageType[][] x1) {
            x0.storageTypes = x1;
            return x1;
        }

        static /* synthetic */ long[][] access$702(Builder x0, long[][] x1) {
            x0.storageCapacities = x1;
            return x1;
        }
    }
}

