/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFileAppendRestart {
    private static final int BLOCK_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndAppend(FileSystem fs, Path p, int lengthForCreate, int lengthForAppend) throws IOException {
        FSDataOutputStream stream = fs.create(p, true, 4096, (short)1, 4096L);
        try {
            AppendTestUtil.write((OutputStream)stream, 0, lengthForCreate);
            stream.close();
            stream = fs.append(p);
            AppendTestUtil.write((OutputStream)stream, lengthForCreate, lengthForAppend);
            stream.close();
        }
        finally {
            IOUtils.closeStream((Closeable)stream);
        }
        int totalLength = lengthForCreate + lengthForAppend;
        Assert.assertEquals((long)totalLength, (long)fs.getFileStatus(p).getLen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendRestart() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        Closeable stream = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p1 = new Path("/block-boundaries");
            this.writeAndAppend((FileSystem)fs, p1, 4096, 4096);
            Path p2 = new Path("/not-block-boundaries");
            this.writeAndAppend((FileSystem)fs, p2, 2048, 4096);
            cluster.restartNameNode(new String[0]);
            AppendTestUtil.check((FileSystem)fs, p1, 8192L);
            AppendTestUtil.check((FileSystem)fs, p2, 6144L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeStream(stream);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithPipelineRecovery() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSDataOutputStream out = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(true).manageNameDfsDirs(true).numDataNodes(4).racks(new String[]{"/rack1", "/rack1", "/rack2", "/rack2"}).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test1");
            out = fs.create(path, true, 4096, (short)3, 4096L);
            AppendTestUtil.write((OutputStream)out, 0, 1024);
            out.close();
            cluster.stopDataNode(3);
            out = fs.append(path);
            AppendTestUtil.write((OutputStream)out, 1024, 1024);
            out.close();
            cluster.restartNameNode(true);
            AppendTestUtil.check((FileSystem)fs, path, 2048L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            if (null != cluster) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
        if (null != cluster) {
            cluster.shutdown();
        }
    }
}

