/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.common.IDsGenerator;
import io.hops.common.IDsGeneratorFactory;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestInodeIDgeneration {
    private static final Log LOG = LogFactory.getLog(TestInodeIDgeneration.class);

    public TestInodeIDgeneration() {
        Logger.getRootLogger().setLevel(Level.WARN);
        Logger.getLogger(TestInodeIDgeneration.class).setLevel(Level.INFO);
        Logger.getLogger(IDsGenerator.class).setLevel(Level.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameUnderReplicatedFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.inodeid.batchsize", 10L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            for (int i = 0; i < 100; ++i) {
                LOG.info((Object)("InodeID: " + IDsGeneratorFactory.getInstance().getUniqueINodeID()));
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

