/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaseRecovery3 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileOverwrite() throws Exception {
        Logger.getRootLogger().setLevel(Level.INFO);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem newdfs = cluster.getFileSystem();
        try {
            FSDataOutputStream fSDataOutputStream;
            Path file;
            int i;
            newdfs.mkdirs(new Path("/dir"));
            for (i = 0; i < 3; ++i) {
                file = new Path("/dir/file" + i);
                fSDataOutputStream = newdfs.create(file, (short)1);
            }
            newdfs.getClient().getLeaseRenewer().interruptAndJoin();
            newdfs.getClient().abort();
            newdfs.close();
            newdfs = (DistributedFileSystem)FileSystem.newInstance((URI)cluster.getURI(), (Configuration)conf);
            for (i = 0; i < 3; ++i) {
                file = new Path("/dir/file" + i);
                fSDataOutputStream = newdfs.create(file, (short)1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileOverwriteSimple() throws Exception {
        Logger.getRootLogger().setLevel(Level.INFO);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem newdfs = cluster.getFileSystem();
        try {
            Path file;
            int i;
            newdfs.mkdirs(new Path("/dir"));
            for (i = 0; i < 3; ++i) {
                file = new Path("/dir/file" + i);
                FSDataOutputStream fSDataOutputStream = newdfs.create(file, (short)1);
            }
            newdfs.getClient().getLeaseRenewer().interruptAndJoin();
            newdfs.getClient().abort();
            newdfs.close();
            newdfs = (DistributedFileSystem)FileSystem.newInstance((URI)cluster.getURI(), (Configuration)conf);
            for (i = 0; i < 3; ++i) {
                file = new Path("/dir/file" + i);
                FSDataOutputStream out = newdfs.create(file, (short)1);
                out.close();
            }
            newdfs.getClient().getLeaseRenewer().interruptAndJoin();
            newdfs.getClient().abort();
            newdfs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseRecoveryWithRenameOp() throws Exception {
        Logger.getRootLogger().setLevel(Level.INFO);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        long SHORT_LEASE_PERIOD = 1000L;
        long LONG_LEASE_PERIOD = 1800L * SHORT_LEASE_PERIOD;
        cluster.setLeasePeriod(LONG_LEASE_PERIOD, SHORT_LEASE_PERIOD);
        DistributedFileSystem newdfs = (DistributedFileSystem)cluster.getNewFileSystemInstance(0);
        try {
            newdfs.mkdirs(new Path("/dir1"));
            ArrayList<FSDataOutputStream> outs1 = new ArrayList<FSDataOutputStream>();
            for (int i = 0; i < 3; ++i) {
                Path file = new Path("/dir1/file" + i);
                FSDataOutputStream out = newdfs.create(file, (short)1);
                outs1.add(out);
            }
            newdfs.mkdirs(new Path("/dir11"));
            DistributedFileSystem newdfs2 = (DistributedFileSystem)cluster.getNewFileSystemInstance(0);
            ArrayList<FSDataOutputStream> outs2 = new ArrayList<FSDataOutputStream>();
            for (int i = 0; i < 4; ++i) {
                Path file = new Path("/dir11/file" + i);
                FSDataOutputStream out = newdfs2.create(file, (short)1);
                outs2.add(out);
            }
            newdfs2.rename(new Path("/dir1"), new Path("/dir111"));
            newdfs.getClient().getLeaseRenewer().interruptAndJoin();
            newdfs.getClient().abort();
            newdfs.close();
            newdfs2.getClient().getLeaseRenewer().interruptAndJoin();
            newdfs2.getClient().abort();
            newdfs2.close();
            Thread.sleep(10000L);
            TestLeaseRecovery3.checkOpenFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            cluster.shutdown();
        }
    }

    public static int checkOpenFiles() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                List inodes = ida.allINodes();
                if (inodes != null && !inodes.isEmpty()) {
                    for (INode inode : inodes) {
                        if (!inode.isUnderConstruction()) continue;
                        throw new IllegalStateException("INode id: " + inode.getId() + " is not closed.");
                    }
                }
                return count;
            }
        };
        return (Integer)subTreeLockChecker.handle();
    }
}

