/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParallelLocalRead
extends TestParallelReadUtil {
    private static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void setupCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        sockDir = new TemporarySocketDirectory();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestParallelLocalRead.%d.sock").getAbsolutePath());
        conf.setBoolean(DFSConfigKeys.DFS_CLIENT_READ_SHORTCIRCUIT_KEY, true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.block.local-path-access.user", UserGroupInformation.getCurrentUser().getShortUserName());
        DomainSocket.disableBindPathValidation();
        TestParallelLocalRead.setupCluster(1, conf);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        TestParallelReadUtil.teardownCluster();
        sockDir.close();
    }

    @Override
    @Test
    public void testParallelReadCopying() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.CopyingReadWorkerHelper());
    }

    @Override
    @Test
    public void testParallelReadByteBuffer() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.DirectReadWorkerHelper());
    }

    @Override
    @Test
    public void testParallelReadMixed() throws IOException {
        this.runTestWorkload(new TestParallelReadUtil.MixedWorkloadHelper());
    }
}

