/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestBalancer {
    private static final Log LOG = LogFactory.getLog(TestBalancer.class);
    static final long CAPACITY = 5000L;
    static final String RACK0 = "/rack0";
    static final String RACK1 = "/rack1";
    static final String RACK2 = "/rack2";
    private static final String fileName = "/tmp.txt";
    static final Path filePath;
    private MiniDFSCluster cluster;
    ClientProtocol client;
    static final long TIMEOUT = 40000L;
    static final double CAPACITY_ALLOWED_VARIANCE = 0.005;
    static final double BALANCE_ALLOWED_VARIANCE = 0.11;
    static final int DEFAULT_BLOCK_SIZE = 100;
    private static final Random r;

    public static void initTestSetup() {
        Dispatcher.setBlockMoveWaitTime((long)1000L);
        NameNodeConnector.setWrite2IdFile((boolean)false);
    }

    static void initConf(Configuration conf) {
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.replication.interval", 1L);
        SimulatedFSDataset.setFactory(conf);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
    }

    static void createFile(MiniDFSCluster cluster, Path filePath, long fileLen, short replicationFactor, int nnIndex) throws IOException, InterruptedException, TimeoutException {
        DistributedFileSystem fs = cluster.getFileSystem(nnIndex);
        DFSTestUtil.createFile((FileSystem)fs, filePath, fileLen, replicationFactor, r.nextLong());
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, replicationFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedBlock[] generateBlocks(Configuration conf, long size, short numNodes) throws IOException, InterruptedException, TimeoutException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numNodes).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            short replicationFactor = (short)(numNodes - 1);
            long fileLen = size / (long)replicationFactor;
            TestBalancer.createFile(this.cluster, filePath, fileLen, replicationFactor, 0);
            List locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            int numOfBlocks = locatedBlocks.size();
            ExtendedBlock[] blocks = new ExtendedBlock[numOfBlocks];
            for (int i = 0; i < numOfBlocks; ++i) {
                ExtendedBlock b = ((LocatedBlock)locatedBlocks.get(i)).getBlock();
                blocks[i] = new ExtendedBlock(b.getBlockPoolId(), b.getBlockId(), b.getNumBytes(), b.getGenerationStamp());
            }
            ExtendedBlock[] extendedBlockArray = blocks;
            return extendedBlockArray;
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    static Block[][] distributeBlocks(ExtendedBlock[] blocks, short replicationFactor, long[] distribution) {
        void var6_9;
        long[] usedSpace = new long[distribution.length];
        System.arraycopy(distribution, 0, usedSpace, 0, distribution.length);
        ArrayList blockReports = new ArrayList(usedSpace.length);
        Block[][] results = new Block[usedSpace.length][];
        for (long anUsedSpace : usedSpace) {
            blockReports.add(new ArrayList());
        }
        for (ExtendedBlock block : blocks) {
            for (int j = 0; j < replicationFactor; ++j) {
                boolean notChosen = true;
                while (notChosen) {
                    int chosenIndex = r.nextInt(usedSpace.length);
                    if (usedSpace[chosenIndex] <= 0L) continue;
                    notChosen = false;
                    ((List)blockReports.get(chosenIndex)).add(block.getLocalBlock());
                    int n = chosenIndex;
                    usedSpace[n] = usedSpace[n] - block.getNumBytes();
                }
            }
        }
        boolean bl = false;
        while (var6_9 < usedSpace.length) {
            List nodeBlockList = (List)blockReports.get((int)var6_9);
            results[var6_9] = nodeBlockList.toArray(new Block[nodeBlockList.size()]);
            ++var6_9;
        }
        return results;
    }

    static long sum(long[] x) {
        long s = 0L;
        for (long a : x) {
            s += a;
        }
        return s;
    }

    private void testUnevenDistribution(Configuration conf, long[] distribution, long[] capacities, String[] racks) throws Exception {
        int numDatanodes = distribution.length;
        if (capacities.length != numDatanodes || racks.length != numDatanodes) {
            throw new IllegalArgumentException("Array length is not the same");
        }
        long totalUsedSpace = TestBalancer.sum(distribution);
        ExtendedBlock[] blocks = this.generateBlocks(conf, totalUsedSpace, (short)numDatanodes);
        Block[][] blocksDN = TestBalancer.distributeBlocks(blocks, (short)(numDatanodes - 1), distribution);
        conf.set("dfs.namenode.safemode.threshold-pct", "0.0f");
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDatanodes).format(false).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        for (int i = 0; i < blocksDN.length; ++i) {
            this.cluster.injectBlocks(i, Arrays.asList(blocksDN[i]), null);
        }
        Thread.sleep(10000L);
        long totalCapacity = TestBalancer.sum(capacities);
        this.runBalancer(conf, totalUsedSpace, totalCapacity);
        this.cluster.shutdown();
    }

    static void waitForHeartBeat(long expectedUsedSpace, long expectedTotalSpace, ClientProtocol client, MiniDFSCluster cluster) throws IOException, TimeoutException {
        long timeout = 40000L;
        long failtime = timeout <= 0L ? Long.MAX_VALUE : Time.monotonicNow() + timeout;
        while (true) {
            long[] status = client.getStats();
            double totalSpaceVariance = Math.abs((double)status[0] - (double)expectedTotalSpace) / (double)expectedTotalSpace;
            double usedSpaceVariance = Math.abs((double)status[1] - (double)expectedUsedSpace) / (double)expectedUsedSpace;
            if (totalSpaceVariance < 0.005 && usedSpaceVariance < 0.005) break;
            if (Time.monotonicNow() > failtime) {
                throw new TimeoutException("Cluster failed to reached expected values of totalSpace (current: " + status[0] + ", expected: " + expectedTotalSpace + "), or usedSpace (current: " + status[1] + ", expected: " + expectedUsedSpace + "), in more than " + timeout + " msec.");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void waitForBalancer(long totalUsedSpace, long totalCapacity, ClientProtocol client, MiniDFSCluster cluster, Balancer.Parameters p) throws IOException, TimeoutException {
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, client, cluster, p, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testBalancerWithPinnedBlocks() throws Exception {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        conf.setBoolean("dfs.datanode.block-pinning.enabled", true);
        long[] capacities = new long[]{5000L, 5000L};
        String[] racks = new String[]{RACK0, RACK1};
        int numOfDatanodes = capacities.length;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(capacities.length).hosts(new String[]{"localhost", "localhost"}).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 8L / 10L;
            InetSocketAddress[] favoredNodes = new InetSocketAddress[numOfDatanodes];
            for (int i = 0; i < favoredNodes.length; ++i) {
                favoredNodes[i] = this.cluster.getDataNodes().get(i).getXferAddress();
            }
            DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(0), filePath, 1024, totalUsedSpace / (long)numOfDatanodes, 100L, (short)numOfDatanodes, 0L, false, favoredNodes);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{RACK2}, new long[]{5000L});
            TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity += 5000L, this.client, this.cluster);
            List namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
            int r = Balancer.run((Collection)namenodes, (Balancer.Parameters)Balancer.Parameters.DEFAULT, (Configuration)conf);
            Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    static void waitForBalancer(long totalUsedSpace, long totalCapacity, ClientProtocol client, MiniDFSCluster cluster, Balancer.Parameters p, int expectedExcludedNodes) throws IOException, TimeoutException {
        boolean balanced;
        long failtime;
        long timeout = 40000L;
        long l = failtime = timeout <= 0L ? Long.MAX_VALUE : Time.monotonicNow() + timeout;
        if (!p.nodesToBeIncluded.isEmpty()) {
            totalCapacity = (long)p.nodesToBeIncluded.size() * 5000L;
        }
        if (!p.nodesToBeExcluded.isEmpty()) {
            totalCapacity -= (long)p.nodesToBeExcluded.size() * 5000L;
        }
        double avgUtilization = (double)totalUsedSpace / (double)totalCapacity;
        do {
            DatanodeInfo[] datanodeReport = client.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            Assert.assertEquals((long)datanodeReport.length, (long)cluster.getDataNodes().size());
            balanced = true;
            int actualExcludedNodeCount = 0;
            for (DatanodeInfo datanode : datanodeReport) {
                double nodeUtilization = (double)datanode.getDfsUsed() / (double)datanode.getCapacity();
                if (Dispatcher.Util.isExcluded((Set)p.nodesToBeExcluded, (DatanodeInfo)datanode)) {
                    Assert.assertTrue((nodeUtilization == 0.0 ? 1 : 0) != 0);
                    ++actualExcludedNodeCount;
                    continue;
                }
                if (!Dispatcher.Util.isIncluded((Set)p.nodesToBeIncluded, (DatanodeInfo)datanode)) {
                    Assert.assertTrue((nodeUtilization == 0.0 ? 1 : 0) != 0);
                    ++actualExcludedNodeCount;
                    continue;
                }
                if (!(Math.abs(avgUtilization - nodeUtilization) > 0.11)) continue;
                balanced = false;
                if (Time.monotonicNow() > failtime) {
                    throw new TimeoutException("Rebalancing expected avg utilization to become " + avgUtilization + ", but on datanode " + datanode + " it remains at " + nodeUtilization + " after more than " + 40000L + " msec.");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            Assert.assertEquals((long)expectedExcludedNodes, (long)actualExcludedNodeCount);
        } while (!balanced);
    }

    String long2String(long[] array) {
        if (array.length == 0) {
            return "<empty>";
        }
        StringBuilder b = new StringBuilder("[").append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            b.append(", ").append(array[i]);
        }
        return b.append("]").toString();
    }

    private void doTest(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack, boolean useTool) throws Exception {
        this.doTest(conf, capacities, racks, newCapacity, newRack, null, useTool, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack, NewNodeInfo nodes, boolean useTool, boolean useFile) throws Exception {
        LOG.info((Object)("capacities = " + this.long2String(capacities)));
        LOG.info((Object)("racks      = " + Arrays.asList(racks)));
        LOG.info((Object)("newCapacity= " + newCapacity));
        LOG.info((Object)("newRack    = " + newRack));
        LOG.info((Object)("useTool    = " + useTool));
        Assert.assertEquals((long)capacities.length, (long)racks.length);
        int numOfDatanodes = capacities.length;
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 3L / 10L;
            TestBalancer.createFile(this.cluster, filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
            if (nodes == null) {
                this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, null, new long[]{newCapacity});
                totalCapacity += newCapacity;
            } else {
                if (nodes.getNumberofIncludeNodes() > 0) {
                    for (DataNode dn : this.cluster.getDataNodes()) {
                        nodes.getNodesToBeIncluded().add(dn.getDatanodeId().getHostName());
                    }
                }
                String[] newRacks = new String[nodes.getNumberofNewNodes()];
                long[] newCapacities = new long[nodes.getNumberofNewNodes()];
                for (int i = 0; i < nodes.getNumberofNewNodes(); ++i) {
                    newRacks[i] = newRack;
                    newCapacities[i] = newCapacity;
                }
                if (nodes.getNames() != null) {
                    this.cluster.startDataNodes(conf, nodes.getNumberofNewNodes(), true, null, newRacks, nodes.getNames(), newCapacities);
                    totalCapacity += newCapacity * (long)nodes.getNumberofNewNodes();
                } else {
                    int i;
                    int totalNodes;
                    this.cluster.startDataNodes(conf, nodes.getNumberofNewNodes(), true, null, newRacks, null, newCapacities);
                    totalCapacity += newCapacity * (long)nodes.getNumberofNewNodes();
                    if (nodes.getNumberofIncludeNodes() > 0) {
                        totalNodes = this.cluster.getDataNodes().size();
                        for (i = 0; i < nodes.getNumberofIncludeNodes(); ++i) {
                            nodes.getNodesToBeIncluded().add(this.cluster.getDataNodes().get(totalNodes - 1 - i).getDatanodeId().getXferAddr());
                        }
                    }
                    if (nodes.getNumberofExcludeNodes() > 0) {
                        totalNodes = this.cluster.getDataNodes().size();
                        for (i = 0; i < nodes.getNumberofExcludeNodes(); ++i) {
                            nodes.getNodesToBeExcluded().add(this.cluster.getDataNodes().get(totalNodes - 1 - i).getDatanodeId().getXferAddr());
                        }
                    }
                }
            }
            Balancer.Parameters p = Balancer.Parameters.DEFAULT;
            if (nodes != null) {
                p = new Balancer.Parameters(Balancer.Parameters.DEFAULT.policy, Balancer.Parameters.DEFAULT.threshold, Balancer.Parameters.DEFAULT.maxIdleIteration, nodes.getNodesToBeExcluded(), nodes.getNodesToBeIncluded());
            }
            int expectedExcludedNodes = 0;
            if (nodes != null) {
                if (!nodes.getNodesToBeExcluded().isEmpty()) {
                    expectedExcludedNodes = nodes.getNodesToBeExcluded().size();
                } else if (!nodes.getNodesToBeIncluded().isEmpty()) {
                    expectedExcludedNodes = this.cluster.getDataNodes().size() - nodes.getNodesToBeIncluded().size();
                }
            }
            if (useTool) {
                this.runBalancerCli(conf, totalUsedSpace, totalCapacity, p, useFile, expectedExcludedNodes);
            } else {
                this.runBalancer(conf, totalUsedSpace, totalCapacity, p, expectedExcludedNodes);
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity) throws Exception {
        this.runBalancer(conf, totalUsedSpace, totalCapacity, Balancer.Parameters.DEFAULT, 0);
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity, Balancer.Parameters p, int excludedNodes) throws Exception {
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        List namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
        int r = TestBalancer.runBalancer(namenodes, p, conf);
        if (conf.getInt("dfs.datanode.balance.max.concurrent.moves", 5) == 0) {
            Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
            return;
        }
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)r);
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        LOG.info((Object)"  .");
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster, p, excludedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int runBalancer(Collection<URI> namenodes, Balancer.Parameters p, Configuration conf) throws IOException, InterruptedException {
        block15: {
            block14: {
                sleeptime = conf.getLong("dfs.heartbeat.interval", 3L) * 2000L + conf.getLong("dfs.namenode.replication.interval", 3L) * 1000L;
                TestBalancer.LOG.info((Object)("namenodes  = " + namenodes));
                TestBalancer.LOG.info((Object)("parameters = " + p));
                TestBalancer.LOG.info((Object)"Print stack trace", new Throwable());
                System.out.println("Time Stamp               Iteration#  Bytes Already Moved  Bytes Left To Move  Bytes Being Moved");
                connectors = Collections.emptyList();
                try {
                    connectors = NameNodeConnector.newNameNodeConnectors(namenodes, (String)Balancer.class.getSimpleName(), (Path)Balancer.BALANCER_ID_PATH, (Configuration)conf, (int)Balancer.Parameters.DEFAULT.maxIdleIteration);
                    done = false;
                    iteration = 0;
lbl11:
                    // 2 sources

                    while (!done) {
                        done = true;
                        Collections.shuffle(connectors);
lbl14:
                        // 4 sources

                        for (NameNodeConnector nnc : connectors) {
                            b = new Balancer(nnc, p, conf);
                            r = b.runOneIteration();
                            r.print(iteration, System.out);
                            b.resetData(conf);
                            if (r.exitStatus == ExitStatus.IN_PROGRESS) {
                                done = false;
                                continue;
                            }
                            if (r.exitStatus != ExitStatus.SUCCESS) {
                                var12_13 = r.exitStatus.getExitCode();
                                var13_14 = connectors.iterator();
                                break block14;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl47
                    }
                    break block15;
                }
                catch (Throwable var15_16) {
                    var16_17 = connectors.iterator();
                    while (true) {
                        if (!var16_17.hasNext()) {
                            throw var15_16;
                        }
                        nnc = (NameNodeConnector)var16_17.next();
                        IOUtils.cleanup((Log)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
                    }
                }
            }
            while (true) {
                if (!var13_14.hasNext()) {
                    return var12_13;
                }
                nnc = (NameNodeConnector)var13_14.next();
                IOUtils.cleanup((Log)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
            }
lbl-1000:
            // 1 sources

            {
                if (iteration <= 0) ** GOTO lbl14
                Assert.assertTrue((boolean)(r.bytesAlreadyMoved > 0L));
                ** GOTO lbl14
lbl47:
                // 1 sources

                if (!done) {
                    Thread.sleep(sleeptime);
                }
                ++iteration;
                ** GOTO lbl11
            }
        }
        var6_6 = connectors.iterator();
        while (true) {
            if (!var6_6.hasNext()) {
                return ExitStatus.SUCCESS.getExitCode();
            }
            nnc = (NameNodeConnector)var6_6.next();
            IOUtils.cleanup((Log)TestBalancer.LOG, (Closeable[])new Closeable[]{nnc});
        }
    }

    private void runBalancerCli(Configuration conf, long totalUsedSpace, long totalCapacity, Balancer.Parameters p, boolean useFile, int expectedExcludedNodes) throws Exception {
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-policy");
        args.add("datanode");
        File excludeHostsFile = null;
        if (!p.nodesToBeExcluded.isEmpty()) {
            args.add("-exclude");
            if (useFile) {
                excludeHostsFile = new File("exclude-hosts-file");
                PrintWriter pw = new PrintWriter(excludeHostsFile);
                for (Object host : p.nodesToBeExcluded) {
                    pw.write((String)host + "\n");
                }
                pw.close();
                args.add("-f");
                args.add("exclude-hosts-file");
            } else {
                args.add(StringUtils.join((Iterable)p.nodesToBeExcluded, (char)','));
            }
        }
        File includeHostsFile = null;
        if (!p.nodesToBeIncluded.isEmpty()) {
            args.add("-include");
            if (useFile) {
                includeHostsFile = new File("include-hosts-file");
                PrintWriter pw = new PrintWriter(includeHostsFile);
                for (String host : p.nodesToBeIncluded) {
                    pw.write(host + "\n");
                }
                pw.close();
                args.add("-f");
                args.add("include-hosts-file");
            } else {
                args.add(StringUtils.join((Iterable)p.nodesToBeIncluded, (char)','));
            }
        }
        Balancer.Cli tool = new Balancer.Cli();
        tool.setConf(conf);
        int r = tool.run(args.toArray(new String[0]));
        Assert.assertEquals((String)"Tools should exit 0 on success", (long)0L, (long)r);
        TestBalancer.waitForHeartBeat(totalUsedSpace, totalCapacity, this.client, this.cluster);
        LOG.info((Object)"Rebalancing with default ctor.");
        TestBalancer.waitForBalancer(totalUsedSpace, totalCapacity, this.client, this.cluster, p, expectedExcludedNodes);
        if (excludeHostsFile != null && excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (includeHostsFile != null && includeHostsFile.exists()) {
            includeHostsFile.delete();
        }
    }

    private void oneNodeTest(Configuration conf, boolean useTool) throws Exception {
        this.doTest(conf, new long[]{5000L}, new String[]{RACK0}, 2500L, RACK0, useTool);
    }

    private void twoNodeTest(Configuration conf) throws Exception {
        this.doTest(conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, false);
    }

    public void integrationTest(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.oneNodeTest(conf, false);
    }

    @Test(timeout=300000L)
    public void testUnknownDatanode() throws IOException, InterruptedException, TimeoutException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        long[] distribution = new long[]{2500L, 3500L, 0L};
        long[] capacities = new long[]{5000L, 5000L, 5000L};
        String[] racks = new String[]{RACK0, RACK1, RACK1};
        int numDatanodes = distribution.length;
        if (capacities.length != numDatanodes || racks.length != numDatanodes) {
            throw new IllegalArgumentException("Array length is not the same");
        }
        long totalUsedSpace = TestBalancer.sum(distribution);
        ExtendedBlock[] blocks = this.generateBlocks((Configuration)conf, totalUsedSpace, (short)numDatanodes);
        Block[][] blocksDN = TestBalancer.distributeBlocks(blocks, (short)(numDatanodes - 1), distribution);
        conf.set("dfs.namenode.safemode.threshold-pct", "0.0f");
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDatanodes).format(false).racks(racks).simulatedCapacities(capacities).build();
        this.cluster.waitActive();
        this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
        Thread.sleep(2000L);
        for (int i = 0; i < 3; ++i) {
            this.cluster.injectBlocks(i, Arrays.asList(blocksDN[i]), null);
        }
        this.cluster.startDataNodes((Configuration)conf, 1, true, null, new String[]{RACK0}, null, new long[]{5000L});
        this.cluster.triggerHeartbeats();
        List namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
        HashSet<String> datanodes = new HashSet<String>();
        datanodes.add(this.cluster.getDataNodes().get(0).getDatanodeId().getHostName());
        Balancer.Parameters p = new Balancer.Parameters(Balancer.Parameters.DEFAULT.policy, Balancer.Parameters.DEFAULT.threshold, Balancer.Parameters.DEFAULT.maxIdleIteration, datanodes, Balancer.Parameters.DEFAULT.nodesToBeIncluded);
        int r = Balancer.run((Collection)namenodes, (Balancer.Parameters)p, (Configuration)conf);
        Assert.assertEquals((long)ExitStatus.SUCCESS.getExitCode(), (long)r);
    }

    @Test(timeout=300000L)
    public void testBalancerCliParseWithThresholdOutOfBoundaries() {
        String[] parameters = new String[]{"-threshold", "0"};
        String reason = "IllegalArgumentException is expected when threshold value is out of boundary.";
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Number out of range: threshold = 0.0", (Object)e.getMessage());
        }
        parameters = new String[]{"-threshold", "101"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Number out of range: threshold = 101.0", (Object)e.getMessage());
        }
    }

    @Test(timeout=300000L)
    public void testBalancer0() throws Exception {
        this.testBalancer0Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer0Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.oneNodeTest(conf, false);
        this.twoNodeTest(conf);
    }

    @Test(timeout=300000L)
    public void testBalancer1() throws Exception {
        this.testBalancer1Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer1Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.testUnevenDistribution(conf, new long[]{2500L, 500L}, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1});
    }

    @Test(timeout=300000L)
    public void testBalancerWithZeroThreadsForMove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.balance.max.concurrent.moves", 0);
        this.testBalancer1Internal((Configuration)conf);
    }

    @Test(timeout=300000L)
    public void testBalancerWithNonZeroThreadsForMove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.balance.max.concurrent.moves", 8);
        this.testBalancer1Internal((Configuration)conf);
    }

    @Test(timeout=300000L)
    public void testBalancer2() throws Exception {
        this.testBalancer2Internal((Configuration)new HdfsConfiguration());
    }

    void testBalancer2Internal(Configuration conf) throws Exception {
        TestBalancer.initConf(conf);
        this.testBalancerDefaultConstructor(conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBalancerDefaultConstructor(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack) throws Exception {
        int numOfDatanodes = capacities.length;
        Assert.assertEquals((long)numOfDatanodes, (long)racks.length);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(capacities.length).racks(racks).simulatedCapacities(capacities).build();
        try {
            this.cluster.waitActive();
            this.client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)conf, (URI)this.cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            long totalCapacity = TestBalancer.sum(capacities);
            long totalUsedSpace = totalCapacity * 3L / 10L;
            TestBalancer.createFile(this.cluster, filePath, totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes, 0);
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new long[]{newCapacity});
            this.runBalancer(conf, totalUsedSpace, totalCapacity += newCapacity);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=300000L)
    public void testBalancerCliParseWithWrongParams() {
        String[] parameters = new String[]{"-threshold"};
        String reason = "IllegalArgumentException is expected when value is not specified";
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-policy"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-policy"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-include"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-threshold", "1", "-exclude"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-include", "-f"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-exclude", "-f"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)reason);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        parameters = new String[]{"-include", "testnode1", "-exclude", "testnode2"};
        try {
            Balancer.Cli.parse((String[])parameters);
            Assert.fail((String)"IllegalArgumentException is expected when both -exclude and -include are specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=300000L)
    public void testExitZeroOnSuccess() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.oneNodeTest((Configuration)conf, true);
    }

    @Test(timeout=300000L)
    public void testBalancerWithExcludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, Balancer.Parameters.DEFAULT.nodesToBeIncluded), false, false);
    }

    @Test(timeout=300000L)
    public void testBalancerWithExcludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), false, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithExcludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, Balancer.Parameters.DEFAULT.nodesToBeIncluded), true, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithExcludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), true, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithExcludeListInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> excludeHosts = new HashSet<String>();
        excludeHosts.add("datanodeY");
        excludeHosts.add("datanodeZ");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, excludeHosts, Balancer.Parameters.DEFAULT.nodesToBeIncluded), true, true);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithExcludeListWithPortsInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 2, 0), true, true);
    }

    @Test(timeout=300000L)
    public void testBalancerWithIncludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, Balancer.Parameters.DEFAULT.nodesToBeExcluded, includeHosts), false, false);
    }

    @Test(timeout=300000L)
    public void testBalancerWithIncludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), false, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithIncludeList() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, Balancer.Parameters.DEFAULT.nodesToBeExcluded, includeHosts), true, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithIncludeListWithPorts() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), true, false);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithIncludeListInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        HashSet<String> includeHosts = new HashSet<String>();
        includeHosts.add("datanodeY");
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new HostNameBasedNodes(new String[]{"datanodeX", "datanodeY", "datanodeZ"}, Balancer.Parameters.DEFAULT.nodesToBeExcluded, includeHosts), true, true);
    }

    @Test(timeout=300000L)
    public void testBalancerCliWithIncludeListWithPortsInAFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        TestBalancer.initConf((Configuration)conf);
        this.doTest((Configuration)conf, new long[]{5000L, 5000L}, new String[]{RACK0, RACK1}, 5000L, RACK2, new PortNumberBasedNodes(3, 0, 1), true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testTwoReplicaShouldNotInSameDN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int blockSize = 0x500000;
        conf.setLong("dfs.blocksize", (long)blockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.replication.interval", 1L);
        int numOfDatanodes = 2;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).racks(new String[]{"/default/rack0", "/default/rack0"}).storagesPerDatanode(2).storageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}).storageCapacities(new long[][]{{100 * blockSize, 20 * blockSize}, {20 * blockSize, 100 * blockSize}}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path barDir = new Path("/bar");
            fs.mkdir(barDir, new FsPermission(777));
            fs.setStoragePolicy(barDir, "ONE_SSD");
            long fileLen = 30 * blockSize;
            Path fooFile = new Path(barDir, "foo");
            TestBalancer.createFile(cluster, fooFile, fileLen, (short)numOfDatanodes, 0);
            cluster.triggerHeartbeats();
            Balancer.Parameters p = Balancer.Parameters.DEFAULT;
            List namenodes = DFSUtil.getNsServiceRpcUris((Configuration)conf);
            int r = Balancer.run((Collection)namenodes, (Balancer.Parameters)p, (Configuration)conf);
            Assert.assertEquals((long)ExitStatus.NO_MOVE_PROGRESS.getExitCode(), (long)r);
        }
        finally {
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        TestBalancer balancerTest = new TestBalancer();
        balancerTest.testBalancer0();
        balancerTest.testBalancer1();
        balancerTest.testBalancer2();
    }

    static {
        ((Log4JLogger)Balancer.LOG).getLogger().setLevel(Level.ALL);
        filePath = new Path(fileName);
        r = new Random();
        TestBalancer.initTestSetup();
    }

    static class PortNumberBasedNodes
    extends NewNodeInfo {
        int newNodes;
        int excludeNodes;
        int includeNodes;

        public PortNumberBasedNodes(int newNodes, int excludeNodes, int includeNodes) {
            this.newNodes = newNodes;
            this.excludeNodes = excludeNodes;
            this.includeNodes = includeNodes;
        }

        @Override
        String[] getNames() {
            return null;
        }

        @Override
        int getNumberofNewNodes() {
            return this.newNodes;
        }

        @Override
        int getNumberofIncludeNodes() {
            return this.includeNodes;
        }

        @Override
        int getNumberofExcludeNodes() {
            return this.excludeNodes;
        }
    }

    static class HostNameBasedNodes
    extends NewNodeInfo {
        String[] hostnames;

        public HostNameBasedNodes(String[] hostnames, Set<String> nodesToBeExcluded, Set<String> nodesToBeIncluded) {
            this.hostnames = hostnames;
            this.nodesToBeExcluded = nodesToBeExcluded;
            this.nodesToBeIncluded = nodesToBeIncluded;
        }

        @Override
        String[] getNames() {
            return this.hostnames;
        }

        @Override
        int getNumberofNewNodes() {
            return this.hostnames.length;
        }

        @Override
        int getNumberofIncludeNodes() {
            return this.nodesToBeIncluded.size();
        }

        @Override
        int getNumberofExcludeNodes() {
            return this.nodesToBeExcluded.size();
        }
    }

    static abstract class NewNodeInfo {
        Set<String> nodesToBeExcluded = new HashSet<String>();
        Set<String> nodesToBeIncluded = new HashSet<String>();

        NewNodeInfo() {
        }

        abstract String[] getNames();

        abstract int getNumberofNewNodes();

        abstract int getNumberofIncludeNodes();

        abstract int getNumberofExcludeNodes();

        public Set<String> getNodesToBeIncluded() {
            return this.nodesToBeIncluded;
        }

        public Set<String> getNodesToBeExcluded() {
            return this.nodesToBeExcluded;
        }
    }
}

