/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import io.hops.metadata.hdfs.entity.HashBucket;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.blockmanagement.ReportStatistics;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.Bucket;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockReport2 {
    public static final Logger LOG = LoggerFactory.getLogger(TestBlockReport2.class);
    static final int BLOCK_SIZE = 1024;
    static final int NUM_BLOCKS = 20;
    static final int FILE_SIZE = 20480;
    private static final int RAND_LIMIT = 2000;
    private static final long DN_RESCAN_INTERVAL = 5000L;
    private static final int FILE_START = 0;
    Random rand = new Random(2000L);

    private static void initLoggers() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        GenericTestUtils.setLogLevel((Log)DataNode.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Log)DFSClient.LOG, (Level)Level.ALL);
    }

    private static void setConfiguration(Configuration conf, int numBuckets, int numDatanodes) {
        conf.setLong("dfs.blocksize", 1024L);
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setLong("dfs.datanode.directoryscan.interval", 5000L);
        conf.setInt("dfs.blockreport.numbuckets", numBuckets);
        conf.setLong("dfs.block.report.load.balancer.max.concurrent.block.reports.per.nn", (long)numDatanodes);
    }

    private void waitForTempReplica(MiniDFSCluster cluster, Block bl, int DN_N1) throws IOException {
        boolean tooLongWait = false;
        int TIMEOUT = 40000;
        if (LOG.isDebugEnabled()) {
            LOG.info("Wait for datanode " + DN_N1 + " to appear");
        }
        while (cluster.getDataNodes().size() <= DN_N1) {
            this.waitTil(20L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("Total number of DNs " + cluster.getDataNodes().size());
        }
        cluster.waitActive();
        DataNode dn1 = cluster.getDataNodes().get(DN_N1);
        String bpid = cluster.getNamesystem().getBlockPoolId();
        ReplicaInfo r = DataNodeTestUtils.fetchReplicaInfo(dn1, bpid, bl.getBlockId());
        long start = Time.now();
        int count = 0;
        while (r == null) {
            this.waitTil(5L);
            r = DataNodeTestUtils.fetchReplicaInfo(dn1, bpid, bl.getBlockId());
            long waiting_period = Time.now() - start;
            if (count++ % 100 == 0 && LOG.isDebugEnabled()) {
                LOG.info("Has been waiting for " + waiting_period + " ms.");
            }
            if (waiting_period <= 40000L) continue;
            Assert.assertTrue((String)"Was waiting too long to get ReplicaInfo from a datanode", (boolean)false);
        }
        HdfsServerConstants.ReplicaState state = r.getState();
        if (LOG.isDebugEnabled()) {
            LOG.info("Replica state before the loop " + state.getValue());
        }
        start = Time.now();
        while (state != HdfsServerConstants.ReplicaState.TEMPORARY) {
            this.waitTil(5L);
            state = r.getState();
            if (LOG.isDebugEnabled()) {
                LOG.info("Keep waiting for " + bl.getBlockName() + " is in state " + state.getValue());
            }
            if (Time.now() - start <= 40000L) continue;
            Assert.assertTrue((String)"Was waiting too long for a replica to become TEMPORARY", (boolean)false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info("Replica state after the loop " + state.getValue());
        }
    }

    private void startDNandWait(MiniDFSCluster cluster, int count) throws IOException, InterruptedException, TimeoutException {
        if (LOG.isDebugEnabled()) {
            LOG.info("Before next DN start: " + cluster.getDataNodes().size());
        }
        int expectedDatanodes = count + cluster.getDataNodes().size();
        cluster.startDataNodes(cluster.getConfiguration(0), 1, true, null, null);
        cluster.waitClusterUp();
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        Assert.assertEquals((long)datanodes.size(), (long)expectedDatanodes);
        if (LOG.isDebugEnabled()) {
            int lastDn = datanodes.size() - 1;
            LOG.info("New datanode " + cluster.getDataNodes().get(lastDn).getDisplayName() + " has been started");
        }
    }

    private void waitReplication(MiniDFSCluster cluster, short replication, Path filePath) throws IOException, TimeoutException, InterruptedException {
        DFSTestUtil.waitReplication((FileSystem)cluster.getFileSystem(), filePath, replication);
    }

    private void append(MiniDFSCluster cluster, Path filePath) throws IOException {
        LOG.info("Appending to " + filePath);
        DFSTestUtil.appendFile((FileSystem)cluster.getFileSystem(), filePath, "appended-string");
    }

    private ArrayList<Block> prepareForRide(MiniDFSCluster cluster, Path filePath, short replication, int numBlocks) throws IOException {
        LOG.info("Creatig File " + filePath);
        DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), filePath, numBlocks * 1024, replication, this.rand.nextLong());
        return this.locatedToBlocks(cluster.getNameNodeRpc().getBlockLocations(filePath.toString(), 0L, (long)(numBlocks * 1024)).getLocatedBlocks(), null);
    }

    private void printStats(MiniDFSCluster cluster) throws IOException {
        BlockManagerTestUtil.updateState(cluster.getNamesystem().getBlockManager());
        if (LOG.isDebugEnabled()) {
            LOG.info("Missing " + cluster.getNamesystem().getMissingBlocksCount());
            LOG.info("Corrupted " + cluster.getNamesystem().getCorruptReplicaBlocks());
            LOG.info("Under-replicated " + cluster.getNamesystem().getUnderReplicatedBlocks());
            LOG.info("Pending delete " + cluster.getNamesystem().getPendingDeletionBlocks());
            LOG.info("Pending replications " + cluster.getNamesystem().getPendingReplicationBlocks());
            LOG.info("Excess " + cluster.getNamesystem().getExcessBlocks());
            LOG.info("Total " + cluster.getNamesystem().getBlocksTotal());
        }
    }

    private ArrayList<Block> locatedToBlocks(List<LocatedBlock> locatedBlks, List<Integer> positionsToRemove) {
        ArrayList<Block> newList = new ArrayList<Block>();
        for (int i = 0; i < locatedBlks.size(); ++i) {
            if (positionsToRemove != null && positionsToRemove.contains(i)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.info(i + " block to be omitted");
                continue;
            }
            newList.add(new Block(locatedBlks.get(i).getBlock().getLocalBlock()));
        }
        return newList;
    }

    private void waitTil(long waitPeriod) {
        try {
            Thread.sleep(waitPeriod);
        }
        catch (InterruptedException e) {
            LOG.info(e.toString(), (Throwable)e);
        }
    }

    private List<File> findAllFiles(File top, FilenameFilter mask) {
        if (top == null) {
            return null;
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (File f : top.listFiles()) {
            if (f.isDirectory()) {
                ret.addAll(this.findAllFiles(f, mask));
                continue;
            }
            if (!mask.accept(f, f.getName())) continue;
            ret.add(f);
        }
        return ret;
    }

    private void corruptBlockLen(Block block) throws IOException {
        if (block == null) {
            throw new IOException("Block isn't suppose to be null");
        }
        long oldLen = block.getNumBytes();
        long newLen = oldLen - this.rand.nextLong();
        Assert.assertTrue((String)"Old and new length shouldn't be the same", (block.getNumBytes() != newLen ? 1 : 0) != 0);
        block.setNumBytesNoPersistance(newLen);
        if (LOG.isDebugEnabled()) {
            LOG.info("Length of " + block.getBlockName() + " is changed to " + newLen + " from " + oldLen);
        }
    }

    private void corruptBlockGS(Block block) throws IOException {
        if (block == null) {
            throw new IOException("Block isn't suppose to be null");
        }
        long oldGS = block.getGenerationStamp();
        long newGS = oldGS - this.rand.nextLong();
        Assert.assertTrue((String)"Old and new GS shouldn't be the same", (block.getGenerationStamp() != newGS ? 1 : 0) != 0);
        block.setGenerationStampNoPersistance(newGS);
        if (LOG.isDebugEnabled()) {
            LOG.info("Generation stamp of " + block.getBlockName() + " is changed to " + block.getGenerationStamp() + " from " + oldGS);
        }
    }

    private Block findBlock(MiniDFSCluster cluster, Path path, long size) throws IOException {
        List lbs = cluster.getNameNodeRpc().getBlockLocations(path.toString(), 0L, size).getLocatedBlocks();
        LocatedBlock lb = (LocatedBlock)lbs.get(lbs.size() - 1);
        Block ret = cluster.getDataNodes().get((int)0).data.getStoredBlock(lb.getBlock().getBlockPoolId(), lb.getBlock().getBlockId());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_01() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            int i;
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            cluster.waitActive();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (i = 0; i < 1; ++i) {
                int numBlocks = 1;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            }
            Thread.sleep(10000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            LOG.info("Deleting all files");
            for (i = 0; i < 1; ++i) {
                Path filePath = new Path("/dir/" + i + ".dat");
                fs.delete(filePath, false);
            }
            Thread.sleep(30000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            LOG.info(e.toString(), (Throwable)e);
            Assert.fail((String)e.toString());
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_02() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            int i;
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (i = 0; i < 5; ++i) {
                int numBlocks = 3;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            }
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (i = 0; i < 5; ++i) {
                Path filePath = new Path("/dir/" + i + ".dat");
                this.append(cluster, filePath);
            }
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_03() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        int NUM_FILES = 5;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            byte[] data;
            Path filePath;
            int i;
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            FSDataOutputStream[] outs = new FSDataOutputStream[5];
            for (i = 0; i < 5; ++i) {
                filePath = new Path("/dir/" + i + ".dat");
                LOG.info("Creating file: " + filePath);
                outs[i] = fs.create(filePath, (short)3);
                data = new byte[512];
                outs[i].write(data);
                outs[i].flush();
                LOG.info("Flushed half a block");
            }
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (i = 0; i < 5; ++i) {
                filePath = new Path("/dir/" + i + ".dat");
                data = new byte[511];
                outs[i].write(data);
                outs[i].hflush();
                LOG.info("HFlushed half a block -1 ");
            }
            Thread.sleep(50000L);
            this.matchDNandNNState(0, 5, cluster, 15, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 15, 5);
            for (i = 0; i < 5; ++i) {
                filePath = new Path("/dir/" + i + ".dat");
                data = new byte[1025];
                outs[i].write(data);
                outs[i].hflush();
                outs[i].close();
                LOG.info("HFlushed 1 byte. The block is complete and file is closed.");
            }
            LOG.info("Sleeping to make sure that all the incremental BR are received");
            Thread.sleep(10000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    @Ignore
    @Test
    public void blockReport_04() throws Exception {
        this.blockReprot_hardlease(true);
    }

    @Ignore
    @Test
    public void blockReport_05() throws Exception {
        this.blockReprot_hardlease(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockReprot_hardlease(boolean hflush) throws Exception {
        DistributedFileSystem dfs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        long SHORT_LEASE_PERIOD = 1000L;
        long LONG_LEASE_PERIOD = 3600000L;
        int numBuckets = 5;
        try {
            LocatedBlocks locatedBlocks;
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            dfs = cluster.getFileSystem();
            String filestr = "/hardLeaseRecovery";
            LOG.info("filestr=" + filestr);
            Path filepath = new Path(filestr);
            FSDataOutputStream stm = dfs.create(filepath);
            Assert.assertTrue((boolean)dfs.getClient().exists(filestr));
            int size = 1536;
            byte[] buffer = new byte[20480];
            LOG.info("size=" + size);
            stm.write(buffer, 0, 1025);
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            stm.write(buffer, 0, 511);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            if (hflush) {
                LOG.info("hflush");
                stm.hflush();
            }
            LOG.info("leasechecker.interruptAndJoin()");
            dfs.getClient().getLeaseRenewer().interruptAndJoin();
            cluster.setLeasePeriod(3600000L, 1000L);
            do {
                Thread.sleep(1000L);
            } while ((locatedBlocks = dfs.getClient().getLocatedBlocks(filestr, 0L, (long)size)).isUnderConstruction());
            Assert.assertEquals((long)size, (long)locatedBlocks.getFileLength());
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            try {
                stm.write(98);
                stm.close();
                Assert.fail((String)"Writer thread should have been killed");
            }
            catch (IOException e) {
                LOG.info(e.toString(), (Throwable)e);
            }
            AppendTestUtil.LOG.info((Object)"File size is good. Now validating sizes from datanodes...");
            AppendTestUtil.checkFullFile((FileSystem)dfs, filepath, size, buffer, filestr);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            dfs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_06() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            int numFiles = 5;
            Path[] paths = new Path[numFiles - 1];
            Path dst = null;
            for (int i = 0; i < numFiles; ++i) {
                int numBlocks = 3;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
                if (i == numFiles - 1) {
                    dst = filePath;
                    continue;
                }
                paths[i] = filePath;
            }
            fs.concat(dst, paths);
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            LOG.info(e.toString(), (Throwable)e);
            Assert.fail((String)e.toString());
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    @Test
    public void blockReport_07() throws IOException, InterruptedException {
        this.blockReportReplication((short)3, (short)6);
    }

    @Ignore
    @Test
    public void blockReport_08() throws IOException, InterruptedException {
        this.blockReportReplication((short)6, (short)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockReportReplication(short replication, short change) throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 6;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 6);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(6).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 6, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 6, cluster, poolId, 0, 5);
            int numFiles = 5;
            int numBlocks = 3;
            for (int i = 0; i < numFiles; ++i) {
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, replication, numBlocks);
            }
            Thread.sleep(10000L);
            int totalReplicas = numFiles * numBlocks * replication;
            int dnBlocks = this.countDNBlocks(cluster);
            int nnBlocks = this.countNNBlocks(0, cluster);
            Assert.assertTrue((String)("Number of blocks do not match, DN Blocks: " + dnBlocks + " NN Blocks: " + nnBlocks + " Both should be equal to: " + totalReplicas), (dnBlocks == totalReplicas && nnBlocks == totalReplicas ? 1 : 0) != 0);
            for (int i = 0; i < numFiles; ++i) {
                Path filePath = new Path("/dir/" + i + ".dat");
                fs.setReplication(filePath, change);
            }
            Thread.sleep(60000L);
            totalReplicas = numFiles * numBlocks * change;
            dnBlocks = this.countDNBlocks(cluster);
            nnBlocks = this.countNNBlocks(0, cluster);
            Assert.assertTrue((String)("Number of blocks do not match, DN Blocks: " + dnBlocks + " NN Blocks: " + nnBlocks + " Both should be equal to: " + totalReplicas), (dnBlocks == totalReplicas && nnBlocks == totalReplicas ? 1 : 0) != 0);
            this.matchDNandNNState(0, 6, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 6, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    @Test
    public void blockReport_09() throws IOException, InterruptedException {
        this.concurrentWrites(1, (short)1, 10, 0);
    }

    @Test
    public void blockReport_10() throws IOException, InterruptedException {
        this.concurrentWrites(5, (short)3, 10, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrentWrites(int numThreads, short replication, int numDataNodes, int threashold) throws IOException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            int i;
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, numDataNodes);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(numDataNodes).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, numDataNodes, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, numDataNodes, cluster, poolId, 0, 5);
            SomeWorkload[] threads = new SomeWorkload[numThreads];
            for (i = 0; i < numThreads; ++i) {
                Path filePath = new Path("/dir/test" + i + ".dat");
                threads[i] = new SomeWorkload(cluster, 1024, replication, i);
                threads[i].start();
            }
            Thread.sleep(60000L);
            for (i = 0; i < numThreads; ++i) {
                threads[i].stopIt();
            }
            Thread.sleep(30000L);
            this.matchDNandNNState(0, numDataNodes, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, numDataNodes, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_11() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (int i = 0; i < 5; ++i) {
                int numBlocks = 3;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            }
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            LOG.info("Before corrupting hashes ");
            this.corruptNNHashes(0, cluster);
            LOG.info("Restarting Cluster");
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(5).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            Thread.sleep(5000L);
            LOG.info("After restart comparing states");
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void blockReport_12() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            for (int i = 0; i < 5; ++i) {
                int numBlocks = 3;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            }
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            this.corruptNNHashes(0, cluster);
            this.matchDNandNNState(0, 5, cluster, 25, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 25, 5);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void blockReport_13() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        try {
            Configuration conf = new Configuration();
            int numBuckets = 5;
            TestBlockReport2.setConfiguration(conf, numBuckets, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, numBuckets);
            for (int i = 0; i < 5; ++i) {
                int numBlocks = 3;
                Path filePath = new Path("/dir/" + i + ".dat");
                this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            }
            Thread.sleep(5000L);
            this.matchDNandNNState(0, 5, cluster, 0, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, numBuckets);
            this.deleteHashes(0, cluster);
            cluster.shutdown();
            conf = new Configuration();
            numBuckets = 10;
            TestBlockReport2.setConfiguration(conf, numBuckets, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(5).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            this.matchDNandNNState(0, 5, cluster, 5 * numBuckets, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 5 * numBuckets, numBuckets);
            this.matchDNandNNState(0, 5, cluster, 0, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, numBuckets);
            this.deleteHashes(0, cluster);
            cluster.shutdown();
            conf = new Configuration();
            numBuckets = 3;
            TestBlockReport2.setConfiguration(conf, numBuckets, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(false).numDataNodes(5).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            this.matchDNandNNState(0, 5, cluster, 5 * numBuckets, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 5 * numBuckets, numBuckets);
            this.matchDNandNNState(0, 5, cluster, 0, numBuckets);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, numBuckets);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    private void checkStats(ReportStatistics stats, int numBuckets) {
        Assert.assertEquals((String)"No buckets should have mismatched ", (long)0L, (long)(numBuckets - stats.getNumBucketsMatching()));
    }

    /*
     * WARNING - void declaration
     */
    private void matchDNandNNState(int nnId, int numDataNodes, MiniDFSCluster cluster, int tolerance, int numBuckets) throws IOException {
        int mismatchCount = 0;
        for (int i = 0; i < numDataNodes; ++i) {
            LOG.info("DataNode Index: " + i);
            DataNode dn = cluster.getDataNodes().get(i);
            Map<DatanodeStorage, BlockReport> storageReports = TestBlockReport2.getDNBR(cluster, dn, numBuckets);
            for (Map.Entry<DatanodeStorage, BlockReport> entry : storageReports.entrySet()) {
                void var18_25;
                BlockReport value = entry.getValue();
                ArrayList<byte[]> dnHashes = new ArrayList<byte[]>();
                for (Bucket bucket : value.getBuckets()) {
                    dnHashes.add(bucket.getHash());
                }
                DatanodeStorageInfo storage = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).getStorageInfo(entry.getKey().getStorageID());
                List<HashBucket> storageHashes = this.getStorageHashes(storage);
                LOG.warn("Total buckets " + storageHashes.size());
                Assert.assertFalse((String)"More buckets on NN than on DN. might indicate configuration issue.", (storageHashes.size() > dnHashes.size() ? 1 : 0) != 0);
                if (storageHashes.size() != dnHashes.size()) {
                    LOG.info("Number of hashes on NN doesn't match DN. This should only be the case before first report.");
                }
                LOG.warn("numBuckets size " + numBuckets);
                byte[][] nnHashes = new byte[20][numBuckets];
                for (HashBucket hashBucket : storageHashes) {
                    LOG.warn("adding " + hashBucket.getBucketId() + ", " + hashBucket.getHash());
                    nnHashes[hashBucket.getBucketId()] = hashBucket.getHash();
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (byte[] hash : dnHashes) {
                    stringBuilder.append(HashBuckets.hashToString((byte[])hash)).append(", ");
                }
                LOG.info("DN Hash: " + stringBuilder);
                StringBuilder stringBuilder2 = new StringBuilder();
                for (byte[] hash : nnHashes) {
                    stringBuilder2.append(HashBuckets.hashToString((byte[])hash)).append(", ");
                }
                LOG.info("NN Hash: " + stringBuilder2);
                boolean bl = false;
                while (var18_25 < numBuckets) {
                    byte[] nnHash;
                    byte[] dnHash = (byte[])dnHashes.get((int)var18_25);
                    if (!HashBuckets.hashEquals((byte[])dnHash, (byte[])(nnHash = nnHashes[var18_25]))) {
                        ++mismatchCount;
                    }
                    ++var18_25;
                }
            }
        }
        if (mismatchCount > tolerance) {
            String msg = "The Hashes Did not match. Mismatched Hashes: " + mismatchCount + " Tolerance: " + tolerance;
            LOG.info(msg);
            Assert.fail((String)msg);
        }
    }

    private void corruptNNHashes(int nnId, MiniDFSCluster cluster) throws IOException {
        for (DataNode dn : cluster.getDataNodes()) {
            BlockManager bm = cluster.getNamesystem(nnId).getBlockManager();
            DatanodeDescriptor dnd = bm.getDatanodeManager().getDatanode(dn.getDatanodeId());
            for (DatanodeStorageInfo storageInfo : dnd.getStorageInfos()) {
                HashBuckets.getInstance().corruptHashBuckets(storageInfo);
            }
        }
    }

    private void deleteHashes(int nnId, MiniDFSCluster cluster) throws IOException {
        for (DataNode dn : cluster.getDataNodes()) {
            BlockManager bm = cluster.getNamesystem(nnId).getBlockManager();
            DatanodeDescriptor dnd = bm.getDatanodeManager().getDatanode(dn.getDatanodeId());
            DatanodeStorageInfo[] storageInfos = dnd.getStorageInfos();
            for (DatanodeStorageInfo storageInfo : dnd.getStorageInfos()) {
                HashBuckets.getInstance().deleteHashBuckets(storageInfo);
            }
        }
    }

    private static Map<DatanodeStorage, BlockReport> getDNBR(MiniDFSCluster cluster, DataNode dn, int numBuckets) {
        String poolId = cluster.getNamesystem().getBlockPoolId();
        Map br = dn.getFSDataset().getBlockReports(poolId);
        for (BlockReport reportedBlocks : br.values()) {
            Assert.assertEquals((String)("Wrong number of buckets read for DN: " + dn), (long)numBuckets, (long)reportedBlocks.getBuckets().length);
        }
        return br;
    }

    public static void sendAndCheckBR(int nnId, int numDataNodes, MiniDFSCluster cluster, String poolId, int tolerance, int numBuckets) throws IOException {
        int mismatched = 0;
        for (int i = 0; i < numDataNodes; ++i) {
            DataNode dn = cluster.getDataNodes().get(i);
            Map<DatanodeStorage, BlockReport> dnBr = TestBlockReport2.getDNBR(cluster, dn, numBuckets);
            BlockManager bm = cluster.getNamesystem(nnId).getBlockManager();
            for (Map.Entry<DatanodeStorage, BlockReport> datanodeStorageBlockReportEntry : dnBr.entrySet()) {
                DatanodeDescriptor datanode = cluster.getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
                DatanodeStorageInfo storageInfo = datanode.getStorageInfo(datanodeStorageBlockReportEntry.getKey().getStorageID());
                List mismatchingbuckets = bm.checkHashes(dn.getDatanodeId(), datanodeStorageBlockReportEntry.getKey(), datanodeStorageBlockReportEntry.getValue());
                BPOfferService.removeMatchingBuckets((List)mismatchingbuckets, (BlockReport)datanodeStorageBlockReportEntry.getValue());
                BlockManager.ReportStatistics stats = bm.processReport(storageInfo, datanodeStorageBlockReportEntry.getValue());
                mismatched += numBuckets - stats.numBucketsMatching;
            }
        }
        if (mismatched > tolerance) {
            String msg = "BR Buckets mismatched : " + mismatched + " Tolerance: " + tolerance;
            LOG.info(msg);
            Assert.fail((String)msg);
        }
    }

    private int countDNBlocks(MiniDFSCluster cluster) throws IOException {
        int count = 0;
        for (DataNode dn : cluster.getDataNodes()) {
            String poolId = cluster.getNamesystem().getBlockPoolId();
            Map blockReports = dn.getFSDataset().getBlockReports(poolId);
            for (BlockReport reportedBlocks : blockReports.values()) {
                count += reportedBlocks.getNumberOfBlocks();
            }
        }
        return count;
    }

    private int countNNBlocks(int nnId, MiniDFSCluster cluster) throws IOException {
        int count = 0;
        BlockManager bm = cluster.getNamesystem(nnId).getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        for (DataNode dn : cluster.getDataNodes()) {
            count += dnm.getDatanode(dn.getDatanodeId()).numBlocks();
        }
        return count;
    }

    private List<HashBucket> getStorageHashes(DatanodeStorageInfo storage) throws IOException {
        List namenodeHashes = HashBuckets.getInstance().getBucketsForStorage(storage);
        boolean hasIncorrectStorageBucket = false;
        for (HashBucket namenodeHash : namenodeHashes) {
            if (namenodeHash.getStorageId() == storage.getSid()) continue;
            hasIncorrectStorageBucket = true;
            break;
        }
        Assert.assertFalse((String)"HashBuckets.getBucketForStorage() returned incorrect storage hash", (boolean)hasIncorrectStorageBucket);
        return namenodeHashes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_14() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            cluster.waitActive();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            int numBlocks = 1;
            Path filePath = new Path("/dir/file.dat");
            this.prepareForRide(cluster, filePath, (short)3, numBlocks);
            Thread.sleep(10000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            filePath = new Path("/dir/file.dat");
            FSDataOutputStream out = fs.create(filePath, true);
            out.write(1);
            out.close();
            Thread.sleep(30000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_15() throws IOException, InterruptedException {
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        int NUM_DATANODES = 5;
        int REPLICATION = 3;
        String poolId = null;
        String baseName = "/dir";
        int numBuckets = 5;
        try {
            Configuration conf = new Configuration();
            TestBlockReport2.setConfiguration(conf, 5, 5);
            cluster = new MiniDFSCluster.Builder(conf).format(true).numDataNodes(5).build();
            fs = cluster.getFileSystem();
            cluster.waitActive();
            String METHOD_NAME = GenericTestUtils.getMethodName();
            LOG.info("Running test " + METHOD_NAME);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            int numBlocks = 1;
            Path filePath1 = new Path("/dir/file1.dat");
            Path filePath2 = new Path("/dir/file2.dat");
            this.prepareForRide(cluster, filePath1, (short)3, numBlocks);
            this.prepareForRide(cluster, filePath2, (short)3, numBlocks);
            Thread.sleep(10000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
            fs.rename(filePath1, filePath2, new Options.Rename[]{Options.Rename.OVERWRITE});
            Thread.sleep(30000L);
            this.matchDNandNNState(0, 5, cluster, 0, 5);
            TestBlockReport2.sendAndCheckBR(0, 5, cluster, poolId, 0, 5);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            LOG.info(e.toString(), (Throwable)e);
        }
        finally {
            fs.close();
            cluster.shutdownDataNodes();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockReport_16() throws IOException, InterruptedException {
        short replicas = 1;
        HdfsConfiguration conf = new HdfsConfiguration();
        int numBuckets = 5;
        TestBlockReport2.setConfiguration((Configuration)conf, 5, replicas);
        conf.setLong("dfs.blockreport.intervalMsec", 3600000L);
        EnumSet<HdfsDataOutputStream.SyncFlag> syncFlags = EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH);
        int FILE_SIZE = 20481;
        String fileName = "hflushtest.dat";
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(replicas).build();
        cluster.waitActive();
        Thread.sleep(10000L);
        DistributedFileSystem fileSystem = cluster.getFileSystem();
        Path testFile = new Path("/testfile");
        try {
            FSDataOutputStream out = fileSystem.create(testFile, replicas);
            BRTestWriter writer = new BRTestWriter(out);
            Thread t = new Thread(writer);
            t.start();
            cluster.getDataNodes().get(0).scheduleAllBlockReport(0L);
            Thread.sleep(15000L);
            writer.stop();
            t.join();
            out.close();
            FSDataInputStream in = fileSystem.open(testFile);
            byte[] block = AppendTestUtil.initBuffer(1024);
            for (int i = 0; i < writer.blocksWritten; ++i) {
                in.read(block);
            }
            in.close();
        }
        finally {
            fileSystem.close();
            cluster.shutdown();
        }
    }

    static {
        TestBlockReport2.initLoggers();
    }

    private class BRTestWriter
    implements Runnable {
        FSDataOutputStream out;
        boolean stop = false;
        byte[] block;
        int blocksWritten = 0;

        BRTestWriter(FSDataOutputStream out) {
            this.out = out;
            this.block = AppendTestUtil.initBuffer(1024);
        }

        public void stop() {
            this.stop = true;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    this.out.write(this.block);
                    this.out.hflush();
                    ++this.blocksWritten;
                }
            }
            catch (IOException e) {
                LOG.info(e.toString(), (Throwable)e);
            }
        }
    }

    private class SomeWorkload
    extends Thread {
        MiniDFSCluster cluster;
        boolean stop = false;
        int blockSize;
        short replication;
        List<Path> paths = new ArrayList<Path>();
        final int tid;
        int counter = 0;
        Random rand = new Random(System.currentTimeMillis());

        public SomeWorkload(MiniDFSCluster cluster, int blockSize, short replication, int tid) {
            this.cluster = cluster;
            this.replication = replication;
            this.blockSize = blockSize;
            this.tid = tid;
        }

        public void stopIt() {
            this.stop = true;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    int choice = this.rand.nextInt(3);
                    switch (choice) {
                        case 0: {
                            Path filePath = new Path("/" + this.tid + "/" + this.counter++ + ".bin");
                            FSDataOutputStream out = this.cluster.getFileSystem().create(filePath, this.replication);
                            byte[] buffer = new byte[this.blockSize];
                            out.write(buffer);
                            out.close();
                            this.paths.add(filePath);
                            break;
                        }
                        case 1: {
                            if (this.paths.size() <= 0) break;
                            Path path = this.paths.remove(0);
                            this.cluster.getFileSystem().delete(path, true);
                            break;
                        }
                        case 2: {
                            if (this.paths.size() <= 0) break;
                            Path path = this.paths.get(0);
                            this.cluster.getFileSystem().setReplication(path, (short)(this.replication + 1));
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("FIX ME");
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                LOG.info(e.toString(), (Throwable)e);
                Assert.fail((String)("Failed to start BlockChecker: " + e));
            }
        }
    }

    private class MyFileFilter
    implements FilenameFilter {
        private String nameToAccept = "";
        private boolean all = false;

        public MyFileFilter(String nameToAccept, boolean all) {
            if (nameToAccept == null) {
                throw new IllegalArgumentException("Argument isn't suppose to be null");
            }
            this.nameToAccept = nameToAccept;
            this.all = all;
        }

        @Override
        public boolean accept(File file, String s) {
            if (this.all) {
                return s != null && s.startsWith(this.nameToAccept);
            }
            return s != null && s.equals(this.nameToAccept);
        }
    }
}

