/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.FakeRenewer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestDelegationTokenFetcher {
    private Configuration conf = new Configuration();
    @Rule
    public TemporaryFolder f = new TemporaryFolder();
    private static final String tokenFile = "token";

    @Test(expected=IOException.class)
    public void testTokenFetchFail() throws Exception {
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doThrow((Throwable)new IOException()).when((Object)fs)).getDelegationToken(Matchers.anyString());
        Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
    }

    @Test
    public void expectedTokenIsRetrievedFromHttp() throws Exception {
        Token testToken = new Token("id".getBytes(), "pwd".getBytes(), FakeRenewer.KIND, new Text("127.0.0.1:1234"));
        WebHdfsFileSystem fs = (WebHdfsFileSystem)Mockito.mock(WebHdfsFileSystem.class);
        ((WebHdfsFileSystem)Mockito.doReturn((Object)testToken).when((Object)fs)).getDelegationToken(Matchers.anyString());
        Path p = new Path(this.f.getRoot().getAbsolutePath(), tokenFile);
        DelegationTokenFetcher.saveDelegationToken((Configuration)this.conf, (FileSystem)fs, null, (Path)p);
        Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
        Iterator itr = creds.getAllTokens().iterator();
        Assert.assertTrue((String)"token not exist error", (boolean)itr.hasNext());
        Token fetchedToken = (Token)itr.next();
        Assert.assertArrayEquals((String)"token wrong identifier error", (byte[])testToken.getIdentifier(), (byte[])fetchedToken.getIdentifier());
        Assert.assertArrayEquals((String)"token wrong password error", (byte[])testToken.getPassword(), (byte[])fetchedToken.getPassword());
        DelegationTokenFetcher.renewTokens((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)testToken, FakeRenewer.getLastRenewed());
        DelegationTokenFetcher.cancelTokens((Configuration)this.conf, (Path)p);
        Assert.assertEquals((Object)testToken, FakeRenewer.getLastCanceled());
    }
}

