/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.JMXGet;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJMXGet {
    private Configuration config;
    private MiniDFSCluster cluster;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;

    @Before
    public void setUp() throws Exception {
        this.config = new HdfsConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        File data_dir;
        if (this.cluster.isClusterUp()) {
            this.cluster.shutdown();
        }
        if ((data_dir = new File(this.cluster.getDataDirectory())).exists() && !FileUtil.fullyDelete((File)data_dir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + data_dir + "'");
        }
    }

    @Test
    public void testNameNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/test1"), 8192, 8192L, 4096L, (short)2, 0xAAAAEEFL);
        JMXGet jmx = new JMXGet();
        String serviceName = "NameNode";
        jmx.setService(serviceName);
        jmx.init();
        Thread.sleep(25000L);
        Assert.assertTrue((String)"error printAllValues", (boolean)TestJMXGet.checkPrintAllValues(jmx));
        Assert.assertEquals((long)numDatanodes, (long)Integer.parseInt(jmx.getValue("NumLiveDataNodes")));
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)Long.parseLong(jmx.getValue("CorruptBlocks")), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"FSNamesystem"));
        this.cluster.shutdown();
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        ObjectName query = new ObjectName("Hadoop:service=" + serviceName + ",*");
        Set<ObjectName> names = mbsc.queryNames(query, null);
        Assert.assertTrue((String)("No beans should be registered for " + serviceName), (boolean)names.isEmpty());
    }

    private static boolean checkPrintAllValues(JMXGet jmx) throws Exception {
        int size = 0;
        byte[] bytes = null;
        String pattern = "List of all the available keys:";
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        System.setErr(new PrintStream(pipeOut));
        jmx.printAllValues();
        size = pipeIn.available();
        if (size != 0) {
            bytes = new byte[size];
            pipeIn.read(bytes, 0, bytes.length);
        }
        pipeOut.close();
        pipeIn.close();
        return bytes != null ? new String(bytes).contains(pattern) : false;
    }

    @Test
    public void testDataNode() throws Exception {
        int numDatanodes = 2;
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(numDatanodes).build();
        this.cluster.waitActive();
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/test"), 8192, 8192L, 4096L, (short)2, 0xAAAAEEFL);
        JMXGet jmx = new JMXGet();
        String serviceName = "DataNode";
        jmx.setService(serviceName);
        jmx.setService("DataNode");
        jmx.init();
        Thread.sleep(15000L);
        Assert.assertEquals((long)8192L, (long)Integer.parseInt(jmx.getValue("BytesWritten")));
        this.cluster.shutdown();
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        ObjectName query = new ObjectName("Hadoop:service=" + serviceName + ",*");
        Set<ObjectName> names = mbsc.queryNames(query, null);
        Assert.assertTrue((String)("No beans should be registered for " + serviceName), (boolean)names.isEmpty());
    }
}

