/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import io.hops.security.CertificateLocalizationCtx;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.HdfsWriter;
import org.apache.hadoop.security.UserGroupInformation;

public class HopsHdfsWriter
extends HdfsWriter {
    private final Configuration conf;
    private final UserGroupInformation ugi;

    HopsHdfsWriter(DFSClient client, OutputStream out, DefaultHttpResponse response, Configuration conf, UserGroupInformation ugi) {
        super(client, out, response);
        this.conf = conf;
        this.ugi = ugi;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpContent chunk) throws IOException {
        super.channelRead0(ctx, chunk);
        this.removeX509Credentials();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        super.exceptionCaught(ctx, cause);
        try {
            CertificateLocalizationCtx.getInstance().getCertificateLocalization().removeX509Material(this.ugi.getUserName());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void removeX509Credentials() throws IOException {
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            try {
                CertificateLocalizationCtx.getInstance().getCertificateLocalization().removeX509Material(this.ugi.getUserName());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("CertificateLocalizationService interrupted while removing X.509 material");
            }
        }
    }
}

