/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import io.hops.common.IDsGeneratorFactory;
import io.hops.common.IDsMonitor;
import io.hops.common.INodeUtil;
import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.ErasureCodingManager;
import io.hops.exception.HDFSClientAppendToDBFileException;
import io.hops.exception.LockUpgradeException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.exception.TransientStorageException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.ActiveBlockReportsDataAccess;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.dal.SafeBlocksDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.entity.BlockChecksum;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.metadata.hdfs.entity.XAttrMetadataLogEntry;
import io.hops.resolvingcache.Cache;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.RootINodeCache;
import io.hops.transaction.handler.EncodingStatusOperationType;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.LeaseLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import io.hops.util.Slicer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.UnknownCryptoProtocolVersionException;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.EncryptionFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSDirAclOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirConcatOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirMkdirOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirRenameOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirStatAndListingOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSymlinkOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNDNCacheOp;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.HdfsAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAclHelper;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.QuotaUpdateManager;
import org.apache.hadoop.hdfs.server.namenode.RetryStartFileException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;
import org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.hadoop.hdfs.server.namenode.top.TopConf;
import org.apache.hadoop.hdfs.server.namenode.top.metrics.TopMetrics;
import org.apache.hadoop.hdfs.server.namenode.top.window.RollingWindowManager;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.NotALeaderException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;

@InterfaceAudience.Private
@Metrics(context="dfs")
public class FSNamesystem
implements Namesystem,
FSNamesystemMBean,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private final boolean isPermissionEnabled;
    private final UserGroupInformation fsOwner;
    private final String superGroup;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final DelegationTokenSecretManager dtSecretManager;
    private final boolean alwaysUseDelegationTokensForTests;
    private static final Step STEP_AWAITING_REPORTED_BLOCKS = new Step(StepType.AWAITING_REPORTED_BLOCKS);
    private final boolean isDefaultAuditLogger;
    private final List<AuditLogger> auditLoggers;
    FSDirectory dir;
    private final BlockManager blockManager;
    private final CacheManager cacheManager;
    private final DatanodeStatistics datanodeStatistics;
    private final String blockPoolId;
    final LeaseManager leaseManager = new LeaseManager(this);
    private volatile Daemon smmthread = null;
    private Daemon nnrmthread = null;
    private Daemon retryCacheCleanerThread = null;
    private volatile boolean hasResourcesAvailable = true;
    private volatile boolean fsRunning = true;
    private final long startTime = Time.now();
    private final long resourceRecheckInterval;
    NameNodeResourceChecker nnResourceChecker;
    private final int maxDBTries;
    private final FsServerDefaults serverDefaults;
    private final boolean supportAppends;
    private final ReplaceDatanodeOnFailure dtpReplaceDatanodeOnFailure;
    private AtomicBoolean inSafeMode = new AtomicBoolean(false);
    private final long maxFsObjects;
    private final long minBlockSize;
    private final long maxBlocksPerFile;
    private final long accessTimePrecision;
    private NameNode nameNode;
    private final Configuration conf;
    private final QuotaUpdateManager quotaUpdateManager;
    private final ExecutorService fsOperationsExecutor;
    private final boolean erasureCodingEnabled;
    private final ErasureCodingManager erasureCodingManager;
    static int DB_IN_MEMORY_BUCKET_SIZE;
    static int DB_ON_DISK_SMALL_BUCKET_SIZE;
    static int DB_ON_DISK_MEDIUM_BUCKET_SIZE;
    static int DB_ON_DISK_LARGE_BUCKET_SIZE;
    static int DB_MAX_SMALL_FILE_SIZE;
    boolean initializedReplQueues = false;
    boolean shouldPopulateReplicationQueue = false;
    private volatile boolean startingActiveService = false;
    private KeyProviderCryptoExtension provider = null;
    private volatile boolean imageLoaded = false;
    private final boolean isRetryCacheEnabled;
    private boolean isTestingSTO = false;
    private ThreadLocal<Times> delays = new ThreadLocal();
    long delayBeforeSTOFlag = 0L;
    long delayAfterBuildingTree = 0L;
    int slicerBatchSize;
    int slicerNbThreads;
    private volatile AtomicBoolean forceReadTheSafeModeFromDB = new AtomicBoolean(true);
    private final TopConf topConf;
    private TopMetrics topMetrics;
    private final int leaseCreationLockRows;
    private final short dbReplicationFactor;
    private ObjectName mbeanName;
    private ObjectName mxbeanName;

    @VisibleForTesting
    boolean isAuditEnabled() {
        return !this.isDefaultAuditLogger || auditLog.isInfoEnabled();
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src) throws IOException {
        this.logAuditEvent(succeeded, cmd, src, null, null);
    }

    private void logAuditEvent(boolean succeeded, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        if (this.isAuditEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(succeeded, FSNamesystem.getRemoteUser(), FSNamesystem.getRemoteIp(), cmd, src, dst, stat);
        }
    }

    private void logAuditEvent(boolean succeeded, UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) throws IOException {
        FileStatus status = null;
        if (stat != null) {
            Path symlink = stat.isSymlink() ? new Path(stat.getSymlink()) : null;
            Path path = dst != null ? new Path(dst) : new Path(src);
            status = new FileStatus(stat.getLen(), stat.isDir(), (int)stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), symlink, path);
        }
        for (AuditLogger logger : this.auditLoggers) {
            if (logger instanceof HdfsAuditLogger) {
                HdfsAuditLogger hdfsLogger = (HdfsAuditLogger)logger;
                hdfsLogger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status, ugi, this.dtSecretManager);
                continue;
            }
            logger.logAuditEvent(succeeded, ugi.toString(), addr, cmd, src, dst, status);
        }
    }

    void imageLoadComplete() {
        Preconditions.checkState((!this.imageLoaded ? 1 : 0) != 0, (Object)"FSDirectory already loaded");
        this.setImageLoaded();
    }

    void setImageLoaded() {
        if (this.imageLoaded) {
            return;
        }
        this.setImageLoaded(true);
        this.dir.markNameCacheInitialized();
    }

    @VisibleForTesting
    boolean isImageLoaded() {
        return this.imageLoaded;
    }

    protected void setImageLoaded(boolean flag) {
        this.imageLoaded = flag;
    }

    void clear() throws IOException {
        this.dir.reset();
        this.dtSecretManager.reset();
        this.leaseManager.removeAllLeases();
        this.setImageLoaded(false);
    }

    @VisibleForTesting
    LeaseManager getLeaseManager() {
        return this.leaseManager;
    }

    public int getSlicerNbThreads() {
        return this.slicerNbThreads;
    }

    public int getSlicerBatchSize() {
        return this.slicerBatchSize;
    }

    static FSNamesystem loadFromDisk(Configuration conf, NameNode namenode) throws IOException {
        FSNamesystem namesystem = new FSNamesystem(conf, namenode);
        HdfsServerConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
            namesystem.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        }
        if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startOpt)) {
            FSNamesystem.rollBackRollingUpgradeTX();
        }
        long loadStart = Time.monotonicNow();
        switch (startOpt) {
            case UPGRADE: {
                StorageInfo sinfo = StorageInfo.getStorageInfoFromDB();
                StorageInfo.updateStorageInfoToDB(sinfo, Time.now());
            }
        }
        namesystem.imageLoadComplete();
        long timeTakenToLoadFSImage = Time.monotonicNow() - loadStart;
        LOG.debug((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " ms"));
        NameNodeMetrics nnMetrics = NameNode.getNameNodeMetrics();
        if (nnMetrics != null) {
            nnMetrics.setFsImageLoadTime((int)timeTakenToLoadFSImage);
        }
        return namesystem;
    }

    FSNamesystem(Configuration conf, NameNode namenode) throws IOException {
        try {
            DataChecksum.Type checksumType;
            this.provider = DFSUtil.createKeyProviderCryptoExtension(conf);
            if (this.provider == null) {
                LOG.info((Object)"No KeyProvider found.");
            } else {
                LOG.info((Object)("Found KeyProvider: " + this.provider.toString()));
            }
            this.conf = conf;
            this.nameNode = namenode;
            this.resourceRecheckInterval = conf.getLong("dfs.namenode.resource.check.interval", 5000L);
            this.blockManager = new BlockManager(this, conf);
            this.erasureCodingEnabled = ErasureCodingManager.isErasureCodingEnabled(conf);
            this.erasureCodingManager = new ErasureCodingManager(this, conf);
            DB_IN_MEMORY_BUCKET_SIZE = FSNamesystem.getDBFileInMemBucketSize();
            DB_ON_DISK_SMALL_BUCKET_SIZE = FSNamesystem.getDBFileSmallBucketSize();
            DB_ON_DISK_MEDIUM_BUCKET_SIZE = FSNamesystem.getDBFileMediumBucketSize();
            DB_ON_DISK_LARGE_BUCKET_SIZE = FSNamesystem.getDBFileLargeBucketSize();
            DB_MAX_SMALL_FILE_SIZE = conf.getInt("dfs.db.file.max.size", 65536);
            if (DB_IN_MEMORY_BUCKET_SIZE >= DB_ON_DISK_SMALL_BUCKET_SIZE || DB_ON_DISK_SMALL_BUCKET_SIZE >= DB_ON_DISK_MEDIUM_BUCKET_SIZE || DB_ON_DISK_MEDIUM_BUCKET_SIZE >= DB_ON_DISK_LARGE_BUCKET_SIZE) {
                throw new IllegalArgumentException("The size for the database files is not correctly set");
            }
            this.datanodeStatistics = this.blockManager.getDatanodeManager().getDatanodeStatistics();
            this.fsOwner = UserGroupInformation.getCurrentUser();
            this.superGroup = conf.get("dfs.permissions.superusergroup", "supergroup");
            this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
            this.blockPoolId = StorageInfo.getStorageInfoFromDB().getBlockPoolId();
            this.blockManager.setBlockPoolId(this.blockPoolId);
            this.hopSpecificInitialization(conf);
            this.quotaUpdateManager = new QuotaUpdateManager(this, conf);
            this.fsOperationsExecutor = Executors.newFixedThreadPool(conf.getInt("dfs.namenode.subtree-executor-limit", 80));
            FSDirDeleteOp.BIGGEST_DELETABLE_DIR = conf.getLong("dfs.dir.delete.batch.size", 50L);
            AbstractFileTree.SUBTREE_QUIESCE_LOCK_BATCH_SIZE = conf.getInt("dfs.subtree.quiesce.lock.batch.size.key", 1000);
            LOG.info((Object)("fsOwner             = " + this.fsOwner));
            LOG.info((Object)("superGroup          = " + this.superGroup));
            LOG.info((Object)("isPermissionEnabled = " + this.isPermissionEnabled));
            String checksumTypeStr = conf.get("dfs.checksum.type", "CRC32C");
            try {
                checksumType = DataChecksum.Type.valueOf((String)checksumTypeStr);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Invalid checksum type in dfs.checksum.type: " + checksumTypeStr);
            }
            this.serverDefaults = new FsServerDefaults(conf.getLongBytes("dfs.blocksize", 0x8000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096), conf.getBoolean("dfs.encrypt.data.transfer", false), conf.getLong("fs.trash.interval", 0L), checksumType, conf.getBoolean("dfs.namenode.quota.enabled", true));
            this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
            this.minBlockSize = conf.getLong("dfs.namenode.fs-limits.min-block-size", 0x100000L);
            this.maxBlocksPerFile = conf.getLong("dfs.namenode.fs-limits.max-blocks-per-file", 10240L);
            this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 3600000L);
            this.supportAppends = conf.getBoolean("dfs.support.append", true);
            LOG.info((Object)("Append Enabled: " + this.supportAppends));
            this.dtpReplaceDatanodeOnFailure = ReplaceDatanodeOnFailure.get(conf);
            this.alwaysUseDelegationTokensForTests = conf.getBoolean("dfs.namenode.delegation.token.always-use", false);
            this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
            this.dir = new FSDirectory(this, conf);
            this.cacheManager = new CacheManager(this, conf, this.blockManager);
            this.topConf = new TopConf(conf);
            this.auditLoggers = this.initAuditLoggers(conf);
            this.isDefaultAuditLogger = this.auditLoggers.size() == 1 && this.auditLoggers.get(0) instanceof DefaultAuditLogger;
            LightWeightCacheDistributed.enable = this.isRetryCacheEnabled = conf.getBoolean("dfs.namenode.enable.retrycache", true);
            this.slicerBatchSize = conf.getInt("dfs.namenode.slicer.batchsize", 500);
            this.slicerNbThreads = conf.getInt("dfs.namenode.slicer.nbofthreads", 20);
            this.maxDBTries = conf.getInt("dfs.namenode.db.check.max.tries", 3);
            DatanodeStorageInfo.BLOCKITERATOR_BATCH_SIZE = this.slicerBatchSize;
            this.leaseCreationLockRows = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
            this.dbReplicationFactor = (short)conf.getInt("dfs.db.replication", 1);
        }
        catch (IOException | RuntimeException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    @VisibleForTesting
    public List<AuditLogger> getAuditLoggers() {
        return this.auditLoggers;
    }

    boolean hasRetryCache() {
        return this.isRetryCacheEnabled;
    }

    public KeyProviderCryptoExtension getProvider() {
        return this.provider;
    }

    private List<AuditLogger> initAuditLoggers(Configuration conf) {
        Collection alClasses = conf.getStringCollection("dfs.namenode.audit.loggers");
        ArrayList auditLoggers = Lists.newArrayList();
        if (alClasses != null && !alClasses.isEmpty()) {
            for (String className : alClasses) {
                try {
                    AuditLogger logger = "default".equals(className) ? new DefaultAuditLogger() : (AuditLogger)Class.forName(className).newInstance();
                    logger.initialize(conf);
                    auditLoggers.add(logger);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (auditLoggers.isEmpty()) {
            auditLoggers.add(new DefaultAuditLogger());
        }
        if (this.topConf.isEnabled) {
            this.topMetrics = new TopMetrics(conf, this.topConf.nntopReportingPeriodsMs);
            auditLoggers.add(new TopAuditLogger(this.topMetrics));
        }
        return Collections.unmodifiableList(auditLoggers);
    }

    private void startSecretManager() {
        if (this.dtSecretManager != null) {
            try {
                this.dtSecretManager.startThreads();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startSecretManagerIfNecessary() throws IOException {
        boolean shouldRun = this.shouldUseDelegationTokens() && !this.isInSafeMode();
        boolean running = this.dtSecretManager.isRunning();
        if (shouldRun && !running) {
            this.startSecretManager();
        }
    }

    private void stopSecretManager() {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.stopThreads();
        }
    }

    void startCommonServices(Configuration conf) throws IOException {
        this.registerMBean();
        IDsMonitor.getInstance().start();
        RootINodeCache.start();
        this.nnResourceChecker = new NameNodeResourceChecker(conf);
        this.checkAvailableResources();
        if (this.isLeader()) {
            this.clearSafeBlocks();
            this.clearActiveBlockReports();
            HdfsVariables.setSafeModeInfo(new SafeModeInfo(conf), -1L);
            this.inSafeMode.set(true);
            assert (this.safeMode() != null && !this.isPopulatingReplQueues());
            StartupProgress prog = NameNode.getStartupProgress();
            prog.beginPhase(Phase.SAFEMODE);
            prog.setTotal(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS, this.getCompleteBlocksTotal());
            this.setBlockTotal();
        }
        this.shouldPopulateReplicationQueue = true;
        this.blockManager.activate(conf);
        if (this.dir.isQuotaEnabled()) {
            this.quotaUpdateManager.activate();
        }
        this.registerMXBean();
        DefaultMetricsSystem.instance().register((Object)this);
    }

    private void stopCommonServices() {
        if (this.blockManager != null) {
            this.blockManager.close();
        }
        if (this.quotaUpdateManager != null) {
            this.quotaUpdateManager.close();
        }
        RootINodeCache.stop();
    }

    void startActiveServices() throws IOException {
        this.startingActiveService = true;
        LOG.info((Object)"Starting services required for active state");
        LOG.info((Object)"Catching up to latest edits from old active before taking over writer role in edits logs");
        try {
            this.blockManager.getDatanodeManager().markAllDatanodesStale();
            if (!this.isInSafeMode()) {
                LOG.info((Object)"Reprocessing replication and invalidation queues");
                this.initializeReplQueues();
            } else if (this.isLeader()) {
                HdfsVariables.resetMisReplicatedIndex();
            }
            this.leaseManager.startMonitor();
            this.startSecretManagerIfNecessary();
            this.nnrmthread = new Daemon((Runnable)new NameNodeResourceMonitor());
            this.nnrmthread.start();
            if (this.isRetryCacheEnabled) {
                this.retryCacheCleanerThread = new Daemon((Runnable)new RetryCacheCleaner());
                this.retryCacheCleanerThread.setName("Retry Cache Cleaner");
                this.retryCacheCleanerThread.start();
            }
            if (this.erasureCodingEnabled) {
                this.erasureCodingManager.activate();
            }
            if (this.cacheManager != null) {
                this.cacheManager.startMonitorThread();
            }
        }
        finally {
            this.startingActiveService = false;
            this.checkSafeMode();
        }
    }

    private void initializeReplQueues() throws IOException {
        LOG.info((Object)"initializing replication queues");
        this.blockManager.processMisReplicatedBlocks();
        this.initializedReplQueues = true;
    }

    public boolean inTransitionToActive() {
        return this.startingActiveService;
    }

    private boolean shouldUseDelegationTokens() {
        return UserGroupInformation.isSecurityEnabled() || this.alwaysUseDelegationTokensForTests;
    }

    void stopActiveServices() {
        LOG.info((Object)"Stopping services started for active state");
        this.stopSecretManager();
        this.leaseManager.stopMonitor();
        if (this.nnrmthread != null) {
            ((NameNodeResourceMonitor)this.nnrmthread.getRunnable()).stopMonitor();
            this.nnrmthread.interrupt();
        }
        if (this.retryCacheCleanerThread != null) {
            ((RetryCacheCleaner)this.retryCacheCleanerThread.getRunnable()).stopMonitor();
            this.retryCacheCleanerThread.interrupt();
        }
        if (this.erasureCodingManager != null) {
            this.erasureCodingManager.close();
        }
        if (this.cacheManager != null) {
            this.cacheManager.stopMonitorThread();
        }
    }

    private void checkNameNodeSafeMode(String errorMsg) throws RetriableException, SafeModeException, IOException {
        if (this.isInSafeMode()) {
            SafeModeInfo safeMode = this.safeMode();
            SafeModeException se = new SafeModeException(errorMsg, safeMode);
            if (this.shouldRetrySafeMode(safeMode)) {
                throw new RetriableException((Exception)se);
            }
            throw se;
        }
    }

    boolean isPermissionEnabled() {
        return this.isPermissionEnabled;
    }

    private boolean shouldRetrySafeMode(SafeModeInfo safeMode) {
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow();
    }

    NamespaceInfo getNamespaceInfo() throws IOException {
        return this.unprotectedGetNamespaceInfo();
    }

    private NamespaceInfo unprotectedGetNamespaceInfo() throws IOException {
        StorageInfo storageInfo = StorageInfo.getStorageInfoFromDB();
        return new NamespaceInfo(storageInfo.getNamespaceID(), this.getClusterId(), this.getBlockPoolId(), storageInfo.getCTime());
    }

    void close() {
        this.fsRunning = false;
        try {
            this.stopCommonServices();
            if (this.smmthread != null) {
                this.smmthread.interrupt();
            }
            this.fsOperationsExecutor.shutdownNow();
        }
        catch (Throwable throwable) {
            try {
                this.stopActiveServices();
                if (this.dir != null) {
                    this.dir.close();
                }
            }
            catch (IOException ie) {
                LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
            }
            throw throwable;
        }
        try {
            this.stopActiveServices();
            if (this.dir != null) {
                this.dir.close();
            }
        }
        catch (IOException ie) {
            LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
        }
    }

    @Override
    public boolean isRunning() {
        return this.fsRunning;
    }

    FsServerDefaults getServerDefaults() {
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        HdfsFileStatus auditStat;
        try {
            this.checkNameNodeSafeMode("Cannot set permission for " + src);
            auditStat = FSDirAttrOp.setPermission(this.dir, src, permission);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setPermission", src);
            throw e;
        }
        this.logAuditEvent(true, "setPermission", src, null, auditStat);
    }

    void setOwner(String src, String username, String group) throws IOException {
        HdfsFileStatus auditStat;
        try {
            this.checkNameNodeSafeMode("Cannot set owner for " + src);
            auditStat = FSDirAttrOp.setOwner(this.dir, src, username, group);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setOwner", src);
            throw e;
        }
        this.logAuditEvent(true, "setOwner", src, null, auditStat);
    }

    public LocatedBlocks getBlockLocations(String clientMachine, String srcArg, long offset, long length) throws IOException {
        LocatedBlocks result = null;
        try {
            try {
                result = this.getBlockLocationsWithLock(clientMachine, srcArg, offset, length, TransactionLockTypes.INodeLockType.READ);
            }
            catch (LockUpgradeException e) {
                LOG.debug((Object)("Encountered LockUpgradeException while reading " + srcArg + ". Retrying the operation using exclusive locks"));
                result = this.getBlockLocationsWithLock(clientMachine, srcArg, offset, length, TransactionLockTypes.INodeLockType.WRITE);
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "open", srcArg);
            throw e;
        }
        this.logAuditEvent(true, "open", srcArg);
        return result;
    }

    LocatedBlocks getBlockLocationsWithLock(final String clientMachine, final String srcArg, final long offset, final long length, final TransactionLockTypes.INodeLockType lockType) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        final boolean isSuperUser = this.dir.getPermissionChecker().isSuperUser();
        HopsTransactionalRequestHandler getBlockLocationsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_LOCATIONS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(lockType, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                if (isSuperUser) {
                    locks.add(lf.getXAttrLock());
                } else {
                    locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                }
            }

            public Object performTask() throws IOException {
                LocatedBlocks blocks;
                GetBlockLocationsResult res = null;
                res = FSNamesystem.this.getBlockLocationsInt(srcArg, src, offset, length, true, true);
                if (res.updateAccessTime()) {
                    long now = Time.now();
                    try {
                        boolean updateAccessTime;
                        INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(src, true);
                        INode inode = iip.getLastINode();
                        boolean bl = updateAccessTime = inode != null && now > inode.getAccessTime() + FSNamesystem.this.getAccessTimePrecision();
                        if (!FSNamesystem.this.isInSafeMode() && updateAccessTime) {
                            boolean bl2 = FSDirAttrOp.setTimes(FSNamesystem.this.dir, inode, -1L, now, false);
                        }
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)("Failed to update the access time of " + src), e);
                    }
                }
                if ((blocks = res.blocks) != null && !blocks.hasPhantomBlock()) {
                    FSNamesystem.this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, blocks.getLocatedBlocks());
                    LocatedBlock lastBlock = blocks.getLastLocatedBlock();
                    if (lastBlock != null) {
                        ArrayList lastBlockList = Lists.newArrayList((Object[])new LocatedBlock[]{lastBlock});
                        FSNamesystem.this.blockManager.getDatanodeManager().sortLocatedBlocks(clientMachine, lastBlockList);
                    }
                }
                return blocks;
            }
        };
        return (LocatedBlocks)getBlockLocationsHandler.handle(this);
    }

    public GetBlockLocationsResult getBlockLocations(final String srcArg, final long offset, final long length, final boolean needBlockToken, final boolean checkSafeMode) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        final boolean isSuperUser = this.dir.getPermissionChecker().isSuperUser();
        HopsTransactionalRequestHandler getBlockLocationsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_LOCATIONS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.CA));
                locks.add(lf.getEZLock());
                if (isSuperUser) {
                    locks.add(lf.getXAttrLock());
                } else {
                    locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                }
            }

            public Object performTask() throws IOException {
                return FSNamesystem.this.getBlockLocationsInt(srcArg, src, offset, length, needBlockToken, checkSafeMode);
            }
        };
        return (GetBlockLocationsResult)getBlockLocationsHandler.handle(this);
    }

    private GetBlockLocationsResult getBlockLocationsInt(String srcArg, String src, long offset, long length, boolean needBlockToken, boolean checkSafeMode) throws IOException {
        GetBlockLocationsResult ret;
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        INodeFile inodeFile = INodeFile.valueOf(this.dir.getINode(src), src);
        if (inodeFile.isFileStoredInDB()) {
            LOG.debug((Object)"SMALL_FILE The file is stored in the database. Returning Phantom Blocks");
            ret = this.getPhantomBlockLocationsUpdateTimes(srcArg, src, needBlockToken);
        } else {
            ret = this.getBlockLocationsInt(srcArg, src, offset, length, needBlockToken);
        }
        if (checkSafeMode && this.isInSafeMode()) {
            for (LocatedBlock b : ret.blocks.getLocatedBlocks()) {
                if (b.getLocations() != null && b.getLocations().length != 0) continue;
                SafeModeException se = new SafeModeException("Zero blocklocations for " + src, this.safeMode());
                throw new RetriableException((Exception)se);
            }
        }
        inodeFile.logProvenanceEvent(this.getNamenodeId(), FileProvenanceEntry.Operation.getBlockLocations());
        return ret;
    }

    private GetBlockLocationsResult getPhantomBlockLocationsUpdateTimes(String srcArg, String src, boolean needBlockToken) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        INodesInPath iip = this.dir.getINodesInPath(src, true);
        INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
        if (this.isPermissionEnabled) {
            this.dir.checkPathAccess(pc, iip, FsAction.READ);
            this.checkUnreadableBySuperuser(pc, inode);
        }
        FileEncryptionInfo feInfo = FSDirectory.isReservedRawName(srcArg) ? null : this.dir.getFileEncryptionInfo(inode, iip);
        LocatedBlocks blocks = this.blockManager.createPhantomLocatedBlocks(inode, inode.getFileDataInDB(), inode.isUnderConstruction(), needBlockToken, feInfo);
        long now = Time.now();
        boolean updateAccessTime = this.isAccessTimeSupported() && !this.isInSafeMode() && now > inode.getAccessTime() + this.getAccessTimePrecision();
        return new GetBlockLocationsResult(updateAccessTime, blocks);
    }

    private GetBlockLocationsResult getBlockLocationsInt(String srcArg, String src, long offset, long length, boolean needBlockToken) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        INodesInPath iip = this.dir.getINodesInPath(src, true);
        INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
        if (this.isPermissionEnabled) {
            this.dir.checkPathAccess(pc, iip, FsAction.READ);
            this.checkUnreadableBySuperuser(pc, inode);
        }
        long fileSize = inode.computeFileSizeNotIncludingLastUcBlock();
        boolean isUc = inode.isUnderConstruction();
        FileEncryptionInfo feInfo = FSDirectory.isReservedRawName(srcArg) ? null : this.dir.getFileEncryptionInfo(inode, iip);
        LocatedBlocks blocks = this.blockManager.createLocatedBlocks(inode.getBlocks(), fileSize, isUc, offset, length, needBlockToken, feInfo);
        for (LocatedBlock lb : blocks.getLocatedBlocks()) {
            this.cacheManager.setCachedLocations(lb, inode.getId());
        }
        long now = Time.now();
        boolean updateAccessTime = this.isAccessTimeSupported() && !this.isInSafeMode() && now > inode.getAccessTime() + this.getAccessTimePrecision();
        return new GetBlockLocationsResult(updateAccessTime, blocks);
    }

    private void checkUnreadableBySuperuser(FSPermissionChecker pc, INode inode) throws IOException {
        if (pc.isSuperUser()) {
            for (XAttr xattr : FSDirXAttrOp.getXAttrs(inode)) {
                if (!XAttrHelper.getPrefixName(xattr).equals("security.hdfs.unreadable.by.superuser") || !pc.isSuperUser()) continue;
                throw new AccessControlException("Access is denied for " + pc.getUser() + " since the superuser is not allowed to perform this operation.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs) throws IOException {
        this.checkNameNodeSafeMode("Cannot concat " + target);
        HdfsFileStatus stat = null;
        boolean success = false;
        try {
            stat = FSDirConcatOp.concat(this.dir, target, srcs);
            success = true;
        }
        finally {
            this.logAuditEvent(success, "concat", Arrays.toString(srcs), target, stat);
        }
    }

    void setTimes(String src, long mtime, long atime) throws IOException {
        HdfsFileStatus auditStat;
        try {
            auditStat = FSDirAttrOp.setTimes(this.dir, src, mtime, atime);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setTimes", src);
            throw e;
        }
        this.logAuditEvent(true, "setTimes", src, null, auditStat);
    }

    void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot create symlink " + link);
            auditStat = FSDirSymlinkOp.createSymlinkInt(this, target, link, dirPerms, createParent);
            if (auditStat == null) {
                return;
            }
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createSymlink", link, target, null);
            throw e;
        }
        this.logAuditEvent(true, "createSymlink", link, target, auditStat);
    }

    boolean setReplication(String src, short replication) throws IOException {
        boolean success = false;
        try {
            this.checkNameNodeSafeMode("Cannot set replication for " + src);
            success = FSDirAttrOp.setReplication(this.dir, this.blockManager, src, replication);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setReplication", src);
            throw e;
        }
        if (success) {
            this.logAuditEvent(true, "setReplication", src);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMetaStatus(String srcArg, final MetaStatus metaStatus) throws IOException {
        final FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        INodeIdentifier stoRootINode = null;
        try {
            stoRootINode = this.lockSubtree(src, SubTreeOperation.Type.META_ENABLE_STO);
            if (stoRootINode == null) {
                throw new FileNotFoundException("Directory does not exist " + src);
            }
            final AbstractFileTree.FileTree fileTree = this.buildTreeForLogging(stoRootINode, metaStatus.isMetaEnabled());
            new HopsTransactionalRequestHandler(HDFSOperationType.SET_META_ENABLED, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    long stoRootINodeId = (Long)this.getParams()[0];
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    il.setIgnoredSTOInodes(stoRootINodeId);
                    locks.add((Lock)il);
                    locks.add(lf.getAcesLock());
                }

                public Object performTask() throws IOException {
                    try {
                        INodesInPath iip = FSNamesystem.this.dir.getINodesInPath4Write(src);
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
                        FSNamesystem.this.setMetaStatusInt(src, fileTree, metaStatus);
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "setMetaEnabled", src);
                        throw e;
                    }
                    return null;
                }
            }.setParams(new Object[]{stoRootINode.getInodeId()}).handle((Object)this);
            if (metaStatus.isMetaEnabled()) {
                this.logMetadataEvents(fileTree);
            }
        }
        finally {
            if (stoRootINode != null) {
                this.unlockSubtree(src, stoRootINode.getInodeId());
            }
        }
    }

    private AbstractFileTree.FileTree buildTreeForLogging(INodeIdentifier inode, boolean metaEnabled) throws IOException {
        if (!metaEnabled) {
            return null;
        }
        AbstractFileTree.FileTree fileTree = new AbstractFileTree.FileTree(this, inode);
        fileTree.buildUp(this.getBlockManager().getStoragePolicySuite());
        return fileTree;
    }

    private void setMetaStatusInt(String src, AbstractFileTree.FileTree fileTree, MetaStatus metaStatus) throws IOException {
        this.checkNameNodeSafeMode("Cannot set metaEnabled for " + src);
        INode targetNode = this.getINode(src);
        if (!targetNode.isDirectory()) {
            throw new FileNotFoundException(src + ": Is not a directory");
        }
        INodeDirectory dirNode = (INodeDirectory)targetNode;
        dirNode.setMetaStatus(metaStatus);
        if (metaStatus.isMetaEnabled()) {
            dirNode.incrementLogicalTime();
            INodeMetadataLogEntry dslogEntry = new INodeMetadataLogEntry(dirNode.getId(), dirNode.getId(), dirNode.getPartitionId().longValue(), dirNode.getParentId(), dirNode.getLocalName(), dirNode.getLogicalTime(), INodeMetadataLogEntry.Operation.Add);
            EntityManager.add((Object)dslogEntry);
            if (dirNode.getNumUserXAttrs() > 0) {
                dirNode.incrementLogicalTime();
                XAttrMetadataLogEntry xattrLogEntry = new XAttrMetadataLogEntry(dirNode.getId(), dirNode.getId(), dirNode.getLogicalTime(), dirNode.getPartitionId().longValue(), dirNode.getParentId(), dirNode.getLocalName());
                EntityManager.add((Object)xattrLogEntry);
            }
        }
        EntityManager.update((Object)dirNode);
    }

    private void logMetadataEvents(AbstractFileTree.FileTree fileTree) throws IOException {
        final ProjectedINode dataSetDir = fileTree.getSubtreeRoot();
        final ArrayList<ProjectedINode> children = new ArrayList<ProjectedINode>(fileTree.getAllChildren());
        try {
            Slicer.slice((int)children.size(), (int)this.getSlicerBatchSize(), (int)this.getSlicerNbThreads(), (ExecutorService)this.getFSOperationsExecutor(), (Slicer.OperationHandler)new Slicer.OperationHandler(){

                public void handle(final int startIndex, final int endIndex) throws Exception {
                    new HopsTransactionalRequestHandler(HDFSOperationType.ADD_METADATA_LOG_ENTRIES){

                        public void acquireLock(TransactionLocks locks) {
                        }

                        public Object performTask() throws IOException {
                            List subList = children.subList(startIndex, endIndex);
                            ArrayList<INodeMetadataLogEntry> logEntries = new ArrayList<INodeMetadataLogEntry>(subList.size());
                            for (ProjectedINode node : subList) {
                                node.incrementLogicalTime();
                                INodeMetadataLogEntry logEntry = new INodeMetadataLogEntry(dataSetDir.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.getLogicalTime(), INodeMetadataLogEntry.Operation.Add);
                                EntityManager.add((Object)logEntry);
                                if (node.getNumUserXAttrs() > 0) {
                                    node.incrementLogicalTime();
                                    XAttrMetadataLogEntry xattrLogEntry = new XAttrMetadataLogEntry(dataSetDir.getId(), node.getId(), node.getLogicalTime(), node.getPartitionId(), node.getParentId(), node.getName());
                                    EntityManager.add((Object)xattrLogEntry);
                                    logEntry = new INodeMetadataLogEntry(dataSetDir.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.getLogicalTime(), INodeMetadataLogEntry.Operation.Add);
                                }
                                logEntries.add(logEntry);
                            }
                            AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
                            return null;
                        }
                    }.handle();
                }
            });
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
    }

    boolean truncate(String src, long newLength, String clientName, String clientMachine, long mtime) throws IOException, UnresolvedLinkException {
        boolean ret;
        try {
            ret = this.truncateInt(src, newLength, clientName, clientMachine, mtime);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "truncate", src);
            throw e;
        }
        return ret;
    }

    boolean truncateInt(String srcArg, final long newLength, final String clientName, final String clientMachine, final long mtime) throws IOException, UnresolvedLinkException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.truncate: src=" + srcArg + " newLength=" + newLength);
        }
        if (newLength < 0L) {
            throw new HadoopIllegalArgumentException("Cannot truncate to a negative file size: " + newLength + ".");
        }
        final FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TRUNCATE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.getNamenodeId()).setActiveNameNodes(FSNamesystem.this.getNameNode().getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV, LockFactory.BLK.PE)).add(lf.getAllUsedHashBucketsLock());
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, clientName, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE));
                if (FSNamesystem.this.isErasureCodingEnabled()) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, src));
                }
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
            }

            public Object performTask() throws IOException {
                INode.BlocksMapUpdateInfo toRemoveBlocks = new INode.BlocksMapUpdateInfo();
                HdfsFileStatus stat = null;
                FSNamesystem.this.checkNameNodeSafeMode("Cannot truncate for " + src);
                boolean res = FSNamesystem.this.truncateInternal(src, newLength, clientName, clientMachine, mtime, pc, toRemoveBlocks);
                stat = FSNamesystem.this.dir.getAuditFileInfo(FSNamesystem.this.dir.getINodesInPath4Write(src, false));
                FSNamesystem.this.logAuditEvent(true, "truncate", src, null, stat);
                if (!toRemoveBlocks.getToDeleteList().isEmpty()) {
                    FSNamesystem.this.removeBlocks(toRemoveBlocks);
                    toRemoveBlocks.clear();
                }
                return res;
            }
        }.handle();
    }

    boolean truncateInternal(String src, long newLength, String clientName, String clientMachine, long mtime, FSPermissionChecker pc, INode.BlocksMapUpdateInfo toRemoveBlocks) throws IOException, UnresolvedLinkException {
        long truncateLength;
        Block truncateBlock;
        INodeFile file;
        BlockInfoContiguous last;
        INodesInPath iip = this.dir.getINodesInPath4Write(src, true);
        if (this.isPermissionEnabled) {
            this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
        }
        if ((last = (file = INodeFile.valueOf(iip.getLastINode(), src)).getLastBlock()) != null && last.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY && (truncateBlock = ((BlockInfoContiguousUnderConstruction)last).getTruncateBlock()) != null && newLength == (truncateLength = file.computeFileSize(false, false) + truncateBlock.getNumBytes())) {
            return false;
        }
        this.recoverLeaseInternal(RecoverLeaseOp.TRUNCATE_FILE, iip, src, clientName, clientMachine, false);
        long oldLength = file.computeFileSize();
        if (oldLength == newLength) {
            return true;
        }
        if (oldLength < newLength) {
            throw new HadoopIllegalArgumentException("Cannot truncate to a larger file size. Current size: " + oldLength + ", truncate size: " + newLength + ".");
        }
        QuotaCounts delta = new QuotaCounts.Builder().build();
        boolean onBlockBoundary = this.dir.truncate(iip, newLength, toRemoveBlocks, mtime, delta);
        Block truncateBlock2 = null;
        if (file.isFileStoredInDB()) {
            int newLengthInt = (int)newLength;
            byte[] oldData = file.getFileDataInDB();
            byte[] newData = new byte[newLengthInt];
            System.arraycopy(oldData, 0, newData, 0, newLengthInt);
            file.deleteFileDataStoredInDB();
            file.storeFileDataInDB(newData);
            file.setSize(newData.length);
            long ssDelta = newLengthInt - oldData.length;
            this.dir.updateSpaceConsumed(iip, 0L, ssDelta, file.getBlockReplication());
            return true;
        }
        if (!onBlockBoundary) {
            long lastBlockDelta = file.computeFileSize() - newLength;
            assert (lastBlockDelta > 0L) : "delta is 0 only if on block bounday";
            truncateBlock2 = this.prepareFileForTruncate(iip, clientName, clientMachine, lastBlockDelta, null);
        }
        this.dir.updateCountNoQuotaCheck(iip, iip.length() - 1, delta);
        file.recomputeFileSize();
        return onBlockBoundary;
    }

    Block prepareFileForTruncate(INodesInPath iip, String leaseHolder, String clientMachine, long lastBlockDelta, Block newBlock) throws IOException {
        BlockInfoContiguousUnderConstruction truncatedBlockUC;
        INodeFile file = iip.getLastINode().asFile();
        String src = iip.getPath();
        file.toUnderConstruction(leaseHolder, clientMachine);
        assert (file.isUnderConstruction()) : "inode should be under construction.";
        this.leaseManager.addLease(file.getFileUnderConstructionFeature().getClientName(), src);
        boolean shouldRecoverNow = newBlock == null;
        BlockInfoContiguous oldBlock = file.getLastBlock();
        boolean shouldCopyOnTruncate = this.shouldCopyOnTruncate(file, oldBlock);
        if (newBlock == null) {
            Block block = newBlock = shouldCopyOnTruncate ? this.createNewBlock(file) : new Block(oldBlock.getBlockId(), oldBlock.getNumBytes(), (long)file.nextGenerationStamp());
        }
        if (shouldCopyOnTruncate) {
            truncatedBlockUC = new BlockInfoContiguousUnderConstruction(newBlock, file.getBlockReplication());
            truncatedBlockUC.setNumBytes(oldBlock.getNumBytes() - lastBlockDelta);
            truncatedBlockUC.setTruncateBlock(oldBlock);
            file.setLastBlock(truncatedBlockUC, this.blockManager.getStorages(oldBlock));
            this.getBlockManager().addBlockCollection(truncatedBlockUC, file);
            NameNode.stateChangeLog.info("BLOCK* prepareFileForTruncate: Scheduling copy-on-truncate to new size " + truncatedBlockUC.getNumBytes() + " new block " + newBlock + " old block " + truncatedBlockUC.getTruncateBlock());
        } else {
            this.blockManager.convertLastBlockToUnderConstruction(file, lastBlockDelta);
            oldBlock = file.getLastBlock();
            assert (!oldBlock.isComplete()) : "oldBlock should be under construction";
            truncatedBlockUC = (BlockInfoContiguousUnderConstruction)oldBlock;
            truncatedBlockUC.setTruncateBlock(new Block((Block)oldBlock));
            truncatedBlockUC.getTruncateBlock().setNumBytesNoPersistance(oldBlock.getNumBytes() - lastBlockDelta);
            truncatedBlockUC.getTruncateBlock().setGenerationStampNoPersistance(newBlock.getGenerationStamp());
            NameNode.stateChangeLog.debug("BLOCK* prepareFileForTruncate: Scheduling in-place block truncate to new size " + truncatedBlockUC.getTruncateBlock().getNumBytes() + " block=" + (Object)((Object)truncatedBlockUC) + " recoveryID= " + newBlock.getGenerationStamp());
        }
        if (shouldRecoverNow) {
            truncatedBlockUC.initializeBlockRecovery(newBlock.getGenerationStamp(), this.getBlockManager().getDatanodeManager());
        }
        return newBlock;
    }

    boolean shouldCopyOnTruncate(INodeFile file, BlockInfoContiguous blk) {
        return false;
    }

    void setStoragePolicy(String src, String policyName) throws IOException {
        HdfsFileStatus auditStat;
        try {
            this.checkNameNodeSafeMode("Cannot set storage policy for " + src);
            auditStat = FSDirAttrOp.setStoragePolicy(this.dir, this.blockManager, src, policyName);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setStoragePolicy", src);
            throw e;
        }
        this.logAuditEvent(true, "setStoragePolicy", src, null, auditStat);
    }

    BlockStoragePolicy getDefaultStoragePolicy() throws IOException {
        return this.blockManager.getDefaultStoragePolicy();
    }

    BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        return this.blockManager.getStoragePolicy(storagePolicyID);
    }

    BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return FSDirAttrOp.getStoragePolicies(this.blockManager);
    }

    long getPreferredBlockSize(String src) throws IOException {
        return FSDirAttrOp.getPreferredBlockSize(this.dir, src);
    }

    private CryptoProtocolVersion chooseProtocolVersion(EncryptionZone zone, CryptoProtocolVersion[] supportedVersions) throws UnknownCryptoProtocolVersionException, UnresolvedLinkException {
        Preconditions.checkNotNull((Object)zone);
        Preconditions.checkNotNull((Object)supportedVersions);
        CryptoProtocolVersion required = zone.getVersion();
        for (CryptoProtocolVersion c : supportedVersions) {
            if (c.equals((Object)CryptoProtocolVersion.UNKNOWN)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring unknown CryptoProtocolVersion provided by client: " + c.getUnknownValue()));
                continue;
            }
            if (!c.equals((Object)required)) continue;
            return c;
        }
        throw new UnknownCryptoProtocolVersionException("No crypto protocol versions provided by the client are supported. Client provided: " + Arrays.toString(supportedVersions) + " NameNode supports: " + Arrays.toString(CryptoProtocolVersion.values()));
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedDataEncryptionKey(String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = null;
        try {
            edek = this.provider.generateEncryptedKey(ezKeyName);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    HdfsFileStatus startFile(final String srcArg, final PermissionStatus permissions, final String holder, final String clientMachine, final EnumSet<CreateFlag> flag, final boolean createParent, final short replication, final long blockSize, final CryptoProtocolVersion[] supportedVersions) throws IOException {
        HdfsFileStatus stat = null;
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final CryptoProtocolVersion[] protocolVersion = new CryptoProtocolVersion[1];
        final CipherSuite[] suite = new CipherSuite[]{null};
        final String[] ezKeyName = new String[]{null};
        final KeyProviderCryptoExtension.EncryptedKeyVersion[] edek = new KeyProviderCryptoExtension.EncryptedKeyVersion[]{null};
        FSPermissionChecker pc = this.getPermissionChecker();
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        if (this.provider != null) {
            new HopsTransactionalRequestHandler(HDFSOperationType.START_FILE, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                    locks.add((Lock)il);
                    locks.add(lf.getEZLock());
                }

                public Object performTask() throws IOException {
                    INodesInPath iip = FSNamesystem.this.dir.getINodesInPath4Write(src);
                    EncryptionZone zone = FSNamesystem.this.dir.getEZForPath(iip);
                    if (zone != null) {
                        protocolVersion[0] = FSNamesystem.this.chooseProtocolVersion(zone, supportedVersions);
                        suite[0] = zone.getSuite();
                        ezKeyName[0] = zone.getKeyName();
                        Preconditions.checkNotNull((Object)protocolVersion);
                        Preconditions.checkNotNull((Object)suite);
                        Preconditions.checkArgument((!suite.equals(CipherSuite.UNKNOWN) ? 1 : 0) != 0, (Object)"Chose an UNKNOWN CipherSuite!");
                        Preconditions.checkNotNull((Object)ezKeyName);
                    }
                    return null;
                }
            }.handle(this);
            Preconditions.checkState((suite == null && ezKeyName == null || suite != null && ezKeyName != null ? 1 : 0) != 0, (Object)"Both suite and ezKeyName should both be null or not null");
            edek[0] = this.generateEncryptedDataEncryptionKey(ezKeyName[0]);
            EncryptionFaultInjector.getInstance().startFileAfterGenerateKey();
        }
        stat = (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.START_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock());
                LeaseLock leaseLock = (LeaseLock)lf.getLeaseLockSinglePath(TransactionLockTypes.LockType.WRITE, holder, src, FSNamesystem.this.leaseCreationLockRows);
                locks.add((Lock)leaseLock).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV));
                locks.add(lf.getAllUsedHashBucketsLock());
                if (FSNamesystem.this.isRetryCacheEnabled) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                if (flag.contains(CreateFlag.OVERWRITE) && FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, src));
                }
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO);
                xAttrsToLock.add(FSDirXAttrOp.XATTR_ENCRYPTION_ZONE);
                locks.add(lf.getXAttrLock(xAttrsToLock));
            }

            public Object performTask() throws IOException {
                byte[] statusArray;
                HdfsFileStatus hdfsFileStatus;
                boolean success = false;
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    HdfsFileStatus test = PBHelper.convert(HdfsProtos.HdfsFileStatusProto.parseFrom(cacheEntry.getPayload()));
                    return test;
                }
                if (NameNode.stateChangeLog.isInfoEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", createFlag=" + flag.toString() + ", blockSize=" + blockSize);
                    builder.append(", supportedVersions=");
                    if (supportedVersions != null) {
                        builder.append(Arrays.toString(supportedVersions));
                    } else {
                        builder.append("null");
                    }
                    NameNode.stateChangeLog.info(builder.toString());
                }
                HdfsFileStatus status = null;
                try {
                    FSNamesystem.this.checkNameNodeSafeMode("Cannot create file" + src);
                    status = FSNamesystem.this.startFileInt(srcArg, src, permissions, holder, clientMachine, flag, createParent, replication, blockSize, suite[0], protocolVersion[0], edek[0]);
                    if (status != null) {
                        success = true;
                    }
                    hdfsFileStatus = status;
                    statusArray = status == null ? null : PBHelper.convert(status).toByteArray();
                }
                catch (AccessControlException e) {
                    try {
                        FSNamesystem.this.logAuditEvent(false, "create", src);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        byte[] statusArray2 = status == null ? null : PBHelper.convert(status).toByteArray();
                        LightWeightCacheDistributed.put(statusArray2, success);
                        throw throwable;
                    }
                }
                LightWeightCacheDistributed.put(statusArray, success);
                return hdfsFileStatus;
            }
        }.handle(this);
        this.logAuditEvent(true, "create", srcArg, null, stat);
        return stat;
    }

    private HdfsFileStatus startFileInt(String srcArg, String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize, CipherSuite suite, CryptoProtocolVersion version, KeyProviderCryptoExtension.EncryptedKeyVersion edek) throws IOException, RetryStartFileException {
        FSPermissionChecker pc = this.getPermissionChecker();
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException(src);
        }
        this.blockManager.verifyReplication(src, replication, clientMachine);
        if (blockSize < this.minBlockSize) {
            throw new IOException("Specified block size is less than configured minimum value (dfs.namenode.fs-limits.min-block-size): " + blockSize + " < " + this.minBlockSize);
        }
        boolean create = flag.contains(CreateFlag.CREATE);
        boolean overwrite = flag.contains(CreateFlag.OVERWRITE);
        INodesInPath iip = this.dir.getINodesInPath4Write(src);
        this.startFileInternal(pc, iip, permissions, holder, clientMachine, create, overwrite, createParent, replication, blockSize, suite, version, edek);
        HdfsFileStatus stat = FSDirStatAndListingOp.getFileInfo(this.dir, src, false, FSDirectory.isReservedRawName(srcArg), true);
        this.logAuditEvent(true, "create", src, null, this.isAuditEnabled() && this.isExternalInvocation() ? stat : null);
        return stat;
    }

    private void startFileInternal(FSPermissionChecker pc, INodesInPath iip, PermissionStatus permissions, String holder, String clientMachine, boolean create, boolean overwrite, boolean createParent, short replication, long blockSize, CipherSuite suite, CryptoProtocolVersion version, KeyProviderCryptoExtension.EncryptedKeyVersion edek) throws RetryStartFileException, IOException {
        INode inode = iip.getLastINode();
        String src = iip.getPath();
        if (inode != null && inode.isDirectory()) {
            throw new FileAlreadyExistsException(src + " already exists as a directory");
        }
        FileEncryptionInfo feInfo = null;
        EncryptionZone zone = this.dir.getEZForPath(iip);
        if (zone != null) {
            if (suite == null || edek == null) {
                throw new RetryStartFileException();
            }
            String ezKeyName = zone.getKeyName();
            if (!ezKeyName.equals(edek.getEncryptionKeyName())) {
                throw new RetryStartFileException();
            }
            feInfo = new FileEncryptionInfo(suite, version, edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        INodeFile myFile = INodeFile.valueOf(inode, src, true);
        if (this.isPermissionEnabled) {
            if (overwrite && myFile != null) {
                this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            this.dir.checkAncestorAccess(pc, iip, FsAction.WRITE);
        }
        if (!createParent) {
            this.dir.verifyParentDir(iip, src);
        }
        try {
            if (myFile == null) {
                if (!create) {
                    throw new FileNotFoundException("Can't overwrite non-existent " + src + " for client " + clientMachine);
                }
            } else if (overwrite) {
                try {
                    FSDirDeleteOp.deleteInternal(this, src, iip);
                    iip = INodesInPath.replace(iip, iip.length() - 1, null);
                }
                catch (AccessControlException e) {
                    this.logAuditEvent(false, "delete", src);
                    throw e;
                }
            } else {
                this.recoverLeaseInternal(RecoverLeaseOp.CREATE_FILE, iip, src, holder, clientMachine, false);
                throw new FileAlreadyExistsException(src + " for client " + clientMachine + " already exists");
            }
            this.checkFsObjectLimit();
            INodeFile newNode = null;
            Map.Entry<INodesInPath, String> parent = FSDirMkdirOp.createAncestorDirectories(this.dir, iip, permissions);
            if (parent != null) {
                iip = this.dir.addFile(parent.getKey(), parent.getValue(), permissions, replication, blockSize, holder, clientMachine);
                INodeFile iNodeFile = newNode = iip != null ? iip.getLastINode().asFile() : null;
            }
            if (newNode == null) {
                throw new IOException("Unable to add " + src + " to namespace");
            }
            this.leaseManager.addLease(newNode.getFileUnderConstructionFeature().getClientName(), src);
            if (feInfo != null) {
                this.dir.setFileEncryptionInfo(src, feInfo);
                newNode = this.dir.getInode(newNode.getId()).asFile();
            }
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* NameSystem.startFile: added " + src + " inode " + newNode.getId() + " " + holder);
            }
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn("DIR* NameSystem.startFile: " + src + " " + ie.getMessage());
            throw ie;
        }
    }

    private LocatedBlock appendFileInternal(FSPermissionChecker pc, INodesInPath iip, String holder, String clientMachine, boolean newBlock) throws IOException {
        INode inode = iip.getLastINode();
        String src = iip.getPath();
        if (inode != null && inode.isDirectory()) {
            throw new FileAlreadyExistsException("Cannot append to directory " + src + "; already exists as a directory.");
        }
        if (this.isPermissionEnabled) {
            this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
        }
        try {
            if (inode == null) {
                throw new FileNotFoundException("failed to append to non-existent file " + src + " for client " + clientMachine);
            }
            INodeFile myFile = INodeFile.valueOf(inode, src, true);
            this.recoverLeaseInternal(RecoverLeaseOp.APPEND_FILE, iip, src, holder, clientMachine, false);
            BlockInfoContiguous lastBlock = myFile.getLastBlock();
            if (lastBlock != null && lastBlock.isComplete() && !this.getBlockManager().isSufficientlyReplicated(lastBlock)) {
                throw new IOException("append: lastBlock=" + (Object)((Object)lastBlock) + " of src=" + src + " is not sufficiently replicated yet.");
            }
            return this.prepareFileForAppend(src, iip, holder, clientMachine, newBlock);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn("DIR* NameSystem.append: " + ie.getMessage());
            throw ie;
        }
    }

    LocatedBlock prepareFileForAppend(String src, INodesInPath iip, String leaseHolder, String clientMachine, boolean newBlock) throws IOException {
        INodeFile file = iip.getLastINode().asFile();
        QuotaCounts delta = this.verifyQuotaForUCBlock(file, iip);
        file.toUnderConstruction(leaseHolder, clientMachine);
        Lease lease = this.leaseManager.addLease(file.getFileUnderConstructionFeature().getClientName(), src);
        if (file.isFileStoredInDB()) {
            LOG.debug((Object)"Stuffed Inode:  prepareFileForWrite stored in database. Returning phantom block");
            List lblocks = this.blockManager.createPhantomLocatedBlocks(file, file.getFileDataInDB(), true, false, null).getLocatedBlocks();
            if (lblocks != null) {
                return (LocatedBlock)lblocks.get(0);
            }
            return null;
        }
        LocatedBlock ret = null;
        if (!newBlock) {
            ret = this.blockManager.convertLastBlockToUnderConstruction(file, 0L);
            if (ret != null && delta != null && this.dir.isQuotaEnabled()) {
                Preconditions.checkState((delta.getStorageSpace() >= 0L ? 1 : 0) != 0, (Object)"appending to a block with size larger than the preferred block size");
                long diff = file.getPreferredBlockSize() - ret.getBlockSize();
                this.dir.updateSpaceConsumed(iip, 0L, diff, file.getBlockReplication());
            }
        } else {
            BlockInfoContiguous lastBlock = file.getLastBlock();
            if (lastBlock != null) {
                ExtendedBlock blk = new ExtendedBlock(this.getBlockPoolId(), (Block)lastBlock);
                ret = new LocatedBlock(blk, new DatanodeInfo[0]);
            }
        }
        lease.updateLastTwoBlocksInLeasePath(src, file.getLastBlock(), file.getPenultimateBlock());
        return ret;
    }

    private QuotaCounts verifyQuotaForUCBlock(INodeFile file, INodesInPath iip) throws QuotaExceededException, IOException {
        if (!this.isImageLoaded() || !this.dir.isQuotaEnabled()) {
            return null;
        }
        if (file.getLastBlock() != null || file.isFileStoredInDB()) {
            QuotaCounts delta = this.computeQuotaDeltaForUCBlock(file);
            FSDirectory.verifyQuota(iip, iip.length() - 1, delta, null);
            return delta;
        }
        return null;
    }

    private QuotaCounts computeQuotaDeltaForUCBlock(INodeFile file) throws IOException {
        QuotaCounts delta = new QuotaCounts.Builder().build();
        BlockInfoContiguous lastBlock = file.getLastBlock();
        long lastBlockNumBytes = -1L;
        if (file.isFileStoredInDB()) {
            lastBlockNumBytes = file.getSize();
        } else if (lastBlock != null) {
            lastBlockNumBytes = lastBlock.getNumBytes();
        }
        if (lastBlockNumBytes >= 0L) {
            long diff = file.getPreferredBlockSize() - lastBlockNumBytes;
            short repl = file.getBlockReplication();
            delta.addStorageSpace(diff * (long)repl);
            BlockStoragePolicy policy = this.dir.getBlockStoragePolicySuite().getPolicy(file.getStoragePolicyID());
            List types = policy.chooseStorageTypes(repl);
            for (StorageType t : types) {
                if (!t.supportTypeQuota()) continue;
                delta.addTypeSpace(t, diff);
            }
        }
        return delta;
    }

    boolean recoverLease(String srcArg, final String holder, final String clientMachine) throws IOException {
        final FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        HopsTransactionalRequestHandler recoverLeaseHandler = new HopsTransactionalRequestHandler(HDFSOperationType.RECOVER_LEASE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, holder, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR)).add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                if (FSNamesystem.this.isInSafeMode()) {
                    FSNamesystem.this.checkNameNodeSafeMode("Cannot recover the lease of " + src);
                }
                if (!DFSUtil.isValidName(src)) {
                    throw new IOException("Invalid file name: " + src);
                }
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath4Write(src);
                INodeFile inode = INodeFile.valueOf(iip.getLastINode(), src);
                if (!inode.isUnderConstruction()) {
                    return true;
                }
                if (FSNamesystem.this.isPermissionEnabled) {
                    FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
                }
                FSNamesystem.this.recoverLeaseInternal(RecoverLeaseOp.RECOVER_LEASE, iip, src, holder, clientMachine, true);
                return false;
            }
        };
        return (Boolean)recoverLeaseHandler.handle(this);
    }

    void recoverLeaseInternal(RecoverLeaseOp op, INodesInPath iip, String src, String holder, String clientMachine, boolean force) throws IOException {
        INodeFile file = iip.getLastINode().asFile();
        if (file != null && file.isUnderConstruction()) {
            Lease leaseFile;
            Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && (leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease)) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, holder + " is already the current lease holder."));
            }
            FileUnderConstructionFeature uc = file.getFileUnderConstructionFeature();
            String clientName = uc.getClientName();
            lease = this.leaseManager.getLease(clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "the file is under construction but no leases found."));
            }
            if (force) {
                LOG.info((Object)("recoverLease: " + lease + ", src=" + src + " from client " + clientName));
                this.internalReleaseLease(lease, src, iip, holder);
            } else {
                assert (lease.getHolder().equals(clientName)) : "Current lease holder " + lease.getHolder() + " does not match file creator " + clientName;
                if (this.leaseManager.expiredSoftLimit(lease)) {
                    LOG.info((Object)("startFile: recover " + lease + ", src=" + src + " client " + clientName));
                    boolean isClosed = this.internalReleaseLease(lease, src, iip, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException.NonAbortingRecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "lease recovery is in progress. Try again later."));
                    }
                } else {
                    BlockInfoContiguous lastBlock = file.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsServerConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException(op.getExceptionMessage(src, holder, clientMachine, "another recovery is in progress by " + clientName + " on " + uc.getClientMachine()));
                    }
                    throw new AlreadyBeingCreatedException(op.getExceptionMessage(src, holder, clientMachine, "this file lease is currently owned by " + clientName + " on " + uc.getClientMachine()));
                }
            }
        }
    }

    LastBlockWithStatus appendFile(String src, String holder, String clientMachine, EnumSet<CreateFlag> flag) throws IOException {
        try {
            return this.appendFileHopFS(src, holder, clientMachine, flag.contains(CreateFlag.NEW_BLOCK));
        }
        catch (HDFSClientAppendToDBFileException e) {
            LOG.debug((Object)e);
            return this.moveToDNsAndAppend(src, holder, clientMachine, flag.contains(CreateFlag.NEW_BLOCK));
        }
    }

    private LastBlockWithStatus moveToDNsAndAppend(String src, String holder, String clientMachine, boolean newBlock) throws IOException {
        FileSystem hopsFSClient1 = FileSystem.newInstance((Configuration)this.conf);
        byte[] data = new byte[DB_MAX_SMALL_FILE_SIZE];
        FSDataInputStream is = hopsFSClient1.open(new Path(src));
        int dataRead = is.read(data, 0, data.length);
        is.close();
        Configuration newConf = this.copyConfiguration(this.conf);
        newConf.setBoolean("dfs.force.client.to.write.small.files.to.disk.key", true);
        FileSystem hopsFSClient2 = FileSystem.newInstance((Configuration)newConf);
        FSDataOutputStream os = hopsFSClient2.create(new Path(src), true);
        os.write(data, 0, dataRead);
        os.close();
        return this.appendFileHopFS(src, holder, clientMachine, newBlock);
    }

    private Configuration copyConfiguration(Configuration conf) {
        HdfsConfiguration newConf = new HdfsConfiguration();
        for (Map.Entry entry : conf) {
            newConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return newConf;
    }

    private LastBlockWithStatus appendFileHopFS(final String srcArg, final String holder, final String clientMachine, final boolean newBlock) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        HopsTransactionalRequestHandler appendFileHandler = new HopsTransactionalRequestHandler(HDFSOperationType.APPEND_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, holder, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV, LockFactory.BLK.PE)).add(lf.getLastBlockHashBucketsLock());
                if (FSNamesystem.this.isRetryCacheEnabled) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                if (FSNamesystem.this.erasureCodingEnabled) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, src));
                }
                locks.add(lf.getAcesLock());
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
            }

            public Object performTask() throws IOException {
                LastBlockWithStatus lastBlockWithStatus = null;
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    INode inode;
                    INodeFile file;
                    LocatedBlock locatedBlock;
                    ClientNamenodeProtocolProtos.AppendResponseProto proto = ClientNamenodeProtocolProtos.AppendResponseProto.parseFrom(cacheEntry.getPayload());
                    LocatedBlock locatedBlock2 = locatedBlock = proto.hasBlock() ? PBHelper.convert(proto.getBlock()) : null;
                    if (locatedBlock.isPhantomBlock() && (file = INodeFile.valueOf(inode = FSNamesystem.this.dir.getINode(src), src)).isFileStoredInDB()) {
                        LOG.debug((Object)"Stuffed Inode: appendFileHopFS  stored in database. Returning phantom block");
                        locatedBlock.setData(file.getFileDataInDB());
                    }
                    HdfsFileStatus stat = proto.hasStat() ? PBHelper.convert(proto.getStat()) : null;
                    return new LastBlockWithStatus(locatedBlock, stat);
                }
                boolean success = false;
                try {
                    EncodingStatus status;
                    INode target = FSNamesystem.this.getINode(src);
                    if (FSNamesystem.this.erasureCodingEnabled && target != null && target instanceof INodeFile && !((INodeFile)target).isFileStoredInDB() && (status = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{target.getId()})) != null) {
                        throw new IOException("Cannot append to erasure-coded file");
                    }
                    if (target != null && target instanceof INodeFile && ((INodeFile)target).isFileStoredInDB() && !holder.contains("HopsFS")) {
                        throw new HDFSClientAppendToDBFileException("HDFS can not directly append to a file stored in the database");
                    }
                    lastBlockWithStatus = FSNamesystem.this.appendFileInt(srcArg, src, holder, clientMachine, newBlock);
                    if (lastBlockWithStatus != null && lastBlockWithStatus.getLastBlock() != null && !lastBlockWithStatus.getLastBlock().isPhantomBlock()) {
                        BlockInfoContiguous blockInfo = (BlockInfoContiguous)((Object)EntityManager.find((FinderType)BlockInfoContiguous.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{lastBlockWithStatus.getLastBlock().getBlock().getBlockId(), target.getId()}));
                        for (Replica replica : blockInfo.getReplicas(FSNamesystem.this.blockManager.getDatanodeManager())) {
                            Block undoBlock = new Block((Block)blockInfo);
                            undoBlock.setGenerationStampNoPersistance(undoBlock.getGenerationStamp() - 1L);
                            HashBuckets.getInstance().undoHash(replica.getStorageId(), HdfsServerConstants.ReplicaState.FINALIZED, undoBlock);
                        }
                    }
                    success = true;
                    LastBlockWithStatus lastBlockWithStatus2 = lastBlockWithStatus;
                    return lastBlockWithStatus2;
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "append", srcArg);
                    throw e;
                }
                finally {
                    LocatedBlock lb = null;
                    if (lastBlockWithStatus != null && lastBlockWithStatus.getLastBlock() != null) {
                        lb = new LocatedBlock(lastBlockWithStatus.getLastBlock().getBlock(), lastBlockWithStatus.getLastBlock().getLocations(), lastBlockWithStatus.getLastBlock().getStorageIDs(), lastBlockWithStatus.getLastBlock().getStorageTypes(), lastBlockWithStatus.getLastBlock().getStartOffset(), lastBlockWithStatus.getLastBlock().isCorrupt(), lastBlockWithStatus.getLastBlock().getBlockToken(), lastBlockWithStatus.getLastBlock().getCachedLocations());
                    }
                    ClientNamenodeProtocolProtos.AppendResponseProto.Builder builder = ClientNamenodeProtocolProtos.AppendResponseProto.newBuilder();
                    if (lb != null) {
                        builder.setBlock(PBHelper.convert(lb));
                    }
                    if (lastBlockWithStatus != null && lastBlockWithStatus.getFileStatus() != null) {
                        builder.setStat(PBHelper.convert(lastBlockWithStatus.getFileStatus()));
                    }
                    byte[] toCache = builder.build().toByteArray();
                    LightWeightCacheDistributed.put(toCache, success);
                }
            }
        };
        LastBlockWithStatus lb = (LastBlockWithStatus)appendFileHandler.handle(this);
        this.logAuditEvent(true, "append", srcArg);
        return lb;
    }

    private LastBlockWithStatus appendFileInt(String srcArg, String src, String holder, String clientMachine, boolean newBlock) throws IOException {
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append is not enabled on this NameNode. Use the dfs.support.append configuration option to enable it.");
        }
        HdfsFileStatus stat = null;
        FSPermissionChecker pc = this.getPermissionChecker();
        INodesInPath iip = this.dir.getINodesInPath4Write(src);
        LocatedBlock lb = this.appendFileInternal(pc, iip, holder, clientMachine, newBlock);
        stat = FSDirStatAndListingOp.getFileInfo(this.dir, src, false, FSDirectory.isReservedRawName(srcArg), true);
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes());
        }
        return new LastBlockWithStatus(lb, stat);
    }

    private ExtendedBlock getExtendedBlock(Block blk) {
        return new ExtendedBlock(this.blockPoolId, blk);
    }

    LocatedBlock getAdditionalBlock(String srcArg, final long fileId, final String clientName, final ExtendedBlock previous, final Set<Node> excludedNodes, final List<String> favoredNodes) throws IOException {
        final LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        HopsTransactionalRequestHandler additionalBlockHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_ADDITIONAL_BLOCK, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fileId == 0L) {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il).add(lf.getLastTwoBlocksLock(src));
                } else {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, fileId).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il).add(lf.getLastTwoBlocksLock(fileId));
                }
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, clientName, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC));
            }

            public Object performTask() throws IOException {
                DatanodeStorageInfo[] targets = FSNamesystem.this.getNewBlockTargets(src, fileId, clientName, previous, excludedNodes, favoredNodes, onRetryBlock);
                if (targets == null) {
                    assert (onRetryBlock[0] != null) : "Retry block is null";
                    return onRetryBlock[0];
                }
                LocatedBlock newBlock = FSNamesystem.this.storeAllocatedBlock(src, fileId, clientName, previous, targets);
                return newBlock;
            }
        };
        return (LocatedBlock)additionalBlockHandler.handle(this);
    }

    DatanodeStorageInfo[] getNewBlockTargets(String src, long fileId, String clientName, ExtendedBlock previous, Set<Node> excludedNodes, List<String> favoredNodes, LocatedBlock[] onRetryBlock) throws IOException {
        String clientMachine = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("BLOCK* getAdditionalBlock: " + src + " inodeId " + fileId + " for " + clientName);
        }
        FileState fileState = this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock);
        INodeFile pendingFile = fileState.inode;
        if (!this.checkFileProgress(src, pendingFile, false)) {
            throw new NotReplicatedYetException("Not replicated yet: " + src);
        }
        src = fileState.path;
        if (onRetryBlock[0] != null && onRetryBlock[0].getLocations().length > 0) {
            return null;
        }
        if ((long)pendingFile.getBlocks().length >= this.maxBlocksPerFile) {
            throw new IOException("File has reached the limit on maximum number of blocks (dfs.namenode.fs-limits.max-blocks-per-file): " + pendingFile.getBlocks().length + " >= " + this.maxBlocksPerFile);
        }
        long blockSize = pendingFile.getPreferredBlockSize();
        clientMachine = pendingFile.getFileUnderConstructionFeature().getClientMachine();
        DatanodeDescriptor clientNode = this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
        short replication = pendingFile.getBlockReplication();
        if (pendingFile.getStoragePolicyID() == 14) {
            if (pendingFile.getParent().getStoragePolicyID() == 14) {
                pendingFile.setStoragePolicyID(this.getBlockManager().getStoragePolicySuite().getDefaultPolicy().getId());
            } else {
                pendingFile.setStoragePolicyID(pendingFile.getParent().getStoragePolicyID());
            }
        }
        if (clientNode == null) {
            clientNode = this.getClientNode(clientMachine);
        }
        return this.getBlockManager().chooseTarget4NewBlock(src, replication, (Node)clientNode, excludedNodes, blockSize, favoredNodes, pendingFile.getStoragePolicyID());
    }

    LocatedBlock storeAllocatedBlock(String src, long fileId, String clientName, ExtendedBlock previous, DatanodeStorageInfo[] targets) throws IOException {
        LocatedBlock[] onRetryBlock = new LocatedBlock[1];
        FileState fileState = this.analyzeFileState(src, fileId, clientName, previous, onRetryBlock);
        INodeFile pendingFile = fileState.inode;
        src = fileState.path;
        if (onRetryBlock[0] != null) {
            if (onRetryBlock[0].getLocations().length > 0) {
                return onRetryBlock[0];
            }
            BlockInfoContiguous lastBlockInFile = pendingFile.getLastBlock();
            ((BlockInfoContiguousUnderConstruction)lastBlockInFile).setExpectedLocations(targets);
            long offset = pendingFile.computeFileSize();
            return this.makeLocatedBlock(lastBlockInFile, targets, offset);
        }
        this.commitOrCompleteLastBlock(pendingFile, fileState.iip, ExtendedBlock.getLocalBlock((ExtendedBlock)previous));
        Block newBlock = this.createNewBlock(pendingFile);
        INodesInPath inodesInPath = INodesInPath.fromINode(pendingFile);
        this.saveAllocatedBlock(src, inodesInPath, newBlock, targets);
        this.persistNewBlock(src, pendingFile);
        long offset = pendingFile.computeFileSize();
        Lease lease = this.leaseManager.getLease(clientName);
        lease.updateLastTwoBlocksInLeasePath(src, newBlock, ExtendedBlock.getLocalBlock((ExtendedBlock)previous));
        LocatedBlock lb = this.makeLocatedBlock(newBlock, targets, offset);
        if (pendingFile.isFileStoredInDB()) {
            pendingFile.setFileStoredInDB(false);
            pendingFile.deleteFileDataStoredInDB();
            this.updateReplicationFromDBToBlocks(inodesInPath);
            LOG.debug((Object)"Stuffed Inode:  appending to a file stored in the database. In the current implementation there is potential for data loss if the client fails");
        }
        return lb;
    }

    private Node getClientNode(String clientMachine) {
        ArrayList<String> hosts = new ArrayList<String>(1);
        hosts.add(clientMachine);
        List<String> rName = this.getBlockManager().getDatanodeManager().resolveNetworkLocation(hosts);
        NodeBase clientNode = null;
        if (rName != null) {
            clientNode = new NodeBase(rName.get(0) + "/" + clientMachine);
        }
        return clientNode;
    }

    FileState analyzeFileState(String src, long fileId, String clientName, ExtendedBlock previous, LocatedBlock[] onRetryBlock) throws IOException {
        INode inode;
        INodesInPath iip;
        this.checkBlock(previous);
        onRetryBlock[0] = null;
        this.checkNameNodeSafeMode("Cannot add block to " + src);
        this.checkFsObjectLimit();
        Block previousBlock = ExtendedBlock.getLocalBlock((ExtendedBlock)previous);
        if (fileId == 0L) {
            iip = this.dir.getINodesInPath4Write(src);
            inode = iip.getLastINode();
        } else {
            inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
            iip = INodesInPath.fromINode(inode);
            if (inode != null) {
                src = iip.getPath();
            }
        }
        INodeFile pendingFile = this.checkLease(src, clientName, inode, fileId, true);
        BlockInfoContiguous lastBlockInFile = pendingFile.getLastBlock();
        if (!Block.matchingIdAndGenStamp((Block)previousBlock, (Block)lastBlockInFile)) {
            BlockInfoContiguous penultimateBlock = pendingFile.getPenultimateBlock();
            if (previous == null && lastBlockInFile != null && lastBlockInFile.getNumBytes() >= pendingFile.getPreferredBlockSize() && lastBlockInFile.isComplete()) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("BLOCK* NameSystem.allocateBlock: handling block allocation writing to a file with a complete previous block: src=" + src + " lastBlock=" + (Object)((Object)lastBlockInFile));
                }
            } else {
                if (Block.matchingIdAndGenStamp((Block)penultimateBlock, (Block)previousBlock)) {
                    if (lastBlockInFile.getNumBytes() != 0L) {
                        throw new IOException("Request looked like a retry to allocate block " + (Object)((Object)lastBlockInFile) + " but it already contains " + lastBlockInFile.getNumBytes() + " bytes");
                    }
                    NameNode.stateChangeLog.info("BLOCK* allocateBlock: caught retry for allocation of a new block in " + src + ". Returning previously allocated block " + (Object)((Object)lastBlockInFile));
                    long offset = pendingFile.computeFileSize();
                    onRetryBlock[0] = this.makeLocatedBlock(lastBlockInFile, ((BlockInfoContiguousUnderConstruction)lastBlockInFile).getExpectedStorageLocations(this.getBlockManager().getDatanodeManager()), offset);
                    return new FileState(pendingFile, src, iip);
                }
                throw new IOException("Cannot allocate block in " + src + ": passed 'previous' block " + previous + " does not match actual last block in file " + (Object)((Object)lastBlockInFile));
            }
        }
        return new FileState(pendingFile, src, iip);
    }

    LocatedBlock makeLocatedBlock(Block blk, DatanodeStorageInfo[] locs, long offset) throws IOException {
        LocatedBlock lBlk = BlockManager.newLocatedBlock(this.getExtendedBlock(blk), locs, offset, false);
        this.getBlockManager().setBlockToken(lBlk, BlockTokenIdentifier.AccessMode.WRITE);
        return lBlk;
    }

    LocatedBlock getAdditionalDatanode(String srcArg, final long fileId, final ExtendedBlock blk, final DatanodeInfo[] existings, final String[] storageIDs, final HashSet<Node> excludes, final int numAdditionalNodes, final String clientName) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        HopsTransactionalRequestHandler getAdditionalDatanodeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_ADDITIONAL_DATANODE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fileId == 0L) {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                } else {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, fileId).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                }
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, clientName, FSNamesystem.this.leaseCreationLockRows));
            }

            public Object performTask() throws IOException {
                INode inode;
                FSNamesystem.this.dtpReplaceDatanodeOnFailure.checkEnabled();
                DatanodeDescriptor clientnode = null;
                FSNamesystem.this.checkNameNodeSafeMode("Cannot add datanode; src=" + src + ", blk=" + blk);
                String src2 = src;
                if (fileId == 0L) {
                    inode = FSNamesystem.this.dir.getINode(src);
                } else {
                    inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
                    if (inode != null) {
                        src2 = inode.getFullPathName();
                    }
                }
                INodeFile file = FSNamesystem.this.checkLease(src2, clientName, inode, fileId, false);
                String clientMachine = file.getFileUnderConstructionFeature().getClientMachine();
                clientnode = FSNamesystem.this.blockManager.getDatanodeManager().getDatanodeByHost(clientMachine);
                long preferredBlockSize = file.getPreferredBlockSize();
                byte storagePolicyID = file.getStoragePolicyID();
                DatanodeManager dm = FSNamesystem.this.blockManager.getDatanodeManager();
                List<DatanodeStorageInfo> chosen = existings.length != 0 ? Arrays.asList(dm.getDatanodeStorageInfos((DatanodeID[])existings, storageIDs)) : Collections.emptyList();
                if (clientnode == null) {
                    clientnode = FSNamesystem.this.getClientNode(clientMachine);
                }
                DatanodeStorageInfo[] targets = FSNamesystem.this.blockManager.chooseTarget4AdditionalDatanode(src2, numAdditionalNodes, (Node)clientnode, chosen, excludes, preferredBlockSize, storagePolicyID);
                LocatedBlock lb = BlockManager.newLocatedBlock(blk, targets, -1L, false);
                FSNamesystem.this.blockManager.setBlockToken(lb, BlockTokenIdentifier.AccessMode.COPY);
                return lb;
            }
        };
        return (LocatedBlock)getAdditionalDatanodeHandler.handle(this);
    }

    boolean abandonBlock(final ExtendedBlock b, final long fileId, String srcArg, final String holder) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        HopsTransactionalRequestHandler abandonBlockHandler = new HopsTransactionalRequestHandler(HDFSOperationType.ABANDON_BLOCK, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fileId == 0L) {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                } else {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, fileId).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                }
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED, src)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.ER, LockFactory.BLK.IV));
                locks.add(lf.getAllUsedHashBucketsLock());
            }

            public Object performTask() throws IOException {
                INode inode;
                INodesInPath iip;
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src);
                }
                FSNamesystem.this.checkNameNodeSafeMode("Cannot abandon block " + b + " for file" + src);
                String srcInt = src;
                if (fileId == 0L) {
                    iip = FSNamesystem.this.dir.getINodesInPath(srcInt, true);
                    inode = iip.getLastINode();
                } else {
                    inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
                    iip = INodesInPath.fromINode(inode);
                    if (inode != null) {
                        srcInt = iip.getPath();
                    }
                }
                INodeFile file = FSNamesystem.this.checkLease(srcInt, holder, inode, fileId, false);
                boolean removed = FSNamesystem.this.dir.removeBlock(srcInt, iip, file, ExtendedBlock.getLocalBlock((ExtendedBlock)b));
                if (!removed) {
                    return true;
                }
                FSNamesystem.this.leaseManager.getLease(holder).updateLastTwoBlocksInLeasePath(srcInt, file.getLastBlock(), file.getPenultimateBlock());
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates");
                }
                FSNamesystem.this.persistBlocks(srcInt, file);
                file.recomputeFileSize();
                return true;
            }
        };
        return (Boolean)abandonBlockHandler.handle(this);
    }

    private INodeFile checkLease(String src, String holder, INode inode, long fileId, boolean updateLastTwoBlocksInFile) throws LeaseExpiredException, StorageException, TransactionContextException, FileNotFoundException {
        String ident = src + " (inode " + fileId + ")";
        if (inode == null) {
            Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + ident + ": File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!inode.isFile()) {
            Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + ident + ": INode is not a regular file. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFile file = inode.asFile();
        if (!file.isUnderConstruction()) {
            Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + ident + ": File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        String clientName = file.getFileUnderConstructionFeature().getClientName();
        if (holder != null && !clientName.equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + ident + " owned by " + clientName + " but is accessed by " + holder);
        }
        if (updateLastTwoBlocksInFile) {
            file.getFileUnderConstructionFeature().updateLastTwoBlocks(this.leaseManager.getLease(holder), src);
        }
        return file;
    }

    boolean completeFile(String srcArg, final String holder, final ExtendedBlock last, final long fileId, final byte[] data) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(this.getPermissionChecker(), srcArg, pathComponents);
        HopsTransactionalRequestHandler completeFileHandler = new HopsTransactionalRequestHandler(HDFSOperationType.COMPLETE_FILE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                INodeLock il;
                LockFactory lf = LockFactory.getInstance();
                if (fileId == 0L) {
                    il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                    locks.add((Lock)il);
                } else {
                    il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, fileId).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                    locks.add((Lock)il);
                }
                LeaseLock leaseLock = (LeaseLock)lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, holder, FSNamesystem.this.leaseCreationLockRows);
                locks.add((Lock)leaseLock).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE)).add(lf.getBlockLock());
                if (data == null) {
                    locks.add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV));
                }
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkBlock(last);
                return FSNamesystem.this.completeFileInternal(src, holder, ExtendedBlock.getLocalBlock((ExtendedBlock)last), fileId, data);
            }
        };
        return (Boolean)completeFileHandler.handle(this);
    }

    private boolean completeFileInternal(String src, String holder, Block last, long fileId, byte[] data) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.completeFile: " + src + " for " + holder);
        }
        this.checkNameNodeSafeMode("Cannot complete file " + src);
        if (data != null) {
            if (last != null) {
                throw new IllegalStateException("Trying to store the file data in the database. Last block of the file should have been null");
            }
            return this.completeFileStoredInDataBase(src, holder, fileId, data);
        }
        return this.completeFileStoredOnDataNodes(src, holder, last, fileId);
    }

    private boolean completeFileStoredOnDataNodes(String src, String holder, Block last, long fileId) throws IOException {
        INodeFile pendingFile;
        INodesInPath iip;
        INode inode = null;
        try {
            if (fileId == 0L) {
                iip = this.dir.getINodesInPath(src, true);
                inode = iip.getLastINode();
            } else {
                inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
                iip = INodesInPath.fromINode(inode);
                if (inode != null) {
                    src = iip.getPath();
                }
            }
            pendingFile = this.checkLease(src, holder, inode, fileId, true);
        }
        catch (LeaseExpiredException lee) {
            BlockInfoContiguous realLastBlock;
            if (inode != null && inode.isFile() && !inode.asFile().isUnderConstruction() && Block.matchingIdAndGenStamp((Block)last, (Block)(realLastBlock = ((INodeFile)inode).getLastBlock()))) {
                NameNode.stateChangeLog.info("DIR* completeFile: request from " + holder + " to complete inode " + fileId + "(" + src + ") which is already closed. But, it appears to be an RPC retry. Returning success");
                return true;
            }
            throw lee;
        }
        if (!this.checkFileProgress(src, pendingFile, false)) {
            return false;
        }
        this.commitOrCompleteLastBlock(pendingFile, iip, last);
        if (!this.checkFileProgress(src, pendingFile, true)) {
            return false;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info("DIR* completeFile: " + src + " is closed by " + holder);
        return true;
    }

    private boolean completeFileStoredInDataBase(String src, String holder, long fileId, byte[] data) throws IOException {
        INodesInPath iip;
        INode inode = null;
        if (fileId == 0L) {
            iip = this.dir.getINodesInPath(src, true);
            inode = iip.getLastINode();
        } else {
            inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
            iip = INodesInPath.fromINode(inode);
            if (inode != null) {
                src = iip.getPath();
            }
        }
        INodeFile pendingFile = this.checkLease(src, holder, inode, fileId, true);
        pendingFile.setStoragePolicyID((byte)14);
        if (pendingFile.isFileStoredInDB()) {
            pendingFile.deleteFileDataStoredInDB();
        }
        pendingFile.setFileStoredInDB(true);
        long oldSize = pendingFile.getSize();
        pendingFile.setSize(data.length);
        pendingFile.storeFileDataInDB(data);
        pendingFile.setFileReplication(this.dbReplicationFactor);
        if (this.dir.isQuotaEnabled()) {
            long delta = (long)data.length - oldSize;
            this.dir.updateSpaceConsumed(iip, 0L, delta, pendingFile.getBlockReplication());
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info("DIR* completeFile: " + src + " is closed by " + holder);
        return true;
    }

    private void saveAllocatedBlock(String src, INodesInPath inodesInPath, Block newBlock, DatanodeStorageInfo[] targets) throws IOException, StorageException {
        BlockInfoContiguous b = this.dir.addBlock(src, inodesInPath, newBlock, targets);
        NameNode.stateChangeLog.info("BLOCK* allocate " + (Object)((Object)b) + " for " + src);
        DatanodeStorageInfo.incrementBlocksScheduled(targets);
    }

    private Block createNewBlock(INodeFile pendingFile) throws IOException {
        Block b = new Block(this.nextBlockId(), 0L, 0L);
        b.setGenerationStampNoPersistance((long)pendingFile.nextGenerationStamp());
        return b;
    }

    boolean checkFileProgress(String src, INodeFile v, boolean checkAll) throws IOException {
        if (checkAll) {
            return this.blockManager.checkBlocksProperlyReplicated(src, v.getBlocks());
        }
        BlockInfoContiguous b = v.getPenultimateBlock();
        return b == null || this.blockManager.checkBlocksProperlyReplicated(src, new BlockInfoContiguous[]{b});
    }

    @Deprecated
    boolean renameTo(String src, String dst) throws IOException {
        if (!this.nameNode.isLeader() && this.dir.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Rename operation can only be performed on a leader namenode");
        }
        this.saveTimes();
        boolean ret = false;
        try {
            this.checkNameNodeSafeMode("Cannot rename " + src);
            ret = FSDirRenameOp.renameToInt(this.dir, src, dst);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename", src, dst, null);
            throw e;
        }
        return ret;
    }

    void renameTo(String src, String dst, Options.Rename ... options) throws IOException {
        if (!this.nameNode.isLeader() && this.dir.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Rename operation can only be performed on a leader namenode");
        }
        this.saveTimes();
        Map.Entry<INode.BlocksMapUpdateInfo, HdfsFileStatus> res = null;
        try {
            this.checkNameNodeSafeMode("Cannot rename " + src);
            res = FSDirRenameOp.renameToInt(this.dir, src, dst, options);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "rename (options=" + Arrays.toString(options) + ")", src, dst, null);
            throw e;
        }
        HdfsFileStatus auditStat = res.getValue();
        this.logAuditEvent(true, "rename (options=" + Arrays.toString(options) + ")", src, dst, auditStat);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.saveTimes();
        if (!this.nameNode.isLeader() && this.dir.isQuotaEnabled()) {
            throw new NotALeaderException("Quota enabled. Delete operation can only be performed on a leader namenode");
        }
        boolean ret = false;
        try {
            this.checkNameNodeSafeMode("Cannot delete " + src);
            ret = FSDirDeleteOp.delete(this, src, recursive);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "delete", src);
            throw e;
        }
        this.logAuditEvent(true, "delete", src);
        return ret;
    }

    FSPermissionChecker getPermissionChecker() throws AccessControlException {
        return this.dir.getPermissionChecker();
    }

    public void removeBlocks(INode.BlocksMapUpdateInfo blocks) throws StorageException, TransactionContextException, IOException {
        List<Block> toDeleteList = blocks.getToDeleteList();
        Iterator<Block> iter = toDeleteList.iterator();
        while (iter.hasNext()) {
            for (int i = 0; i < BLOCK_DELETION_INCREMENT && iter.hasNext(); ++i) {
                this.blockManager.removeBlock(iter.next());
            }
        }
    }

    void removeLeasesAndINodes(String src, List<INode> removedINodes) throws IOException {
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (removedINodes != null) {
            this.dir.removeFromInodeMap(removedINodes);
            removedINodes.clear();
        }
    }

    public HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws IOException {
        HdfsFileStatus stat = null;
        try {
            stat = FSDirStatAndListingOp.getFileInfo(this.dir, src, resolveLink);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getfileinfo", src);
            throw e;
        }
        this.logAuditEvent(true, "getfileinfo", src);
        return stat;
    }

    boolean isFileClosed(String src) throws AccessControlException, UnresolvedLinkException, StandbyException, IOException {
        try {
            return FSDirStatAndListingOp.isFileClosed(this.dir, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "isFileClosed", src);
            throw e;
        }
    }

    boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot create directory " + src);
            auditStat = FSDirMkdirOp.mkdirs(this, src, permissions, createParent);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "mkdirs", src);
            throw e;
        }
        this.logAuditEvent(true, "mkdirs", src, null, auditStat);
        return true;
    }

    ContentSummary getContentSummary(String src) throws IOException {
        boolean success = true;
        try {
            ContentSummary contentSummary = FSDirStatAndListingOp.getContentSummary(this.dir, src);
            return contentSummary;
        }
        catch (AccessControlException ace) {
            success = false;
            throw ace;
        }
        finally {
            this.logAuditEvent(success, "contentSummary", src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long ssQuota, StorageType type) throws IOException {
        boolean success = false;
        try {
            this.checkNameNodeSafeMode("Cannot set quota on " + src);
            FSDirAttrOp.setQuota(this.dir, src, nsQuota, ssQuota, type);
            success = true;
        }
        finally {
            this.logAuditEvent(success, "setQuota", src);
        }
    }

    void fsync(String srcArg, final long fileId, final String clientName, final long lastBlockLength) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        new HopsTransactionalRequestHandler(HDFSOperationType.FSYNC, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                if (fileId == 0L) {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                } else {
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, fileId).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                }
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, clientName, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock());
            }

            public Object performTask() throws IOException {
                INode inode;
                NameNode.stateChangeLog.info("BLOCK* fsync: " + src + " for " + clientName);
                FSNamesystem.this.checkNameNodeSafeMode("Cannot fsync file " + src);
                String src2 = src;
                if (fileId == 0L) {
                    inode = FSNamesystem.this.dir.getINode(src);
                } else {
                    inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{fileId});
                    if (inode != null) {
                        src2 = inode.getFullPathName();
                    }
                }
                INodeFile pendingFile = FSNamesystem.this.checkLease(src2, clientName, inode, fileId, true);
                if (lastBlockLength > 0L) {
                    pendingFile.getFileUnderConstructionFeature().updateLengthOfLastBlock(pendingFile, lastBlockLength);
                }
                FSNamesystem.this.persistBlocks(src2, pendingFile);
                pendingFile.recomputeFileSize();
                return null;
            }
        }.handle(this);
    }

    boolean internalReleaseLease(Lease lease, String src, INodesInPath iip, String recoveryLeaseHolder) throws IOException {
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering " + lease + ", src=" + src));
        assert (!this.isInSafeMode());
        INodeFile pendingFile = iip.getLastINode().asFile();
        int nrBlocks = pendingFile.numBlocks();
        BlockInfoContiguous[] blocks = pendingFile.getBlocks();
        BlockInfoContiguous curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock != null && curBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn(message);
            throw new IOException(message);
        }
        BlockInfoContiguous lastBlock = pendingFile.getLastBlock();
        HdfsServerConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfoContiguous penultimateBlock = pendingFile.getPenultimateBlock();
        boolean penultimateBlockMinReplication = penultimateBlock == null ? true : this.blockManager.checkMinReplication(penultimateBlock);
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated. Try again later.";
                NameNode.stateChangeLog.warn(message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                boolean copyOnTruncate;
                BlockInfoContiguousUnderConstruction uc = (BlockInfoContiguousUnderConstruction)lastBlock;
                Block recoveryBlock = uc.getTruncateBlock();
                boolean truncateRecovery = recoveryBlock != null;
                boolean bl = copyOnTruncate = truncateRecovery && recoveryBlock.getBlockId() != uc.getBlockId();
                assert (!copyOnTruncate || recoveryBlock.getBlockId() < uc.getBlockId() && recoveryBlock.getGenerationStamp() < uc.getGenerationStamp() && recoveryBlock.getNumBytes() > uc.getNumBytes()) : "wrong recoveryBlock";
                if (uc.getNumExpectedLocations() == 0) {
                    uc.setExpectedLocations(this.blockManager.getStorages(lastBlock));
                }
                if (uc.getNumExpectedLocations() == 0 && uc.getNumBytes() == 0L) {
                    pendingFile.removeLastBlock(lastBlock);
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn("BLOCK* internalReleaseLease: Removed empty last block and closed file.");
                    return true;
                }
                long blockRecoveryId = pendingFile.nextGenerationStamp();
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                if (copyOnTruncate) {
                    uc.setGenerationStamp(blockRecoveryId);
                } else if (truncateRecovery) {
                    recoveryBlock.setGenerationStampNoPersistance(blockRecoveryId);
                }
                uc.initializeBlockRecovery(blockRecoveryId, this.getBlockManager().getDatanodeManager());
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed. Lease recovery is in progress. RecoveryId = " + blockRecoveryId + " for block " + (Object)((Object)lastBlock));
            }
        }
        return false;
    }

    private Lease reassignLease(Lease lease, String src, String newHolder, INodeFile pendingFile) throws StorageException, TransactionContextException {
        if (newHolder == null) {
            return lease;
        }
        return this.reassignLeaseInternal(lease, src, newHolder, pendingFile);
    }

    private Lease reassignLeaseInternal(Lease lease, String src, String newHolder, INodeFile pendingFile) throws StorageException, TransactionContextException {
        pendingFile.getFileUnderConstructionFeature().setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void commitOrCompleteLastBlock(INodeFile fileINode, INodesInPath iip, Block commitBlock) throws IOException {
        Preconditions.checkArgument((boolean)fileINode.isUnderConstruction());
        if (!this.blockManager.commitOrCompleteLastBlock(fileINode, commitBlock)) {
            return;
        }
        this.updateQuotaUponBlockCompletion(fileINode, iip, commitBlock);
    }

    public void updateQuotaUponBlockCompletion(INodeFile fileINode, INodesInPath iip, Block commitBlock) throws IOException {
        long diff;
        fileINode.recomputeFileSize();
        if (this.dir.isQuotaEnabled() && (diff = fileINode.getPreferredBlockSize() - commitBlock.getNumBytes()) > 0L) {
            this.dir.updateSpaceConsumed(iip, 0L, -diff, fileINode.getBlockReplication());
        }
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFile pendingFile) throws IOException {
        boolean skipReplicationCheck = false;
        if (pendingFile.getStoragePolicyID() == 14) {
            skipReplicationCheck = true;
        }
        this.finalizeINodeFileUnderConstructionInternal(src, pendingFile, skipReplicationCheck);
    }

    private void finalizeINodeFileUnderConstructionInternal(String src, INodeFile pendingFile, boolean skipReplicationChecks) throws IOException {
        FileUnderConstructionFeature uc = pendingFile.getFileUnderConstructionFeature();
        Preconditions.checkArgument((uc != null ? 1 : 0) != 0);
        this.leaseManager.removeLease(uc.getClientName(), src);
        pendingFile.toCompleteFile(Time.now());
        this.closeFile(src, pendingFile);
        pendingFile.logProvenanceEvent(this.getNamenodeId(), FileProvenanceEntry.Operation.append());
        if (!skipReplicationChecks) {
            this.blockManager.checkReplication(pendingFile);
        }
    }

    void commitBlockSynchronization(final ExtendedBlock oldBlock, final long newGenerationStamp, final long newLength, final boolean closeFile, final boolean deleteBlock, final DatanodeID[] newTargets, final String[] newTargetStorages) throws IOException {
        final String[] src = new String[]{""};
        final boolean[] copyTruncate = new boolean[]{false};
        final BlockInfoContiguousUnderConstruction[] truncatedBlock = new BlockInfoContiguousUnderConstruction[]{null};
        new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(oldBlock.getLocalBlock());
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(oldBlock.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV));
                if (FSNamesystem.this.isErasureCodingEnabled() && this.inodeIdentifier != null) {
                    locks.add(lf.getIndivdualEncodingStatusLock(TransactionLockTypes.LockType.WRITE, this.inodeIdentifier.getInodeId()));
                }
            }

            public Object performTask() throws IOException {
                if (this.inodeIdentifier == null || EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{this.inodeIdentifier.getInodeId()}) == null) {
                    throw new FileNotFoundException("File not found for block: " + oldBlock + ", likely due to delayed block removal");
                }
                BlockInfoContiguous storedBlock = FSNamesystem.this.getStoredBlock(ExtendedBlock.getLocalBlock((ExtendedBlock)oldBlock));
                if (storedBlock == null) {
                    if (deleteBlock) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Block (=" + oldBlock + ") not found"));
                        }
                        return null;
                    }
                    throw new IOException("Block (=" + oldBlock + ") not found");
                }
                BlockCollection blockCollection = storedBlock.getBlockCollection();
                if (blockCollection == null) {
                    throw new IOException("The blockCollection of " + (Object)((Object)storedBlock) + " is null, likely because the file owning this block was deleted and the block removal is delayed");
                }
                FSNamesystem.this.checkNameNodeSafeMode("Cannot commitBlockSynchronization while in safe mode");
                LOG.info((Object)("commitBlockSynchronization Provided Block (oldBlock=" + oldBlock + ", newGenerationStamp=" + newGenerationStamp + ", newLength=" + newLength + ", newTargets=" + Arrays.asList(newTargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteBlock + ")"));
                FSNamesystem.this.commitBlockSynchronizationInternal(oldBlock, newGenerationStamp, newLength, closeFile, deleteBlock, newTargets, newTargetStorages, src, copyTruncate, truncatedBlock);
                return null;
            }
        }.handle(this);
        if (closeFile) {
            LOG.info((Object)("commitBlockSynchronization(oldBlock=" + oldBlock + ", file=" + src[0] + (copyTruncate[0] ? ", newBlock=" + truncatedBlock : ", newgenerationstamp=" + newGenerationStamp) + ", newLength=" + newLength + ", newTargets=" + Arrays.asList(newTargets) + ") successful"));
        } else {
            LOG.info((Object)("commitBlockSynchronization(" + oldBlock + ") successful"));
        }
    }

    void commitBlockSynchronizationInternal(ExtendedBlock oldBlock, long newGenerationStamp, long newLength, boolean closeFile, boolean deleteBlock, DatanodeID[] newTargets, String[] newTargetStorages, String[] src, boolean[] copyTruncate, BlockInfoContiguousUnderConstruction[] truncatedBlock) throws IOException {
        BlockInfoContiguous storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock((ExtendedBlock)oldBlock));
        long oldGenerationStamp = storedBlock.getGenerationStamp();
        long oldNumBytes = storedBlock.getNumBytes();
        if (storedBlock == null || storedBlock.isDeleted()) {
            throw new IOException("The blockCollection of " + (Object)((Object)storedBlock) + " is null, likely because the file owning this block was deleted and the block removal is delayed");
        }
        INodeFile iFile = ((INode)((Object)storedBlock.getBlockCollection())).asFile();
        if ((!iFile.isUnderConstruction() || storedBlock.isComplete()) && iFile.getLastBlock().isComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unexpected block (=" + oldBlock + ") since the file (=" + iFile.getLocalName() + ") is not under construction"));
            }
            return;
        }
        truncatedBlock[0] = (BlockInfoContiguousUnderConstruction)iFile.getLastBlock();
        long recoveryId = truncatedBlock[0].getBlockRecoveryId();
        boolean bl = copyTruncate[0] = truncatedBlock[0].getBlockId() != storedBlock.getBlockId();
        if (recoveryId != newGenerationStamp) {
            throw new IOException("The recovery id " + newGenerationStamp + " does not match current recovery id " + recoveryId + " for block " + oldBlock);
        }
        if (deleteBlock) {
            Block blockToDel = ExtendedBlock.getLocalBlock((ExtendedBlock)oldBlock);
            boolean remove = iFile.removeLastBlock(blockToDel);
            if (remove) {
                this.blockManager.removeBlock(storedBlock);
            }
        } else {
            int i;
            if (!copyTruncate[0]) {
                storedBlock.setGenerationStamp(newGenerationStamp);
                storedBlock.setNumBytes(newLength);
            }
            iFile.recomputeFileSize();
            ArrayList<DatanodeDescriptor> trimmedTargets = new ArrayList<DatanodeDescriptor>(newTargets.length);
            ArrayList<String> trimmedStorages = new ArrayList<String>(newTargets.length);
            for (i = 0; i < newTargets.length; ++i) {
                DatanodeDescriptor targetNode = this.blockManager.getDatanodeManager().getDatanode(newTargets[i]);
                if (targetNode != null) {
                    trimmedTargets.add(targetNode);
                    trimmedStorages.add(newTargetStorages[i]);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("DatanodeDescriptor (=" + newTargets[i] + ") not found"));
            }
            if (closeFile && !trimmedTargets.isEmpty()) {
                for (i = 0; i < trimmedTargets.size(); ++i) {
                    DatanodeStorageInfo storageInfo = ((DatanodeDescriptor)((Object)trimmedTargets.get(i))).getStorageInfo((String)trimmedStorages.get(i));
                    if (storageInfo == null) continue;
                    if (copyTruncate[0]) {
                        storageInfo.addBlock(truncatedBlock[0]);
                        continue;
                    }
                    storageInfo.addBlock(storedBlock);
                }
            }
            DatanodeStorageInfo[] trimmedStorageInfos = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(trimmedTargets.toArray(new DatanodeID[trimmedTargets.size()]), trimmedStorages.toArray(new String[trimmedStorages.size()]));
            if (copyTruncate[0]) {
                iFile.setLastBlock(truncatedBlock[0], trimmedStorageInfos);
            } else {
                iFile.setLastBlock(storedBlock, trimmedStorageInfos);
                if (closeFile) {
                    this.blockManager.markBlockReplicasAsCorrupt(storedBlock, oldGenerationStamp, oldNumBytes, trimmedStorageInfos);
                }
            }
        }
        if (closeFile) {
            if (copyTruncate[0]) {
                src[0] = this.closeFileCommitBlocks(iFile, truncatedBlock[0]);
                this.blockManager.removeBlock(storedBlock);
            } else {
                src[0] = this.closeFileCommitBlocks(iFile, storedBlock);
            }
        } else {
            src[0] = iFile.getFullPathName();
            this.persistBlocks(src[0], iFile);
        }
    }

    @VisibleForTesting
    String closeFileCommitBlocks(INodeFile pendingFile, BlockInfoContiguous storedBlock) throws IOException {
        INodesInPath iip = INodesInPath.fromINode(pendingFile);
        String src = iip.getPath();
        this.commitOrCompleteLastBlock(pendingFile, iip, storedBlock);
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        return src;
    }

    @VisibleForTesting
    BlockInfoContiguous getStoredBlock(Block block) throws StorageException, TransactionContextException {
        return this.blockManager.getStoredBlock(block);
    }

    void renewLease(final String holder) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RENEW_LEASE){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, holder, FSNamesystem.this.leaseCreationLockRows));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot renew lease for " + holder);
                FSNamesystem.this.leaseManager.renewLease(holder);
                return null;
            }
        }.handle(this);
    }

    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        DirectoryListing dl = null;
        try {
            dl = FSDirStatAndListingOp.getListingInt(this.dir, src, startAfter, needLocation);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listStatus", src);
            throw e;
        }
        this.logAuditEvent(true, "listStatus", src);
        return dl;
    }

    void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.getBlockManager().getDatanodeManager().registerDatanode(nodeReg);
        this.checkSafeMode();
    }

    String getRegistrationID() throws IOException {
        return Storage.getRegistrationID(StorageInfo.getStorageInfoFromDB());
    }

    HeartbeatResponse handleHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int xmitsInProgress, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        int maxTransfer = this.blockManager.getMaxReplicationStreams() - xmitsInProgress;
        DatanodeCommand[] cmds = this.blockManager.getDatanodeManager().handleHeartbeat(nodeReg, reports, this.blockPoolId, cacheCapacity, cacheUsed, xceiverCount, maxTransfer, failedVolumes, volumeFailureSummary);
        return new HeartbeatResponse(cmds, (RollingUpgradeStatus)this.getRollingUpgradeInfoTX());
    }

    private boolean nameNodeHasResourcesAvailable() {
        return this.hasResourcesAvailable;
    }

    void checkAvailableResources() {
        Preconditions.checkState((this.nnResourceChecker != null ? 1 : 0) != 0, (Object)"nnResourceChecker not initialized");
        int tries = 0;
        Throwable lastThrowable = null;
        while (tries < this.maxDBTries) {
            try {
                SafeModeInfo safeMode = this.safeMode();
                if (safeMode != null) {
                    this.forceReadTheSafeModeFromDB.set(true);
                }
                if (!this.nnResourceChecker.hasAvailablePrimarySpace()) {
                    this.forceReadTheSafeModeFromDB.set(true);
                }
                this.hasResourcesAvailable = this.nnResourceChecker.hasAvailableSpace();
                break;
            }
            catch (StorageException e) {
                LOG.warn((Object)("StorageException in checkAvailableResources (" + tries + "/" + this.maxDBTries + ")."), (Throwable)e);
                if (e instanceof TransientStorageException) continue;
                lastThrowable = e;
                ++tries;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable t) {
                LOG.error((Object)"Runtime exception in checkAvailableResources. ", t);
                lastThrowable = t;
                ++tries;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (tries >= this.maxDBTries) {
            ExitUtil.terminate((int)1, lastThrowable);
        }
    }

    private void persistBlocks(String path, INodeFile file) throws IOException {
        Preconditions.checkArgument((boolean)file.isUnderConstruction());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system");
        }
    }

    void incrDeletedFileCount(long count) {
        NameNode.getNameNodeMetrics().incrFilesDeleted(count);
    }

    private void closeFile(String path, INodeFile file) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system");
        }
        file.logMetadataEvent(INodeMetadataLogEntry.Operation.Add);
    }

    private void checkBlock(ExtendedBlock block) throws IOException {
        if (block != null && !this.blockPoolId.equals(block.getBlockPoolId())) {
            throw new IOException("Unexpected BlockPoolId " + block.getBlockPoolId() + " - expected " + this.blockPoolId);
        }
    }

    @Metric(value={"MissingBlocks", "Number of missing blocks"})
    public long getMissingBlocksCount() throws IOException {
        return this.blockManager.getMissingBlocksCount();
    }

    @Metric(value={"MissingReplOneBlocks", "Number of missing blocks with replication factor 1"})
    public long getMissingReplOneBlocksCount() throws IOException {
        return this.blockManager.getMissingReplOneBlocksCount();
    }

    @Metric(value={"ExpiredHeartbeats", "Number of expired heartbeats"})
    public int getExpiredHeartbeats() {
        return this.datanodeStatistics.getExpiredHeartbeats();
    }

    long[] getStats() throws IOException {
        long[] stats = this.datanodeStatistics.getStats();
        stats[3] = this.getUnderReplicatedBlocks();
        stats[4] = this.getCorruptReplicaBlocks();
        stats[5] = this.getMissingBlocksCount();
        stats[6] = this.getMissingReplOneBlocksCount();
        return stats;
    }

    @Override
    @Metric(value={"CapacityTotal", "Total raw capacity of data nodes in bytes"})
    public long getCapacityTotal() {
        return this.datanodeStatistics.getCapacityTotal();
    }

    @Metric(value={"CapacityTotalGB", "Total raw capacity of data nodes in GB"})
    public float getCapacityTotalGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityTotal());
    }

    @Override
    @Metric(value={"CapacityUsed", "Total used capacity across all data nodes in bytes"})
    public long getCapacityUsed() {
        return this.datanodeStatistics.getCapacityUsed();
    }

    @Metric(value={"CapacityUsedGB", "Total used capacity across all data nodes in GB"})
    public float getCapacityUsedGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityUsed());
    }

    @Override
    @Metric(value={"CapacityRemaining", "Remaining capacity in bytes"})
    public long getCapacityRemaining() {
        return this.datanodeStatistics.getCapacityRemaining();
    }

    @Metric(value={"CapacityRemainingGB", "Remaining capacity in GB"})
    public float getCapacityRemainingGB() {
        return DFSUtil.roundBytesToGB(this.getCapacityRemaining());
    }

    @Metric(value={"CapacityUsedNonDFS", "Total space used by data nodes for non DFS purposes in bytes"})
    public long getCapacityUsedNonDFS() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    @Metric
    public int getTotalLoad() {
        return this.datanodeStatistics.getXceiverCount();
    }

    int getNumberOfDatanodes(HdfsConstants.DatanodeReportType type) {
        return this.getBlockManager().getDatanodeManager().getDatanodeListForReport(type).size();
    }

    DatanodeInfo[] datanodeReport(HdfsConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        List<DatanodeDescriptor> results = dm.getDatanodeListForReport(type);
        DatanodeInfo[] arr = new DatanodeInfo[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new DatanodeInfo((DatanodeInfo)results.get(i));
        }
        return arr;
    }

    DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws AccessControlException, StandbyException {
        this.checkSuperuserPrivilege();
        DatanodeManager dm = this.getBlockManager().getDatanodeManager();
        List<DatanodeDescriptor> datanodes = dm.getDatanodeListForReport(type);
        DatanodeStorageReport[] reports = new DatanodeStorageReport[datanodes.size()];
        for (int i = 0; i < reports.length; ++i) {
            DatanodeDescriptor d = datanodes.get(i);
            reports[i] = new DatanodeStorageReport(new DatanodeInfo((DatanodeInfo)d), d.getStorageReports());
        }
        return reports;
    }

    Date getStartTime() {
        return new Date(this.startTime);
    }

    void refreshNodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().refreshNodes(new HdfsConfiguration());
    }

    void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkSuperuserPrivilege();
        this.getBlockManager().getDatanodeManager().setBalancerBandwidth(bandwidth);
    }

    private void persistNewBlock(String path, INodeFile file) throws IOException {
        Preconditions.checkArgument((boolean)file.isUnderConstruction());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("persistNewBlock: " + path + " with new block " + file.getLastBlock().toString() + ", current total block count is " + file.getBlocks().length);
        }
    }

    boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (action != HdfsConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode();
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode(false);
                    break;
                }
                default: {
                    LOG.error((Object)"Unexpected safe mode action");
                }
            }
        }
        return this.isInSafeMode();
    }

    @Override
    public void checkSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            safeMode.checkMode();
        }
    }

    @Override
    public boolean isInSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            if (this.inSafeMode.get()) {
                new SafeModeInfo().leave();
            }
            this.forceReadTheSafeModeFromDB.set(false);
            return false;
        }
        if (safeMode.isOn() && !this.isLeader()) {
            safeMode.tryToHelpToGetOut();
        }
        this.inSafeMode.set(safeMode.isOn());
        return safeMode.isOn();
    }

    private SafeModeInfo safeMode() throws IOException {
        if (!this.forceReadTheSafeModeFromDB.get()) {
            return null;
        }
        List<Object> vals = HdfsVariables.getSafeModeFromDB();
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return new SafeModeInfo((Double)vals.get(0), (Integer)vals.get(1), (Integer)vals.get(2), (Integer)vals.get(3), (Double)vals.get(4), (Integer)vals.get(5) == 0);
    }

    @Override
    public boolean isInStartupSafeMode() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return false;
        }
        return !safeMode.isManual() && !safeMode.areResourcesLow() && safeMode.isOn();
    }

    @Override
    public boolean isPopulatingReplQueues() throws IOException {
        if (!this.shouldPopulateReplicationQueues()) {
            return false;
        }
        return this.initializedReplQueues;
    }

    private boolean shouldPopulateReplicationQueues() {
        return this.shouldPopulateReplicationQueue;
    }

    @Override
    public void incrementSafeBlockCount(int replication, BlockInfoContiguous blk) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.incrementSafeBlockCount((short)replication, blk);
    }

    @Override
    public void decrementSafeBlockCount(BlockInfoContiguous b) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        if (b.isComplete()) {
            safeMode.decrementSafeBlockCount(b, (short)this.blockManager.countNodes(b).liveReplicas());
        }
    }

    @Override
    public void adjustSafeModeBlockTotals(List<Block> deltaSafe, int deltaTotal) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.adjustBlockTotals(deltaSafe, deltaTotal);
    }

    private void setBlockTotal() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.setBlockTotal(this.blockManager.getTotalCompleteBlocks());
    }

    @Override
    public long getCacheCapacity() {
        return this.datanodeStatistics.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.datanodeStatistics.getCacheUsed();
    }

    @Override
    @Metric
    public long getBlocksTotal() throws IOException {
        return this.blockManager.getTotalBlocks();
    }

    private long getCompleteBlocksTotal() throws IOException {
        long numUCBlocks = this.leaseManager.getNumUnderConstructionBlocks();
        return this.getBlocksTotal() - numUCBlocks;
    }

    void enterSafeMode(boolean resourcesLow) throws IOException {
        this.stopSecretManager();
        this.shouldPopulateReplicationQueue = true;
        this.inSafeMode.set(true);
        this.forceReadTheSafeModeFromDB.set(true);
        if (!resourcesLow && !this.isLeader()) {
            return;
        }
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            if (resourcesLow) {
                safeMode.setResourcesLow();
            } else {
                safeMode.setManual();
            }
        }
        if (safeMode == null || !this.isInSafeMode()) {
            safeMode = new SafeModeInfo(resourcesLow);
        }
        if (resourcesLow) {
            safeMode.setResourcesLow();
        } else {
            safeMode.setManual();
        }
        HdfsVariables.setSafeModeInfo(safeMode, 0L);
        NameNode.stateChangeLog.info("STATE* Safe mode is ON" + safeMode.getTurnOffTip());
    }

    void leaveSafeMode() throws IOException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info("STATE* Safe mode is already OFF");
            return;
        }
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            safeMode.leave();
        }
    }

    String getSafeModeTip() throws IOException {
        boolean inSafeMode;
        if (!this.isInSafeMode()) {
            return "";
        }
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            inSafeMode = false;
        } else {
            if (safeMode.isOn() && !this.isLeader()) {
                safeMode.tryToHelpToGetOut();
            }
            inSafeMode = safeMode.isOn();
        }
        if (!inSafeMode) {
            return "";
        }
        return safeMode.getTurnOffTip();
    }

    public StorageReceivedDeletedBlocks processIncrementalBlockReport(DatanodeRegistration nodeReg, StorageReceivedDeletedBlocks r) throws IOException {
        return this.blockManager.processIncrementalBlockReport(nodeReg, r);
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.superGroup, permission);
    }

    @Override
    public void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    @Override
    public long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    @Metric
    public long getFilesTotal() {
        try {
            return this.dir.totalInodes();
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return -1L;
        }
    }

    @Override
    @Metric
    public long getPendingReplicationBlocks() {
        return this.blockManager.getPendingReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getUnderReplicatedBlocks() {
        return this.blockManager.getUnderReplicatedBlocksCount();
    }

    @Metric(value={"CorruptBlocks", "Number of blocks with corrupt replicas"})
    public long getCorruptReplicaBlocks() {
        return this.blockManager.getCorruptReplicaBlocksCount();
    }

    @Override
    @Metric
    public long getScheduledReplicationBlocks() {
        return this.blockManager.getScheduledReplicationBlocksCount();
    }

    @Override
    @Metric
    public long getPendingDeletionBlocks() throws IOException {
        return this.blockManager.getPendingDeletionBlocksCount();
    }

    @Override
    public long getBlockDeletionStartTime() {
        return this.startTime + this.blockManager.getStartupDelayBlockDeletionInMs();
    }

    @Metric
    public long getExcessBlocks() throws IOException {
        return this.blockManager.getExcessBlocksCount();
    }

    @Metric
    public long getPostponedMisreplicatedBlocks() {
        return this.blockManager.getPostponedMisreplicatedBlocksCount();
    }

    @Metric
    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() throws IOException {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    private void registerMBean() {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad MBean setup", e);
        }
        LOG.info((Object)"Registered FSNamesystemState MBean");
    }

    void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
            this.mbeanName = null;
        }
        if (this.mxbeanName != null) {
            MBeans.unregister((ObjectName)this.mxbeanName);
            this.mxbeanName = null;
        }
        if (this.blockManager != null) {
            this.blockManager.shutdown();
        }
    }

    @Override
    @Metric(value={"LiveDataNodes", "Number of datanodes marked as live"})
    public int getNumLiveDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumLiveDataNodes();
    }

    @Override
    @Metric(value={"DeadDataNodes", "Number of datanodes marked dead due to delayed heartbeat"})
    public int getNumDeadDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumDeadDataNodes();
    }

    @Override
    public int getNumDecomLiveDataNodes() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int liveDecommissioned = 0;
        for (DatanodeDescriptor node : live) {
            liveDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return liveDecommissioned;
    }

    @Override
    public int getNumDecomDeadDataNodes() {
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(null, dead, true);
        int deadDecommissioned = 0;
        for (DatanodeDescriptor node : dead) {
            deadDecommissioned += node.isDecommissioned() ? 1 : 0;
        }
        return deadDecommissioned;
    }

    @Override
    public int getVolumeFailuresTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        int volumeFailuresTotal = 0;
        for (DatanodeDescriptor node : live) {
            volumeFailuresTotal += node.getVolumeFailures();
        }
        return volumeFailuresTotal;
    }

    @Override
    public long getEstimatedCapacityLostTotal() {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.getBlockManager().getDatanodeManager().fetchDatanodes(live, null, true);
        long estimatedCapacityLostTotal = 0L;
        for (DatanodeDescriptor node : live) {
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary == null) continue;
            estimatedCapacityLostTotal += volumeFailureSummary.getEstimatedCapacityLostTotal();
        }
        return estimatedCapacityLostTotal;
    }

    @Override
    public int getNumDecommissioningDataNodes() {
        return this.getBlockManager().getDatanodeManager().getDecommissioningNodes().size();
    }

    @Override
    @Metric(value={"StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat"})
    public int getNumStaleDataNodes() {
        return this.getBlockManager().getDatanodeManager().getNumStaleNodes();
    }

    @Override
    public int getNumStaleStorages() {
        return this.getBlockManager().getDatanodeManager().getNumStaleStorages();
    }

    @Override
    public String getTopUserOpCounts() {
        if (!this.topConf.isEnabled) {
            return null;
        }
        Date now = new Date();
        List<RollingWindowManager.TopWindow> topWindows = this.topMetrics.getTopWindows();
        TreeMap<String, Object> topMap = new TreeMap<String, Object>();
        topMap.put("windows", topWindows);
        topMap.put("timestamp", DFSUtil.dateToIso8601String(now));
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(topMap);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to fetch TopUser metrics", (Throwable)e);
            return null;
        }
    }

    private long nextBlockId() throws IOException {
        this.checkNameNodeSafeMode("Cannot get next block ID");
        return IDsGeneratorFactory.getInstance().getUniqueBlockID();
    }

    private INodeFile checkUCBlock(ExtendedBlock block, String clientName) throws IOException {
        this.checkNameNodeSafeMode("Cannot get a new generation stamp and an access token for block " + block);
        BlockInfoContiguous storedBlock = this.getStoredBlock(ExtendedBlock.getLocalBlock((ExtendedBlock)block));
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + (Object)((Object)storedBlock));
        }
        INodeFile file = (INodeFile)storedBlock.getBlockCollection();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + (Object)((Object)storedBlock) + " belonged to does not exist or it is not under construction.");
        }
        if (clientName == null || !clientName.equals(file.getFileUnderConstructionFeature().getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return file;
    }

    void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        NameNode.stateChangeLog.info("*DIR* reportBadBlocks");
        for (LocatedBlock block : blocks) {
            ExtendedBlock blk = block.getBlock();
            DatanodeInfo[] nodes = block.getLocations();
            String[] storageIDs = block.getStorageIDs();
            for (int j = 0; j < nodes.length; ++j) {
                this.blockManager.findAndMarkBlockAsCorrupt(blk, nodes[j], storageIDs == null ? null : storageIDs[j], "client machine reported it");
            }
        }
    }

    LocatedBlock updateBlockForPipeline(final ExtendedBlock block, final String clientName) throws IOException {
        HopsTransactionalRequestHandler updateBlockForPipelineHandler = new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_BLOCK_FOR_PIPELINE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block b = block.getLocalBlock();
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(b);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getBlockLock(block.getBlockId(), this.inodeIdentifier));
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkUCBlock(block, clientName);
                INodeFile pendingFile = (INodeFile)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{this.inodeIdentifier.getInodeId()});
                block.setGenerationStamp((long)pendingFile.nextGenerationStamp());
                LocatedBlock locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
                FSNamesystem.this.blockManager.setBlockToken(locatedBlock, BlockTokenIdentifier.AccessMode.WRITE);
                return locatedBlock;
            }
        };
        return (LocatedBlock)updateBlockForPipelineHandler.handle(this);
    }

    void updatePipeline(final String clientName, final ExtendedBlock oldBlock, final ExtendedBlock newBlock, final DatanodeID[] newNodes, final String[] newStorageIDs) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_PIPELINE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block b = oldBlock.getLocalBlock();
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock(b);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ, FSNamesystem.this.leaseCreationLockRows)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock(oldBlock.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.UC)).add(lf.getLastBlockHashBucketsLock());
                if (FSNamesystem.this.isRetryCacheEnabled) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    FSNamesystem.this.checkNameNodeSafeMode("Pipeline not updated");
                    assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
                    LOG.info((Object)("updatePipeline(" + oldBlock.getLocalBlock() + ", newGS=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", client=" + clientName + ")"));
                    FSNamesystem.this.updatePipelineInternal(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
                    LOG.info((Object)("updatePipeline(" + oldBlock.getLocalBlock() + " => " + newBlock.getLocalBlock() + ") success"));
                    success = true;
                    Object var3_3 = null;
                    return var3_3;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
            }
        }.handle(this);
    }

    private void updatePipelineInternal(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException, StorageException {
        INodeFile pendingFile = this.checkUCBlock(oldBlock, clientName);
        pendingFile.getFileUnderConstructionFeature().updateLastTwoBlocks(this.leaseManager.getLease(clientName));
        BlockInfoContiguousUnderConstruction blockInfo = (BlockInfoContiguousUnderConstruction)pendingFile.getLastBlock();
        if (newBlock.getGenerationStamp() <= blockInfo.getGenerationStamp() || newBlock.getNumBytes() < blockInfo.getNumBytes()) {
            String msg = "Update " + oldBlock + " (len = " + blockInfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        for (Replica replica : blockInfo.getReplicas(this.blockManager.getDatanodeManager())) {
            HashBuckets.getInstance().undoHash(replica.getStorageId(), HdfsServerConstants.ReplicaState.FINALIZED, oldBlock.getLocalBlock());
        }
        blockInfo.setNumBytes(newBlock.getNumBytes());
        blockInfo.setGenerationStampAndVerifyReplicas(newBlock.getGenerationStamp(), this.blockManager.getDatanodeManager());
        pendingFile.recomputeFileSize();
        DatanodeStorageInfo[] storages = this.blockManager.getDatanodeManager().getDatanodeStorageInfos(newNodes, newStorageIDs);
        blockInfo.setExpectedLocations(storages);
    }

    void unprotectedChangeLease(String src, String dst) throws StorageException, TransactionContextException {
        this.leaseManager.changeLease(src, dst);
    }

    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(final String path, String[] cookieTab) throws IOException {
        this.checkSuperuserPrivilege();
        final int[] count = new int[]{0};
        final ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
        if (cookieTab == null) {
            cookieTab = new String[]{null};
        }
        if (this.blockManager.getMissingBlocksCount() == 0L) {
            if (cookieTab[0] == null) {
                cookieTab[0] = String.valueOf(FSNamesystem.getIntCookie(cookieTab[0]));
            }
            LOG.debug((Object)"there are no corrupt file blocks.");
            return corruptFiles;
        }
        if (!this.isPopulatingReplQueues()) {
            throw new IOException("Cannot run listCorruptFileBlocks because replication queues have not been initialized.");
        }
        Iterator<Block> blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
        final int[] skip = new int[]{FSNamesystem.getIntCookie(cookieTab[0])};
        for (int i = 0; i < skip[0] && blkIterator.hasNext(); ++i) {
            blkIterator.next();
        }
        HopsTransactionalRequestHandler listCorruptFileBlocksHandler = new HopsTransactionalRequestHandler(HDFSOperationType.LIST_CORRUPT_FILE_BLOCKS){
            INodeIdentifier iNodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                Block block = (Block)this.getParams()[0];
                this.iNodeIdentifier = INodeUtil.resolveINodeFromBlock(block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                Block block = (Block)this.getParams()[0];
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, this.iNodeIdentifier, true)).add(lf.getBlockLock(block.getBlockId(), this.iNodeIdentifier)).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER));
            }

            public Object performTask() throws IOException {
                String src;
                Block blk = (Block)this.getParams()[0];
                INodeFile inode = (INodeFile)FSNamesystem.this.blockManager.getBlockCollection(blk);
                skip[0] = skip[0] + 1;
                if (inode != null && FSNamesystem.this.blockManager.countNodes(blk).liveReplicas() == 0 && (src = FSDirectory.getFullPathName(inode)).startsWith(path)) {
                    corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                    count[0] = count[0] + 1;
                }
                return null;
            }
        };
        while (blkIterator.hasNext()) {
            Block blk = blkIterator.next();
            listCorruptFileBlocksHandler.setParams(new Object[]{blk});
            listCorruptFileBlocksHandler.handle(this);
            if (count[0] < 100) continue;
            break;
        }
        cookieTab[0] = String.valueOf(skip[0]);
        LOG.info((Object)("list corrupt file blocks returned: " + count[0]));
        return corruptFiles;
    }

    private static int getIntCookie(String cookie) {
        int c;
        if (cookie == null) {
            c = 0;
        } else {
            try {
                c = Integer.parseInt(cookie);
            }
            catch (NumberFormatException e) {
                c = 0;
            }
        }
        c = Math.max(0, c);
        return c;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false), this);
    }

    DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    Token<DelegationTokenIdentifier> getDelegationToken(final Text renewer) throws IOException {
        HopsTransactionalRequestHandler getDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot issue delegation token");
                if (!FSNamesystem.this.isAllowedDelegationTokenOp()) {
                    throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
                }
                if (FSNamesystem.this.dtSecretManager == null || !FSNamesystem.this.dtSecretManager.isRunning()) {
                    LOG.warn((Object)"trying to get DT with no secret manager running");
                    return null;
                }
                UserGroupInformation ugi = FSNamesystem.getRemoteUser();
                String user = ugi.getUserName();
                Text owner = new Text(user);
                Text realUser = null;
                if (ugi.getRealUser() != null) {
                    realUser = new Text(ugi.getRealUser().getUserName());
                }
                DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
                Token token = new Token((TokenIdentifier)dtId, (SecretManager)FSNamesystem.this.dtSecretManager);
                long expiryTime = FSNamesystem.this.dtSecretManager.getTokenExpiryTime(dtId);
                return token;
            }
        };
        return (Token)getDelegationTokenHandler.handle(this);
    }

    long renewDelegationToken(final Token<DelegationTokenIdentifier> token) throws IOException {
        HopsTransactionalRequestHandler renewDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.RENEW_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot renew delegation token");
                if (!FSNamesystem.this.isAllowedDelegationTokenOp()) {
                    throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
                }
                String renewer = FSNamesystem.getRemoteUser().getShortUserName();
                long expiryTime = FSNamesystem.this.dtSecretManager.renewToken(token, renewer);
                DelegationTokenIdentifier id = new DelegationTokenIdentifier();
                ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
                DataInputStream in = new DataInputStream(buf);
                id.readFields((DataInput)in);
                return expiryTime;
            }
        };
        return (Long)renewDelegationTokenHandler.handle(this);
    }

    void cancelDelegationToken(final Token<DelegationTokenIdentifier> token) throws IOException {
        HopsTransactionalRequestHandler cancelDelegationTokenHandler = new HopsTransactionalRequestHandler(HDFSOperationType.CANCEL_DELEGATION_TOKEN){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws IOException {
                FSNamesystem.this.checkNameNodeSafeMode("Cannot cancel delegation token");
                String canceller = FSNamesystem.getRemoteUser().getUserName();
                DelegationTokenIdentifier id = (DelegationTokenIdentifier)FSNamesystem.this.dtSecretManager.cancelToken(token, canceller);
                return null;
            }
        };
        cancelDelegationTokenHandler.handle(this);
    }

    public void logUpdateMasterKey(DelegationKey key) throws IOException {
        assert (!this.isInSafeMode()) : "this should never be called while in safe mode, since we stop the DT manager before entering safe mode!";
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = FSNamesystem.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    boolean isExternalInvocation() {
        return Server.isRpcInvocation() || NamenodeWebHdfsMethods.isWebHdfsInvocation();
    }

    private static InetAddress getRemoteIp() {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            return ip;
        }
        return NamenodeWebHdfsMethods.getRemoteIp();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (this.isAuditEnabled()) {
            this.logAuditEvent(true, FSNamesystem.getRemoteUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        this.mxbeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)this);
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() throws IOException {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON. " + this.getSafeModeTip();
    }

    public boolean isUpgradeFinalized() {
        throw new UnsupportedOperationException("HOP: Upgrade is not supported");
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.datanodeStatistics.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.datanodeStatistics.getCapacityUsedPercent();
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return this.datanodeStatistics.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.datanodeStatistics.getPercentBlockPoolUsed();
    }

    @Override
    public float getPercentRemaining() {
        return this.datanodeStatistics.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() throws IOException {
        return this.getBlocksTotal();
    }

    @Override
    @Metric
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public long getNumberOfMissingBlocks() throws IOException {
        return this.getMissingBlocksCount();
    }

    @Override
    public long getNumberOfMissingBlocksWithReplicationFactorOne() throws IOException {
        return this.getMissingReplOneBlocksCount();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() throws IOException {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        for (DatanodeDescriptor node : live) {
            ImmutableMap.Builder innerinfo = ImmutableMap.builder();
            innerinfo.put((Object)"infoAddr", (Object)node.getInfoAddr()).put((Object)"infoSecureAddr", (Object)node.getInfoSecureAddr()).put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"usedSpace", (Object)this.getDfsUsed(node)).put((Object)"adminState", (Object)node.getAdminState().toString()).put((Object)"nonDfsUsedSpace", (Object)node.getNonDfsUsed()).put((Object)"capacity", (Object)node.getCapacity()).put((Object)"numBlocks", (Object)node.numBlocks()).put((Object)"version", (Object)node.getSoftwareVersion()).put((Object)"used", (Object)node.getDfsUsed()).put((Object)"remaining", (Object)node.getRemaining()).put((Object)"blockScheduled", (Object)node.getBlocksScheduled()).put((Object)"blockPoolUsed", (Object)node.getBlockPoolUsed()).put((Object)"blockPoolUsedPercent", (Object)Float.valueOf(node.getBlockPoolUsedPercent())).put((Object)"volfails", (Object)node.getVolumeFailures());
            VolumeFailureSummary volumeFailureSummary = node.getVolumeFailureSummary();
            if (volumeFailureSummary != null) {
                innerinfo.put((Object)"failedStorageLocations", (Object)volumeFailureSummary.getFailedStorageLocations()).put((Object)"lastVolumeFailureDate", (Object)volumeFailureSummary.getLastVolumeFailureDate()).put((Object)"estimatedCapacityLostTotal", (Object)volumeFailureSummary.getEstimatedCapacityLostTotal());
            }
            info.put(node.getHostName() + ":" + node.getXferPort(), innerinfo.build());
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(null, dead, true);
        for (DatanodeDescriptor node : dead) {
            ImmutableMap innerInfo = ImmutableMap.builder().put((Object)"lastContact", (Object)this.getLastContact(node)).put((Object)"decommissioned", (Object)node.isDecommissioned()).put((Object)"xferaddr", (Object)node.getXferAddr()).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerInfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap<String, ImmutableMap> info = new HashMap<String, ImmutableMap>();
        List<DatanodeDescriptor> decomNodeList = this.blockManager.getDatanodeManager().getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            ImmutableMap innerInfo = ImmutableMap.builder().put((Object)"xferaddr", (Object)node.getXferAddr()).put((Object)"underReplicatedBlocks", (Object)node.decommissioningStatus.getUnderReplicatedBlocks()).put((Object)"decommissionOnlyReplicas", (Object)node.decommissioningStatus.getDecommissionOnlyReplicas()).put((Object)"underReplicateInOpenFiles", (Object)node.decommissioningStatus.getUnderReplicatedInOpenFiles()).build();
            info.put(node.getHostName() + ":" + node.getXferPort(), innerInfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (Time.monotonicNow() - alivenode.getLastUpdateMonotonic()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor aliveNode) {
        return aliveNode.getDfsUsed();
    }

    @Override
    public String getClusterId() {
        String cid = "";
        try {
            cid = StorageInfo.getStorageInfoFromDB().getClusterID();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cid;
    }

    @Override
    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public String getNameDirStatuses() {
        throw new UnsupportedOperationException("HOP: there are no name dirs any more");
    }

    @Override
    public String getNodeUsage() {
        float median = 0.0f;
        float max = 0.0f;
        float min = 0.0f;
        float dev = 0.0f;
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        this.blockManager.getDatanodeManager().fetchDatanodes(live, null, true);
        if (live.size() > 0) {
            float totalDfsUsed = 0.0f;
            float[] usages = new float[live.size()];
            int i = 0;
            for (DatanodeDescriptor dn : live) {
                usages[i++] = dn.getDfsUsedPercent();
                totalDfsUsed += dn.getDfsUsedPercent();
            }
            totalDfsUsed /= (float)live.size();
            Arrays.sort(usages);
            median = usages[usages.length / 2];
            max = usages[usages.length - 1];
            min = usages[0];
            for (i = 0; i < usages.length; ++i) {
                dev += (usages[i] - totalDfsUsed) * (usages[i] - totalDfsUsed);
            }
            dev = (float)Math.sqrt(dev / (float)usages.length);
        }
        HashMap<String, String> innerInfo = new HashMap<String, String>();
        innerInfo.put("min", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(min)}));
        innerInfo.put("median", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(median)}));
        innerInfo.put("max", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(max)}));
        innerInfo.put("stdDev", StringUtils.format((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(dev)}));
        info.put("nodeUsage", innerInfo);
        return JSON.toString(info);
    }

    @Override
    public String getNNStarted() {
        return this.getStartTime().toString();
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    public FSDirectory getFSDirectory() {
        return this.dir;
    }

    @VisibleForTesting
    public void setFSDirectory(FSDirectory dir) {
        this.dir = dir;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getCorruptFiles() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Collection<CorruptFileBlockInfo> corruptFileBlocks = this.listCorruptFileBlocks("/", null);
            int corruptFileCount = corruptFileBlocks.size();
            if (corruptFileCount != 0) {
                for (CorruptFileBlockInfo c : corruptFileBlocks) {
                    list.add(c.toString());
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Get corrupt file blocks returned error: " + e.getMessage()));
        }
        return JSON.toString(list);
    }

    @Override
    public int getDistinctVersionCount() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions().size();
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return this.blockManager.getDatanodeManager().getDatanodesSoftwareVersions();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public int getNumNameNodes() {
        return this.nameNode.getActiveNameNodes().size();
    }

    @Override
    public String getLeaderNameNode() {
        return ((ActiveNode)this.nameNode.getActiveNameNodes().getSortedActiveNodes().get(0)).getHostname();
    }

    @Override
    public String getDatabaseUtilization() {
        try {
            DecimalFormat df = new DecimalFormat("0.00");
            return df.format(HdfsStorageFactory.getResourceMemUtilization());
        }
        catch (StorageException e) {
            e.printStackTrace();
            return "Unable to connect to DB";
        }
    }

    public synchronized void verifyToken(DelegationTokenIdentifier identifier, byte[] password) throws SecretManager.InvalidToken, RetriableException {
        try {
            this.getDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)identifier, password);
        }
        catch (SecretManager.InvalidToken it) {
            if (this.inTransitionToActive()) {
                throw new RetriableException((Exception)((Object)it));
            }
            throw it;
        }
    }

    @Override
    public boolean isGenStampInFuture(Block block) throws StorageException {
        throw new UnsupportedOperationException("Not supported anymore.");
    }

    @VisibleForTesting
    public SafeModeInfo getSafeModeInfoForTests() throws IOException {
        return this.safeMode();
    }

    @VisibleForTesting
    public void setNNResourceChecker(NameNodeResourceChecker nnResourceChecker) {
        this.nnResourceChecker = nnResourceChecker;
    }

    RollingUpgradeInfo queryRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        return this.getRollingUpgradeInfoTX();
    }

    RollingUpgradeInfo startRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        long startTime = Time.now();
        this.checkNameNodeSafeMode("Failed to start rolling upgrade");
        RollingUpgradeInfo rollingUpgradeInfo = this.startRollingUpgradeInternal(startTime);
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "startRollingUpgrade", null, null, null);
        }
        return rollingUpgradeInfo;
    }

    RollingUpgradeInfo startRollingUpgradeInternal(final long startTime) throws IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                FSNamesystem.this.checkRollingUpgrade("start rolling upgrade");
                return FSNamesystem.this.setRollingUpgradeInfo(startTime);
            }
        }.handle();
    }

    RollingUpgradeInfo setRollingUpgradeInfo(long startTime) throws TransactionContextException, StorageException {
        RollingUpgradeInfo rollingUpgradeInfo = new RollingUpgradeInfo(this.blockPoolId, startTime, 0L);
        HdfsVariables.setRollingUpgradeInfo(rollingUpgradeInfo);
        return rollingUpgradeInfo;
    }

    public RollingUpgradeInfo getRollingUpgradeInfoTX() throws IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.READ));
            }

            public Object performTask() throws StorageException, IOException {
                return HdfsVariables.getRollingUpgradeInfo();
            }
        }.handle();
    }

    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        RollingUpgradeInfo upgradeInfo = null;
        try {
            upgradeInfo = this.getRollingUpgradeInfoTX();
        }
        catch (IOException ex) {
            LOG.warn((Object)ex);
        }
        if (upgradeInfo != null) {
            return new RollingUpgradeInfo.Bean(upgradeInfo);
        }
        return null;
    }

    public boolean isRollingUpgrade() throws TransactionContextException, StorageException, InvalidProtocolBufferException {
        return HdfsVariables.getRollingUpgradeInfo() != null;
    }

    public boolean isRollingUpgradeTX() throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.READ));
            }

            public Object performTask() throws StorageException, IOException {
                return FSNamesystem.this.isRollingUpgrade();
            }
        }.handle();
    }

    void checkRollingUpgrade(String action) throws RollingUpgradeException, TransactionContextException, StorageException, InvalidProtocolBufferException {
        if (this.isRollingUpgrade()) {
            throw new RollingUpgradeException("Failed to " + action + " since a rolling upgrade is already in progress. Existing rolling upgrade info:\n" + HdfsVariables.getRollingUpgradeInfo());
        }
    }

    RollingUpgradeInfo finalizeRollingUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.checkNameNodeSafeMode("Failed to finalize rolling upgrade");
        RollingUpgradeInfo returnInfo = this.finalizeRollingUpgradeInternal(Time.now());
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            this.logAuditEvent(true, "finalizeRollingUpgrade", null, null, null);
        }
        return returnInfo;
    }

    RollingUpgradeInfo finalizeRollingUpgradeInternal(final long finalizeTime) throws RollingUpgradeException, IOException {
        return (RollingUpgradeInfo)new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                if (!FSNamesystem.this.isRollingUpgrade()) {
                    throw new RollingUpgradeException("Failed to finalize rolling upgrade since there is no rolling upgrade in progress.");
                }
                long startTime = HdfsVariables.getRollingUpgradeInfo().getStartTime();
                HdfsVariables.setRollingUpgradeInfo(null);
                return new RollingUpgradeInfo(FSNamesystem.this.blockPoolId, startTime, finalizeTime);
            }
        }.handle();
    }

    static void rollBackRollingUpgradeTX() throws RollingUpgradeException, IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ROLLING_UPGRADE_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.RollingUpgradeInfo, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                HdfsVariables.setRollingUpgradeInfo(null);
                return null;
            }
        }.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        boolean success;
        CacheDirectiveInfo effectiveDirective = null;
        if (!flags.contains(CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add cache directive", this.safeMode());
            }
            effectiveDirective = FSNDNCacheOp.addCacheDirective(this, this.dir, this.cacheManager, directive, flags);
            success = effectiveDirective != null;
        }
        catch (Throwable throwable) {
            boolean success2 = effectiveDirective != null;
            String effectiveDirectiveStr = effectiveDirective != null ? effectiveDirective.toString() : null;
            this.logAuditEvent(success2, "addCacheDirective", effectiveDirectiveStr, null, null);
            throw throwable;
        }
        String effectiveDirectiveStr = effectiveDirective != null ? effectiveDirective.toString() : null;
        this.logAuditEvent(success, "addCacheDirective", effectiveDirectiveStr, null, null);
        return effectiveDirective != null ? effectiveDirective.getId() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        boolean success = false;
        if (!flags.contains(CacheFlag.FORCE)) {
            this.cacheManager.waitForRescanIfNeeded();
        }
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add cache directive", this.safeMode());
            }
            FSNDNCacheOp.modifyCacheDirective(this, this.dir, this.cacheManager, directive, flags);
            success = true;
        }
        finally {
            String idStr = "{id: " + directive.getId().toString() + "}";
            this.logAuditEvent(success, "modifyCacheDirective", idStr, directive.toString(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCacheDirective(long id) throws IOException {
        boolean success = false;
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot remove cache directives", this.safeMode());
            }
            FSNDNCacheOp.removeCacheDirective(this, this.cacheManager, id);
            success = true;
        }
        finally {
            String idStr = "{id: " + Long.toString(id) + "}";
            this.logAuditEvent(success, "removeCacheDirective", idStr, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> listCacheDirectives(long startId, CacheDirectiveInfo filter) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CacheDirectiveEntry> results;
        this.cacheManager.waitForRescanIfNeeded();
        boolean success = false;
        try {
            results = FSNDNCacheOp.listCacheDirectives(this, this.cacheManager, startId, filter);
            success = true;
        }
        finally {
            this.logAuditEvent(success, "listCacheDirectives", filter.toString(), null, null);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCachePool(CachePoolInfo req) throws IOException {
        boolean success = false;
        String poolInfoStr = null;
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add cache pool " + req.getPoolName(), this.safeMode());
            }
            CachePoolInfo info = FSNDNCacheOp.addCachePool(this, this.cacheManager, req);
            poolInfoStr = info.toString();
            success = true;
        }
        catch (Throwable throwable) {
            this.logAuditEvent(success, "addCachePool", poolInfoStr, null, null);
            throw throwable;
        }
        this.logAuditEvent(success, "addCachePool", poolInfoStr, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modifyCachePool(CachePoolInfo req) throws IOException {
        boolean success = false;
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot modify cache pool " + req.getPoolName(), this.safeMode());
            }
            FSNDNCacheOp.modifyCachePool(this, this.cacheManager, req);
            success = true;
            String poolNameStr = "{poolName: " + (req == null ? null : req.getPoolName()) + "}";
            this.logAuditEvent(success, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
        }
        catch (Throwable throwable) {
            String poolNameStr = "{poolName: " + (req == null ? null : req.getPoolName()) + "}";
            this.logAuditEvent(success, "modifyCachePool", poolNameStr, req == null ? null : req.toString(), null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachePool(String cachePoolName) throws IOException {
        boolean success = false;
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot remove cache pool " + cachePoolName, this.safeMode());
            }
            FSNDNCacheOp.removeCachePool(this, this.cacheManager, cachePoolName);
            success = true;
        }
        finally {
            String poolNameStr = "{poolName: " + cachePoolName + "}";
            this.logAuditEvent(success, "removeCachePool", poolNameStr, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        BatchedRemoteIterator.BatchedListEntries<CachePoolEntry> results;
        boolean success = false;
        this.cacheManager.waitForRescanIfNeeded();
        try {
            results = FSNDNCacheOp.listCachePools(this, this.cacheManager, prevKey);
            success = true;
        }
        finally {
            this.logAuditEvent(success, "listCachePools", null, null, null);
        }
        return results;
    }

    private void hopSpecificInitialization(Configuration conf) throws IOException {
        HdfsStorageFactory.setConfiguration(conf);
    }

    @Override
    public boolean isLeader() {
        return this.nameNode.isLeader();
    }

    @Override
    public long getNamenodeId() {
        return this.nameNode.getLeCurrentId();
    }

    public String getSuperGroup() {
        return this.superGroup;
    }

    public void performPendingSafeModeOperation() throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode != null) {
            safeMode.performSafeModePendingOperation();
        }
    }

    void changeConf(List<String> props, List<String> newVals) throws IOException {
        for (int i = 0; i < props.size(); ++i) {
            String prop = props.get(i);
            String value = newVals.get(i);
            if (prop.equals("dfs.resolvingcache.enabled") || prop.equals("dfs.ndb.setpartitionkey.enabled")) {
                LOG.info((Object)("change configuration for  " + prop + " to " + value));
                this.conf.set(prop, value);
                if (!prop.equals("dfs.resolvingcache.enabled")) continue;
                Cache.getInstance().enableOrDisable(Boolean.parseBoolean(value));
                continue;
            }
            LOG.info((Object)("change configuration for  " + prop + " to " + value + " is not supported yet"));
        }
    }

    @Override
    public void adjustSafeModeBlocks(Set<Long> safeBlocks) throws IOException {
        SafeModeInfo safeMode = this.safeMode();
        if (safeMode == null) {
            return;
        }
        safeMode.adjustSafeBlocks(safeBlocks);
    }

    public QuotaUpdateManager getQuotaUpdateManager() {
        return this.quotaUpdateManager;
    }

    private int addSafeBlock(Long safeBlock) throws IOException {
        AtomicInteger added = new AtomicInteger(0);
        ArrayList<Long> safeBlocks = new ArrayList<Long>();
        safeBlocks.add(safeBlock);
        this.addSafeBlocksTX(safeBlocks, added);
        return added.get();
    }

    private void removeSafeBlock(final Long safeBlock) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.REMOVE_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                if (da.isSafe(safeBlock)) {
                    da.remove(safeBlock);
                }
                return null;
            }
        }.handle();
    }

    private void addSafeBlocksTX(final List<Long> safeBlocks, final AtomicInteger added) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.ADD_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                boolean inTransaction = connector.isTransactionActive();
                if (!inTransaction) {
                    connector.beginTransaction();
                    connector.writeLock();
                }
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                int before = da.countAll();
                da.insert((Collection)safeBlocks);
                connector.flush();
                int after = da.countAll();
                added.addAndGet(after - before);
                if (!inTransaction) {
                    connector.commit();
                }
                return null;
            }
        }.handle();
    }

    private int addSafeBlocks(final List<Long> safeBlocks) throws IOException {
        final AtomicInteger added = new AtomicInteger(0);
        try {
            Slicer.slice((int)safeBlocks.size(), (int)this.slicerBatchSize, (int)this.slicerNbThreads, (ExecutorService)this.fsOperationsExecutor, (Slicer.OperationHandler)new Slicer.OperationHandler(){

                public void handle(int startIndex, int endIndex) throws Exception {
                    List ids = safeBlocks.subList(startIndex, endIndex);
                    FSNamesystem.this.addSafeBlocksTX(ids, added);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        return added.get();
    }

    private int getBlockSafe() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.GET_SAFE_BLOCKS_COUNT){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                return da.countAll();
            }
        }.handle();
    }

    private void clearSafeBlocks() throws IOException {
        LOG.warn((Object)"cealring the safe blocks tabl, this may take some time.");
        new LightWeightRequestHandler(HDFSOperationType.CLEAR_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                SafeBlocksDataAccess da = (SafeBlocksDataAccess)HdfsStorageFactory.getDataAccess(SafeBlocksDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    private void clearActiveBlockReports() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.CLEAR_SAFE_BLOCKS){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    public ExecutorService getFSOperationsExecutor() {
        return this.fsOperationsExecutor;
    }

    public INodeIdentifier lockSubtree(String path, SubTreeOperation.Type stoType) throws IOException {
        return this.lockSubtreeAndCheckOwnerAndParentPermission(path, false, null, stoType);
    }

    @VisibleForTesting
    INodeIdentifier lockSubtreeAndCheckOwnerAndParentPermission(final String path, final boolean doCheckOwner, final FsAction parentAccess, final SubTreeOperation.Type stoType) throws IOException {
        if (path.compareTo("/") == 0) {
            return null;
        }
        return (INodeIdentifier)new HopsTransactionalRequestHandler(HDFSOperationType.SET_SUBTREE_LOCK){

            @Override
            public void setUp() throws IOException {
                super.setUp();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("About to lock \"" + path + "\""));
                }
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path);
                il.setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled()).enableHierarchicalLocking(FSNamesystem.this.conf.getBoolean("dfs.namenode.subtree.hierarchical.locking", true));
                locks.add((Lock)il).add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.READ_COMMITTED, FSNamesystem.this.getSubTreeLockPathPrefix(path), true));
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INode inode;
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(path, false);
                if (FSNamesystem.this.isPermissionEnabled && !pc.isSuperUser()) {
                    FSNamesystem.this.dir.checkPermission(pc, iip, doCheckOwner, null, parentAccess, null, null, true);
                }
                if ((inode = iip.getLastINode()) != null && inode.isDirectory() && !inode.isRoot()) {
                    FSNamesystem.this.checkSubTreeLocks(FSNamesystem.this.getSubTreeLockPathPrefix(path));
                    inode.setSubtreeLocked(true);
                    inode.setSubtreeLockOwner(FSNamesystem.this.getNamenodeId());
                    EntityManager.update((Object)inode);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Lock the INode with sub tree lock flag. Path: \"" + path + "\"  id: " + inode.getId() + " pid: " + inode.getParentId() + " name: " + inode.getLocalName()));
                    }
                    EntityManager.update((Object)new SubTreeOperation(FSNamesystem.this.getSubTreeLockPathPrefix(path), inode.getId(), FSNamesystem.this.nameNode.getId(), stoType, System.currentTimeMillis(), pc.getUser()));
                    INodeIdentifier iNodeIdentifier = new INodeIdentifier(Long.valueOf(inode.getId()), Long.valueOf(inode.getParentId()), inode.getLocalName(), inode.getPartitionId());
                    iNodeIdentifier.setDepth(Short.valueOf(inode.myDepth()));
                    iNodeIdentifier.setStoragePolicy(inode.getStoragePolicyID());
                    FSNamesystem.this.delayBeforeSTOFlag(stoType.toString());
                    return iNodeIdentifier;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No component was locked in the path using sub tree flag. Path: \"" + path + "\""));
                }
                return null;
            }
        }.handle(this);
    }

    String getSubTreeLockPathPrefix(String path) {
        String subTreeLockPrefix = path;
        if (!subTreeLockPrefix.endsWith("/")) {
            subTreeLockPrefix = subTreeLockPrefix + "/";
        }
        return subTreeLockPrefix;
    }

    private void checkSubTreeLocks(String path) throws TransactionContextException, StorageException, RetriableException {
        List ops = (List)EntityManager.findList((FinderType)SubTreeOperation.Finder.ByPathPrefix, (Object[])new Object[]{path});
        HashSet<Long> activeNameNodeIds = new HashSet<Long>();
        for (ActiveNode node : this.nameNode.getActiveNameNodes().getActiveNodes()) {
            activeNameNodeIds.add(node.getId());
        }
        for (SubTreeOperation op : ops) {
            if (activeNameNodeIds.contains(op.getNameNodeId())) {
                throw new RetriableException("At least one ongoing subtree operation on the descendants of this subtree, e.g., Path: " + op.getPath() + " Operation: " + op.getOpType() + " NameNodeId: " + op.getNameNodeId());
            }
            EntityManager.remove((Object)op);
        }
    }

    @VisibleForTesting
    void unlockSubtreeInternal(final String path, final long ignoreStoInodeId) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RESET_SUBTREE_LOCK){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = (INodeLock)lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled()).setIgnoredSTOInodes(ignoreStoInodeId).enableHierarchicalLocking(FSNamesystem.this.conf.getBoolean("dfs.namenode.subtree.hierarchical.locking", true));
                locks.add((Lock)il);
                locks.add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.WRITE, FSNamesystem.this.getSubTreeLockPathPrefix(path), false));
            }

            public Object performTask() throws IOException {
                SubTreeOperation subTreeOp;
                INodesInPath inodesInPath = FSNamesystem.this.dir.getINodesInPath(path, false);
                INode inode = inodesInPath.getLastINode();
                if (inode != null && inode.isSTOLocked()) {
                    inode.setSubtreeLocked(false);
                    EntityManager.update((Object)inode);
                }
                if ((subTreeOp = (SubTreeOperation)EntityManager.find((FinderType)SubTreeOperation.Finder.ByPath, (Object[])new Object[]{FSNamesystem.this.getSubTreeLockPathPrefix(path)})) != null) {
                    EntityManager.remove((Object)subTreeOp);
                }
                return null;
            }
        }.handle(this);
    }

    @VisibleForTesting
    void unlockSubtree(String path, long ignoreStoInodeId) throws IOException {
        try {
            this.unlockSubtreeInternal(path, ignoreStoInodeId);
        }
        catch (Exception e) {
            this.setAsyncLockRemoval(path);
            throw e;
        }
    }

    void setAsyncLockRemoval(final String path) throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.SET_ASYNC_SUBTREE_RECOVERY_FLAG){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess dataAccess = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                SubTreeOperation op = (SubTreeOperation)dataAccess.findByPath(FSNamesystem.this.getSubTreeLockPathPrefix(path));
                if (op != null && op.getAsyncLockRecoveryTime() == 0L) {
                    op.setAsyncLockRecoveryTime(System.currentTimeMillis());
                    ArrayList<SubTreeOperation> modified = new ArrayList<SubTreeOperation>();
                    modified.add(op);
                    dataAccess.prepare((Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST, modified);
                }
                return null;
            }
        };
        handler.handle();
    }

    private int pid(String param) {
        StringTokenizer tok = new StringTokenizer(param);
        tok.nextElement();
        return Integer.parseInt((String)tok.nextElement());
    }

    private String pname(String param) {
        StringTokenizer tok = new StringTokenizer(param);
        return (String)tok.nextElement();
    }

    @Override
    public NameNode getNameNode() {
        return this.nameNode;
    }

    public EncodingStatus getEncodingStatus(String filePathArg) throws IOException {
        byte[][] pathComponents;
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String filePath = this.dir.resolvePath(pc, filePathArg, pathComponents = FSDirectory.getPathComponentsForReservedPath(filePathArg));
        HopsTransactionalRequestHandler findReq = new HopsTransactionalRequestHandler(HDFSOperationType.FIND_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, filePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.READ_COMMITTED, filePath));
            }

            public Object performTask() throws IOException {
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(filePath, true);
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.READ);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "getEncodingStatus", filePath);
                    throw e;
                }
                INode targetNode = iip.getLastINode();
                if (targetNode == null) {
                    throw new FileNotFoundException();
                }
                return EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
            }
        };
        Object result = findReq.handle();
        if (result == null) {
            return new EncodingStatus(EncodingStatus.Status.NOT_ENCODED);
        }
        return (EncodingStatus)result;
    }

    public INode findInode(final long id) throws IOException {
        LightWeightRequestHandler findHandler = new LightWeightRequestHandler(HDFSOperationType.GET_INODE){

            public Object performTask() throws IOException {
                INodeDataAccess dataAccess = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return dataAccess.findInodeByIdFTIS(id);
            }
        };
        return (INode)findHandler.handle();
    }

    public String getPath(long id, boolean inTree) throws IOException {
        LinkedList<INode> resolvedInodes = new LinkedList<INode>();
        boolean[] resolved = new boolean[1];
        INodeUtil.findPathINodesById(id, inTree, resolvedInodes, resolved);
        if (!resolved[0]) {
            throw new IOException("Path could not be resolved for inode with id " + id);
        }
        return INodeUtil.constructPath(resolvedInodes);
    }

    public LocatedBlocks getMissingBlockLocations(String clientMachine, String filePath) throws IOException {
        LocatedBlocks blocks = this.getBlockLocations(clientMachine, filePath, 0L, Long.MAX_VALUE);
        Iterator iterator = blocks.getLocatedBlocks().iterator();
        while (iterator.hasNext()) {
            LocatedBlock b = (LocatedBlock)iterator.next();
            if (b.isCorrupt() || b.getLocations().length == 0 && b.getBlockSize() > 0L) continue;
            iterator.remove();
        }
        return blocks;
    }

    public void addEncodingStatus(String sourcePathArg, final EncodingPolicy policy, final EncodingStatus.Status status, final boolean checkRetryCache) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(sourcePathArg);
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String sourcePath = this.dir.resolvePath(pc, sourcePathArg, pathComponents);
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, sourcePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, sourcePath));
                if (FSNamesystem.this.isRetryCacheEnabled) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = null;
                if (checkRetryCache && (cacheEntry = LightWeightCacheDistributed.get()) != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(sourcePath, true);
                    try {
                        if (FSNamesystem.this.isPermissionEnabled) {
                            FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
                        }
                    }
                    catch (AccessControlException e) {
                        FSNamesystem.this.logAuditEvent(false, "encodeFile", sourcePath);
                        throw e;
                    }
                    INode target = iip.getLastINode();
                    EncodingStatus existing = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{target.getId()});
                    if (existing != null) {
                        throw new IOException("Attempting to request encoding for anencoded file");
                    }
                    INode inode = FSNamesystem.this.dir.getINode(sourcePath);
                    EncodingStatus encodingStatus = new EncodingStatus(Long.valueOf(inode.getId()), inode.isInTree(), status, policy, Long.valueOf(System.currentTimeMillis()));
                    EntityManager.add((Object)encodingStatus);
                    success = true;
                    Object var8_9 = null;
                    return var8_9;
                }
                finally {
                    if (checkRetryCache) {
                        LightWeightCacheDistributed.put(null, success);
                    }
                }
            }
        }.handle();
    }

    public void removeEncodingStatus(final EncodingStatus encodingStatus) throws IOException {
        LightWeightRequestHandler removeHandler = new LightWeightRequestHandler(EncodingStatusOperationType.DELETE){

            public Object performTask() throws IOException {
                BlockChecksumDataAccess blockChecksumDataAccess = (BlockChecksumDataAccess)HdfsStorageFactory.getDataAccess(BlockChecksumDataAccess.class);
                EncodingStatusDataAccess encodingStatusDataAccess = (EncodingStatusDataAccess)HdfsStorageFactory.getDataAccess(EncodingStatusDataAccess.class);
                blockChecksumDataAccess.deleteAll(encodingStatus.getInodeId().longValue());
                blockChecksumDataAccess.deleteAll(encodingStatus.getParityInodeId().longValue());
                encodingStatusDataAccess.delete((Object)encodingStatus);
                return null;
            }
        };
        removeHandler.handle();
    }

    public void removeEncodingStatus(final String path, final EncodingStatus encodingStatus) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.DELETE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, path));
            }

            public Object performTask() throws IOException {
                EntityManager.remove((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public void revokeEncoding(String filePathArg, short replication) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(filePathArg);
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String filePath = this.dir.resolvePath(pc, filePathArg, pathComponents);
        this.setReplication(filePath, replication);
        new HopsTransactionalRequestHandler(HDFSOperationType.REVOKE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, filePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, filePath));
            }

            public Object performTask() throws IOException {
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(filePath, true);
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "revokeEncoding", filePath);
                    throw e;
                }
                INode targetNode = iip.getLastINode();
                EncodingStatus encodingStatus = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
                encodingStatus.setRevoked(Boolean.valueOf(true));
                EntityManager.update((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.Status status) throws IOException {
        this.updateEncodingStatus(sourceFile, status, null, null);
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.ParityStatus parityStatus) throws IOException {
        this.updateEncodingStatus(sourceFile, null, parityStatus, null);
    }

    public void updateEncodingStatus(String sourceFile, EncodingStatus.Status status, String parityFile) throws IOException {
        this.updateEncodingStatus(sourceFile, status, null, parityFile);
    }

    public void updateEncodingStatus(String sourceFileArg, final EncodingStatus.Status status, final EncodingStatus.ParityStatus parityStatus, final String parityFile) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(sourceFileArg);
        final String sourceFile = this.dir.resolvePath(this.getPermissionChecker(), sourceFileArg, pathComponents);
        new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_ENCODING_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, sourceFile).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, sourceFile));
            }

            public Object performTask() throws IOException {
                INode targetNode = FSNamesystem.this.getINode(sourceFile);
                EncodingStatus encodingStatus = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{targetNode.getId()});
                if (status != null) {
                    encodingStatus.setStatus(status);
                    encodingStatus.setStatusModificationTime(Long.valueOf(System.currentTimeMillis()));
                }
                if (parityFile != null) {
                    encodingStatus.setParityFileName(parityFile);
                }
                if (parityStatus != null) {
                    encodingStatus.setParityStatus(parityStatus);
                    encodingStatus.setStatusModificationTime(Long.valueOf(System.currentTimeMillis()));
                }
                EntityManager.update((Object)encodingStatus);
                return null;
            }
        }.handle();
    }

    public INode getINode(String path) throws UnresolvedLinkException, StorageException, TransactionContextException {
        INodesInPath inodesInPath = this.dir.getINodesInPath4Write(path);
        return inodesInPath.getLastINode();
    }

    public boolean isErasureCodingEnabled() {
        return this.erasureCodingEnabled;
    }

    public void addBlockChecksum(String srcArg, final int blockIndex, final long checksum) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_BLOCK_CHECKSUM){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(src, true);
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.WRITE);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "addBlockChecksum", src);
                    throw e;
                }
                long inodeId = iip.getLastINode().getId();
                BlockChecksum blockChecksum = new BlockChecksum(inodeId, blockIndex, checksum);
                EntityManager.add((Object)blockChecksum);
                return null;
            }
        }.handle();
    }

    public long getBlockChecksum(String srcArg, final int blockIndex) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        return (Long)new HopsTransactionalRequestHandler(HDFSOperationType.GET_BLOCK_CHECKSUM){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il).add(lf.getBlockChecksumLock(src, blockIndex));
            }

            public Object performTask() throws IOException {
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(src, true);
                try {
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.READ);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "getBlockChecksum", src);
                    throw e;
                }
                INode node = iip.getLastINode();
                BlockChecksumDataAccess.KeyTuple key = new BlockChecksumDataAccess.KeyTuple(node.getId(), blockIndex);
                BlockChecksum checksum = (BlockChecksum)EntityManager.find((FinderType)BlockChecksum.Finder.ByKeyTuple, (Object[])new Object[]{key});
                if (checksum == null) {
                    throw new IOException("No checksum was found for " + key);
                }
                return checksum.getChecksum();
            }
        }.handle();
    }

    void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot modify ACL entries on " + src);
            auditStat = FSDirAclOp.modifyAclEntries(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "modifyAclEntries", src);
            throw e;
        }
        this.logAuditEvent(true, "modifyAclEntries", src, null, auditStat);
    }

    void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot remove ACL entries on " + src);
            auditStat = FSDirAclOp.removeAclEntries(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAclEntries", src);
            throw e;
        }
        this.logAuditEvent(true, "removeAclEntries", src, null, auditStat);
    }

    void removeDefaultAcl(String src) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot remove default ACL entries on " + src);
            auditStat = FSDirAclOp.removeDefaultAcl(this.dir, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeDefaultAcl", src);
            throw e;
        }
        this.logAuditEvent(true, "removeDefaultAcl", src, null, auditStat);
    }

    void removeAcl(String src) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot remove ACL on " + src);
            auditStat = FSDirAclOp.removeAcl(this.dir, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeAcl", src);
            throw e;
        }
        this.logAuditEvent(true, "removeAcl", src, null, auditStat);
    }

    void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot set ACL on " + src);
            auditStat = FSDirAclOp.setAcl(this.dir, src, aclSpec);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setAcl", src);
            throw e;
        }
        this.logAuditEvent(true, "setAcl", src, null, auditStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AclStatus getAclStatus(String src) throws IOException {
        boolean success = false;
        try {
            AclStatus ret = FSDirAclOp.getAclStatus(this.dir, src);
            success = true;
            AclStatus aclStatus = ret;
            return aclStatus;
        }
        finally {
            this.logAuditEvent(success, "getAclStatus", src);
        }
    }

    void createEncryptionZone(String src, String keyName) throws IOException, UnresolvedLinkException, SafeModeException, AccessControlException {
        try {
            if (this.provider == null) {
                throw new IOException("Can't create an encryption zone for " + src + " since no key provider is available.");
            }
            if (keyName == null || keyName.isEmpty()) {
                throw new IOException("Must specify a key name when creating an encryption zone");
            }
            KeyProvider.Metadata metadata = this.provider.getMetadata(keyName);
            if (metadata == null) {
                throw new IOException("Key " + keyName + " doesn't exist.");
            }
            this.provider.warmUpEncryptedKeys(new String[]{keyName});
            this.createEncryptionZoneInt(src, metadata.getCipher(), keyName);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "createEncryptionZone", src);
            throw e;
        }
    }

    private void createEncryptionZoneInt(String srcArg, String cipher, final String keyName) throws IOException {
        this.checkSuperuserPrivilege();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        FSPermissionChecker pc = this.getPermissionChecker();
        this.checkNameNodeSafeMode("Cannot create encryption zone on " + srcArg);
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        final CipherSuite suite = CipherSuite.convert((String)cipher);
        final CryptoProtocolVersion version = CryptoProtocolVersion.ENCRYPTION_ZONES;
        HdfsFileStatus resultingStat = (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.CREATE_EZ, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
                locks.add(lf.getEZLock());
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO);
                xAttrsToLock.add(FSDirXAttrOp.XATTR_ENCRYPTION_ZONE);
                locks.add(lf.getXAttrLock(xAttrsToLock));
                if (FSNamesystem.this.isRetryCacheEnabled) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return null;
                }
                boolean success = false;
                try {
                    XAttr ezXAttr = FSNamesystem.this.dir.createEncryptionZone(src, suite, version, keyName);
                    ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
                    xAttrs.add(ezXAttr);
                    INodesInPath iip = FSNamesystem.this.dir.getINodesInPath4Write(src, false);
                    HdfsFileStatus resultingStat = FSNamesystem.this.dir.getAuditFileInfo(iip);
                    success = true;
                    HdfsFileStatus hdfsFileStatus = resultingStat;
                    return hdfsFileStatus;
                }
                finally {
                    LightWeightCacheDistributed.put(null, success);
                }
            }
        }.handle();
        this.logAuditEvent(true, "createEncryptionZone", srcArg, null, resultingStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EncryptionZone getEZForPath(String srcArg) throws AccessControlException, UnresolvedLinkException, IOException {
        final HdfsFileStatus[] resultingStat = new HdfsFileStatus[]{null};
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        boolean success = false;
        final FSPermissionChecker pc = this.getPermissionChecker();
        try {
            final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
            EncryptionZone ret = (EncryptionZone)new HopsTransactionalRequestHandler(HDFSOperationType.GET_EZ_PATH, src){

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                    locks.add((Lock)il);
                    locks.add(lf.getEZLock());
                    locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO));
                }

                public Object performTask() throws IOException {
                    INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(src, true);
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, FsAction.READ);
                    }
                    EncryptionZone ret = FSNamesystem.this.dir.getEZForPath(iip);
                    resultingStat[0] = FSNamesystem.this.dir.getAuditFileInfo(iip);
                    return ret;
                }
            }.handle();
            success = true;
            EncryptionZone encryptionZone = ret;
            return encryptionZone;
        }
        finally {
            this.logAuditEvent(success, "getEZForPath", srcArg, null, resultingStat[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BatchedRemoteIterator.BatchedListEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        boolean success = false;
        this.checkSuperuserPrivilege();
        try {
            this.checkSuperuserPrivilege();
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> ret = this.dir.listEncryptionZones(prevId);
            success = true;
            BatchedRemoteIterator.BatchedListEntries<EncryptionZone> batchedListEntries = ret;
            return batchedListEntries;
        }
        finally {
            this.logAuditEvent(success, "listEncryptionZones", null);
        }
    }

    void setXAttr(String srcArg, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        HdfsFileStatus auditStat = null;
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        FSPermissionChecker pc = this.dir.getPermissionChecker();
        String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        try {
            this.checkNameNodeSafeMode("Cannot set XAttr on " + src);
            auditStat = FSDirXAttrOp.setXAttr(this.dir, srcArg, src, xAttr, flag);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "setXAttr", src);
            throw e;
        }
        this.logAuditEvent(true, "setXAttr", src, null, auditStat);
    }

    List<XAttr> getXAttrs(String srcArg, List<XAttr> xAttrs) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        FSPermissionChecker pc = this.getPermissionChecker();
        String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        try {
            return FSDirXAttrOp.getXAttrs(this.dir, srcArg, src, xAttrs);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "getXAttrs", src);
            throw e;
        }
    }

    List<XAttr> listXAttrs(String srcArg) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        FSPermissionChecker pc = this.getPermissionChecker();
        String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        try {
            return FSDirXAttrOp.listXAttrs(this.dir, srcArg, src);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "listXAttrs", srcArg);
            throw e;
        }
    }

    void removeXAttr(String srcArg, XAttr xAttr) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        FSPermissionChecker pc = this.getPermissionChecker();
        String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        HdfsFileStatus auditStat = null;
        try {
            this.checkNameNodeSafeMode("Cannot remove XAttr entry on " + src);
            auditStat = FSDirXAttrOp.removeXAttr(this.dir, srcArg, src, xAttr);
        }
        catch (AccessControlException e) {
            this.logAuditEvent(false, "removeXAttr", src);
            throw e;
        }
        this.logAuditEvent(true, "removeXAttr", src, null, auditStat);
    }

    public LocatedBlock getRepairedBlockLocations(String clientMachine, final String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        DatanodeInfo[] nodes;
        int index;
        int i;
        EncodingStatus status = this.getEncodingStatus(sourcePath);
        Codec codec = Codec.getCodec(status.getEncodingPolicy().getCodec());
        ArrayList<LocatedBlock> sourceLocations = new ArrayList<LocatedBlock>(this.getBlockLocations(clientMachine, sourcePath, 0L, Long.MAX_VALUE).getLocatedBlocks());
        Collections.sort(sourceLocations, LocatedBlock.blockIdComparator);
        ArrayList<LocatedBlock> parityLocations = new ArrayList<LocatedBlock>(this.getBlockLocations(clientMachine, parityPath, 0L, Long.MAX_VALUE).getLocatedBlocks());
        Collections.sort(parityLocations, LocatedBlock.blockIdComparator);
        HashSet<Node> excluded = new HashSet<Node>();
        int stripe = isParity ? this.getStripe(block, parityLocations, codec.getParityLength()) : this.getStripe(block, sourceLocations, codec.getStripeLength());
        for (i = index = stripe * codec.getStripeLength(); i < sourceLocations.size() && i < index + codec.getStripeLength(); ++i) {
            for (DatanodeInfo node : nodes = sourceLocations.get(i).getLocations()) {
                excluded.add((Node)node);
            }
        }
        for (i = index = stripe * codec.getParityLength(); i < parityLocations.size() && i < index + codec.getParityLength(); ++i) {
            for (DatanodeInfo node : nodes = parityLocations.get(i).getLocations()) {
                excluded.add((Node)node);
            }
        }
        byte storagePolicyID = (Byte)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, sourcePath).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INode targetNode = FSNamesystem.this.nameNode.getNamesystem().getINode(sourcePath);
                return targetNode.getLocalStoragePolicyID();
            }
        }.handle();
        LinkedList<DatanodeStorageInfo> chosenStorages = new LinkedList<DatanodeStorageInfo>();
        DatanodeStorageInfo[] descriptors = this.blockManager.chooseTarget4ParityRepair(isParity ? parityPath : sourcePath, isParity ? (short)1 : status.getEncodingPolicy().getTargetReplication(), null, chosenStorages, excluded, block.getBlockSize(), storagePolicyID);
        return BlockManager.newLocatedBlock(block.getBlock(), descriptors, -1L, false);
    }

    private int getStripe(LocatedBlock block, ArrayList<LocatedBlock> locatedBlocks, int length) {
        int i = 0;
        for (LocatedBlock b : locatedBlocks) {
            if (block.getBlock().getBlockId() == b.getBlock().getBlockId()) break;
            ++i;
        }
        return i / length;
    }

    public PathInformation getPathExistingINodesFromDB(final String path, final boolean doCheckOwner, final FsAction ancestorAccess, final FsAction parentAccess, final FsAction access, final FsAction subAccess) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_PATH_INFO){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getBlockLock());
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = FSNamesystem.this.getPermissionChecker();
                byte[][] pathComponents = INode.getPathComponents(path);
                INodesInPath iip = FSNamesystem.this.dir.getExistingPathINodes(pathComponents);
                if (FSNamesystem.this.isPermissionEnabled && !pc.isSuperUser()) {
                    FSNamesystem.this.dir.checkPermission(pc, iip, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, false);
                }
                boolean isDir = false;
                QuotaCounts usage = new QuotaCounts.Builder().build();
                QuotaCounts quota = new QuotaCounts.Builder().build();
                INode leafInode = iip.getLastINode();
                if (leafInode != null) {
                    if (leafInode instanceof INodeFile || leafInode instanceof INodeSymlink) {
                        isDir = false;
                        leafInode.computeQuotaUsage(FSNamesystem.this.getBlockManager().getStoragePolicySuite(), usage);
                    } else {
                        isDir = true;
                        if (leafInode instanceof INodeDirectory && FSNamesystem.this.dir.isQuotaEnabled()) {
                            DirectoryWithQuotaFeature q = ((INodeDirectory)leafInode).getDirectoryWithQuotaFeature();
                            quota = q != null ? q.getQuota() : leafInode.getQuotaCounts();
                            if (!((INodeDirectory)leafInode).isWithQuota() && ((INodeDirectory)leafInode).getChildrenNum() == 0) {
                                usage.setNameSpace(1L);
                            }
                        }
                    }
                }
                List[] acls = new List[iip.length()];
                for (int i = 0; i < iip.length(); ++i) {
                    if (iip.getINode(i) == null) continue;
                    AclFeature aclFeature = INodeAclHelper.getAclFeature(iip.getINode(i));
                    acls[i] = aclFeature != null ? aclFeature.getEntries() : null;
                }
                return new PathInformation(path, pathComponents, iip, isDir, quota, usage, acls);
            }
        };
        return (PathInformation)handler.handle(this);
    }

    public static int getMaxSmallFileSize() {
        return DB_MAX_SMALL_FILE_SIZE;
    }

    public static int getDBOnDiskSmallBucketSize() {
        return DB_ON_DISK_SMALL_BUCKET_SIZE;
    }

    public static int getDBOnDiskMediumBucketSize() {
        return DB_ON_DISK_MEDIUM_BUCKET_SIZE;
    }

    public static int getDBOnDiskLargeBucketSize() {
        return DB_ON_DISK_LARGE_BUCKET_SIZE;
    }

    public static int getDBInMemBucketSize() {
        return DB_IN_MEMORY_BUCKET_SIZE;
    }

    public byte[] getSmallFileData(final long id) throws IOException {
        final long inodeId = -id;
        return (byte[])new HopsTransactionalRequestHandler(HDFSOperationType.GET_SMALL_FILE_DATA){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromId(inodeId);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ, this.inodeIdentifier));
            }

            public Object performTask() throws IOException {
                INode iNode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{inodeId});
                if (iNode == null) {
                    throw new FileNotFoundException("The file id: " + id + " does not exist");
                }
                if (iNode instanceof INodeFile) {
                    INodeFile file = (INodeFile)iNode;
                    if (!file.isFileStoredInDB()) {
                        throw new IOException("The requested file is not stored in the database.");
                    }
                    return ((INodeFile)iNode).getFileDataInDB();
                }
                throw new FileNotFoundException("Inode id: " + id + " is not a file.");
            }
        }.handle();
    }

    void checkAccess(String srcArg, final FsAction mode) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final FSPermissionChecker pc = this.getPermissionChecker();
        final String src = this.dir.resolvePath(pc, srcArg, pathComponents);
        HopsTransactionalRequestHandler checkAccessHandler = new HopsTransactionalRequestHandler(HDFSOperationType.CHECK_ACCESS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INodesInPath iip = FSNamesystem.this.dir.getINodesInPath(src, true);
                try {
                    INode inode = iip.getLastINode();
                    if (inode == null) {
                        throw new FileNotFoundException("Path not found");
                    }
                    if (FSNamesystem.this.isPermissionEnabled) {
                        FSNamesystem.this.dir.checkPathAccess(pc, iip, mode);
                    }
                }
                catch (AccessControlException e) {
                    FSNamesystem.this.logAuditEvent(false, "checkAccess", src);
                    throw e;
                }
                return null;
            }
        };
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        checkAccessHandler.handle(this);
    }

    public LastUpdatedContentSummary getLastUpdatedContentSummary(String pathArg) throws IOException {
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(pathArg);
        FSPermissionChecker pc = this.getPermissionChecker();
        final String path = this.dir.resolvePath(pc, pathArg, pathComponents);
        LastUpdatedContentSummary luSummary = (LastUpdatedContentSummary)((Object)new HopsTransactionalRequestHandler(HDFSOperationType.GET_LAST_UPDATED_CONTENT_SUMMARY){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, TransactionLockTypes.INodeResolveType.PATH, path).setNameNodeID(FSNamesystem.this.nameNode.getId()).setActiveNameNodes(FSNamesystem.this.nameNode.getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!FSNamesystem.this.dir.isQuotaEnabled());
                locks.add((Lock)il);
            }

            public Object performTask() throws IOException {
                INodeDirectory quotaDir;
                DirectoryWithQuotaFeature q;
                INode subtreeRoot = FSNamesystem.this.getINode(path);
                if (subtreeRoot instanceof INodeDirectory && (q = (quotaDir = (INodeDirectory)subtreeRoot).getDirectoryWithQuotaFeature()) != null) {
                    LastUpdatedContentSummary.Builder builder = new LastUpdatedContentSummary.Builder().fileAndDirectoryCount(q.getSpaceConsumed().getNameSpace()).spaceConsumed(q.getSpaceConsumed().getStorageSpace()).quota(q.getQuota().getNameSpace()).spaceQuota(q.getQuota().getStorageSpace());
                    for (StorageType type : StorageType.asList()) {
                        builder.typeConsumed(type, q.getSpaceConsumed().getTypeSpace(type)).typeQuota(type, q.getQuota().getTypeSpace(type));
                    }
                    return builder.build();
                }
                return null;
            }
        }.handle(this));
        if (luSummary == null) {
            ContentSummary summary = this.getContentSummary(path);
            LastUpdatedContentSummary.Builder builder = new LastUpdatedContentSummary.Builder().fileAndDirectoryCount(summary.getFileCount() + summary.getDirectoryCount()).spaceConsumed(summary.getSpaceConsumed()).quota(summary.getQuota()).spaceQuota(summary.getSpaceQuota());
            for (StorageType type : StorageType.asList()) {
                builder.typeConsumed(type, summary.getTypeConsumed(type)).typeQuota(type, summary.getTypeQuota(type));
            }
            luSummary = builder.build();
        }
        return luSummary;
    }

    public List<AclEntry> calculateNearestDefaultAclForSubtree(PathInformation pathInfo) throws IOException {
        for (int i = pathInfo.getPathInodeAcls().length - 1; i > -1; --i) {
            List<AclEntry> aclEntries = pathInfo.getPathInodeAcls()[i];
            if (aclEntries == null) continue;
            ArrayList<AclEntry> onlyDefaults = new ArrayList<AclEntry>();
            for (AclEntry aclEntry : aclEntries) {
                if (!aclEntry.getScope().equals((Object)AclEntryScope.DEFAULT)) continue;
                onlyDefaults.add(aclEntry);
            }
            if (onlyDefaults.isEmpty()) continue;
            return onlyDefaults;
        }
        return new ArrayList<AclEntry>();
    }

    public byte calculateNearestinheritedStoragePolicy(PathInformation pathInfo) throws IOException {
        for (int i = pathInfo.getINodesInPath().length() - 1; i > -1; --i) {
            byte storagePolicy = pathInfo.getINodesInPath().getINode(i).getLocalStoragePolicyID();
            if (storagePolicy == 0) continue;
            return storagePolicy;
        }
        return 0;
    }

    public void setDelayBeforeSTOFlag(long delay) {
        if (this.isTestingSTO) {
            this.delayBeforeSTOFlag = delay;
        }
    }

    public void setDelayAfterBuildingTree(long delay) {
        if (this.isTestingSTO) {
            this.delayAfterBuildingTree = delay;
        }
    }

    public void delayBeforeSTOFlag(String message) {
        if (this.isTestingSTO) {
            Times time = this.delays.get();
            if (time == null) {
                time = this.saveTimes();
            }
            try {
                LOG.debug((Object)("Testing STO. " + message + " Sleeping for " + time.delayBeforeSTOFlag));
                Thread.sleep(time.delayBeforeSTOFlag);
                LOG.debug((Object)("Testing STO. " + message + " Waking up from sleep of " + time.delayBeforeSTOFlag));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)e);
            }
        }
    }

    public void delayAfterBbuildingTree(String message) {
        if (this.isTestingSTO) {
            Times time = this.delays.get();
            if (time == null) {
                time = this.saveTimes();
            }
            try {
                LOG.debug((Object)("Testing STO. " + message + " Sleeping for " + time.delayAfterBuildingTree));
                Thread.sleep(time.delayAfterBuildingTree);
                LOG.debug((Object)("Testing STO. " + message + " Waking up from sleep of " + time.delayAfterBuildingTree));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)e);
            }
        }
    }

    public void setTestingSTO(boolean val) {
        this.isTestingSTO = val;
    }

    public boolean isTestingSTO() {
        return this.isTestingSTO;
    }

    public Times saveTimes() {
        if (this.isTestingSTO) {
            this.delays.remove();
            Times times = new Times(this.delayBeforeSTOFlag, this.delayAfterBuildingTree);
            this.delays.set(times);
            return times;
        }
        return null;
    }

    public boolean isRetryCacheEnabled() {
        return this.isRetryCacheEnabled;
    }

    private static int getDBFileInMemBucketSize() throws IOException {
        if (!HdfsStorageFactory.isInitialized()) {
            return 0;
        }
        LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.GET_DB_FILE_TABLE_SIZE){

            public Object performTask() throws IOException {
                InMemoryInodeDataAccess da = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
                return da.getLength();
            }
        };
        return (Integer)h.handle();
    }

    private static int getDBFileSmallBucketSize() throws IOException {
        if (!HdfsStorageFactory.isInitialized()) {
            return 0;
        }
        LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.GET_DB_FILE_TABLE_SIZE){

            public Object performTask() throws IOException {
                SmallOnDiskInodeDataAccess da = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
                return da.getLength();
            }
        };
        return (Integer)h.handle();
    }

    private static int getDBFileMediumBucketSize() throws IOException {
        if (!HdfsStorageFactory.isInitialized()) {
            return 0;
        }
        LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.GET_DB_FILE_TABLE_SIZE){

            public Object performTask() throws IOException {
                MediumOnDiskInodeDataAccess da = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
                return da.getLength();
            }
        };
        return (Integer)h.handle();
    }

    private static int getDBFileLargeBucketSize() throws IOException {
        if (!HdfsStorageFactory.isInitialized()) {
            return 0;
        }
        LightWeightRequestHandler h = new LightWeightRequestHandler(HDFSOperationType.GET_DB_FILE_TABLE_SIZE){

            public Object performTask() throws IOException {
                LargeOnDiskInodeDataAccess da = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
                return da.getLength();
            }
        };
        return (Integer)h.handle();
    }

    public int getLeaseCreationLockRows() {
        return this.leaseCreationLockRows;
    }

    public List<RetryCacheEntry> getCacheSet() throws IOException {
        return (List)new LightWeightRequestHandler(HDFSOperationType.RETRY_CACHE_GET_ALL){

            public Object performTask() throws IOException {
                RetryCacheEntryDataAccess da = (RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class);
                return da.findAll();
            }
        }.handle();
    }

    public short getDBReplicationFactor() {
        return this.dbReplicationFactor;
    }

    private void updateReplicationFromDBToBlocks(INodesInPath iip) throws TransactionContextException, StorageException, QuotaExceededException {
        INodeFile file = iip.getLastINode().asFile();
        short oldReplicationFactor = this.dbReplicationFactor;
        short newReplicationFactor = this.serverDefaults.getReplication();
        long ssDelta = file.getSize();
        EnumCounters<StorageType> typeSpaceDeltas = this.dir.getStorageTypeDeltas(file.getStoragePolicyID(), ssDelta, oldReplicationFactor, oldReplicationFactor);
        typeSpaceDeltas.add(StorageType.DB, -(ssDelta * (long)oldReplicationFactor));
        QuotaCounts deltas = new QuotaCounts.Builder().nameSpace(0L).storageSpace(0L).typeSpaces(typeSpaceDeltas).build();
        this.dir.updateCountNoQuotaCheck(iip, iip.length() - 1, deltas);
        FSDirAttrOp.unprotectedSetReplicationWithoutGetBlocks(this.dir, iip, newReplicationFactor, null);
    }

    static {
        DB_MAX_SMALL_FILE_SIZE = 0;
    }

    private class Times {
        long delayBeforeSTOFlag = 0L;
        long delayAfterBuildingTree = 0L;

        public Times(long delayBeforeSTOFlag, long delayAfterBuildingTree) {
            this.delayBeforeSTOFlag = delayBeforeSTOFlag;
            this.delayAfterBuildingTree = delayAfterBuildingTree;
        }
    }

    class RetryCacheCleaner
    implements Runnable {
        public final Log cleanerLog = LogFactory.getLog(RetryCacheCleaner.class);
        boolean shouldCacheCleanerRun = true;
        long entryExpiryMillis;
        Timer timer = new Timer();

        public RetryCacheCleaner() {
            this.entryExpiryMillis = FSNamesystem.this.conf.getLong("dfs.namenode.retrycache.expirytime.millis", 600000L);
        }

        private int deleteAllForEpoch(final long epoch) throws IOException {
            return (Integer)new LightWeightRequestHandler(HDFSOperationType.CLEAN_RETRY_CACHE){

                public Object performTask() throws IOException {
                    RetryCacheEntryDataAccess da = (RetryCacheEntryDataAccess)HdfsStorageFactory.getDataAccess(RetryCacheEntryDataAccess.class);
                    return da.removeOlds(epoch);
                }
            }.handle();
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && this.shouldCacheCleanerRun) {
                try {
                    if (!FSNamesystem.this.isLeader()) continue;
                    Thread.sleep(1000L);
                    long lastDeletedEpochSec = HdfsVariables.getRetryCacheCleanerEpoch();
                    long toBeDeletedEpochSec = lastDeletedEpochSec + 1L;
                    if (toBeDeletedEpochSec >= (this.timer.now() - this.entryExpiryMillis) / 1000L) continue;
                    this.cleanerLog.debug((Object)("Current epoch " + System.currentTimeMillis() / 1000L + " Last deleted epoch is " + lastDeletedEpochSec + " To be deleted epoch " + toBeDeletedEpochSec));
                    int countDeleted = this.deleteAllForEpoch(toBeDeletedEpochSec);
                    HdfsVariables.setRetryCacheCleanerEpoch(toBeDeletedEpochSec);
                    this.cleanerLog.debug((Object)("Deleted " + countDeleted + " entries for epoch " + toBeDeletedEpochSec));
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        this.cleanerLog.warn((Object)"RetryCacheCleaner Interrupted");
                        return;
                    }
                    this.cleanerLog.warn((Object)"Exception in RetryCacheCleaner: ", (Throwable)e);
                }
            }
        }

        public void stopMonitor() {
            this.shouldCacheCleanerRun = false;
        }
    }

    public class FNode
    implements Comparable<FNode> {
        private String parentPath;
        private INode inode;

        public FNode(String parentPath, INode inode) {
            this.parentPath = parentPath;
            this.inode = inode;
        }

        public String getPath() {
            if (this.parentPath.endsWith("/")) {
                return this.parentPath + this.inode.getLocalName();
            }
            return this.parentPath + "/" + this.inode.getLocalName();
        }

        public INode getINode() {
            return this.inode;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        @Override
        public int compareTo(FNode o) {
            int obj1Length = INode.getPathComponents(this.getPath()).length;
            int obj2Length = INode.getPathComponents(o.getPath()).length;
            return Integer.compare(obj2Length, obj1Length);
        }
    }

    private static class DefaultAuditLogger
    extends HdfsAuditLogger {
        private boolean logTokenTrackingId;

        private DefaultAuditLogger() {
        }

        @Override
        public void initialize(Configuration conf) {
            this.logTokenTrackingId = conf.getBoolean("dfs.namenode.audit.log.token.tracking.id", false);
        }

        @Override
        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus status, UserGroupInformation ugi, DelegationTokenSecretManager dtSecretManager) {
            if (auditLog.isInfoEnabled()) {
                StringBuilder sb = (StringBuilder)auditBuffer.get();
                sb.setLength(0);
                sb.append("allowed=").append(succeeded).append("\t");
                sb.append("ugi=").append(userName).append("\t");
                sb.append("ip=").append(addr).append("\t");
                sb.append("cmd=").append(cmd).append("\t");
                sb.append("src=").append(src).append("\t");
                sb.append("dst=").append(dst).append("\t");
                if (null == status) {
                    sb.append("perm=null");
                } else {
                    sb.append("perm=");
                    sb.append(status.getOwner()).append(":");
                    sb.append(status.getGroup()).append(":");
                    sb.append(status.getPermission());
                }
                if (this.logTokenTrackingId) {
                    sb.append("\t").append("trackingId=");
                    String trackingId = null;
                    if (ugi != null && dtSecretManager != null && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.TOKEN) {
                        for (TokenIdentifier tid : ugi.getTokenIdentifiers()) {
                            if (!(tid instanceof DelegationTokenIdentifier)) continue;
                            DelegationTokenIdentifier dtid = (DelegationTokenIdentifier)tid;
                            trackingId = dtSecretManager.getTokenTrackingId((AbstractDelegationTokenIdentifier)dtid);
                            break;
                        }
                    }
                    sb.append(trackingId);
                }
                sb.append("\t").append("proto=");
                sb.append(NamenodeWebHdfsMethods.isWebHdfsInvocation() ? "webhdfs" : "rpc");
                this.logAuditMessage(sb.toString());
            }
        }

        public void logAuditMessage(String message) {
            auditLog.info((Object)message);
        }
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                SafeModeInfo safeMode;
                while (FSNamesystem.this.fsRunning && (safeMode = FSNamesystem.this.safeMode()) != null) {
                    if (safeMode.canLeave()) {
                        safeMode.leave();
                        FSNamesystem.this.smmthread = null;
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (FSNamesystem.this.fsRunning) return;
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread");
                return;
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    public class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private double replicationQueueThreshold;
        private long lastStatusReport = 0L;
        private boolean resourcesLow = false;
        private StartupProgress.Counter awaitingReportedBlocksCounter;
        public ThreadLocal<Boolean> safeModePendingOperation = new ThreadLocal();

        private long reached() throws IOException {
            return HdfsVariables.getSafeModeReached();
        }

        private SafeModeInfo(Configuration conf) throws IOException {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            if (this.safeReplication > 1) {
                LOG.warn((Object)"Only safe replication 1 is supported");
                this.safeReplication = 1;
            }
            LOG.info((Object)("dfs.namenode.safemode.threshold-pct = " + this.threshold));
            LOG.info((Object)("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold));
            LOG.info((Object)("dfs.namenode.safemode.extension     = " + this.extension));
            this.replicationQueueThreshold = conf.getFloat("dfs.namenode.replqueue.threshold-pct", (float)this.threshold);
            HdfsVariables.setBlockTotal(0);
        }

        private SafeModeInfo(boolean resourcesLow) throws IOException {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.replicationQueueThreshold = 1.5;
            HdfsVariables.setBlockTotal(-1);
            this.resourcesLow = resourcesLow;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        private SafeModeInfo(double threshold, int datanodeThreshold, int extension, int safeReplication, double replicationQueueThreshold, boolean resourcesLow) throws IOException {
            this.threshold = threshold;
            this.datanodeThreshold = datanodeThreshold;
            this.extension = extension;
            this.safeReplication = safeReplication;
            this.replicationQueueThreshold = replicationQueueThreshold;
            this.resourcesLow = resourcesLow;
        }

        private SafeModeInfo() {
        }

        public double getThreshold() {
            return this.threshold;
        }

        public int getDatanodeThreshold() {
            return this.datanodeThreshold;
        }

        public int getExtension() {
            return this.extension;
        }

        public int getSafeReplication() {
            return this.safeReplication;
        }

        public double getReplicationQueueThreshold() {
            return this.replicationQueueThreshold;
        }

        public long getLastStatusReport() {
            return this.lastStatusReport;
        }

        public boolean isResourcesLow() {
            return this.resourcesLow;
        }

        public long getReached() throws IOException {
            return this.reached();
        }

        private boolean isOn() throws IOException {
            this.doConsistencyCheck();
            return this.reached() >= 0L;
        }

        private void enter() throws IOException {
            if (FSNamesystem.this.isLeader()) {
                LOG.info((Object)"enter safe mode");
                HdfsVariables.setSafeModeReached(0L);
            }
        }

        private void leave() throws IOException {
            if (!FSNamesystem.this.inSafeMode.getAndSet(false)) {
                return;
            }
            FSNamesystem.this.forceReadTheSafeModeFromDB.set(false);
            if (!FSNamesystem.this.isPopulatingReplQueues() && FSNamesystem.this.shouldPopulateReplicationQueues()) {
                FSNamesystem.this.initializeReplQueues();
            }
            this.leaveInternal();
            FSNamesystem.this.clearSafeBlocks();
        }

        private void leaveInternal() throws IOException {
            long timeInSafeMode = Time.now() - FSNamesystem.this.startTime;
            NameNode.stateChangeLog.info("STATE* Leaving safe mode after " + timeInSafeMode / 1000L + " secs");
            NameNode.getNameNodeMetrics().setSafeModeTime((int)timeInSafeMode);
            if (this.reached() >= 0L) {
                NameNode.stateChangeLog.info("STATE* Safe mode is OFF");
            }
            if (FSNamesystem.this.isLeader()) {
                HdfsVariables.exitSafeMode();
            }
            NetworkTopology nt = FSNamesystem.this.blockManager.getDatanodeManager().getNetworkTopology();
            NameNode.stateChangeLog.info("STATE* Network topology has " + nt.getNumOfRacks() + " racks and " + nt.getNumOfLeaves() + " datanodes");
            NameNode.stateChangeLog.info("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.numOfUnderReplicatedBlocks() + " blocks");
            FSNamesystem.this.startSecretManagerIfNecessary();
            StartupProgress prog = NameNode.getStartupProgress();
            if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                prog.endStep(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                prog.endPhase(Phase.SAFEMODE);
            }
        }

        private boolean canInitializeReplicationQueues() throws IOException {
            return FSNamesystem.this.shouldPopulateReplicationQueues() && this.blockSafe() >= this.blockReplicationQueueThreshold();
        }

        private boolean canLeave() throws IOException {
            if (!FSNamesystem.this.isLeader()) {
                return false;
            }
            if (this.reached() == 0L) {
                return false;
            }
            if (Time.now() - this.reached() < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON, in safe mode extension.", false);
                return false;
            }
            if (this.needEnter()) {
                this.reportStatus("STATE* Safe mode ON, thresholds not met.", false);
                return false;
            }
            return true;
        }

        private void tryToHelpToGetOut() throws IOException {
            if (this.isManual() || this.areResourcesLow() || FSNamesystem.this.isLeader()) {
                return;
            }
            this.checkMode();
        }

        private void clusterLeftSafeModeAlready() throws IOException {
            this.leaveInternal();
        }

        private boolean needEnter() throws IOException {
            return this.threshold != 0.0 && this.blockSafe() < this.blockThreshold() || this.datanodeThreshold != 0 && FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold || !FSNamesystem.this.nameNodeHasResourcesAvailable();
        }

        private void checkMode() throws IOException {
            if (!FSNamesystem.this.isLeader() && this.reached() < 0L) {
                return;
            }
            if (FSNamesystem.this.smmthread == null && this.needEnter()) {
                this.enter();
                if (this.canInitializeReplicationQueues() && !FSNamesystem.this.isPopulatingReplQueues()) {
                    FSNamesystem.this.initializeReplQueues();
                }
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave();
                return;
            }
            if (this.reached() > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (FSNamesystem.this.isLeader()) {
                HdfsVariables.setSafeModeReached(Time.now());
            }
            this.startSafeModeMonitor();
            this.reportStatus("STATE* Safe mode extension entered.", true);
            if (this.canInitializeReplicationQueues() && !FSNamesystem.this.isPopulatingReplQueues()) {
                FSNamesystem.this.initializeReplQueues();
            }
        }

        private synchronized void startSafeModeMonitor() throws IOException {
            if (FSNamesystem.this.smmthread == null) {
                FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
                FSNamesystem.this.smmthread.start();
                this.reportStatus("STATE* Safe mode extension entered.", true);
            }
        }

        private synchronized void setBlockTotal(int total) throws IOException {
            int blockTotal = total;
            int blockThreshold = (int)((double)blockTotal * this.threshold);
            int blockReplicationQueueThreshold = (int)((double)blockTotal * this.replicationQueueThreshold);
            HdfsVariables.setBlockTotal(blockTotal, blockThreshold, blockReplicationQueueThreshold);
            this.checkMode();
        }

        private synchronized void updateBlockTotal(int deltaTotal) throws IOException {
            HdfsVariables.updateBlockTotal(deltaTotal, this.threshold, this.replicationQueueThreshold);
            this.setSafeModePendingOperation(true);
        }

        private void incrementSafeBlockCount(short replication, Block blk) throws IOException {
            if (replication == this.safeReplication) {
                int added = FSNamesystem.this.addSafeBlock(blk.getBlockId());
                StartupProgress prog = NameNode.getStartupProgress();
                if (prog.getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                    if (this.awaitingReportedBlocksCounter == null) {
                        this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                    }
                    this.awaitingReportedBlocksCounter.add(added);
                }
                this.setSafeModePendingOperation(true);
            }
        }

        private void decrementSafeBlockCount(Block blk, short replication) throws IOException {
            if (replication == this.safeReplication - 1) {
                FSNamesystem.this.removeSafeBlock(blk.getBlockId());
                this.setSafeModePendingOperation(true);
            }
        }

        private boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        private synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        private boolean areResourcesLow() {
            return this.resourcesLow;
        }

        private void setResourcesLow() {
            this.resourcesLow = true;
        }

        String getTurnOffTip() throws IOException {
            int blockTotal;
            int blockThreshold;
            int blockSafe;
            if (!this.isOn()) {
                return "Safe mode is OFF.";
            }
            String adminMsg = "It was turned on manually. ";
            if (this.areResourcesLow()) {
                adminMsg = "Resources are low on NN. Please add or free up more resources then turn off safe mode manually. NOTE:  If you turn off safe mode before adding resources, the NN will immediately return to safe mode. ";
            }
            if (this.isManual() || this.areResourcesLow()) {
                return adminMsg + "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off.";
            }
            boolean thresholdsMet = true;
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            try {
                blockSafe = this.blockSafe();
                blockThreshold = this.blockThreshold();
                blockTotal = this.blockTotal();
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
                return "got exception " + ex.getMessage();
            }
            if (blockSafe < blockThreshold) {
                msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.%n", blockSafe, blockThreshold - blockSafe, this.threshold, blockTotal);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", blockSafe, this.threshold, blockTotal);
            }
            if (numLive < this.datanodeThreshold) {
                msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.%n", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                thresholdsMet = false;
            } else {
                msg = msg + String.format("The number of live datanodes %d has reached the minimum number %d. ", numLive, this.datanodeThreshold);
            }
            long reached = this.reached();
            msg = msg + (reached > 0L ? "In safe mode extension. " : "");
            msg = msg + "Safe mode will be turned off automatically ";
            msg = !thresholdsMet ? msg + "once the thresholds have been reached." : (reached + (long)this.extension - Time.now() > 0L ? msg + "in " + (reached + (long)this.extension - Time.now()) / 1000L + " seconds." : msg + "soon.");
            return msg;
        }

        private void reportStatus(String msg, boolean rightNow) throws IOException {
            long curTime = Time.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.error(msg + " \n" + this.getTurnOffTip());
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String blockSafe;
            long blockThreshold = -1L;
            long reached = -1L;
            try {
                blockSafe = "" + this.blockSafe();
                blockThreshold = this.blockThreshold();
                reached = this.reached();
            }
            catch (IOException ex) {
                blockSafe = ex.getMessage();
            }
            String resText = "Current safe blocks = " + blockSafe + ". Target blocks = " + blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(reached) + ".";
            }
            return resText;
        }

        private void doConsistencyCheck() throws IOException {
            boolean assertsOn = false;
            if (!$assertionsDisabled) {
                assertsOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (!assertsOn) {
                return;
            }
            long blockTotal = this.blockTotal();
            if (blockTotal == -1L) {
                return;
            }
            long blockSafe = this.blockSafe();
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            if (blockTotal != (long)activeBlocks && (blockSafe < 0L || blockSafe > blockTotal)) {
                throw new AssertionError((Object)(" SafeMode: Inconsistent filesystem state: SafeMode data: blockTotal=" + blockTotal + " blockSafe=" + blockSafe + "; BlockManager data: active=" + activeBlocks));
            }
        }

        private void adjustBlockTotals(List<Block> deltaSafe, int deltaTotal) throws IOException {
            int oldBlockSafe = 0;
            if (LOG.isDebugEnabled()) {
                oldBlockSafe = this.blockSafe();
            }
            if (deltaSafe != null) {
                for (Block b : deltaSafe) {
                    FSNamesystem.this.removeSafeBlock(b.getBlockId());
                }
            }
            if (LOG.isDebugEnabled()) {
                int newBlockSafe = this.blockSafe();
                long blockTotal = this.blockTotal();
                LOG.debug((Object)("Adjusting block totals from " + oldBlockSafe + "/" + blockTotal + " to " + newBlockSafe + "/" + (blockTotal + (long)deltaTotal)));
            }
            this.updateBlockTotal(deltaTotal);
        }

        private void setSafeModePendingOperation(Boolean val) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SafeModeX Some operation are put on hold");
            }
            this.safeModePendingOperation.set(val);
        }

        private void adjustSafeBlocks(Set<Long> safeBlocks) throws IOException {
            StartupProgress prog;
            int added = FSNamesystem.this.addSafeBlocks(new ArrayList<Long>(safeBlocks));
            if (LOG.isDebugEnabled()) {
                long blockTotal = this.blockTotal();
                LOG.debug((Object)("Adjusting safe blocks, added " + added + " blocks"));
            }
            if ((prog = NameNode.getStartupProgress()).getStatus(Phase.SAFEMODE) != Status.COMPLETE) {
                if (this.awaitingReportedBlocksCounter == null) {
                    this.awaitingReportedBlocksCounter = prog.getCounter(Phase.SAFEMODE, STEP_AWAITING_REPORTED_BLOCKS);
                }
                this.awaitingReportedBlocksCounter.add(added);
            }
            this.setSafeModePendingOperation(true);
            this.checkMode();
        }

        private void performSafeModePendingOperation() throws IOException {
            if (this.safeModePendingOperation.get() != null && this.safeModePendingOperation.get().booleanValue()) {
                LOG.debug((Object)"SafeMode about to perform pending safe mode operation");
                this.safeModePendingOperation.set(false);
                this.checkMode();
            }
        }

        int blockSafe() throws IOException {
            return FSNamesystem.this.getBlockSafe();
        }

        int blockTotal() throws IOException {
            return HdfsVariables.getBlockTotal();
        }

        int blockReplicationQueueThreshold() throws IOException {
            return HdfsVariables.getBlockReplicationQueueThreshold();
        }

        int blockThreshold() throws IOException {
            return HdfsVariables.getBlockThreshold();
        }
    }

    class NameNodeResourceMonitor
    implements Runnable {
        boolean shouldNNRmRun = true;

        NameNodeResourceMonitor() {
        }

        @Override
        public void run() {
            try {
                while (FSNamesystem.this.fsRunning && this.shouldNNRmRun) {
                    FSNamesystem.this.checkAvailableResources();
                    if (!FSNamesystem.this.nameNodeHasResourcesAvailable()) {
                        String lowResourcesMsg = "NameNode's database low on available resources.";
                        if (!FSNamesystem.this.isInSafeMode()) {
                            LOG.warn((Object)(lowResourcesMsg + "Entering safe mode."));
                        } else {
                            LOG.warn((Object)(lowResourcesMsg + "Already in safe mode."));
                        }
                        FSNamesystem.this.enterSafeMode(true);
                    }
                    try {
                        Thread.sleep(FSNamesystem.this.resourceRecheckInterval);
                    }
                    catch (InterruptedException lowResourcesMsg) {}
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception in NameNodeResourceMonitor: ", (Throwable)e);
            }
        }

        public void stopMonitor() {
            this.shouldNNRmRun = false;
        }
    }

    static class FileState {
        public final INodeFile inode;
        public final String path;
        public final INodesInPath iip;

        public FileState(INodeFile inode, String fullPath, INodesInPath iip) {
            this.inode = inode;
            this.path = fullPath;
            this.iip = iip;
        }
    }

    private static enum RecoverLeaseOp {
        CREATE_FILE,
        APPEND_FILE,
        TRUNCATE_FILE,
        RECOVER_LEASE;


        private String getExceptionMessage(String src, String holder, String clientMachine, String reason) {
            return "Failed to " + (Object)((Object)this) + " " + src + " for " + holder + " on " + clientMachine + " because " + reason;
        }
    }

    public static class GetBlockLocationsResult {
        final boolean updateAccessTime;
        public final LocatedBlocks blocks;

        boolean updateAccessTime() {
            return this.updateAccessTime;
        }

        private GetBlockLocationsResult(boolean updateAccessTime, LocatedBlocks blocks) {
            this.updateAccessTime = updateAccessTime;
            this.blocks = blocks;
        }
    }
}

