/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HopsFilesTestHelper;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaUpdateManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestQuota2 {
    public static final Log LOG = LogFactory.getLog(TestQuota2.class);
    private final int NUM_NAMENODES = 2;
    private Random rand = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaPriotizedUpdates() {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            dfs.setStoragePolicy(new Path("/"), "DB");
            String baseDir = "/some/dir/for/writing";
            this.printQuota(dfs);
            dfs.mkdirs(new Path(baseDir));
            long nsQ = 1024L;
            long dsQ = 0xA00000L;
            dfs.setQuota(new Path("/some/dir/for/writing"), nsQ, dsQ);
            dfs.setQuota(new Path("/some/dir/for"), nsQ, dsQ);
            dfs.setQuota(new Path("/some/dir"), nsQ, dsQ);
            dfs.setQuota(new Path("/some"), nsQ, dsQ);
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After creating Dirs");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            for (int i = 0; i < 55; ++i) {
                FSDataOutputStream out = dfs.create(new Path(baseDir + "/large-file" + i), (short)3);
                HopsFilesTestHelper.writeData(out, 0, 1024);
                out.close();
            }
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After adding files");
            FSNamesystem fsn = cluster.getNamesystem(this.rand.nextInt(2));
            FSDirectory fsd = fsn.getFSDirectory();
            PathInformation pathInfo = fsn.getPathExistingINodesFromDB("/", false, null, FsAction.WRITE, null, null);
            INodeIdentifier subtreeRoot = INodeDirectory.getRootIdentifier();
            List nearestDefaultsForSubtree = fsn.calculateNearestDefaultAclForSubtree(pathInfo);
            AbstractFileTree.FileTree fileTree = new AbstractFileTree.FileTree(fsn, subtreeRoot, FsAction.ALL, true, nearestDefaultsForSubtree, subtreeRoot.getStoragePolicy());
            fileTree.buildUp(fsd.getBlockStoragePolicySuite());
            for (int i = fileTree.getHeight(); i > 0; --i) {
                Iterator itr;
                Collection dirs = fileTree.getDirsByLevel(i);
                ArrayList<Long> dirIDs = new ArrayList<Long>();
                for (ProjectedINode dir : dirs) {
                    dirIDs.add(dir.getId());
                }
                Iterator iterator = itr = dirIDs.iterator();
                synchronized (iterator) {
                    this.getActiveQuotaManager(cluster).addPrioritizedUpdates(itr);
                    itr.wait();
                    LOG.error((Object)("Waiting for prioritized update for level " + i));
                }
                TestQuota2.showQuotaTable("Prioritized update for level " + i + " applied. INode IDs: " + Arrays.toString(dirIDs.toArray()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testQuotaPrioritizedUpdatesWithDepricatedRename() {
        this.testQuotaPrioritizedUpdatesWithRename(true);
    }

    @Test
    public void testQuotaPrioritizedUpdatesWithNewRename() {
        this.testQuotaPrioritizedUpdatesWithRename(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuotaPrioritizedUpdatesWithRename(boolean depricatedRename) {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            dfs.setStoragePolicy(new Path("/"), "DB");
            String baseDir = "/some/dir/for/writing";
            String renameDest = "/some/other";
            long DSQ = 0x6400000L;
            long NSQ = 1024L;
            dfs.mkdirs(new Path(baseDir));
            dfs.setQuota(new Path("/some/dir/for/writing"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir/for"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir"), NSQ, DSQ);
            dfs.setQuota(new Path("/some"), NSQ, DSQ);
            dfs.mkdirs(new Path(renameDest));
            dfs.setQuota(new Path(renameDest), NSQ, DSQ);
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After creating Dirs");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            for (int i = 0; i < 25; ++i) {
                FSDataOutputStream out = dfs.create(new Path(baseDir + "/file" + i), (short)3);
                HopsFilesTestHelper.writeData(out, 0, 1024);
                out.close();
            }
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After adding files");
            if (depricatedRename) {
                dfs.rename(new Path(baseDir), new Path(renameDest));
            } else {
                dfs.rename(new Path(baseDir), new Path(renameDest), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After moving files ");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = false;
            Thread.sleep(5000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After unpause Quota manager ");
            TestQuota2.checkAllQuotaEntries();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testQuotaNonDeprecatedRenameFileWithOverwrite() throws Exception {
        this.testQuotaRename(false, true);
    }

    @Test
    public void testQuotaDeprecatedRenameFile() throws Exception {
        this.testQuotaRename(true, false);
    }

    @Test
    public void testQuotaNonDeprecatedRenameFile() throws Exception {
        this.testQuotaRename(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuotaRename(boolean deprecatedRename, boolean overwrite) throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            dfs.setStoragePolicy(new Path("/"), "DB");
            String baseDir = "/some/dir/for/writing";
            String srcFile = baseDir + "/file";
            String renameDestDir = "/some/other";
            String renameDestFile = "/some/other/file";
            long DSQ = 0x6400000L;
            long NSQ = 1024L;
            int FILE_SIZE = 1024;
            dfs.mkdirs(new Path(baseDir));
            dfs.setQuota(new Path("/some/dir/for/writing"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir/for"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir"), NSQ, DSQ);
            dfs.setQuota(new Path("/some"), NSQ, DSQ);
            dfs.mkdirs(new Path(renameDestDir));
            dfs.setQuota(new Path(renameDestDir), NSQ, DSQ);
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After creating Dirs");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            FSDataOutputStream out = dfs.create(new Path(srcFile), (short)3);
            HopsFilesTestHelper.writeData(out, 0, 1024);
            out.close();
            if (overwrite) {
                out = dfs.create(new Path(renameDestFile), (short)3);
                HopsFilesTestHelper.writeData(out, 0, 1024);
                out.close();
            }
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After addin files");
            if (deprecatedRename) {
                assert (dfs.rename(new Path(srcFile), new Path(renameDestFile)));
            } else {
                dfs.rename(new Path(srcFile), new Path(renameDestFile), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After moving files ");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = false;
            Thread.sleep(5000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After unpause Quota manager ");
            LastUpdatedContentSummary qu = dfs.getLastUpdatedContentSummary(new Path(renameDestDir));
            Assert.assertTrue((String)("Expecting: 1024 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 1024L ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting: 1 Got: " + qu.getFileAndDirectoryCount()), (qu.getFileAndDirectoryCount() == 2L ? 1 : 0) != 0);
            qu = dfs.getLastUpdatedContentSummary(new Path("/"));
            Assert.assertTrue((String)("Expecting: 1024 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 1024L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaDeleteFile() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            String baseDir = "/some/dir/for/writing";
            String srcFile = baseDir + "/file";
            long DSQ = 0x6400000L;
            long NSQ = 1024L;
            int FILE_SIZE = 1024;
            dfs.mkdirs(new Path(baseDir));
            dfs.setQuota(new Path("/some/dir/for/writing"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir/for"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir"), NSQ, DSQ);
            dfs.setQuota(new Path("/some"), NSQ, DSQ);
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After creating Dirs");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            FSDataOutputStream out = dfs.create(new Path(srcFile), (short)3);
            HopsFilesTestHelper.writeData(out, 0, 1024);
            out.close();
            dfs.delete(new Path(srcFile), true);
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After deleting file");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = false;
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After unpause Quota manager ");
            LastUpdatedContentSummary qu = dfs.getLastUpdatedContentSummary(new Path(baseDir));
            Assert.assertTrue((String)("Expecting: 0 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting: 1 Got: " + qu.getFileAndDirectoryCount()), (qu.getFileAndDirectoryCount() == 1L ? 1 : 0) != 0);
            qu = dfs.getLastUpdatedContentSummary(new Path("/"));
            Assert.assertTrue((String)("Expecting: 0 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaOverwriteFile() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            dfs.setStoragePolicy(new Path("/"), "DB");
            String baseDir = "/some/dir/for/writing";
            String srcFile = baseDir + "/file";
            long DSQ = 0x6400000L;
            long NSQ = 1024L;
            int FILE_SIZE = 1024;
            dfs.mkdirs(new Path(baseDir));
            dfs.setQuota(new Path("/some/dir/for/writing"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir/for"), NSQ, DSQ);
            dfs.setQuota(new Path("/some/dir"), NSQ, DSQ);
            dfs.setQuota(new Path("/some"), NSQ, DSQ);
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After creating Dirs");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            FSDataOutputStream out = dfs.create(new Path(srcFile), (short)3);
            HopsFilesTestHelper.writeData(out, 0, 1024);
            out.close();
            out = dfs.create(new Path(srcFile), (short)3);
            HopsFilesTestHelper.writeData(out, 0, 512);
            out.close();
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After overwriting file");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = false;
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After unpause Quota manager ");
            LastUpdatedContentSummary qu = dfs.getLastUpdatedContentSummary(new Path(baseDir));
            Assert.assertTrue((String)("Expecting: 512 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 512L ? 1 : 0) != 0);
            Assert.assertTrue((String)("Expecting: 1 Got: " + qu.getFileAndDirectoryCount()), (qu.getFileAndDirectoryCount() == 2L ? 1 : 0) != 0);
            qu = dfs.getLastUpdatedContentSummary(new Path("/"));
            Assert.assertTrue((String)("Expecting: 512 Got: " + qu.getSpaceConsumed()), (qu.getSpaceConsumed() == 512L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaRenameDstDir() {
        MiniDFSCluster cluster = null;
        try {
            FSDataOutputStream out;
            int i;
            HdfsConfiguration conf = new HdfsConfiguration();
            int NUM_DN = 3;
            int BLKSIZE = 0x400000;
            conf.setLong("dfs.blocksize", 0x400000L);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).format(true).build();
            cluster.waitActive();
            CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties> dnpList = new CopyOnWriteArrayList<MiniDFSCluster.DataNodeProperties>(cluster.getDataNodeProperties());
            assert (dnpList.size() == 3);
            DistributedFileSystem dfs = cluster.getFileSystem(this.rand.nextInt(2));
            dfs.setStoragePolicy(new Path("/"), "DB");
            String baseDir = "/some/dir/for/writing";
            String renameDest = "/some/other/writing";
            dfs.mkdirs(new Path(baseDir));
            dfs.mkdirs(new Path(renameDest));
            Thread.sleep(3000L);
            TestQuota2.showQuotaTable("After creating Dirs");
            for (i = 0; i < 5; ++i) {
                out = dfs.create(new Path(baseDir + "/file" + i), (short)3);
                HopsFilesTestHelper.writeData(out, 0, 1024);
                out.close();
            }
            for (i = 0; i < 5; ++i) {
                out = dfs.create(new Path(renameDest + "/file" + i), (short)3);
                HopsFilesTestHelper.writeData(out, 0, 2048);
                out.close();
            }
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            TestQuota2.showQuotaTable("After adding files");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = true;
            Thread.sleep(3000L);
            for (i = 0; i < 5; ++i) {
                dfs.delete(new Path(renameDest + "/file" + i));
            }
            TestQuota2.showQuotaTable("After deleting files");
            dfs.rename(new Path(baseDir), new Path(renameDest), new Options.Rename[]{Options.Rename.OVERWRITE});
            Thread.sleep(3000L);
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After moving folder ");
            this.getActiveQuotaManager((MiniDFSCluster)cluster).pauseAsyncOps = false;
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            TestQuota2.showQuotaTable("After unpause Quota manager ");
            dfs.delete(new Path("/some"));
            DFSTestUtil.waitForQuotaUpdatesToBeApplied();
            this.printQuota(dfs);
            TestQuota2.showQuotaTable("After deleting everything");
            LastUpdatedContentSummary qu = dfs.getLastUpdatedContentSummary(new Path("/"));
            assert (qu.getSpaceConsumed() == 0L);
            assert (qu.getFileAndDirectoryCount() == 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static void showQuotaTable(final String msg) {
        try {
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws IOException {
                    HdfsStorageFactory.getConnector().beginTransaction();
                    QuotaUpdateDataAccess da = (QuotaUpdateDataAccess)HdfsStorageFactory.getDataAccess(QuotaUpdateDataAccess.class);
                    List list = da.findLimited(1000);
                    LOG.info((Object)("====================== Show Tables( " + msg + " ) ======================"));
                    LOG.info((Object)"---------------------- Quota Updates table -----------------------------");
                    int index = 0;
                    Collections.sort(list, new Comparator<QuotaUpdate>(){

                        @Override
                        public int compare(QuotaUpdate o1, QuotaUpdate o2) {
                            return Long.compare(o1.getInodeId(), o2.getInodeId());
                        }
                    });
                    for (QuotaUpdate qu : list) {
                        LOG.info((Object)(index++ + ") " + qu));
                    }
                    LOG.info((Object)"--------------------- INodes Quota Features Table ----------------------");
                    INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    List allINodes = ida.allINodes();
                    ArrayList<INodeCandidatePrimaryKey> qDirs = new ArrayList<INodeCandidatePrimaryKey>();
                    for (INode inode : allINodes) {
                        if (!inode.isDirectory()) continue;
                        qDirs.add(new INodeCandidatePrimaryKey(inode.getId()));
                    }
                    DirectoryWithQuotaFeatureDataAccess dqa = (DirectoryWithQuotaFeatureDataAccess)HdfsStorageFactory.getDataAccess(DirectoryWithQuotaFeatureDataAccess.class);
                    List quotaValues = (List)dqa.findAttributesByPkList(qDirs);
                    Collections.sort(quotaValues, new Comparator<DirectoryWithQuotaFeature>(){

                        @Override
                        public int compare(DirectoryWithQuotaFeature o1, DirectoryWithQuotaFeature o2) {
                            if (o1 != null && o2 != null) {
                                return Long.compare(o1.getInodeId(), o2.getInodeId());
                            }
                            return 0;
                        }
                    });
                    index = 0;
                    for (DirectoryWithQuotaFeature dwqa : quotaValues) {
                        if (dwqa == null) continue;
                        LOG.info((Object)(index++ + ") ID: " + dwqa.getInodeId() + " NS: " + dwqa.getQuota().getNameSpace() + " DS " + dwqa.getSpaceConsumed()));
                    }
                    LOG.info((Object)"========================================================================");
                    HdfsStorageFactory.getConnector().commit();
                    return null;
                }
            }.handle();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void checkAllQuotaEntries() {
        try {
            new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

                public Object performTask() throws IOException {
                    HdfsStorageFactory.getConnector().beginTransaction();
                    INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    List allINodes = ida.allINodes();
                    ArrayList<INodeCandidatePrimaryKey> qDirs = new ArrayList<INodeCandidatePrimaryKey>();
                    for (INode inode : allINodes) {
                        if (!inode.isDirectory()) continue;
                        qDirs.add(new INodeCandidatePrimaryKey(inode.getId()));
                    }
                    DirectoryWithQuotaFeatureDataAccess dqa = (DirectoryWithQuotaFeatureDataAccess)HdfsStorageFactory.getDataAccess(DirectoryWithQuotaFeatureDataAccess.class);
                    List quotaValues = (List)dqa.findAttributesByPkList(qDirs);
                    for (DirectoryWithQuotaFeature qv : quotaValues) {
                        Assert.assertTrue((String)("Negative quota for ID: " + qv.getInodeId()), (qv.getSpaceConsumed().getNameSpace() >= 0L ? 1 : 0) != 0);
                        Assert.assertTrue((String)("Negative quota for ID: " + qv.getInodeId()), (qv.getSpaceConsumed().getStorageSpace() >= 0L ? 1 : 0) != 0);
                    }
                    HdfsStorageFactory.getConnector().commit();
                    return null;
                }
            }.handle();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private QuotaUpdateManager getActiveQuotaManager(MiniDFSCluster cluster) {
        for (int i = 0; i < 2; ++i) {
            if (!cluster.getNamesystem(i).isLeader()) continue;
            return cluster.getNamesystem(i).getQuotaUpdateManager();
        }
        throw new IllegalStateException("No leader NN found");
    }

    private void printQuota(DistributedFileSystem dfs) throws IOException {
        LastUpdatedContentSummary q = dfs.getLastUpdatedContentSummary(new Path("/"));
        LOG.info((Object)("Capacity: " + dfs.getStatus().getCapacity() + " Used: " + dfs.getStatus().getUsed() + " Remaining: " + dfs.getStatus().getRemaining()));
        LOG.info((Object)("File and dir count: " + q.getFileAndDirectoryCount()));
        LOG.info((Object)("SpaceQuota: " + q.getSpaceQuota() + " Consumed: " + q.getSpaceConsumed()));
    }

    static {
        Logger.getRootLogger().setLevel(Level.ERROR);
        Logger.getLogger(TestQuota2.class).setLevel(Level.ALL);
        Logger.getLogger(QuotaUpdateManager.class).setLevel(Level.ALL);
    }
}

