/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.DiskChecker;
import org.junit.Assert;
import org.junit.Test;

public class TestWriteToReplica {
    private static final int FINALIZED = 0;
    private static final int TEMPORARY = 1;
    private static final int RBW = 2;
    private static final int RWR = 3;
    private static final int RUR = 4;
    private static final int NON_EXISTENT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testClose(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testAppend(bpid, dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToRbw() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testWriteToRbw(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteToTemporary() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        try {
            cluster.waitActive();
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ExtendedBlock[] blocks = this.setup(bpid, dataSet);
            this.testWriteToTemporary(dataSet, blocks);
        }
        finally {
            cluster.shutdown();
        }
    }

    private ExtendedBlock[] setup(String bpid, FsDatasetImpl dataSet) throws IOException {
        ExtendedBlock[] blocks = new ExtendedBlock[]{new ExtendedBlock(bpid, 1L, 1L, 2001L), new ExtendedBlock(bpid, 2L, 1L, 2002L), new ExtendedBlock(bpid, 3L, 1L, 2003L), new ExtendedBlock(bpid, 4L, 1L, 2004L), new ExtendedBlock(bpid, 5L, 1L, 2005L), new ExtendedBlock(bpid, 6L, 1L, 2006L)};
        ReplicaMap replicasMap = dataSet.volumeMap;
        FsVolumeImpl vol = (FsVolumeImpl)dataSet.volumes.getNextVolume(StorageType.DEFAULT, 0L).getVolume();
        FinalizedReplica replicaInfo = new FinalizedReplica(blocks[0].getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile());
        replicasMap.add(bpid, (ReplicaInfo)replicaInfo);
        replicaInfo.getBlockFile().createNewFile();
        replicaInfo.getMetaFile().createNewFile();
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaInPipeline(blocks[1].getBlockId(), blocks[1].getGenerationStamp(), (FsVolumeSpi)vol, vol.createTmpFile(bpid, blocks[1].getLocalBlock()).getParentFile(), 0L));
        replicaInfo = new ReplicaBeingWritten(blocks[2].getLocalBlock(), (FsVolumeSpi)vol, vol.createRbwFile(bpid, blocks[2].getLocalBlock()).getParentFile(), null);
        replicasMap.add(bpid, (ReplicaInfo)replicaInfo);
        replicaInfo.getBlockFile().createNewFile();
        replicaInfo.getMetaFile().createNewFile();
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaWaitingToBeRecovered(blocks[3].getLocalBlock(), (FsVolumeSpi)vol, vol.createRbwFile(bpid, blocks[3].getLocalBlock()).getParentFile()));
        replicasMap.add(bpid, (ReplicaInfo)new ReplicaUnderRecovery((ReplicaInfo)new FinalizedReplica(blocks[4].getLocalBlock(), (FsVolumeSpi)vol, vol.getCurrentDir().getParentFile()), 2007L));
        return blocks;
    }

    private void testAppend(String bpid, FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        long newGS = blocks[0].getGenerationStamp() + 1L;
        FsVolumeImpl v = (FsVolumeImpl)dataSet.volumeMap.get(bpid, blocks[0].getLocalBlock()).getVolume();
        long available = v.getCapacity() - v.getDfsUsed();
        long expectedLen = blocks[0].getNumBytes();
        try {
            v.decDfsUsed(bpid, -available);
            blocks[0].setNumBytes(expectedLen + 100L);
            dataSet.append(blocks[0], newGS, expectedLen);
            Assert.fail((String)("Should not have space to append to an RWR replica" + blocks[3]));
        }
        catch (DiskChecker.DiskOutOfSpaceException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Insufficient space for appending to "));
        }
        v.decDfsUsed(bpid, available);
        blocks[0].setNumBytes(expectedLen);
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.append(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.append(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have appended to a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[1]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[2], blocks[2].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RBW replica" + blocks[2]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[2]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[3]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have appended to an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to an unfinalized replica " + blocks[4]), (Object)e.getMessage());
        }
        try {
            dataSet.append(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have appended to a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertEquals((Object)("Cannot append to a non-existent replica " + blocks[5]), (Object)e.getMessage());
        }
        newGS = blocks[0].getGenerationStamp() + 1L;
        dataSet.recoverAppend(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.recoverAppend(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have appended to a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.recoverAppend(blocks[2], newGS, blocks[2].getNumBytes());
        blocks[2].setGenerationStamp(newGS);
        try {
            dataSet.recoverAppend(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have appended to an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverAppend(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have appended to an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverAppend(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have appended to a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot append to a non-existent replica "));
        }
    }

    private void testClose(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        long newGS = blocks[0].getGenerationStamp() + 1L;
        dataSet.recoverClose(blocks[0], newGS, blocks[0].getNumBytes());
        blocks[0].setGenerationStamp(newGS);
        try {
            dataSet.recoverClose(blocks[1], blocks[1].getGenerationStamp() + 1L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have recovered close a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        newGS = blocks[2].getGenerationStamp() + 1L;
        dataSet.recoverClose(blocks[2], newGS, blocks[2].getNumBytes());
        blocks[2].setGenerationStamp(newGS);
        try {
            dataSet.recoverClose(blocks[3], blocks[3].getGenerationStamp() + 1L, blocks[2].getNumBytes());
            Assert.fail((String)("Should not have recovered close an RWR replica" + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverClose(blocks[4], blocks[4].getGenerationStamp() + 1L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have recovered close an RUR replica" + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover append/close to a replica that's not FINALIZED and not RBW "));
        }
        try {
            dataSet.recoverClose(blocks[5], blocks[5].getGenerationStamp(), blocks[5].getNumBytes());
            Assert.fail((String)("Should not have recovered close a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot append to a non-existent replica "));
        }
    }

    private void testWriteToRbw(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        try {
            dataSet.recoverRbw(blocks[0], blocks[0].getGenerationStamp() + 1L, 0L, blocks[0].getNumBytes());
            Assert.fail((String)("Should not have recovered a finalized replica " + blocks[0]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(StorageType.DEFAULT, blocks[0]);
            Assert.fail((String)("Should not have created a replica that's already finalized " + blocks[0]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[1], blocks[1].getGenerationStamp() + 1L, 0L, blocks[1].getNumBytes());
            Assert.fail((String)("Should not have recovered a temporary replica " + blocks[1]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(StorageType.DEFAULT, blocks[1]);
            Assert.fail((String)("Should not have created a replica that had created as temporary " + blocks[1]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        dataSet.recoverRbw(blocks[2], blocks[2].getGenerationStamp() + 1L, 0L, blocks[2].getNumBytes());
        try {
            dataSet.createRbw(StorageType.DEFAULT, blocks[2]);
            Assert.fail((String)("Should not have created a replica that had created as RBW " + blocks[2]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[3], blocks[3].getGenerationStamp() + 1L, 0L, blocks[3].getNumBytes());
            Assert.fail((String)("Should not have recovered a RWR replica " + blocks[3]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(StorageType.DEFAULT, blocks[3]);
            Assert.fail((String)("Should not have created a replica that was waiting to be recovered " + blocks[3]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[4], blocks[4].getGenerationStamp() + 1L, 0L, blocks[4].getNumBytes());
            Assert.fail((String)("Should not have recovered a RUR replica " + blocks[4]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot recover a non-RBW replica "));
        }
        try {
            dataSet.createRbw(StorageType.DEFAULT, blocks[4]);
            Assert.fail((String)("Should not have created a replica that was under recovery " + blocks[4]));
        }
        catch (ReplicaAlreadyExistsException e) {
            // empty catch block
        }
        try {
            dataSet.recoverRbw(blocks[5], blocks[5].getGenerationStamp() + 1L, 0L, blocks[5].getNumBytes());
            Assert.fail((String)("Cannot recover a non-existent replica " + blocks[5]));
        }
        catch (ReplicaNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot append to a non-existent replica "));
        }
        dataSet.createRbw(StorageType.DEFAULT, blocks[5]);
    }

    private void testWriteToTemporary(FsDatasetImpl dataSet, ExtendedBlock[] blocks) throws IOException {
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[0]);
            Assert.fail((String)("Should not have created a temporary replica that was finalized " + blocks[0]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[1]);
            Assert.fail((String)("Should not have created a replica that had created astemporary " + blocks[1]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[2]);
            Assert.fail((String)("Should not have created a replica that had created as RBW " + blocks[2]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[3]);
            Assert.fail((String)("Should not have created a replica that was waiting to be recovered " + blocks[3]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[4]);
            Assert.fail((String)("Should not have created a replica that was under recovery " + blocks[4]));
        }
        catch (ReplicaAlreadyExistsException replicaAlreadyExistsException) {
            // empty catch block
        }
        dataSet.createTemporary(StorageType.DEFAULT, blocks[5]);
        try {
            dataSet.createTemporary(StorageType.DEFAULT, blocks[5]);
            Assert.fail((String)("Should not have created a replica that had already been created " + blocks[5]));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains(blocks[5].getBlockName()));
            Assert.assertTrue((boolean)(e instanceof ReplicaAlreadyExistsException));
        }
        long newGenStamp = blocks[5].getGenerationStamp() * 10L;
        blocks[5].setGenerationStamp(newGenStamp);
        try {
            ReplicaInPipelineInterface replicaInfo = dataSet.createTemporary(StorageType.DEFAULT, blocks[5]).getReplica();
            Assert.assertTrue((replicaInfo.getGenerationStamp() == newGenStamp ? 1 : 0) != 0);
            Assert.assertTrue((replicaInfo.getBlockId() == blocks[5].getBlockId() ? 1 : 0) != 0);
        }
        catch (ReplicaAlreadyExistsException e) {
            Assert.fail((String)("createRbw() Should have removed the block with the older genstamp and replaced it with the newer one: " + blocks[5]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicaMapAfterDatanodeRestart() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).build();
        try {
            cluster.waitActive();
            NameNode nn1 = cluster.getNameNode(0);
            NameNode nn2 = cluster.getNameNode(1);
            Assert.assertNotNull((String)"cannot create nn1", (Object)nn1);
            Assert.assertNotNull((String)"cannot create nn2", (Object)nn2);
            DataNode dn = cluster.getDataNodes().get(0);
            FsDatasetImpl dataSet = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
            ReplicaMap replicaMap = dataSet.volumeMap;
            List volumes = dataSet.getVolumes();
            Assert.assertEquals((String)"number of volumes is wrong", (long)2L, (long)volumes.size());
            ArrayList<String> bpList = new ArrayList<String>(Arrays.asList(cluster.getNamesystem(0).getBlockPoolId()));
            Assert.assertTrue((String)"Cluster should have 1 block pool", (bpList.size() == 1 ? 1 : 0) != 0);
            this.createReplicas(bpList, volumes, replicaMap);
            ReplicaMap oldReplicaMap = new ReplicaMap((Object)this);
            oldReplicaMap.addAll(replicaMap);
            cluster.restartDataNode(0);
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            dataSet = (FsDatasetImpl)dn.getFSDataset();
            this.testEqualityOfReplicaMap(oldReplicaMap, dataSet.volumeMap, bpList);
        }
        finally {
            cluster.shutdown();
        }
    }

    private void testEqualityOfReplicaMap(ReplicaMap oldReplicaMap, ReplicaMap newReplicaMap, List<String> bpidList) {
        for (String bpid : bpidList) {
            for (ReplicaInfo info : newReplicaMap.replicas(bpid)) {
                Assert.assertNotNull((String)("Volume map before restart didn't contain the blockpool: " + bpid), (Object)oldReplicaMap.replicas(bpid));
                ReplicaInfo oldReplicaInfo = oldReplicaMap.get(bpid, info.getBlockId());
                Assert.assertNotNull((String)("Old Replica Map didnt't contain block with blockId: " + info.getBlockId()), (Object)oldReplicaInfo);
                HdfsServerConstants.ReplicaState oldState = oldReplicaInfo.getState();
                if (info.getState() == HdfsServerConstants.ReplicaState.RWR) {
                    if (oldState != HdfsServerConstants.ReplicaState.RWR && oldState != HdfsServerConstants.ReplicaState.RBW && oldState != HdfsServerConstants.ReplicaState.RUR) continue;
                    oldReplicaMap.remove(bpid, (Block)oldReplicaInfo);
                    continue;
                }
                if (info.getState() != HdfsServerConstants.ReplicaState.FINALIZED || oldState != HdfsServerConstants.ReplicaState.FINALIZED) continue;
                oldReplicaMap.remove(bpid, (Block)oldReplicaInfo);
            }
        }
        for (String bpid : bpidList) {
            for (ReplicaInfo replicaInfo : oldReplicaMap.replicas(bpid)) {
                if (replicaInfo.getState() == HdfsServerConstants.ReplicaState.TEMPORARY) continue;
                Assert.fail((String)("After datanode restart we lost the block with blockId: " + replicaInfo.getBlockId()));
            }
        }
    }

    private void createReplicas(List<String> bpList, List<FsVolumeImpl> volumes, ReplicaMap volumeMap) throws IOException {
        Assert.assertTrue((String)"Volume map can't be null", (volumeMap != null ? 1 : 0) != 0);
        long id = 1L;
        for (String bpId : bpList) {
            for (FsVolumeImpl volume : volumes) {
                FinalizedReplica finalizedReplica = new FinalizedReplica(id, 1L, id, (FsVolumeSpi)volume, DatanodeUtil.idToBlockDir((File)volume.getFinalizedDir(bpId), (long)id));
                volumeMap.add(bpId, (ReplicaInfo)finalizedReplica);
                ReplicaBeingWritten rbwReplica = new ReplicaBeingWritten(++id, 1L, id, (FsVolumeSpi)volume, volume.getRbwDir(bpId), null, 100L);
                volumeMap.add(bpId, (ReplicaInfo)rbwReplica);
                ReplicaWaitingToBeRecovered rwrReplica = new ReplicaWaitingToBeRecovered(++id, 1L, id, (FsVolumeSpi)volume, volume.getRbwDir(bpId));
                volumeMap.add(bpId, (ReplicaInfo)rwrReplica);
                ReplicaInPipeline ripReplica = new ReplicaInPipeline(++id, id, (FsVolumeSpi)volume, volume.getTmpDir(bpId), 0L);
                volumeMap.add(bpId, (ReplicaInfo)ripReplica);
                ++id;
            }
        }
        for (String bpId : bpList) {
            for (ReplicaInfo replicaInfo : volumeMap.replicas(bpId)) {
                File parentFile = replicaInfo.getBlockFile().getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IOException("Failed to mkdirs " + parentFile);
                }
                replicaInfo.getBlockFile().createNewFile();
                replicaInfo.getMetaFile().createNewFile();
            }
        }
    }
}

