/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.server.namenode.CachePool;

public class CachePoolContext
extends BaseEntityContext<String, CachePool> {
    private CachePoolDataAccess<CachePool> dataAccess;
    private Set<CachePool> pools;

    public CachePoolContext(CachePoolDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public CachePool find(FinderType<CachePool> finder, Object ... params) throws TransactionContextException, StorageException {
        CachePool.Finder hbFinder = (CachePool.Finder)finder;
        switch (hbFinder) {
            case ByName: {
                return this.findByPrimaryKey(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<CachePool> findList(FinderType<CachePool> finder, Object ... params) throws TransactionContextException, StorageException {
        CachePool.Finder hbFinder = (CachePool.Finder)finder;
        switch (hbFinder) {
            case All: {
                return this.findAll(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private CachePool findByPrimaryKey(CachePool.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        CachePool result;
        String pk = (String)params[0];
        if (this.contains(pk)) {
            result = (CachePool)this.get(pk);
            this.hit(hbFinder, result, new Object[]{"name", pk});
        } else {
            this.aboutToAccessStorage(hbFinder, params);
            result = (CachePool)this.dataAccess.find(pk);
            if (this.pools == null) {
                this.pools = new HashSet<CachePool>();
            }
            this.pools.add(result);
            this.gotFromDB(pk, result);
            this.miss(hbFinder, result, new Object[]{"name", pk});
        }
        return result;
    }

    private Collection<CachePool> findAll(CachePool.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException, TransactionContextException {
        if (this.pools != null) {
            return this.pools;
        }
        this.aboutToAccessStorage(hbFinder, params);
        Collection result = this.dataAccess.findAll();
        if (this.pools == null) {
            this.pools = new HashSet<CachePool>();
        }
        this.pools.addAll(result);
        this.gotFromDB(result);
        this.miss(hbFinder, result, new Object[0]);
        return this.pools;
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getModified());
    }

    String getKey(CachePool CachePool2) {
        return CachePool2.getPoolName();
    }
}

