/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EncodingStatusContext
extends BaseEntityContext<Long, EncodingStatus> {
    private final EncodingStatusDataAccess<EncodingStatus> dataAccess;
    private final Map<Long, EncodingStatus> parityInodeIdToEncodingStatus = new HashMap<Long, EncodingStatus>();

    public EncodingStatusContext(EncodingStatusDataAccess<EncodingStatus> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(EncodingStatus encodingStatus) throws TransactionContextException {
        super.update((Object)encodingStatus);
        this.addInternal(encodingStatus);
    }

    public void remove(EncodingStatus encodingStatus) throws TransactionContextException {
        if (!this.contains(encodingStatus.getInodeId())) {
            this.update(encodingStatus);
        }
        super.remove((Object)encodingStatus);
        this.removeInternal(encodingStatus);
    }

    public void clear() throws TransactionContextException {
        super.clear();
        this.parityInodeIdToEncodingStatus.clear();
    }

    public EncodingStatus find(FinderType<EncodingStatus> finder, Object ... params) throws TransactionContextException, StorageException {
        EncodingStatus.Finder eFinder = (EncodingStatus.Finder)finder;
        Long inodeId = (Long)params[0];
        if (inodeId == null) {
            return null;
        }
        switch (eFinder) {
            case ByInodeId: {
                return this.findByINodeId(eFinder, inodeId);
            }
            case ByParityInodeId: {
                return this.findByParityINodeId(eFinder, inodeId);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<EncodingStatus> findList(FinderType<EncodingStatus> finder, Object ... params) throws TransactionContextException, StorageException {
        EncodingStatus.Finder eFinder = (EncodingStatus.Finder)finder;
        switch (eFinder) {
            case ByInodeIds: {
                return this.findByINodeIds(eFinder, params);
            }
            case ByParityInodeIds: {
                return this.findByParityINodeIds(eFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public int count(CounterType<EncodingStatus> counter, Object ... params) throws TransactionContextException, StorageException {
        EncodingStatus.Counter eCounter = (EncodingStatus.Counter)counter;
        switch (eCounter) {
            case RequestedEncodings: {
                return this.dataAccess.countRequestedEncodings();
            }
            case ActiveEncodings: {
                return this.dataAccess.countActiveEncodings();
            }
            case ActiveRepairs: {
                return this.dataAccess.countActiveRepairs();
            }
            case Encoded: {
                return this.dataAccess.countEncoded();
            }
        }
        throw new RuntimeException(UNSUPPORTED_COUNTER);
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        for (EncodingStatus status : this.getAdded()) {
            this.dataAccess.add((Object)status);
        }
        for (EncodingStatus status : this.getModified()) {
            this.dataAccess.update((Object)status);
        }
        for (EncodingStatus status : this.getRemoved()) {
            this.dataAccess.delete((Object)status);
        }
    }

    Long getKey(EncodingStatus encodingStatus) {
        return encodingStatus.getInodeId();
    }

    private EncodingStatus findByINodeId(EncodingStatus.Finder eFinder, long inodeId) throws StorageCallPreventedException, StorageException {
        EncodingStatus result = null;
        if (this.contains(inodeId)) {
            result = (EncodingStatus)this.get(inodeId);
            this.hit((FinderType)eFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, new Object[]{inodeId});
            result = (EncodingStatus)this.dataAccess.findByInodeId(inodeId);
            this.gotFromDB(inodeId, result);
            this.addInternal(result);
            this.miss((FinderType)eFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private Collection<EncodingStatus> findByINodeIds(EncodingStatus.Finder eFinder, Object ... params) throws StorageCallPreventedException, StorageException {
        Collection inodeIds = (Collection)params[0];
        ArrayList<EncodingStatus> result = new ArrayList<EncodingStatus>(inodeIds.size());
        ArrayList<Long> toGetFromDB = new ArrayList<Long>();
        Iterator iterator = inodeIds.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            if (this.contains(id)) {
                result.add((EncodingStatus)this.get(id));
                this.hit((FinderType)eFinder, this.get(id), new Object[]{"inodeid", id});
                continue;
            }
            toGetFromDB.add(id);
        }
        if (!toGetFromDB.isEmpty()) {
            this.aboutToAccessStorage((FinderType)eFinder, new Object[]{toGetFromDB});
            Collection gotFromDB = this.dataAccess.findByInodeIds(toGetFromDB);
            for (EncodingStatus s : gotFromDB) {
                this.gotFromDB(s.getInodeId(), s);
                this.addInternal(s);
                this.miss((FinderType)eFinder, s, new Object[]{"inodeid", s.getInodeId()});
                result.add(s);
            }
            Iterator iterator2 = toGetFromDB.iterator();
            while (iterator2.hasNext()) {
                long id = (Long)iterator2.next();
                if (this.contains(id)) continue;
                Object s = null;
                this.gotFromDB(id, s);
                this.miss((FinderType)eFinder, s, new Object[]{"inodeid", id});
            }
        }
        return result;
    }

    private EncodingStatus findByParityINodeId(EncodingStatus.Finder eFinder, long pairtyINodeId) throws StorageCallPreventedException, StorageException {
        EncodingStatus result = null;
        if (this.parityInodeIdToEncodingStatus.containsKey(pairtyINodeId)) {
            result = this.parityInodeIdToEncodingStatus.get(pairtyINodeId);
            this.hit((FinderType)eFinder, result, new Object[]{"parityinodeid", pairtyINodeId});
        } else {
            this.aboutToAccessStorage((FinderType)eFinder, new Object[]{pairtyINodeId});
            result = (EncodingStatus)this.dataAccess.findByParityInodeId(pairtyINodeId);
            this.gotFromDB(result);
            this.addInternal(pairtyINodeId, result);
            this.miss((FinderType)eFinder, result, new Object[]{"parityinodeid", pairtyINodeId});
        }
        return result;
    }

    private Collection<EncodingStatus> findByParityINodeIds(EncodingStatus.Finder eFinder, Object ... params) throws StorageCallPreventedException, StorageException {
        Collection inodeIds = (Collection)params[0];
        ArrayList<EncodingStatus> result = new ArrayList<EncodingStatus>(inodeIds.size());
        ArrayList<Long> toGetFromDB = new ArrayList<Long>();
        Iterator iterator = inodeIds.iterator();
        while (iterator.hasNext()) {
            long pairtyINodeId = (Long)iterator.next();
            if (this.parityInodeIdToEncodingStatus.containsKey(pairtyINodeId)) {
                result.add(this.parityInodeIdToEncodingStatus.get(pairtyINodeId));
                this.hit((FinderType)eFinder, this.parityInodeIdToEncodingStatus.get(pairtyINodeId), new Object[]{"parityinodeid", pairtyINodeId});
                continue;
            }
            toGetFromDB.add(pairtyINodeId);
        }
        if (!toGetFromDB.isEmpty()) {
            this.aboutToAccessStorage((FinderType)eFinder, new Object[]{toGetFromDB});
            Collection gotFromDB = this.dataAccess.findByParityInodeIds(toGetFromDB);
            if (gotFromDB != null) {
                for (EncodingStatus s : gotFromDB) {
                    this.gotFromDB(s);
                    this.addInternal(s.getParityInodeId(), s);
                    this.miss((FinderType)eFinder, s, new Object[]{"parityinodeid", s.getParityInodeId()});
                    result.add(s);
                }
            }
            Iterator iterator2 = toGetFromDB.iterator();
            while (iterator2.hasNext()) {
                long id = (Long)iterator2.next();
                if (this.parityInodeIdToEncodingStatus.containsKey(id)) continue;
                EncodingStatus s = null;
                this.addInternal(id, s);
                this.miss((FinderType)eFinder, s, new Object[]{"parityinodeid", id});
            }
        }
        return result;
    }

    private void addInternal(EncodingStatus encodingStatus) {
        if (encodingStatus != null && encodingStatus.getParityInodeId() != null) {
            this.addInternal(encodingStatus.getParityInodeId(), encodingStatus);
        }
    }

    private void addInternal(long parityINodeId, EncodingStatus encodingStatus) {
        this.parityInodeIdToEncodingStatus.put(parityINodeId, encodingStatus);
    }

    private void removeInternal(EncodingStatus encodingStatus) {
        if (encodingStatus != null && encodingStatus.getParityInodeId() != null) {
            this.parityInodeIdToEncodingStatus.remove(encodingStatus.getParityInodeId());
        }
    }
}

