/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HashBucketContext
extends BaseEntityContext<HashBucket.PrimaryKey, HashBucket> {
    private HashBucketDataAccess dataAccess;
    private Map<Integer, Collection<HashBucket>> lockedBuckets = new HashMap<Integer, Collection<HashBucket>>();

    public HashBucketContext(HashBucketDataAccess hashBucketDataAccess) {
        this.dataAccess = hashBucketDataAccess;
    }

    public HashBucket find(FinderType<HashBucket> finder, Object ... params) throws TransactionContextException, StorageException {
        HashBucket.Finder hbFinder = (HashBucket.Finder)finder;
        switch (hbFinder) {
            case ByStorageIdAndBucketId: {
                return this.findByPrimaryKey(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<HashBucket> findList(FinderType<HashBucket> finder, Object ... params) throws TransactionContextException, StorageException {
        HashBucket.Finder hbFinder = (HashBucket.Finder)finder;
        switch (hbFinder) {
            case ByStorageId: {
                return this.findByStorageId(hbFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private HashBucket findByPrimaryKey(HashBucket.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        HashBucket result;
        int bucketId;
        int storageId = (Integer)params[0];
        HashBucket.PrimaryKey pk = new HashBucket.PrimaryKey(storageId, bucketId = ((Integer)params[1]).intValue());
        if (this.contains(pk)) {
            result = (HashBucket)this.get(pk);
            this.hit((FinderType)hbFinder, result, new Object[]{"sid", storageId, "bucketId", bucketId});
        } else {
            this.aboutToAccessStorage((FinderType)hbFinder, params);
            result = (HashBucket)this.dataAccess.findBucket(storageId, bucketId);
            this.gotFromDB(pk, result);
            this.miss((FinderType)hbFinder, result, new Object[]{"sid", storageId, "bucketId", bucketId});
        }
        return result;
    }

    private Collection<HashBucket> findByStorageId(HashBucket.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        Collection result;
        int storageId = (Integer)params[0];
        if (this.lockedBuckets.containsKey(storageId)) {
            result = this.lockedBuckets.get(storageId);
            this.hit((FinderType)hbFinder, result, new Object[]{"sid", storageId});
        } else {
            this.aboutToAccessStorage((FinderType)hbFinder, params);
            result = this.dataAccess.findBucketsByStorageId(storageId);
            this.gotFromDB(result);
            this.lockedBuckets.put(storageId, result);
            this.miss((FinderType)hbFinder, result, new Object[]{"sid", storageId});
        }
        return result;
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getModified());
    }

    HashBucket.PrimaryKey getKey(HashBucket hashBucket) {
        return new HashBucket.PrimaryKey(hashBucket.getStorageId(), hashBucket.getBucketId());
    }
}

