/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestFileCreation {
    static final String DIR = "/" + TestFileCreation.class.getSimpleName() + "/";
    private static final String RPC_DETAILED_METRICS = "RpcDetailedActivityForPort";
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int numBlocks = 2;
    static final int fileSize = 16385;
    boolean simulatedStorage = false;
    private static final String[] NON_CANONICAL_PATHS = new String[]{"//foo", "///foo2", "//dir//file", "////test2/file", "/dir/./file2", "/dir/../file3"};

    public static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        System.out.println("createFile: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        return stm;
    }

    public static HdfsDataOutputStream create(DistributedFileSystem dfs, Path name, int repl) throws IOException {
        return (HdfsDataOutputStream)TestFileCreation.createFile((FileSystem)dfs, name, repl);
    }

    static void writeFile(FSDataOutputStream stm) throws IOException {
        TestFileCreation.writeFile(stm, 16385);
    }

    public static void writeFile(FSDataOutputStream stm, int size) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(3735928559L, size);
        stm.write(buffer, 0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerDefaults() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x8000000L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        conf.setInt("dfs.client-write-packet-size", 65536);
        conf.setInt("dfs.replication", 4);
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            FsServerDefaults serverDefaults = fs.getServerDefaults();
            Assert.assertEquals((long)0x8000000L, (long)serverDefaults.getBlockSize());
            Assert.assertEquals((long)512L, (long)serverDefaults.getBytesPerChecksum());
            Assert.assertEquals((long)65536L, (long)serverDefaults.getWritePacketSize());
            Assert.assertEquals((long)4L, (long)serverDefaults.getReplication());
            Assert.assertEquals((long)4096L, (long)serverDefaults.getFileBufferSize());
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int NUM_FILES = 5;
        int NUM_BLOCKS_PER_FILE = 5;
        boolean NUM_REPLICAS = true;
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            for (int i = 0; i < 5; ++i) {
                Path file = new Path("file_" + i + ".dat");
                FSDataOutputStream stm = TestFileCreation.createFile((FileSystem)fs, file, 1);
                Assert.assertTrue((String)(file + " should be a file"), (boolean)fs.getFileStatus(file).isFile());
                byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 40960);
                stm.write(buffer, 0, 40960);
                stm.close();
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFileCreation() throws IOException {
        this.checkFileCreation(null, false);
    }

    @Test
    public void testFileCreationUsingHostname() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        this.checkFileCreation(null, true);
    }

    public void testFileCreationSetLocalInterface() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Linux"));
        this.checkFileCreation("lo", false);
        try {
            this.checkFileCreation("bogus-interface", false);
            Assert.fail((String)"Able to specify a bogus interface");
        }
        catch (UnknownHostException e) {
            Assert.assertEquals((Object)"No such interface bogus-interface", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFileCreation(String netIf, boolean useDnHostname) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (netIf != null) {
            conf.set("dfs.client.local.interfaces", netIf);
        }
        conf.setBoolean("dfs.client.use.datanode.hostname", useDnHostname);
        if (useDnHostname) {
            conf.set("dfs.datanode.hostname", "localhost");
        }
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).checkDataNodeHostConfig(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path path = new Path("/");
            System.out.println("Path : \"" + path.toString() + "\"");
            System.out.println(fs.getFileStatus(path).isDirectory());
            Assert.assertTrue((String)"/ should be a directory", (boolean)fs.getFileStatus(path).isDirectory());
            Path dir1 = new Path("/test_dir");
            fs.mkdirs(dir1);
            System.out.println("createFile: Creating " + dir1.getName() + " for overwrite of existing directory.");
            try {
                fs.create(dir1, true);
                fs.close();
                Assert.assertTrue((String)"Did not prevent directory from being overwritten.", (boolean)false);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            Path file1 = new Path("filestatus.dat");
            Path parent = file1.getParent();
            fs.mkdirs(parent);
            DistributedFileSystem dfs = fs;
            dfs.setQuota(file1.getParent(), 100L, 40960L);
            FSDataOutputStream stm = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            Assert.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            System.out.println("Path : \"" + file1 + "\"");
            TestFileCreation.writeFile(stm);
            stm.close();
            long len = fs.getFileStatus(file1).getLen();
            Assert.assertTrue((String)(file1 + " should be of size " + 16385 + " but found to be of size " + len), (len == 16385L ? 1 : 0) != 0);
            long diskSpace = dfs.getContentSummary(file1.getParent()).getLength();
            Assert.assertEquals((String)(file1 + " should take " + 16385 + " bytes disk space but found to take " + diskSpace + " bytes"), (long)16385L, (long)diskSpace);
            if (this.simulatedStorage) {
                DataNode dn = cluster.getDataNodes().get(0);
                FsDatasetSpi<?> dataset = DataNodeTestUtils.getFSDataset(dn);
                Assert.assertEquals((long)16385L, (long)dataset.getDfsUsed());
                Assert.assertEquals((long)0x1FFFFFFBFFFL, (long)dataset.getRemaining());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteOnExit() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        try {
            Path file1 = new Path("filestatus.dat");
            Path file2 = new Path("filestatus2.dat");
            Path file3 = new Path("filestatus3.dat");
            FSDataOutputStream stm1 = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            FSDataOutputStream stm3 = TestFileCreation.createFile((FileSystem)localfs, file3, 1);
            System.out.println("DeleteOnExit: Created files.");
            TestFileCreation.writeFile(stm1);
            TestFileCreation.writeFile(stm3);
            stm1.close();
            stm2.close();
            stm3.close();
            fs.deleteOnExit(file1);
            fs.deleteOnExit(file2);
            localfs.deleteOnExit(file3);
            fs.close();
            localfs.close();
            fs = null;
            localfs = null;
            fs = cluster.getFileSystem();
            localfs = FileSystem.getLocal((Configuration)conf);
            Assert.assertTrue((String)(file1 + " still exists inspite of deletOnExit set."), (!fs.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((String)(file2 + " still exists inspite of deletOnExit set."), (!fs.exists(file2) ? 1 : 0) != 0);
            Assert.assertTrue((String)(file3 + " still exists inspite of deletOnExit set."), (!localfs.exists(file3) ? 1 : 0) != 0);
            System.out.println("DeleteOnExit successful.");
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            IOUtils.closeStream((Closeable)localfs);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverwriteOpenForWrite() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory((Configuration)conf);
        conf.setBoolean("dfs.permissions.enabled", false);
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        UserGroupInformation otherUgi = UserGroupInformation.createUserForTesting((String)"testuser", (String[])new String[]{"testgroup"});
        FileSystem fs2 = (FileSystem)otherUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)cluster.getConfiguration(0));
            }
        });
        String metricsName = RPC_DETAILED_METRICS + cluster.getNameNodePort();
        try {
            Path p = new Path("/testfile");
            FSDataOutputStream stm1 = fs.create(p);
            stm1.write(1);
            MetricsAsserts.assertCounter((String)"CreateNumOps", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)metricsName));
            try {
                fs2.create(p, false);
                Assert.fail((String)"Did not throw!");
            }
            catch (IOException abce) {
                GenericTestUtils.assertExceptionContains((String)"Failed to CREATE_FILE", (Throwable)abce);
            }
            FSDataOutputStream stm2 = fs2.create(p, true);
            stm2.write(2);
            stm2.close();
            try {
                stm1.close();
                Assert.fail((String)"Should have exception closing stm1 since it was deleted");
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"No lease on inode: ", (Throwable)ioe);
                GenericTestUtils.assertExceptionContains((String)"File does not exist.", (Throwable)ioe);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            IOUtils.closeStream((Closeable)fs2);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationError1() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        try {
            DatanodeInfo[] info;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            Assert.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            System.out.println("Path : \"" + file1 + "\"");
            cluster.shutdownDataNodes();
            while ((info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length != 0) {
                System.out.println("testFileCreationError1: waiting for datanode  to die.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            try {
                stm.write(buffer);
                stm.close();
            }
            catch (Exception e) {
                System.out.println("Encountered expected exception");
            }
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)"Error blocks were not cleaned up", (locations.locatedBlockCount() == 0 ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationError2() throws IOException {
        long leasePeriod = 1000L;
        System.out.println("testFileCreationError2 start");
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path file1 = new Path("/filestatus.dat");
            TestFileCreation.createFile((FileSystem)dfs, file1, 1);
            System.out.println("testFileCreationError2: Created file filestatus.dat with one replicas.");
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: The file has " + locations.locatedBlockCount() + " blocks.");
            LocatedBlock location = client.getNamenode().addBlock(file1.toString(), client.clientName, null, null, 0L, null);
            System.out.println("testFileCreationError2: Added block " + location.getBlock());
            locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            int count = locations.locatedBlockCount();
            System.out.println("testFileCreationError2: The file now has " + count + " blocks.");
            cluster.setLeasePeriod(leasePeriod, leasePeriod);
            try {
                Thread.sleep(6L * leasePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: locations = " + locations.locatedBlockCount());
            Assert.assertEquals((long)0L, (long)locations.locatedBlockCount());
            System.out.println("testFileCreationError2 successful");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationError3() throws IOException {
        System.out.println("testFileCreationError3 start");
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path f = new Path("/foo.txt");
            TestFileCreation.createFile((FileSystem)dfs, f, 3);
            try {
                cluster.getNameNodeRpc().addBlock(f.toString(), client.clientName, null, null, 0L, null);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD!", (Throwable)ioe);
            }
            System.out.println("testFileCreationError3 successful");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationNamenodeRestart() throws IOException, NoSuchFieldException, IllegalAccessException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            int nnport = cluster.getNameNodePort();
            Path file1 = new Path("/filestatus.dat");
            HdfsDataOutputStream stm = TestFileCreation.create(fs, file1, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file1);
            Assert.assertEquals((String)(file1 + " should be replicated to 1 datanode."), (long)1L, (long)stm.getCurrentBlockReplication());
            TestFileCreation.writeFile((FSDataOutputStream)stm, 16384);
            stm.hflush();
            Assert.assertEquals((String)(file1 + " should still be replicated to 1 datanode."), (long)1L, (long)stm.getCurrentBlockReplication());
            Path fileRenamed = new Path("/filestatusRenamed.dat");
            fs.rename(file1, fileRenamed);
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file1 + " to " + fileRenamed);
            file1 = fileRenamed;
            Path file2 = new Path("/filestatus2.dat");
            FSDataOutputStream stm2 = TestFileCreation.createFile((FileSystem)fs, file2, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file2);
            Path file3 = new Path("/user/home/fullpath.dat");
            FSDataOutputStream stm3 = TestFileCreation.createFile((FileSystem)fs, file3, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file3);
            Path file4 = new Path("/user/home/fullpath4.dat");
            FSDataOutputStream stm4 = TestFileCreation.createFile((FileSystem)fs, file4, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file4);
            fs.mkdirs(new Path("/bin"));
            fs.rename(new Path("/user/home"), new Path("/bin"));
            Path file3new = new Path("/bin/home/fullpath.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file3 + " to " + file3new);
            Path file4new = new Path("/bin/home/fullpath4.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file4 + " to " + file4new);
            cluster.shutdown(false, false);
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            cluster.shutdown(false, false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSOutputStream dfstream = (DFSOutputStream)stm.getWrappedStream();
            Field f = DFSOutputStream.class.getDeclaredField("src");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
            f.setAccessible(true);
            f.set(dfstream, file1.toString());
            dfstream = (DFSOutputStream)stm3.getWrappedStream();
            f.set(dfstream, file3new.toString());
            dfstream = (DFSOutputStream)stm4.getWrappedStream();
            f.set(dfstream, file4new.toString());
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            stm.write(buffer);
            stm.close();
            stm2.write(buffer);
            stm2.close();
            stm3.close();
            stm4.close();
            DFSClient client = fs.dfs;
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)("Error blocks were not cleaned up for file " + file1), (locations.locatedBlockCount() == 3 ? 1 : 0) != 0);
            locations = client.getNamenode().getBlockLocations(file2.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            Assert.assertTrue((String)("Error blocks were not cleaned up for file " + file2), (locations.locatedBlockCount() == 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(fs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClientDeath() throws IOException, InterruptedException {
        DistributedFileSystem fs;
        HdfsConfiguration conf = new HdfsConfiguration();
        System.out.println("Testing adbornal client death.");
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem dfs = fs = cluster.getFileSystem();
        DFSClient dfsclient = dfs.dfs;
        try {
            Path file1 = new Path("/clienttest.dat");
            FSDataOutputStream stm = TestFileCreation.createFile((FileSystem)fs, file1, 1);
            System.out.println("Created file clienttest.dat");
            TestFileCreation.writeFile(stm);
            dfsclient.close();
            Assert.assertTrue((String)(file1 + " does not exist."), (boolean)AppendTestUtil.createHdfsWithDifferentUsername((Configuration)conf).exists(file1));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationNonRecursive() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/" + Time.now() + "-testFileCreationNonRecursive");
        FSDataOutputStream out = null;
        try {
            IOException expectedException = null;
            String nonExistDir = "/non-exist-" + Time.now();
            fs.delete(new Path(nonExistDir), true);
            EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
            out = TestFileCreation.createNonRecursive((FileSystem)fs, path, 1, createFlag);
            out.close();
            try {
                TestFileCreation.createNonRecursive((FileSystem)fs, new Path(path, "Create"), 1, createFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Create a file when parent directory exists as a file should throw ParentNotDirectoryException ", (expectedException != null && expectedException instanceof ParentNotDirectoryException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path2 = new Path(nonExistDir + "/testCreateNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive((FileSystem)fs, path2, 1, createFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Create a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
            EnumSet<CreateFlag> overwriteFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
            out = TestFileCreation.createNonRecursive((FileSystem)fs, path, 1, overwriteFlag);
            out.close();
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive((FileSystem)fs, new Path(path, "Overwrite"), 1, overwriteFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Overwrite a file when parent directory exists as a file should throw ParentNotDirectoryException ", (expectedException != null && expectedException instanceof ParentNotDirectoryException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path3 = new Path(nonExistDir + "/testOverwriteNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive((FileSystem)fs, path3, 1, overwriteFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            Assert.assertTrue((String)"Overwrite a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    static FSDataOutputStream createNonRecursive(FileSystem fs, Path name, int repl, EnumSet<CreateFlag> flag) throws IOException {
        System.out.println("createNonRecursive: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = ((DistributedFileSystem)fs).createNonRecursive(name, FsPermission.getDefault(), flag, fs.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L, null);
        return stm;
    }

    @Test
    public void testFileCreationSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testFileCreation();
        this.simulatedStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentFileCreation() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            int i;
            DistributedFileSystem fs = cluster.getFileSystem();
            Path[] p = new Path[]{new Path("/foo"), new Path("/bar")};
            FSDataOutputStream[] out = new FSDataOutputStream[]{fs.create(p[0]), fs.create(p[1])};
            for (i = 0; i < 100; ++i) {
                out[0].write(i);
                out[1].write(i);
            }
            out[0].close();
            while (i < 200) {
                out[1].write(i);
                ++i;
            }
            out[1].close();
            FSDataInputStream[] in = new FSDataInputStream[]{fs.open(p[0]), fs.open(p[1])};
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)i, (long)in[0].read());
            }
            for (i = 0; i < 200; ++i) {
                Assert.assertEquals((long)i, (long)in[1].read());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationSyncOnClose() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.synconclose", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            int i;
            DistributedFileSystem fs = cluster.getFileSystem();
            Path[] p = new Path[]{new Path("/foo"), new Path("/bar")};
            FSDataOutputStream[] out = new FSDataOutputStream[]{fs.create(p[0]), fs.create(p[1])};
            for (i = 0; i < 100; ++i) {
                out[0].write(i);
                out[1].write(i);
            }
            out[0].close();
            while (i < 200) {
                out[1].write(i);
                ++i;
            }
            out[1].close();
            FSDataInputStream[] in = new FSDataInputStream[]{fs.open(p[0]), fs.open(p[1])};
            for (i = 0; i < 100; ++i) {
                Assert.assertEquals((long)i, (long)in[0].read());
            }
            for (i = 0; i < 200; ++i) {
                Assert.assertEquals((long)i, (long)in[1].read());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseExpireHardLimit() throws Exception {
        System.out.println("testLeaseExpireHardLimit start");
        long leasePeriod = 1000L;
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            String f = DIR + "foo";
            Path fpath = new Path(f);
            HdfsDataOutputStream out = TestFileCreation.create(dfs, fpath, 3);
            out.write("something".getBytes());
            out.hflush();
            int actualRepl = out.getCurrentBlockReplication();
            Assert.assertTrue((String)(f + " should be replicated to " + 3 + " datanodes, but is only replicated to " + actualRepl + " datanodes."), (actualRepl == 3 ? 1 : 0) != 0);
            cluster.setLeasePeriod(1000L, 1000L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LocatedBlocks locations = dfs.dfs.getNamenode().getBlockLocations(f, 0L, Long.MAX_VALUE);
            Assert.assertEquals((long)1L, (long)locations.locatedBlockCount());
            LocatedBlock locatedblock = (LocatedBlock)locations.getLocatedBlocks().get(0);
            int successcount = 0;
            for (DatanodeInfo datanodeinfo : locatedblock.getLocations()) {
                DataNode datanode = cluster.getDataNode(datanodeinfo.getIpcPort());
                ExtendedBlock blk = locatedblock.getBlock();
                Block b = DataNodeTestUtils.getFSDataset(datanode).getStoredBlock(blk.getBlockPoolId(), blk.getBlockId());
                File blockfile = DataNodeTestUtils.getFile(datanode, blk.getBlockPoolId(), b.getBlockId());
                System.out.println("blockfile=" + blockfile);
                if (blockfile == null) continue;
                BufferedReader in = new BufferedReader(new FileReader(blockfile));
                Assert.assertEquals((Object)"something", (Object)in.readLine());
                in.close();
                ++successcount;
            }
            System.out.println("successcount=" + successcount);
            Assert.assertTrue((successcount > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
        System.out.println("testLeaseExpireHardLimit successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsClose() throws Exception {
        System.out.println("test file system close start");
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            String f = DIR + "foofs";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something".getBytes());
            dfs.close();
        }
        finally {
            System.out.println("testFsClose successful");
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsCloseAfterClusterShutdown() throws IOException {
        System.out.println("test testFsCloseAfterClusterShutdown start");
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.replication.min", 3);
        conf.setBoolean("ipc.client.ping", false);
        conf.setInt("ipc.ping.interval", 10000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            String f = DIR + "testFsCloseAfterClusterShutdown";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something_test".getBytes());
            out.hflush();
            cluster.stopDataNode(2);
            boolean hasException = false;
            try {
                out.close();
                System.out.println("testFsCloseAfterClusterShutdown: Error here");
            }
            catch (IOException e) {
                hasException = true;
            }
            Assert.assertTrue((String)"Failed to close file after cluster shutdown", (boolean)hasException);
        }
        finally {
            System.out.println("testFsCloseAfterClusterShutdown successful");
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testCreateNonCanonicalPathAndRestartRpc() throws Exception {
        this.doCreateTest(CreationMethod.DIRECT_NN_RPC);
    }

    @Test
    public void testCreateNonCanonicalPathAndRestartFromString() throws Exception {
        this.doCreateTest(CreationMethod.PATH_FROM_STRING);
    }

    @Test
    public void testCreateNonCanonicalPathAndRestartFromUri() throws Exception {
        this.doCreateTest(CreationMethod.PATH_FROM_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateTest(CreationMethod method) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            NamenodeProtocols nnrpc = cluster.getNameNodeRpc();
            block9: for (String pathStr : NON_CANONICAL_PATHS) {
                System.out.println("Creating " + pathStr + " by " + (Object)((Object)method));
                switch (method) {
                    case DIRECT_NN_RPC: {
                        try {
                            nnrpc.create(pathStr, new FsPermission(493), "client", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 0x8000000L, null);
                            Assert.fail((String)("Should have thrown exception when creating '" + pathStr + "' by " + (Object)((Object)method)));
                            continue block9;
                        }
                        catch (IOException ipe) {
                            if (ipe.getCause() instanceof InvalidPathException) continue block9;
                            throw ipe;
                        }
                    }
                    case PATH_FROM_URI: 
                    case PATH_FROM_STRING: {
                        Path p = method == CreationMethod.PATH_FROM_URI ? new Path(new URI(fs.getUri() + pathStr)) : new Path(fs.getUri() + pathStr);
                        FSDataOutputStream stm = fs.create(p);
                        IOUtils.closeStream((Closeable)stm);
                        continue block9;
                    }
                    default: {
                        throw new AssertionError((Object)("bad method: " + (Object)((Object)method)));
                    }
                }
            }
            cluster.restartNameNode(new String[0]);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalDelete() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            fs.mkdirs(new Path("/A/B/C"));
            this.createSmallFile((FileSystem)fs, new Path("/A/af1"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/B/bf2"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/B/bf3"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/B/C/cf1"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/B/C/cf2"), 1);
            String s = "asdf";
            fs.mkdirs(new Path("/A/D"));
            fs.mkdirs(new Path("/A/D/E"));
            fs.mkdirs(new Path("/A/D/F"));
            fs.mkdirs(new Path("/A/D/F/G"));
            fs.mkdirs(new Path("/A/D/F/H"));
            this.createSmallFile((FileSystem)fs, new Path("/A/D/E/ef1"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/D/F/ff1"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/D/F/H/hf1"), 1);
            this.createSmallFile((FileSystem)fs, new Path("/A/D/F/G/gf1"), 1);
            System.out.println("_________________________TestX Deleting /A/B/C/cf1_______________________________________________");
            Assert.assertTrue((boolean)fs.delete(new Path("/A/B/C/cf1"), true));
            System.out.println("_________________________TestX Deleting /A/D_______________________________________________");
            Assert.assertTrue((boolean)fs.delete(new Path("/A/D"), true));
            System.out.println("_________________________TestX Deleting /A/B/C_______________________________________________");
            Assert.assertTrue((boolean)fs.delete(new Path("/A/B/C"), true));
        }
        finally {
            cluster.shutdown();
        }
    }

    private void createSmallFile(FileSystem fs, Path path, int replication) throws IOException {
        FSDataOutputStream stm = TestFileCreation.createFile(fs, path, replication);
        TestFileCreation.writeFile(stm);
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteDirs() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            fs.mkdirs(new Path("/A"));
            fs.mkdirs(new Path("/A/B"));
            fs.mkdirs(new Path("/A/C"));
            Assert.assertTrue((boolean)fs.delete(new Path("/A"), true));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            int i;
            fs.mkdirs(new Path("/dir"));
            for (i = 0; i < 100; ++i) {
                FSDataOutputStream stm = TestFileCreation.createFile((FileSystem)fs, new Path("/dir/file" + i), 1);
                stm.close();
            }
            fs.rename(new Path("/dir/file" + (i - 1)), new Path("/dir/file" + i));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameDL() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            Path dir1 = new Path("/A/B/C/D");
            Path dir2 = new Path("/D");
            fs.mkdirs(dir1);
            fs.mkdirs(dir2);
            fs.rename(dir2, dir1);
            fs.rename(dir2, new Path("/A/B/C"));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreationSimple() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            int k;
            int f;
            int FILES = 10;
            int BLOCKS = 2;
            Path base = new Path("/f1/f2/f3/f4/f5");
            dfs.mkdirs(base);
            for (f = 0; f < 10; ++f) {
                FSDataOutputStream out = dfs.create(new Path(base, "test" + f));
                for (k = 0; k < 2; ++k) {
                    out.write(k);
                }
                out.close();
            }
            for (f = 0; f < 10; ++f) {
                FSDataInputStream in = dfs.open(new Path(base, "test" + f));
                for (k = 0; k < 2; ++k) {
                    Assert.assertTrue((in.read() == k ? 1 : 0) != 0);
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileAndDirListing() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            FileStatus[] status;
            String data = "test";
            Path base = new Path("/f1");
            dfs.mkdirs(base);
            dfs.mkdirs(new Path(base, "dir"));
            FSDataOutputStream out = dfs.create(new Path(base, "test"));
            out.write("test".getBytes());
            out.close();
            for (FileStatus statu1 : status = dfs.listStatus(base)) {
                if (!statu1.isFile()) continue;
                Assert.assertTrue((String)"File size does not match ", (statu1.getLen() == (long)"test".getBytes().length ? 1 : 0) != 0);
            }
            for (FileStatus statu : status = dfs.listStatus(new Path(base, "test"))) {
                if (!statu.isFile()) continue;
                Assert.assertTrue((String)"File size does not match ", (statu.getLen() == (long)"test".getBytes().length ? 1 : 0) != 0);
            }
            dfs.listLocatedStatus(base);
            dfs.listLocatedStatus(new Path(base, "test"));
        }
        catch (Exception e) {
            Assert.fail();
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void test2() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsVariables.resetMisReplicatedIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockUpgrade() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            fs.mkdirs(new Path("/test"));
            fs.listStatus(new Path("/test"));
            TestFileCreation.createFile((FileSystem)fs, new Path("/test/f.txt"), 3);
        }
        catch (Exception e) {
            Assert.fail();
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testTx() throws IOException, InterruptedException {
        class Thread
        extends java.lang.Thread {
            TransactionLockTypes.LockType lockType;
            String holder = "DFSClient_NONMAPREDUCE_-1273425403_1";

            Thread(TransactionLockTypes.LockType lockType) {
                this.lockType = lockType;
            }

            @Override
            public void run() {
                try {
                    TestFileCreation.this.acquireLock(this.lockType, this.holder);
                }
                catch (IOException ex) {
                    Logger.getLogger(TestFileCreation.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        Thread t1 = new Thread(TransactionLockTypes.LockType.READ);
        t1.start();
        Thread t2 = new Thread(TransactionLockTypes.LockType.READ);
        t2.start();
        t1.join();
        t2.join();
    }

    private void acquireLock(TransactionLockTypes.LockType lockType, final String holder) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        final int leaseCreationLockRows = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HopsTransactionalRequestHandler testHandler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            TransactionLockTypes.LockType lockType;
            {
                super(x0);
                this.lockType = null;
            }

            public void setUp() throws IOException {
                super.setUp();
                this.lockType = (TransactionLockTypes.LockType)this.getParams()[0];
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLockAllPaths(this.lockType, holder, leaseCreationLockRows));
            }

            public Object performTask() throws IOException {
                Lease lease = (Lease)EntityManager.find((FinderType)Lease.Finder.ByHolder, (Object[])new Object[]{holder, Lease.getHolderId((String)holder)});
                if (lease != null) {
                    FSNamesystem.LOG.debug((Object)("Got the lock " + this.lockType + "Lease. Holder is: " + lease.getHolder() + " ID: " + lease.getHolderID()));
                } else {
                    FSNamesystem.LOG.debug((Object)"LEASE is NULL");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(TestFileCreation.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        };
        testHandler.setParams(new Object[]{lockType});
        testHandler.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListDirPerformance() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean BYTES_PER_CHECKSUM = true;
        boolean PACKET_SIZE = true;
        boolean BLOCK_SIZE = true;
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.client-write-packet-size", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            fs.mkdirs(new Path("/test"));
            TestFileCreation.createFile((FileSystem)fs, new Path("/test/f.txt"), 3);
            for (int i = 0; i < 32; ++i) {
                fs.mkdirs(new Path("/test/dir" + i));
            }
            fs.listLocatedStatus(new Path("/test"));
        }
        catch (Exception e) {
            Assert.fail();
            e.printStackTrace();
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void eyeBallTest() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            conf.setBoolean("dfs.erasure_coding.enabled", false);
            conf.setBoolean("dfs.namenode.quota.enabled", true);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            Path file = new Path("/dir/file");
            dfs.mkdirs(dir);
            dfs.create(file).close();
            dfs.open(file).close();
            dfs.append(file).close();
            dfs.listStatus(file);
            dfs.listStatus(dir);
            dfs.getFileStatus(file);
            dfs.getFileStatus(dir);
            dfs.setPermission(file, new FsPermission(511));
            dfs.setPermission(dir, new FsPermission(511));
            dfs.setOwner(file, System.getProperty("user.name"), System.getProperty("user.name"));
            dfs.setOwner(dir, System.getProperty("user.name"), System.getProperty("user.name"));
            dfs.setReplication(file, (short)3);
            dfs.rename(file, new Path("/dir/file2"));
            dfs.delete(new Path("/dir/file2"));
            dfs.delete(dir);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileRead() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"), new FsPermission(777));
            dfs.create(new Path("/test.txt"), (short)3).close();
            dfs.append(new Path("/test.txt")).close();
            dfs.open(new Path("/test.txt")).close();
            dfs.getFileStatus(new Path("/test.txt"));
            dfs.listStatus(new Path("/test.txt"));
            dfs.setReplication(new Path("/dir"), (short)1);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatAfterRestart() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path file = new Path("/dir/dir/file.txt");
            dfs.create(file, (short)3).close();
            cluster.shutdown();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).numDataNodes(0).build();
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            dfs.listStatus(file);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLS() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(new Path("/dir"), new FsPermission(777));
            for (int i = 0; i < 32; ++i) {
                dfs.create(new Path("/dir/file" + i + ".txt"), (short)3).close();
            }
            dfs.listStatus(new Path("/dir"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotReplicatedYetException() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int BLOCK_SIZE = 1024;
            conf.setInt("dfs.blocksize", 1024);
            conf.setInt("dfs.namenode.replication.min", 1);
            conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            FSDataOutputStream out = dfs.create(new Path("/file"));
            byte[] buffer = new byte[4096];
            out.write(buffer);
            out.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIdMismatch() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path f = new Path("/testFileIdMismatch.txt");
            TestFileCreation.createFile((FileSystem)dfs, f, 3);
            long someOtherFileId = -1L;
            try {
                cluster.getNameNodeRpc().complete(f.toString(), client.clientName, null, someOtherFileId, null);
                Assert.fail();
            }
            catch (LeaseExpiredException e) {
                FileSystem.LOG.info((Object)"Caught Expected LeaseExpiredException: ", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameUnderReplicatedFile() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).format(true).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.newInstance((URI)fs.getUri(), (Configuration)fs.getConf());
        try {
            fs.mkdirs(new Path("/dir"));
            Path src = new Path("/dir/src");
            Path dest = new Path("/dir/dest");
            FSDataOutputStream out = fs.create(src, (short)3);
            out.write(1);
            out.close();
            out = fs.create(dest, (short)3);
            out.write(1);
            out.close();
            try {
                dfs.rename(src, dest, new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static class Writer
    implements Runnable {
        final FileSystem fs;
        final Path filepath;
        final int numOfBlocks;
        final String name;

        Writer(FileSystem fs, Path filepath, int numOfBlocks) {
            this.name = Writer.class.getSimpleName() + ":" + filepath;
            this.fs = fs;
            this.filepath = filepath;
            this.numOfBlocks = numOfBlocks;
        }

        @Override
        public void run() {
            FSDataOutputStream out = null;
            try {
                out = this.fs.create(this.filepath);
                for (int i = 0; i < this.numOfBlocks; ++i) {
                    out.write(i);
                }
                FSNamesystem.LOG.error((Object)("www: " + this.name + " done writing"));
            }
            catch (Exception e) {
                try {
                    FSNamesystem.LOG.error((Object)("www: " + this.name + " dies: e=" + e));
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)out);
            }
            IOUtils.closeStream((Closeable)out);
        }
    }

    private static enum CreationMethod {
        DIRECT_NN_RPC,
        PATH_FROM_URI,
        PATH_FROM_STRING;

    }
}

