/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHABasicFailover
extends TestCase {
    public static final Logger LOG = LoggerFactory.getLogger(TestHABasicFailover.class);
    Configuration conf;
    MiniDFSCluster cluster;
    int NUM_NAMENODES;
    int NUM_DATANODES;

    public TestHABasicFailover() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        this.conf = new HdfsConfiguration();
        this.cluster = null;
        this.NUM_NAMENODES = 2;
        this.NUM_DATANODES = 1;
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void testFailover() throws IOException, TimeoutException {
        boolean NN1 = false;
        boolean NN2 = true;
        if (this.NUM_NAMENODES < 2) {
            this.NUM_NAMENODES = 2;
        }
        try {
            this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(this.NUM_NAMENODES)).numDataNodes(this.NUM_DATANODES).build();
            this.cluster.waitActive();
            long timeout = (long)this.conf.getInt("dfs.leader.check.interval", 2000) + this.conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
            LOG.info("NameNode 1 id " + this.cluster.getNameNode(0).getId() + " address " + this.cluster.getNameNode(0).getServiceRpcAddress().toString());
            LOG.info("NameNode 2 id " + this.cluster.getNameNode(1).getId() + " address " + this.cluster.getNameNode(1).getServiceRpcAddress().toString());
            TestHABasicFailover.assertTrue((String)"NN1 is expected to be leader, but is not", (boolean)this.cluster.getNameNode(0).isLeader());
            this.cluster.shutdownNameNode(0);
            TestHABasicFailover.waitLeaderElection(this.cluster.getDataNodes(), this.cluster.getNameNode(1), timeout * 10L);
            TestHABasicFailover.assertTrue((String)"NN2 is expected to be the leader, but is not", (boolean)this.cluster.getNameNode(1).isLeader());
            TestHABasicFailover.assertTrue((String)"Not all datanodes detected the new leader", (boolean)TestHABasicFailover.doesDataNodesRecognizeLeader(this.cluster.getDataNodes(), this.cluster.getNameNode(1)));
            LOG.debug("TestNN going to restart the NN2");
            this.cluster.restartNameNode(1, false);
            this.cluster.waitActive();
            TestHABasicFailover.waitLeaderElection(this.cluster.getDataNodes(), this.cluster.getNameNode(1), timeout * 10L);
            TestHABasicFailover.assertTrue((String)"NN2 is expected to be the leader, but is not", (boolean)this.cluster.getNameNode(1).isLeader());
            TestHABasicFailover.assertTrue((String)"Not all datanodes detected the new leader", (boolean)TestHABasicFailover.doesDataNodesRecognizeLeader(this.cluster.getDataNodes(), this.cluster.getNameNode(1)));
            this.cluster.restartNameNode(0);
            this.cluster.waitActive();
            TestHABasicFailover.waitLeaderElection(this.cluster.getDataNodes(), this.cluster.getNameNode(1), timeout * 10L);
            this.cluster.shutdownNameNode(1);
            this.cluster.waitActive();
            TestHABasicFailover.waitLeaderElection(this.cluster.getDataNodes(), this.cluster.getNameNode(0), timeout * 10L);
            TestHABasicFailover.assertTrue((String)"NN1 is expected to be the leader, but is not", (boolean)this.cluster.getNameNode(0).isLeader());
            TestHABasicFailover.assertTrue((String)"Not all datanodes detected the new leader", (boolean)TestHABasicFailover.doesDataNodesRecognizeLeader(this.cluster.getDataNodes(), this.cluster.getNameNode(0)));
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    public static boolean doesDataNodesRecognizeLeader(List<DataNode> datanodes, NameNode namenode) {
        boolean result = true;
        for (DataNode datanode : datanodes) {
            result &= datanode.isConnectedToNN(namenode.getNameNodeAddress()) || datanode.isConnectedToNN(namenode.getServiceRpcAddress());
        }
        return result;
    }

    public static void waitLeaderElection(List<DataNode> datanodes, NameNode nn, long timeout) throws TimeoutException {
        block6: {
            long initTime = System.currentTimeMillis();
            while (!nn.isLeader()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                if (System.currentTimeMillis() - initTime < timeout) continue;
                throw new TimeoutException("Namenode was not elected leader. Time out " + timeout);
            }
            initTime = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                boolean result = TestHABasicFailover.doesDataNodesRecognizeLeader(datanodes, nn);
                if (result) break block6;
            } while (System.currentTimeMillis() - initTime < timeout);
            throw new TimeoutException("Datanodes weren't able to detect newly elected leader");
        }
    }
}

