/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;

public class TestHABlockReports
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestHABlockReports.class);
    Configuration conf = new HdfsConfiguration();
    MiniDFSCluster cluster = null;
    int NUM_NAMENODES = 2;
    int NUM_DATANODES = 3;

    public void setconfig() {
        this.conf.setInt("dfs.client.failover.max.attempts", 1);
        this.conf.setInt("dfs.client.retry.max.attempts", 1);
        this.conf.setInt("dfs.client.failover.sleep.base.millis", 500);
        this.conf.setInt("dfs.client.failover.sleep.max.millis", 1000);
        this.conf.setInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", 2);
        this.conf.setInt("ipc.client.connect.max.retries", 1);
        this.conf.set("dfs.client.retry.policy.spec", "1000,2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void testMultiNNBlockReports() throws IOException, TimeoutException, InterruptedException {
        boolean NN1 = false;
        boolean NN2 = true;
        if (this.NUM_NAMENODES < 2) {
            this.NUM_NAMENODES = 2;
        }
        try {
            this.setconfig();
            this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(this.NUM_NAMENODES)).numDataNodes(this.NUM_DATANODES).build();
            this.cluster.waitActive();
            Thread.sleep(10000L);
            TestHABlockReports.assertEquals((String)"Wrong number of block reports", (long)6L, (long)this.getTotalBRSent(this.cluster));
            LOG.info((Object)("Cluster started. Total Block reports: " + this.getTotalBRSent(this.cluster)));
            this.cluster.shutdownNameNode(1);
            LOG.info((Object)"Second namenode is killed");
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            for (int i = 0; i < 5; ++i) {
                FSDataOutputStream out = fs.create(new Path("/test" + i));
                out.write(i);
                out.close();
            }
            LOG.info((Object)"Created some files to change the state of the datanodes");
            TestHABlockReports.assertEquals((String)"Wrong number of block reports", (long)6L, (long)this.getTotalBRSent(this.cluster));
            this.cluster.restartNameNode(1);
            this.cluster.waitActive();
            Thread.sleep(10000L);
            LOG.info((Object)("Restarted the second namenode. Total Block reports: " + this.getTotalBRSent(this.cluster)));
            TestHABlockReports.assertEquals((String)"Wrong number of block reports", (long)6L, (long)this.getTotalBRSent(this.cluster));
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Test(timeout=900000L)
    public void testAllDeadNamenodes() throws IOException, TimeoutException, InterruptedException {
        boolean NN1 = false;
        boolean NN2 = true;
        if (this.NUM_NAMENODES < 2) {
            this.NUM_NAMENODES = 2;
        }
        try {
            this.setconfig();
            this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(this.NUM_NAMENODES)).numDataNodes(this.NUM_DATANODES).format(true).build();
            this.cluster.waitActive();
            Thread.sleep(10000L);
            TestHABlockReports.assertEquals((String)"Wrong number of block reports", (long)6L, (long)this.getTotalBRSent(this.cluster));
            LOG.info((Object)("Cluster started. Total Block reports: " + this.getTotalBRSent(this.cluster)));
            this.cluster.shutdownNameNode(0);
            this.cluster.shutdownNameNode(1);
            Thread.sleep(10000L);
            this.cluster.restartNameNode(0, false);
            this.cluster.restartNameNode(1, false);
            this.cluster.getNameNode(0);
            NameNode.metrics.incrAddBlockOps();
            this.cluster.waitActive();
            Thread.sleep(10000L);
            TestHABlockReports.assertEquals((String)"Wrong number of block reports", (long)12L, (long)this.getTotalBRSent(this.cluster));
            LOG.info((Object)("Cluster started. Total Block reports: " + this.getTotalBRSent(this.cluster)));
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    private long getTotalBRSent(MiniDFSCluster cluster) {
        long counter = 0L;
        ArrayList<DataNode> datanodes = cluster.getDataNodes();
        for (DataNode dn : datanodes) {
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
            counter += MetricsAsserts.getLongCounter((String)"BlockReportCount", (MetricsRecordBuilder)rb);
        }
        return counter;
    }
}

