/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.common.security.FsSecurityActions;
import io.hops.common.security.HopsworksFsSecurityActions;
import io.hops.security.HopsSecurityActionsFactory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestHopsworksFsSecurityActions {
    private static final String USERNAME = "PROJECT__USERNAME";
    private String HOPSWORKS_ENDPOINT = "https://HOST:PORT";
    private static String classpath;
    private Configuration conf;
    private String HOPSWORKS_API_KEY = "";

    @BeforeClass
    public static void beforeClass() throws Exception {
        classpath = KeyStoreTestUtil.getClasspathDir(TestHopsworksFsSecurityActions.class);
    }

    @Before
    public void beforeTest() throws Exception {
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
        this.conf = new Configuration();
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.set("dfs.security-actions.actor-class", "io.hops.common.security.DevHopsworksFsSecurityActions");
        String sslConfFilename = super.getClass().getSimpleName() + ".ssl-server.xml";
        Path sslServerPath = Paths.get(classpath, sslConfFilename);
        Configuration sslServer = new Configuration(false);
        sslServer.set("hops.hopsworks-api-key", this.HOPSWORKS_API_KEY);
        KeyStoreTestUtil.saveConfig((File)sslServerPath.toFile(), (Configuration)sslServer);
        this.conf.set("hadoop.ssl.server.conf", sslConfFilename);
        this.conf.set("hops.hopsworks.host", this.HOPSWORKS_ENDPOINT);
    }

    @After
    public void afterTest() throws Exception {
        HopsSecurityActionsFactory.getInstance().clear(this.conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
    }

    @Test
    public void testGetX509Credentials() throws Exception {
        FsSecurityActions actor = (FsSecurityActions)HopsSecurityActionsFactory.getInstance().getActor(this.conf, this.conf.get("dfs.security-actions.actor-class", "io.hops.common.security.HopsworksFsSecurityActions"));
        HopsworksFsSecurityActions.X509CredentialsDTO x509DTO = actor.getX509Credentials(USERNAME);
        Assert.assertFalse((boolean)x509DTO.getFileExtension().isEmpty());
        Assert.assertFalse((boolean)x509DTO.getkStore().isEmpty());
        Assert.assertFalse((boolean)x509DTO.gettStore().isEmpty());
        Assert.assertFalse((boolean)x509DTO.getPassword().isEmpty());
    }
}

