/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.ipc.RefreshHandler;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGenericRefresh {
    private static MiniDFSCluster cluster;
    private static Configuration config;
    private static final int NNPort = 54222;
    private static RefreshHandler firstHandler;
    private static RefreshHandler secondHandler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        config = new Configuration();
        config.set("hadoop.security.authorization", "true");
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:54222");
        cluster = new MiniDFSCluster.Builder(config).nameNodePort(54222).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDownBeforeClass() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        firstHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)firstHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).toReturn((Object)RefreshResponse.successResponse());
        RefreshRegistry.defaultRegistry().register("firstHandler", firstHandler);
        secondHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one", "two"})).toReturn((Object)new RefreshResponse(3, "three"));
        Mockito.stub((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one"})).toReturn((Object)new RefreshResponse(2, "two"));
        RefreshRegistry.defaultRegistry().register("secondHandler", secondHandler);
    }

    @After
    public void tearDown() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        RefreshRegistry.defaultRegistry().unregisterAll("secondHandler");
    }

    @Test
    public void testInvalidCommand() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "nn"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should fail due to bad args", (long)-1L, (long)exitCode);
    }

    @Test
    public void testInvalidIdentifier() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "unregisteredIdentity"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should fail due to no handler registered", (long)-1L, (long)exitCode);
    }

    @Test
    public void testValidIdentifier() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "firstHandler"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should succeed", (long)0L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("firstHandler", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)secondHandler, (VerificationMode)Mockito.never())).handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class));
    }

    @Test
    public void testVariableArgs() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "secondHandler", "one"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should return 2", (long)2L, (long)exitCode);
        exitCode = admin.run(new String[]{"-refresh", "localhost:54222", "secondHandler", "one", "two"});
        Assert.assertEquals((String)"DFSAdmin should now return 3", (long)3L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one", "two"});
    }

    @Test
    public void testUnregistration() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "firstHandler"};
        int exitCode = admin.run(args);
        Assert.assertEquals((String)"DFSAdmin should return -1", (long)-1L, (long)exitCode);
    }

    @Test
    public void testUnregistrationReturnValue() {
        RefreshHandler mockHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        RefreshRegistry.defaultRegistry().register("test", mockHandler);
        boolean ret = RefreshRegistry.defaultRegistry().unregister("test", mockHandler);
        Assert.assertTrue((boolean)ret);
    }

    @Test
    public void testMultipleRegistration() throws Exception {
        RefreshRegistry.defaultRegistry().register("sharedId", firstHandler);
        RefreshRegistry.defaultRegistry().register("sharedId", secondHandler);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "sharedId", "one"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("sharedId", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("sharedId", new String[]{"one"});
        RefreshRegistry.defaultRegistry().unregisterAll("sharedId");
    }

    @Test
    public void testMultipleReturnCodeMerging() throws Exception {
        RefreshHandler handlerOne = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)handlerOne.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).toReturn((Object)new RefreshResponse(23, "Twenty Three"));
        RefreshHandler handlerTwo = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)handlerTwo.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).toReturn((Object)new RefreshResponse(10, "Ten"));
        RefreshRegistry.defaultRegistry().register("shared", handlerOne);
        RefreshRegistry.defaultRegistry().register("shared", handlerTwo);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "shared"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)handlerOne)).handleRefresh("shared", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)handlerTwo)).handleRefresh("shared", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("shared");
    }

    @Test
    public void testExceptionResultsInNormalError() throws Exception {
        RefreshHandler exceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)exceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).toThrow((Throwable)new RuntimeException("Exceptional Handler Throws Exception"));
        RefreshHandler otherExceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.stub((Object)otherExceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).toThrow((Throwable)new RuntimeException("More Exceptions"));
        RefreshRegistry.defaultRegistry().register("exceptional", exceptionalHandler);
        RefreshRegistry.defaultRegistry().register("exceptional", otherExceptionalHandler);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:54222", "exceptional"};
        int exitCode = admin.run(args);
        Assert.assertEquals((long)-1L, (long)exitCode);
        ((RefreshHandler)Mockito.verify((Object)exceptionalHandler)).handleRefresh("exceptional", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)otherExceptionalHandler)).handleRefresh("exceptional", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("exceptional");
    }
}

