/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;

public class HopsFilesTestHelper {
    public static void writeFile(DistributedFileSystem dfs, String name, int size, boolean overwrite) throws IOException {
        FSDataOutputStream os = dfs.create(new Path(name), overwrite);
        HopsFilesTestHelper.writeData(os, 0, size);
        os.close();
    }

    public static void writeFile(FileSystem fs, String name, int size) throws IOException {
        FSDataOutputStream os = fs.create(new Path(name), (short)1);
        HopsFilesTestHelper.writeData(os, 0, size);
        os.close();
    }

    public static void writeData(FSDataOutputStream os, int existingSize, int size) throws IOException {
        byte[] data = new byte[size];
        int i = 0;
        while (i < size) {
            byte number;
            data[i] = number = (byte)(existingSize % 128);
            ++i;
            ++existingSize;
        }
        os.write(data);
    }

    public static void verifyFile(FileSystem dfs, String file, int size) throws IOException {
        long sizeDFS = dfs.getFileStatus(new Path(file)).getLen();
        Assert.assertTrue((String)("Expected: " + size + " Actual: " + sizeDFS), (sizeDFS == (long)size ? 1 : 0) != 0);
        FSDataInputStream is = dfs.open(new Path(file));
        byte[] buffer = new byte[size];
        IOUtils.readFully((InputStream)is, (byte[])buffer, (int)0, (int)size);
        is.close();
        for (int i = 0; i < size; ++i) {
            if (i % 128 == buffer[i]) continue;
            Assert.fail((String)("Data is corrupted. Expecting: " + i % 128 + " got: " + buffer[i] + " index: " + i));
        }
    }

    public static int countDBFiles() throws IOException {
        return HopsFilesTestHelper.countInMemoryDBFiles() + HopsFilesTestHelper.countAllOnDiskDBFiles();
    }

    public static int countInMemoryDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                InMemoryInodeDataAccess fida = (InMemoryInodeDataAccess)HdfsStorageFactory.getDataAccess(InMemoryInodeDataAccess.class);
                return fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countAllOnDiskDBFiles() throws IOException {
        return HopsFilesTestHelper.countOnDiskLargeDBFiles() + HopsFilesTestHelper.countOnDiskMediumDBFiles() + HopsFilesTestHelper.countOnDiskSmallDBFiles();
    }

    public static int countOnDiskSmallDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                SmallOnDiskInodeDataAccess fida = (SmallOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(SmallOnDiskInodeDataAccess.class);
                return count += fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countOnDiskMediumDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                MediumOnDiskInodeDataAccess fida = (MediumOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(MediumOnDiskInodeDataAccess.class);
                return count += fida.count();
            }
        };
        return (Integer)countDBFiles.handle();
    }

    public static int countOnDiskLargeDBFiles() throws IOException {
        LightWeightRequestHandler countDBFiles = new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST_DB_FILES){

            public Object performTask() throws StorageException, IOException {
                int count = 0;
                LargeOnDiskInodeDataAccess fida = (LargeOnDiskInodeDataAccess)HdfsStorageFactory.getDataAccess(LargeOnDiskInodeDataAccess.class);
                return count += fida.countUniqueFiles();
            }
        };
        return (Integer)countDBFiles.handle();
    }
}

