/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.util.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBlockReaderLocal {
    private static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void init() {
        sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
    }

    @AfterClass
    public static void shutdown() throws IOException {
        sockDir.close();
    }

    public static void assertArrayRegionsEqual(byte[] buf1, int off1, byte[] buf2, int off2, int len) {
        for (int i = 0; i < len; ++i) {
            if (buf1[off1 + i] == buf2[off2 + i]) continue;
            Assert.fail((String)("arrays differ at byte " + i + ". The first array has " + buf1[off1 + i] + ", but the second array has " + buf2[off2 + i]));
        }
    }

    private static void readFully(BlockReaderLocal reader, ByteBuffer buf, int off, int len) throws IOException {
        int amt = len;
        while (amt > 0) {
            buf.limit(off + len);
            buf.position(off);
            long ret = reader.read(buf);
            if (ret < 0L) {
                throw new EOFException("Premature EOF from BlockReaderLocal after reading " + (len - amt) + " byte(s).");
            }
            amt = (int)((long)amt - ret);
            off = (int)((long)off + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBlockReaderLocalTest(BlockReaderLocalTest test, boolean checksum, long readahead) throws IOException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", !checksum);
        conf.setLong("dfs.bytes-per-checksum", 512L);
        conf.set("dfs.checksum.type", "CRC32C");
        conf.setLong("dfs.client.cache.readahead", readahead);
        test.setConfiguration(conf);
        FileInputStream dataIn = null;
        FileInputStream metaIn = null;
        Path TEST_PATH = new Path("/a");
        long RANDOM_SEED = 4567L;
        BlockReaderLocal blockReaderLocal = null;
        FSDataInputStream fsIn = null;
        byte[] original = new byte[12345];
        DistributedFileSystem fs = null;
        ShortCircuitShm shm = null;
        RandomAccessFile raf = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 4567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            fsIn.close();
            fsIn = null;
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, TEST_PATH);
            File dataFile = cluster.getBlockFile(0, block);
            File metaFile = cluster.getBlockMetadataFile(0, block);
            ShortCircuitCache shortCircuitCache = ClientContext.getFromConf((Configuration)conf).getShortCircuitCache();
            cluster.shutdown();
            cluster = null;
            test.setup(dataFile, checksum);
            FileInputStream[] streams = new FileInputStream[]{new FileInputStream(dataFile), new FileInputStream(metaFile)};
            dataIn = streams[0];
            metaIn = streams[1];
            ExtendedBlockId key = new ExtendedBlockId(block.getBlockId(), block.getBlockPoolId());
            raf = new RandomAccessFile(new File(sockDir.getDir().getAbsolutePath(), UUID.randomUUID().toString()), "rw");
            raf.setLength(8192L);
            FileInputStream shmStream = new FileInputStream(raf.getFD());
            shm = new ShortCircuitShm(ShortCircuitShm.ShmId.createRandom(), shmStream);
            ShortCircuitReplica replica = new ShortCircuitReplica(key, dataIn, metaIn, shortCircuitCache, Time.now(), shm.allocAndRegisterSlot(ExtendedBlockId.fromExtendedBlock((ExtendedBlock)block)));
            blockReaderLocal = new BlockReaderLocal.Builder(new DfsClientConf.ShortCircuitConf((Configuration)conf)).setFilename(TEST_PATH.getName()).setBlock(block).setShortCircuitReplica(replica).setCachingStrategy(new CachingStrategy(Boolean.valueOf(false), Long.valueOf(readahead))).setVerifyChecksum(checksum).setTracer(FsTracer.get((Configuration)conf)).build();
            dataIn = null;
            metaIn = null;
            test.doTest(blockReaderLocal, original);
            Assert.assertEquals((long)0L, (long)streams[0].getChannel().position());
            Assert.assertEquals((long)0L, (long)streams[1].getChannel().position());
        }
        finally {
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            if (dataIn != null) {
                dataIn.close();
            }
            if (metaIn != null) {
                metaIn.close();
            }
            if (blockReaderLocal != null) {
                blockReaderLocal.close();
            }
            if (shm != null) {
                shm.free();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    @Test
    public void testBlockReaderLocalImmediateClose() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalImmediateClose(), true, 0L);
        this.runBlockReaderLocalTest(new TestBlockReaderLocalImmediateClose(), false, 0L);
    }

    @Test
    public void testBlockReaderSimpleReads() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderSimpleReadsShortReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), true, 511L);
    }

    @Test
    public void testBlockReaderSimpleReadsNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderSimpleReadsNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), true, 0L);
    }

    @Test
    public void testBlockReaderSimpleReadsNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderSimpleReads(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalArrayReads2() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalArrayReads2NoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalArrayReads2NoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalArrayReads2NoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalArrayReads2(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalByteBufferReads() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalByteBufferReadsNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalByteBufferReadsNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalByteBufferReadsNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferReads(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalByteBufferFastLaneReads() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferFastLaneReads(), true, 1024L);
    }

    @Test
    public void testBlockReaderLocalByteBufferFastLaneReadsNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferFastLaneReads(), false, 1024L);
    }

    @Test
    public void testBlockReaderLocalByteBufferFastLaneReadsNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferFastLaneReads(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalByteBufferFastLaneReadsNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalByteBufferFastLaneReads(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalReadCorruptStart() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorruptStart(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalReadCorrupt() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalReadCorruptNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalReadCorruptNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalReadCorruptNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadCorrupt(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalWithMlockChanges() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalWithMlockChanges(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalWithMlockChangesNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalWithMlockChanges(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalWithMlockChangesNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalWithMlockChanges(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalWithMlockChangesNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalWithMlockChanges(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalOnFileWithoutChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalOnFileWithoutChecksum(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalOnFileWithoutChecksumNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalOnFileWithoutChecksum(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalOnFileWithoutChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalOnFileWithoutChecksum(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalOnFileWithoutChecksumNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalOnFileWithoutChecksum(), false, 0L);
    }

    @Test
    public void testBlockReaderLocalReadZeroBytes() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadZeroBytes(), true, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalReadZeroBytesNoChecksum() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadZeroBytes(), false, 0x400000L);
    }

    @Test
    public void testBlockReaderLocalReadZeroBytesNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadZeroBytes(), true, 0L);
    }

    @Test
    public void testBlockReaderLocalReadZeroBytesNoChecksumNoReadahead() throws IOException {
        this.runBlockReaderLocalTest(new TestBlockReaderLocalReadZeroBytes(), false, 0L);
    }

    @Test(timeout=60000L)
    public void TestStatisticsForShortCircuitLocalRead() throws Exception {
        this.testStatistics(true);
    }

    @Test(timeout=60000L)
    public void TestStatisticsForLocalRead() throws Exception {
        this.testStatistics(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStatistics(boolean isShortCircuit) throws Exception {
        Assume.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        TemporarySocketDirectory sockDir = null;
        if (isShortCircuit) {
            DFSInputStream.tcpReadsDisabledForTesting = true;
            sockDir = new TemporarySocketDirectory();
            conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestStatisticsForLocalRead.%d.sock").getAbsolutePath());
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
            DomainSocket.disableBindPathValidation();
        } else {
            conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, false);
        }
        MiniDFSCluster cluster = null;
        Path TEST_PATH = new Path("/a");
        long RANDOM_SEED = 4567L;
        FSDataInputStream fsIn = null;
        byte[] original = new byte[12345];
        DistributedFileSystem fs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, TEST_PATH, 12345L, (short)1, 4567L);
            try {
                DFSTestUtil.waitReplication((FileSystem)fs, TEST_PATH, (short)1);
            }
            catch (InterruptedException e) {
                Assert.fail((String)("unexpected InterruptedException during waitReplication: " + e));
            }
            catch (TimeoutException e) {
                Assert.fail((String)("unexpected TimeoutException during waitReplication: " + e));
            }
            fsIn = fs.open(TEST_PATH);
            IOUtils.readFully((InputStream)fsIn, (byte[])original, (int)0, (int)12345);
            HdfsDataInputStream dfsIn = (HdfsDataInputStream)fsIn;
            Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalBytesRead());
            Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalLocalBytesRead());
            if (isShortCircuit) {
                Assert.assertEquals((long)12345L, (long)dfsIn.getReadStatistics().getTotalShortCircuitBytesRead());
            } else {
                Assert.assertEquals((long)0L, (long)dfsIn.getReadStatistics().getTotalShortCircuitBytesRead());
            }
            fsIn.close();
            fsIn = null;
        }
        finally {
            DFSInputStream.tcpReadsDisabledForTesting = false;
            if (fsIn != null) {
                fsIn.close();
            }
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            if (sockDir != null) {
                sockDir.close();
            }
        }
    }

    private static class TestBlockReaderLocalReadZeroBytes
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalReadZeroBytes() {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] emptyArr = new byte[]{};
            Assert.assertEquals((long)0L, (long)reader.read(emptyArr, 0, 0));
            ByteBuffer emptyBuf = ByteBuffer.wrap(emptyArr);
            Assert.assertEquals((long)0L, (long)reader.read(emptyBuf));
            reader.skip(1L);
            Assert.assertEquals((long)0L, (long)reader.read(emptyArr, 0, 0));
            Assert.assertEquals((long)0L, (long)reader.read(emptyBuf));
            reader.skip(12344L);
            Assert.assertEquals((long)-1L, (long)reader.read(emptyArr, 0, 0));
            Assert.assertEquals((long)-1L, (long)reader.read(emptyBuf));
        }
    }

    private static class TestBlockReaderLocalOnFileWithoutChecksum
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalOnFileWithoutChecksum() {
        }

        @Override
        public void setConfiguration(HdfsConfiguration conf) {
            conf.set("dfs.checksum.type", "NULL");
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            Assert.assertTrue((!reader.getVerifyChecksum() ? 1 : 0) != 0);
            ByteBuffer buf = ByteBuffer.wrap(new byte[12345]);
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 1, 9);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1, buf.array(), 1, 9);
            TestBlockReaderLocal.readFully(reader, buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf.array(), 10, 100);
            reader.forceAnchorable();
            TestBlockReaderLocal.readFully(reader, buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf.array(), 110, 700);
            reader.forceUnanchorable();
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf.array(), 811, 5);
        }
    }

    private static class TestBlockReaderLocalWithMlockChanges
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalWithMlockChanges() {
        }

        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(new byte[12345]);
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 1, 9);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1, buf.array(), 1, 9);
            TestBlockReaderLocal.readFully(reader, buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf.array(), 10, 100);
            reader.forceAnchorable();
            TestBlockReaderLocal.readFully(reader, buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf.array(), 110, 700);
            reader.forceUnanchorable();
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf.array(), 811, 5);
        }
    }

    private static class TestBlockReaderLocalReadCorrupt
    extends BlockReaderLocalTest {
        boolean usingChecksums = false;

        private TestBlockReaderLocalReadCorrupt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
            this.usingChecksums = usingChecksums;
            try (RandomAccessFile bf = null;){
                bf = new RandomAccessFile(blockFile, "rw");
                bf.seek(1539L);
                bf.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            }
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            block3: {
                byte[] buf = new byte[12345];
                try {
                    reader.readFully(buf, 0, 10);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 10);
                    reader.readFully(buf, 10, 100);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf, 10, 100);
                    reader.readFully(buf, 110, 700);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf, 110, 700);
                    reader.skip(1L);
                    reader.readFully(buf, 811, 5);
                    TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf, 811, 5);
                    reader.readFully(buf, 816, 900);
                    if (this.usingChecksums) {
                        Assert.fail((String)"did not detect corruption");
                    }
                }
                catch (ChecksumException e) {
                    if (this.usingChecksums) break block3;
                    Assert.fail((String)"didn't expect to get ChecksumException: not using checksums.");
                }
            }
        }
    }

    private static class TestBlockReaderLocalReadCorruptStart
    extends BlockReaderLocalTest {
        boolean usingChecksums = false;

        private TestBlockReaderLocalReadCorruptStart() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setup(File blockFile, boolean usingChecksums) throws IOException {
            this.usingChecksums = usingChecksums;
            try (RandomAccessFile bf = null;){
                bf = new RandomAccessFile(blockFile, "rw");
                bf.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            }
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            if (this.usingChecksums) {
                try {
                    reader.readFully(buf, 0, 10);
                    Assert.fail((String)"did not detect corruption");
                }
                catch (IOException iOException) {}
            } else {
                reader.readFully(buf, 0, 10);
            }
        }
    }

    private static class TestBlockReaderLocalByteBufferFastLaneReads
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalByteBufferFastLaneReads() {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            ByteBuffer buf = ByteBuffer.allocateDirect(12345);
            TestBlockReaderLocal.readFully(reader, buf, 0, 5120);
            buf.flip();
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, DFSTestUtil.asArray(buf), 0, 5120);
            reader.skip(1537L);
            TestBlockReaderLocal.readFully(reader, buf, 0, 1);
            buf.flip();
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 6657, DFSTestUtil.asArray(buf), 0, 1);
            reader.forceAnchorable();
            TestBlockReaderLocal.readFully(reader, buf, 0, 5120);
            buf.flip();
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 6658, DFSTestUtil.asArray(buf), 0, 5120);
            reader.forceUnanchorable();
            TestBlockReaderLocal.readFully(reader, buf, 0, 513);
            buf.flip();
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 11778, DFSTestUtil.asArray(buf), 0, 513);
            reader.skip(3L);
            TestBlockReaderLocal.readFully(reader, buf, 0, 50);
            buf.flip();
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 12294, DFSTestUtil.asArray(buf), 0, 50);
        }
    }

    private static class TestBlockReaderLocalByteBufferReads
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalByteBufferReads() {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(new byte[12345]);
            TestBlockReaderLocal.readFully(reader, buf, 0, 10);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf.array(), 0, 10);
            TestBlockReaderLocal.readFully(reader, buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf.array(), 10, 100);
            TestBlockReaderLocal.readFully(reader, buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf.array(), 110, 700);
            reader.skip(1L);
            TestBlockReaderLocal.readFully(reader, buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf.array(), 811, 5);
        }
    }

    private static class TestBlockReaderLocalArrayReads2
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalArrayReads2() {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            reader.readFully(buf, 0, 10);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 10);
            reader.readFully(buf, 10, 100);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 10, buf, 10, 100);
            reader.readFully(buf, 110, 700);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 110, buf, 110, 700);
            reader.readFully(buf, 810, 1);
            reader.readFully(buf, 811, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 811, buf, 811, 5);
            reader.readFully(buf, 816, 900);
            reader.readFully(buf, 1716, 5);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1716, buf, 1716, 5);
        }
    }

    private static class TestBlockReaderSimpleReads
    extends BlockReaderLocalTest {
        private TestBlockReaderSimpleReads() {
        }

        @Override
        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
            byte[] buf = new byte[12345];
            reader.readFully(buf, 0, 512);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 0, buf, 0, 512);
            reader.readFully(buf, 512, 512);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 512, buf, 512, 512);
            reader.readFully(buf, 1024, 513);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1024, buf, 1024, 513);
            reader.readFully(buf, 1537, 514);
            TestBlockReaderLocal.assertArrayRegionsEqual(original, 1537, buf, 1537, 514);
            Assert.assertTrue((reader.getMaxReadaheadLength() >= 512 ? 1 : 0) != 0);
        }
    }

    private static class TestBlockReaderLocalImmediateClose
    extends BlockReaderLocalTest {
        private TestBlockReaderLocalImmediateClose() {
        }
    }

    private static class BlockReaderLocalTest {
        static final int TEST_LENGTH = 12345;
        static final int BYTES_PER_CHECKSUM = 512;

        private BlockReaderLocalTest() {
        }

        public void setConfiguration(HdfsConfiguration conf) {
        }

        public void setup(File blockFile, boolean usingChecksums) throws IOException {
        }

        public void doTest(BlockReaderLocal reader, byte[] original) throws IOException {
        }
    }
}

