/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.security.HopsFileBasedKeyStoresFactory;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CRLFetcherFactory;
import org.apache.hadoop.security.ssl.CRLValidatorFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDFSStartupWithCRL {
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestDFSStartupWithCRL.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private final String keyAlgorithm = "RSA";
    private final String signatureAlgorithm = "SHA256withRSA";
    private final String password = "password";
    private static String confDir = null;
    private Configuration conf;
    private MiniDFSCluster cluster;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BASE_DIR_FILE.mkdirs();
        confDir = KeyStoreTestUtil.getClasspathDir(TestDFSStartupWithCRL.class);
    }

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        String testDataPath = System.getProperty("test.build.data", "build/test/data");
        File testDataCluster1 = new File(testDataPath, "dfs_cluster");
        String c1Path = testDataCluster1.getAbsolutePath();
        this.conf.set("hdfs.minidfs.basedir", c1Path);
        CRLValidatorFactory.getInstance().clearCache();
        CRLFetcherFactory.getInstance().clearFetcherCache();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        File sslServerConf;
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
        if ((sslServerConf = Paths.get(confDir, TestDFSStartupWithCRL.class.getSimpleName() + ".ssl-server.xml").toFile()).exists()) {
            sslServerConf.delete();
        }
    }

    @Test(timeout=20000L)
    public void testDFSStartup() throws Exception {
        String hostname = "localhost";
        Path inputCRLPath = Paths.get(BASE_DIR, "input.crl.pem");
        Path fetchedCRLPath = Paths.get(BASE_DIR, "fetched.crl.pem");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(this.conf);
        Path keyStore = Paths.get(BASE_DIR, loader.getSuperKeystoreFilename(ugi.getUserName()));
        Path trustStore = Paths.get(BASE_DIR, loader.getSuperTruststoreFilename(ugi.getUserName()));
        Path passwdFile = Paths.get(BASE_DIR, loader.getSuperMaterialPasswdFilename(ugi.getUserName()));
        FileUtils.writeStringToFile((File)passwdFile.toFile(), (String)"password");
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair((String)"RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate((String)("CN=" + hostname + ",L=" + ugi.getUserName()), (KeyPair)keyPair, (int)10, (String)"SHA256withRSA");
        KeyStoreTestUtil.createKeyStore((String)keyStore.toString(), (String)"password", (String)"server", (Key)keyPair.getPrivate(), (Certificate)cert);
        KeyStoreTestUtil.createTrustStore((String)trustStore.toString(), (String)"password", (String)"server", (Certificate)cert);
        X509CRL crl = KeyStoreTestUtil.generateCRL((X509Certificate)cert, (PrivateKey)keyPair.getPrivate(), (String)"SHA256withRSA", null, null);
        FileWriter fw = new FileWriter(inputCRLPath.toFile(), false);
        PemWriter pw = new PemWriter((Writer)fw);
        pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)crl));
        pw.flush();
        fw.flush();
        pw.close();
        fw.close();
        this.conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.HopsSSLSocketFactory");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        String superUser = UserGroupInformation.getCurrentUser().getUserName();
        this.conf.set("hadoop.proxyuser." + superUser, "*");
        this.conf.set("hadoop.ssl.enabled.protocols", "TLSv1.2,TLSv1.1");
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.SOCKET_ENABLED_PROTOCOL.getValue(), "TLSv1.2");
        this.conf.set("hadoop.ssl.keystores.factory.class", HopsFileBasedKeyStoresFactory.class.getCanonicalName());
        this.conf.set("hops.tls.superuser-material-directory", BASE_DIR);
        this.conf.setBoolean("hops.crl.validation.enabled", true);
        this.conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        this.conf.set("hops.crl.fetcher.interval", "1s");
        this.conf.set("hops.crl.input.uri", "file://" + inputCRLPath.toString());
        this.conf.set("hops.crl.output.file", fetchedCRLPath.toString());
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.cluster.waitClusterUp();
        Assert.assertEquals((long)1L, (long)this.cluster.getDataNodes().size());
    }
}

