/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestDFSUpgrade {
    private static final int EXPECTED_TXID = 61;
    private static final Log LOG = LogFactory.getLog((String)TestDFSUpgrade.class.getName());
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ": numDirs=" + numDirs));
    }

    void checkDataNode(String[] baseDirs, String bpid) throws IOException {
        for (int i = 0; i < baseDirs.length; ++i) {
            File current = new File(baseDirs[i], "current/" + bpid + "/current");
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, current, false), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            File currentFinalized = MiniDFSCluster.getFinalizedDir(new File(baseDirs[i]), bpid);
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, currentFinalized, true), (long)UpgradeUtilities.checksumMasterBlockPoolFinalizedContents());
            File previous = new File(baseDirs[i], "current/" + bpid + "/previous");
            Assert.assertTrue((boolean)previous.isDirectory());
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, previous, false), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            File previousFinalized = new File(baseDirs[i], "current/" + bpid + "/previous/finalized");
            Assert.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, previousFinalized, true), (long)UpgradeUtilities.checksumMasterBlockPoolFinalizedContents());
        }
    }

    void startNameNodeShouldFail(HdfsServerConstants.StartupOption operation) {
        this.startNameNodeShouldFail(operation, null, null);
    }

    void startNameNodeShouldFail(HdfsServerConstants.StartupOption operation, Class<? extends Exception> exceptionClass, Pattern messagePattern) {
        try {
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).startupOption(operation).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            Assert.fail((String)"NameNode should have failed to start");
        }
        catch (Exception e) {
            if (exceptionClass != null) {
                Assert.assertTrue((String)("Caught exception is not of expected class " + exceptionClass.getSimpleName() + ": " + StringUtils.stringifyException((Throwable)e)), (boolean)exceptionClass.isInstance(e));
            }
            if (messagePattern != null) {
                Assert.assertTrue((String)("Caught exception message string does not match expected pattern \"" + messagePattern.pattern() + "\" : " + StringUtils.stringifyException((Throwable)e)), (boolean)messagePattern.matcher(e.getMessage()).find());
            }
            LOG.info((Object)"Successfully detected expected NameNode startup failure.");
        }
    }

    void startBlockPoolShouldFail(HdfsServerConstants.StartupOption operation, String bpid) throws IOException {
        this.cluster.startDataNodes(this.conf, 1, false, operation, null);
        Assert.assertFalse((String)("Block pool " + bpid + " should have failed to start"), (boolean)this.cluster.getDataNodes().get(0).isBPServiceAlive(bpid));
    }

    private MiniDFSCluster createCluster() throws IOException {
        return new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
    }

    @BeforeClass
    public static void initialize() throws Exception {
        UpgradeUtilities.initialize();
    }

    @Test(timeout=600000L)
    public void testUpgrade() throws Exception {
        StorageInfo storageInfo = null;
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            this.conf.setLong("dfs.heartbeat.interval", 1L);
            this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 10000);
            this.conf.setInt("dfs.client.failover.max.attempts", 1);
            this.conf.set("dfs.client.retry.policy.spec", "1,1");
            String[] dataNodeDirs = this.conf.getStrings("dfs.datanode.data.dir");
            this.log("Normal NameNode upgrade", numDirs);
            this.cluster = this.createCluster();
            try {
                DistributedFileSystem dfs = this.cluster.getFileSystem();
                dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
                dfs.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
                Assert.fail();
            }
            catch (RemoteException re) {
                LOG.info((Object)"The exception is expected.", (Throwable)re);
            }
            this.cluster.shutdown();
            this.log("Normal DataNode upgrade", numDirs);
            this.cluster = this.createCluster();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
            this.checkDataNode(dataNodeDirs, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode upgrade with existing previous dir", numDirs);
            this.cluster = this.createCluster();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
            this.checkDataNode(dataNodeDirs, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode upgrade with future stored layout version in current", numDirs);
            this.cluster = this.createCluster();
            File[] baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            storageInfo = new StorageInfo(Integer.MIN_VALUE, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster), HdfsServerConstants.NodeType.DATA_NODE, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.REGULAR, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode upgrade with newer fsscTime in current", numDirs);
            this.cluster = this.createCluster();
            baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            storageInfo = new StorageInfo(HdfsConstants.DATANODE_LAYOUT_VERSION, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), Long.MAX_VALUE, HdfsServerConstants.NodeType.DATA_NODE, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.REGULAR, UpgradeUtilities.getCurrentBlockPoolID(null));
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
        }
    }

    private void deleteStorageFilesWithPrefix(String[] nameNodeDirs, String prefix) throws Exception {
        for (String baseDirStr : nameNodeDirs) {
            File baseDir = new File(baseDirStr);
            File currentDir = new File(baseDir, "current");
            for (File f : currentDir.listFiles()) {
                if (!f.getName().startsWith(prefix)) continue;
                Assert.assertTrue((String)("Deleting " + f), (boolean)f.delete());
            }
        }
    }

    @Test(expected=IOException.class)
    public void testUpgradeFromPreUpgradeLVFails() throws IOException {
        Storage.checkVersionUpgradable((int)-2);
        Assert.fail((String)"Expected IOException is not thrown");
    }

    @Ignore
    public void test203LayoutVersion() {
        for (int lv : Storage.LAYOUT_VERSIONS_203) {
            Assert.assertTrue((boolean)Storage.is203LayoutVersion((int)lv));
        }
    }

    public static void main(String[] args) throws Exception {
        TestDFSUpgrade t = new TestDFSUpgrade();
        TestDFSUpgrade.initialize();
        t.testUpgrade();
    }
}

