/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.hops.transaction.lock.LeaseCreationLockComparator;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.junit.Test;

public class TestLeaseCreationLock {
    @Test
    public void testLeaseOrder() throws Exception {
        int LEASE_CREATION_LOCK_ROWS = 1000;
        ArrayList<String> op0 = new ArrayList<String>();
        op0.add("/Aa");
        op0.add("/AaAaAaAa");
        ArrayList<String> op1 = new ArrayList<String>();
        op1.add("/BB");
        op1.add("/AaAaBBBB");
        Collections.sort(op0);
        Collections.sort(op1);
        assert (Math.abs(Lease.getHolderId((String)((String)op0.get(0)))) % LEASE_CREATION_LOCK_ROWS == Math.abs(Lease.getHolderId((String)((String)op1.get(1)))) % LEASE_CREATION_LOCK_ROWS);
        assert (Math.abs(Lease.getHolderId((String)((String)op0.get(1)))) % LEASE_CREATION_LOCK_ROWS == Math.abs(Lease.getHolderId((String)((String)op1.get(0)))) % LEASE_CREATION_LOCK_ROWS);
        Collections.sort(op0, new LeaseCreationLockComparator(LEASE_CREATION_LOCK_ROWS));
        Collections.sort(op1, new LeaseCreationLockComparator(LEASE_CREATION_LOCK_ROWS));
        assert (Math.abs(Lease.getHolderId((String)((String)op0.get(0)))) % LEASE_CREATION_LOCK_ROWS == Math.abs(Lease.getHolderId((String)((String)op1.get(0)))) % LEASE_CREATION_LOCK_ROWS);
        assert (Math.abs(Lease.getHolderId((String)((String)op0.get(1)))) % LEASE_CREATION_LOCK_ROWS == Math.abs(Lease.getHolderId((String)((String)op1.get(1)))) % LEASE_CREATION_LOCK_ROWS);
    }
}

