/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestMultithreadedCopyToOrFromLocal {
    private static final Log LOG = LogFactory.getLog(TestMultithreadedCopyToOrFromLocal.class);
    private final int SUCCESS = 0;
    private final int ERROR = 1;
    static final String TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    int filesPerDir = 10;
    int dirPerDir = 2;
    int maxDepth = 5;

    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFromLocal() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.enable.retrycache", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        File localDir = new File(TEST_ROOT_DIR, "localDir");
        File copiedDir = new File(TEST_ROOT_DIR, "copiedDir");
        File copiedBackDir = new File(TEST_ROOT_DIR, "copiedBackDir");
        String numThreads = "10";
        if (copiedDir.exists()) {
            FileUtils.deleteDirectory((File)copiedDir);
        }
        if (copiedBackDir.exists()) {
            FileUtils.deleteDirectory((File)copiedDir);
        }
        if (localDir.exists()) {
            FileUtils.deleteDirectory((File)localDir);
        }
        String hdfsTestDirStr = TEST_ROOT_DIR;
        Path hdfsTestDir = new Path(hdfsTestDirStr);
        try {
            fs = cluster.getFileSystem();
            this.createLocalDir(localDir);
            fs.mkdirs(hdfsTestDir);
            fs.setStoragePolicy(hdfsTestDir, "DB");
            shell = new FsShell(conf);
            long startTime = System.currentTimeMillis();
            String[] argv = new String[]{"-copyFromLocal", "-t", numThreads, "-d", localDir.getAbsolutePath(), hdfsTestDirStr + "/copiedDir"};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken copyFromLocal " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
            startTime = System.currentTimeMillis();
            argv = new String[]{"-copyToLocal", "-t", numThreads, hdfsTestDirStr + "/copiedDir", copiedBackDir.getAbsolutePath()};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyToLocal command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken copyToLocal " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
            this.verify(localDir, copiedBackDir);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            cluster.shutdown();
        }
    }

    private void createLocalDir(File base) throws IOException {
        this.createLocalDir(base, 0);
    }

    private void verify(File base1, File base2) throws IOException {
        this.verify(base1, base2, 0);
    }

    private void createLocalDir(File base, int depth) throws IOException {
        if (depth >= this.maxDepth) {
            return;
        }
        base.mkdir();
        for (int dir = 0; dir < this.dirPerDir; ++dir) {
            File dirPath = new File(base, "dir_depth_" + depth + "_count_" + dir);
            dirPath.mkdir();
            LOG.info((Object)(" DIR: " + dirPath));
            this.createLocalDir(dirPath, depth + 1);
            for (int file = 0; file < this.filesPerDir; ++file) {
                File filePath = new File(dirPath, "file_" + file);
                BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
                writer.write(filePath.toString());
                writer.close();
                LOG.info((Object)("FILE: " + filePath));
            }
        }
    }

    private void verify(File base1, File base2, int depth) throws IOException {
        if (depth >= this.maxDepth) {
            return;
        }
        for (int dir = 0; dir < this.dirPerDir; ++dir) {
            File dirPath1 = new File(base1, "dir_depth_" + depth + "_count_" + dir);
            File dirPath2 = new File(base2, "dir_depth_" + depth + "_count_" + dir);
            Assert.assertTrue((boolean)dirPath1.isDirectory());
            Assert.assertTrue((boolean)dirPath2.isDirectory());
            this.verify(dirPath1, dirPath2, depth + 1);
            for (int file = 0; file < this.filesPerDir; ++file) {
                File filePath1 = new File(dirPath1, "file_" + file);
                File filePath2 = new File(dirPath2, "file_" + file);
                Assert.assertTrue((boolean)filePath1.isFile());
                Assert.assertTrue((boolean)filePath2.isFile());
                BufferedReader reader1 = new BufferedReader(new FileReader(filePath1));
                String f1Data = reader1.readLine();
                reader1.close();
                BufferedReader reader2 = new BufferedReader(new FileReader(filePath1));
                String f2Data = reader2.readLine();
                reader2.close();
                Assert.assertTrue((boolean)f1Data.equals(f2Data));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFromLocal2() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        FsShell shell = null;
        DistributedFileSystem fs = null;
        File localFile = new File(TEST_ROOT_DIR, "localFile");
        File copiedFile = new File(TEST_ROOT_DIR, "copiedFile");
        File copiedBackFile = new File(TEST_ROOT_DIR, "copiedBackFile");
        String numThreads = "10";
        if (copiedFile.exists()) {
            FileUtils.forceDelete((File)copiedFile);
        }
        if (localFile.exists()) {
            FileUtils.forceDelete((File)localFile);
        }
        if (copiedBackFile.exists()) {
            FileUtils.forceDelete((File)copiedBackFile);
        }
        String hdfsTestDirStr = TEST_ROOT_DIR;
        Path hdfsTestDir = new Path(hdfsTestDirStr);
        try {
            fs = cluster.getFileSystem();
            this.createLocalFile(localFile);
            fs.mkdirs(hdfsTestDir);
            fs.setStoragePolicy(hdfsTestDir, "DB");
            shell = new FsShell(conf);
            long startTime = System.currentTimeMillis();
            String[] argv = new String[]{"-copyFromLocal", "-t", numThreads, "-d", localFile.getAbsolutePath(), copiedFile.getAbsolutePath()};
            int res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyFromLocal command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken copyFromLocal " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
            startTime = System.currentTimeMillis();
            argv = new String[]{"-copyToLocal", "-t", numThreads, copiedFile.getAbsolutePath(), copiedBackFile.getAbsolutePath()};
            res = ToolRunner.run((Tool)shell, (String[])argv);
            Assert.assertEquals((String)"copyToLocal command should have succeeded", (long)0L, (long)res);
            LOG.info((Object)("Time taken copyToLocal " + (System.currentTimeMillis() - startTime) / 1000L + " sec"));
            this.verifyFiles(localFile, copiedBackFile);
        }
        finally {
            if (null != shell) {
                shell.close();
            }
            cluster.shutdown();
        }
    }

    void createLocalFile(File filePath) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
        writer.write(filePath.toString());
        writer.close();
    }

    void verifyFiles(File filePath1, File filePath2) throws IOException {
        BufferedReader reader1 = new BufferedReader(new FileReader(filePath1));
        String f1Data = reader1.readLine();
        reader1.close();
        BufferedReader reader2 = new BufferedReader(new FileReader(filePath1));
        String f2Data = reader2.readLine();
        reader2.close();
        Assert.assertTrue((boolean)f1Data.equals(f2Data));
    }
}

