/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.TestDoAsEffectiveUser;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDelegationTokenForProxyUser {
    private static MiniDFSCluster cluster;
    private static Configuration config;
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String[] GROUP_NAMES;
    private static final String REAL_USER = "RealUser";
    private static final String PROXY_USER = "ProxyUser";
    private static UserGroupInformation ugi;
    private static UserGroupInformation proxyUgi;
    private static final Log LOG;

    private static void configureSuperUserIPAddresses(Configuration conf, String superUserShortName) throws IOException {
        ArrayList<String> ipList = new ArrayList<String>();
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface inf = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = inf.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                ipList.add(addr.getHostAddress());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String ip : ipList) {
            builder.append(ip);
            builder.append(',');
        }
        builder.append("127.0.1.1,");
        builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        LOG.info((Object)("Local Ip addresses: " + builder.toString()));
        conf.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(superUserShortName), new String[]{builder.toString()});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        config = new HdfsConfiguration();
        config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        config.setStrings(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(REAL_USER), new String[]{GROUP1_NAME});
        config.setBoolean("dfs.namenode.delegation.token.always-use", true);
        TestDelegationTokenForProxyUser.configureSuperUserIPAddresses(config, REAL_USER);
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
        cluster = new MiniDFSCluster.Builder(config).build();
        cluster.waitActive();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        ugi = UserGroupInformation.createRemoteUser((String)REAL_USER);
        proxyUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER, (UserGroupInformation)ugi, (String[])GROUP_NAMES);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=20000L)
    public void testDelegationTokenWithRealUser() throws IOException {
        try {
            Token[] tokens = (Token[])proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<?>[]>(){

                @Override
                public Token<?>[] run() throws IOException {
                    return cluster.getFileSystem().addDelegationTokens("RenewerUser", null);
                }
            });
            DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
            byte[] tokenId = tokens[0].getIdentifier();
            identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
            Assert.assertEquals((Object)identifier.getUser().getUserName(), (Object)PROXY_USER);
            Assert.assertEquals((Object)identifier.getUser().getRealUser().getUserName(), (Object)REAL_USER);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test(timeout=20000L)
    public void testWebHdfsDoAs() throws Exception {
        WebHdfsTestUtil.LOG.info((Object)"START: testWebHdfsDoAs()");
        WebHdfsTestUtil.LOG.info((Object)("ugi.getShortUserName()=" + ugi.getShortUserName()));
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUserForTesting((String)PROXY_USER, (UserGroupInformation)ugi, (String[])GROUP_NAMES);
        WebHdfsFileSystem webhdfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(ugi, config, "webhdfs");
        Path root = new Path("/");
        cluster.getFileSystem().setPermission(root, new FsPermission(511));
        Whitebox.setInternalState((Object)webhdfs, (String)"ugi", (Object)proxyUgi);
        Path responsePath = webhdfs.getHomeDirectory();
        WebHdfsTestUtil.LOG.info((Object)("responsePath=" + responsePath));
        Assert.assertEquals((Object)(webhdfs.getUri() + "/user/" + PROXY_USER), (Object)responsePath.toString());
        Path f = new Path("/testWebHdfsDoAs/a.txt");
        FSDataOutputStream out = webhdfs.create(f);
        out.write("Hello, webhdfs user!".getBytes());
        out.close();
        FileStatus status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
        out = webhdfs.append(f);
        out.write("\nHello again!".getBytes());
        out.close();
        status = webhdfs.getFileStatus(f);
        WebHdfsTestUtil.LOG.info((Object)("status.getOwner()=" + status.getOwner()));
        WebHdfsTestUtil.LOG.info((Object)("status.getLen()  =" + status.getLen()));
        Assert.assertEquals((Object)PROXY_USER, (Object)status.getOwner());
    }

    static {
        GROUP_NAMES = new String[]{GROUP1_NAME, GROUP2_NAME};
        LOG = LogFactory.getLog(TestDoAsEffectiveUser.class);
    }
}

