/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBlockInfo {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestBlockInfo");
    private int leaseCreationLockRows;

    @Before
    public void setup() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.leaseCreationLockRows = conf.getInt("dfs.lease.creation.locks.count.key", 1000);
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        HashBuckets.initialize((int)1);
    }

    @Test
    public void testAddStorage() throws Exception {
        Block block = new Block(0L);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(block, 1L);
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        storage.setSid(0);
        boolean added = this.addStorage(blockInfo, storage);
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((long)storage.getSid(), (long)this.getStorageId(blockInfo));
    }

    private boolean addStorage(final BlockInfoContiguous blockInfo, final DatanodeStorageInfo storage) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blockInfo.getBlockId(), new INodeIdentifier(Long.valueOf(blockInfo.getInodeId())))).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE}));
            }

            public Object performTask() throws IOException {
                return blockInfo.addStorage(storage);
            }
        }.handle();
    }

    private int getStorageId(final BlockInfoContiguous blockInfo) throws IOException {
        return (Integer)new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                ReplicaDataAccess da = (ReplicaDataAccess)HdfsStorageFactory.getDataAccess(ReplicaDataAccess.class);
                List replicas = da.findReplicasById(blockInfo.getBlockId(), blockInfo.getInodeId());
                return ((Replica)replicas.get(0)).getStorageId();
            }
        }.handle();
    }

    @Test
    public void testReplaceStorage() throws Exception {
        DatanodeStorageInfo storage1 = DFSTestUtil.createDatanodeStorageInfo("storageID1", "127.0.0.1");
        storage1.setSid(1);
        storage1.getDatanodeDescriptor().getStorageInfo(storage1.getStorageID()).setSid(1);
        DatanodeStorageInfo storage2 = new DatanodeStorageInfo(storage1.getDatanodeDescriptor(), new DatanodeStorage("storageID2"));
        storage2.setSid(2);
        int NUM_BLOCKS = 10;
        BlockInfoContiguous[] blockInfos = new BlockInfoContiguous[10];
        for (int i = 0; i < 10; ++i) {
            Block block = new Block((long)i);
            blockInfos[i] = new BlockInfoContiguous(block, (long)i);
            this.addBlockInfo(blockInfos[i]);
            this.addBlock(storage1, blockInfos[i]);
        }
        boolean added = this.addBlock(storage2, blockInfos[5]) == DatanodeStorageInfo.AddBlockResult.ADDED;
        Assert.assertThat((Object)added, (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.getStorageId(blockInfos[5]), (Matcher)Is.is((Object)storage2.getSid()));
    }

    private DatanodeStorageInfo.AddBlockResult addBlock(final DatanodeStorageInfo storage, final BlockInfoContiguous blk) throws IOException {
        return (DatanodeStorageInfo.AddBlockResult)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blk.getBlockId(), new INodeIdentifier(Long.valueOf(blk.getInodeId())))).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE}));
            }

            public Object performTask() throws StorageException, IOException {
                return storage.addBlock(blk);
            }
        }.handle();
    }

    private void addBlockInfo(final BlockInfoContiguous blk) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                BlockInfoDataAccess da = (BlockInfoDataAccess)HdfsStorageFactory.getDataAccess(BlockInfoDataAccess.class);
                ArrayList<BlockInfoContiguous> added = new ArrayList<BlockInfoContiguous>();
                added.add(blk);
                da.prepare(null, null, added);
                return null;
            }
        }.handle();
    }

    private void setBlockCollection(final BlockInfoContiguous blockInfo, final BlockCollection bc, final int leaseCreationLockRows) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(0L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, leaseCreationLockRows)).add(lf.getLeasePathLock()).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                blockInfo.setBlockCollection(bc);
                return null;
            }
        }.handle();
    }

    private boolean isDeleted(final BlockInfoContiguous blockInfo, final int leaseCreationLockRows) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.COMMIT_BLOCK_SYNCHRONIZATION){
            INodeIdentifier inodeIdentifier;
            {
                super(x0);
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(0L));
            }

            public void setUp() throws StorageException {
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier, true)).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, leaseCreationLockRows)).add(lf.getLeasePathLock()).add(lf.getBlockLock(10L, this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                return blockInfo.isDeleted();
            }
        }.handle();
    }
}

